/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.HashMap;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndToEndGrapher
extends Grapher {
    String title;
    public static final String FREE_HIST = "STG5105L";
    public static final String USED_HIST = "STG5107L";
    public static final String CAPACITY_HIST = "STG5109L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.histSubtype == 1) {
            this.title = FREE_HIST;
        } else if (grr.histSubtype == 3) {
            this.title = USED_HIST;
        } else if (grr.histSubtype == 5) {
            this.title = CAPACITY_HIST;
        }
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title);
        chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        return chart;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand) {
        int fsID;
        RespEndToEnd structure;
        int i;
        RespEndToEnd[] data = (RespEndToEnd[])pData;
        GuiReportReq newGrr = new GuiReportReq();
        newGrr.reportType = 30;
        newGrr.reportSubtype = 28;
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.chartLabelType = 1;
        newGrr.grrID1 = -1;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        int length = 0;
        MutableInteger key = new MutableInteger();
        HashMap<MutableInteger, MutableInteger> map = new HashMap<MutableInteger, MutableInteger>();
        RespEndToEnd[] array = new RespEndToEnd[rows.length];
        for (i = 0; i < rows.length; ++i) {
            structure = data[rows[i]];
            key.value = fsID = (int)structure.reeFilesystemID;
            if (map.get(key) != null) continue;
            map.put(key, key);
            key = new MutableInteger();
            array[length] = structure;
            ++length;
        }
        newGrr.selectedResources = new int[length];
        for (i = 0; i < length; ++i) {
            structure = array[i];
            newGrr.selectedResources[i] = fsID = (int)structure.reeFilesystemID;
            SpaceHistChart.addLegend(newGrr, structure.reeComputer, structure.reeLVFSPath, fsID);
        }
        if (actionCommand == FREE_HIST) {
            newGrr.histSubtype = 1;
            newGrr.historyTitle = "STG5111L";
        } else if (actionCommand == USED_HIST) {
            newGrr.histSubtype = (byte)3;
            newGrr.historyTitle = "STG1278T";
        } else {
            newGrr.histSubtype = (byte)5;
            newGrr.historyTitle = "STG5113L";
        }
        return newGrr;
    }
}

