/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskArrayData
implements GuiRequestor {
    public static final int GROUP_SEPARATION = 12;
    private NameList diskArray;
    private JPanel panel;

    public DiskArrayData(NameList pDiskArray) {
        this.diskArray = pDiskArray;
        this.panel = null;
    }

    public static void addItem(Container panel, GridBagConstraints c, String msgID, String value) {
        String s = MessageLog.getMessageNoID(msgID);
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        c.gridwidth = 1;
        panel.add((Component)label, c);
        label = new JLabel(value);
        label.setFont(BaseTree.plainFont);
        label.setForeground(Color.black);
        c.gridwidth = 0;
        int leftMargin = c.insets.left;
        c.insets.left = 24;
        panel.add((Component)label, c);
        c.insets.left = leftMargin;
    }

    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        Request request = GuiRequest.makeDiskArrayInfoRequest(this.diskArray.nlID);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NasFiler[] responseData = (NasFiler[])response.responseData;
        NasFiler parentStruct = responseData[0];
        Computer diskArray = parentStruct.nfComputer;
        String s = diskArray.cmpOSType == 21 ? MessageLog.getMessageNoID("SAG0071L", parentStruct.nfAlias) : MessageLog.getMessageNoID("SAG0006L", parentStruct.nfAlias);
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets.left = 40;
        c.insets.top = 30;
        c.insets.bottom = 20;
        this.panel.add((Component)label, c);
        c.insets.top = 0;
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "STG1103L", parentStruct.nfLdapTree.getLtName());
        c.insets.bottom = 0;
        if (diskArray.cmpOSType == 21) {
            this.makeClusterPanel(diskArray, c);
        } else {
            this.makeDiskArrayPanel(diskArray, c);
        }
        if (diskArray.cmpLastProbeTime == 0L || diskArray.cmpLastProbeTime == -1L) {
            DiskArrayData.addItem(this.panel, c, "STG1119L", Util.getString("STG0019T"));
            DiskArrayData.addItem(this.panel, c, "STG1120L", Util.getString("DBG0108L"));
        } else {
            DateFormat df = DateFormat.getDateTimeInstance();
            Date timestamp = new Date(diskArray.cmpLastProbeTime);
            s = TableCellStrings.DateRenderer(timestamp, df);
            DiskArrayData.addItem(this.panel, c, "STG1119L", s);
            s = ComputersAdjuster.probeStatus[diskArray.cmpProbeStatus];
            DiskArrayData.addItem(this.panel, c, "STG1120L", s);
        }
        s = diskArray.cmpProbingCompID < 0 ? MessageLog.getMessageNoID("SAG0025L") : (Constants.isCimomManaged(diskArray.cmpOSType) ? GuiClient.serverStatusResp.serverName : GuiUtil.getComputer((int)diskArray.cmpProbingCompID).gcTSName);
        DiskArrayData.addItem(this.panel, c, "SAG0011L", s);
        GuiUtil.completePanel(this.panel);
    }

    private void makeDiskArrayPanel(Computer diskArray, GridBagConstraints c) {
        String s;
        String da = diskArray.cmpManufacturer;
        if (diskArray.cmpManufacturer.toLowerCase().equals("unknown")) {
            da = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, c, "STG1105L", da);
        DiskArrayData.addItem(this.panel, c, "STG1106L", diskArray.cmpModel);
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "STG1107L", diskArray.cmpSerialNumber);
        c.insets.bottom = 0;
        if ((diskArray.cmpOSType == 15 || diskArray.cmpOSType == 12 || diskArray.cmpOSType == 25 || diskArray.cmpOSType == 27) && diskArray.cmpRAM > 0) {
            long bytes = diskArray.cmpRAM;
            s = Util.formatPrefBytes(bytes <<= 20);
            DiskArrayData.addItem(this.panel, c, "SAG0007L", s);
            if ((diskArray.cmpOSType == 12 || diskArray.cmpOSType == 25 || diskArray.cmpOSType == 27) && diskArray.cmpSwapSpace > 0) {
                bytes = diskArray.cmpSwapSpace;
                s = Util.formatPrefBytes(bytes <<= 20);
                DiskArrayData.addItem(this.panel, c, "SAG0024L", s);
            }
        }
        c.insets.bottom = 12;
        String cosv = diskArray.cmpOSVersion;
        if (diskArray.cmpOSVersion == null || diskArray.cmpOSVersion.toLowerCase().equals("unknown")) {
            cosv = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, c, "STG1146L", cosv);
        c.insets.bottom = 0;
        if (Constants.hasDiskInfo(diskArray.cmpOSType)) {
            DiskArrayData.addItem(this.panel, c, "SAG0008L", Integer.toString(diskArray.cmpNDisks));
            s = Util.formatPrefBytes(diskArray.cmpDiskCapacity << 9);
            if (diskArray.cmpDiskCapacity > 0L) {
                DiskArrayData.addItem(this.panel, c, "STG1115L", s);
            } else {
                DiskArrayData.addItem(this.panel, c, "STG1115L", MessageLog.getMessageNoID("STG0019T"));
            }
            s = Util.formatPrefBytes(diskArray.cmpDiskFreeSpace << 9);
            c.insets.bottom = 12;
            if (diskArray.cmpDiskFreeSpace > 0L) {
                DiskArrayData.addItem(this.panel, c, "SAG0047I", s);
            } else {
                DiskArrayData.addItem(this.panel, c, "SAG0047I", MessageLog.getMessageNoID("STG0019T"));
            }
            c.insets.bottom = 0;
        }
        if (Constants.hasStoragePoolInfo(diskArray.cmpOSType)) {
            s = Util.formatPrefBytes(diskArray.cmpVolGroupCapacity << 9);
            DiskArrayData.addItem(this.panel, c, "SAG0048I", s);
            s = Util.formatPrefBytes(diskArray.cmpVolGroupFreespace << 9);
            DiskArrayData.addItem(this.panel, c, "SAG0049I", s);
            long wrk = 0L;
            if (diskArray.cmpOSType == 15) {
                wrk = diskArray.cmpDiskCapacity - diskArray.cmpDiskFreeSpace - diskArray.cmpLogicalDiskCapacity;
                if (wrk < 0L) {
                    wrk = diskArray.cmpVolGroupCapacity - diskArray.cmpVolGroupFreespace - diskArray.cmpLogicalDiskCapacity;
                }
            } else if (diskArray.cmpDiskGroupFreeCap == -1L) {
                wrk = -1L;
            } else {
                wrk = diskArray.cmpDiskCapacity - diskArray.cmpDiskGroupFreeCap;
                wrk -= diskArray.cmpVolGroupCapacity;
            }
            if (diskArray.cmpOSType == 12 || diskArray.cmpOSType == 25 || diskArray.cmpOSType == 27 || diskArray.cmpOSType == 15) {
                s = Util.formatPrefBytes(wrk << 9);
                DiskArrayData.addItem(this.panel, c, "SAG0050I", s);
                c.insets.bottom = 12;
                s = Util.formatPrefBytes(diskArray.cmpDiskGroupFreeCap << 9);
                DiskArrayData.addItem(this.panel, c, "SAG0051I", s);
                c.insets.bottom = 0;
            } else {
                c.insets.bottom = 12;
                s = Util.formatPrefBytes(wrk << 9);
                DiskArrayData.addItem(this.panel, c, "SAG0050I", s);
                c.insets.bottom = 0;
            }
        }
        DiskArrayData.addItem(this.panel, c, "SAG0009L", Integer.toString(diskArray.cmpNLogicalDisks));
        s = Util.formatPrefBytes(diskArray.cmpLogicalDiskCapacity << 9);
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "SAG0010L", s);
        c.insets.bottom = 0;
    }

    private void makeClusterPanel(Computer diskArray, GridBagConstraints c) {
        String da = diskArray.cmpManufacturer;
        if (diskArray.cmpManufacturer.toLowerCase().equals("unknown")) {
            da = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, c, "STG1105L", da);
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "STG1106L", diskArray.cmpModel);
        c.insets.bottom = 0;
        long memory = diskArray.cmpRAM;
        String s = Util.formatPrefBytes(memory * 0x100000L);
        DiskArrayData.addItem(this.panel, c, "SAG0065L", s);
        c.insets.bottom = 12;
        String cosv = diskArray.cmpOSVersion;
        if (diskArray.cmpOSVersion.toLowerCase().equals("unknown")) {
            cosv = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, c, "SAG0066L", cosv);
        c.insets.bottom = 0;
        if (Constants.hasDiskInfo(diskArray.cmpOSType)) {
            DiskArrayData.addItem(this.panel, c, "SAG0067L", Integer.toString(diskArray.cmpNDisks));
            DiskArrayData.addItem(this.panel, c, "SAG0079L", Integer.toString(diskArray.cmpSwapSpace));
            s = Util.formatPrefBytes(diskArray.cmpDiskCapacity * 512L);
            DiskArrayData.addItem(this.panel, c, "SAG0068L", s);
            s = Util.formatPrefBytes(diskArray.cmpDiskFreeSpace * 512L);
            c.insets.bottom = 12;
            DiskArrayData.addItem(this.panel, c, "SAG0069L", s);
            c.insets.bottom = 0;
        }
        if (Constants.hasStoragePoolInfo(diskArray.cmpOSType)) {
            s = Util.formatPrefBytes(diskArray.cmpVolGroupCapacity * 512L);
            DiskArrayData.addItem(this.panel, c, "SAG0070L", s);
            s = Util.formatPrefBytes(diskArray.cmpVolGroupFreespace * 512L);
            c.insets.bottom = 12;
            DiskArrayData.addItem(this.panel, c, "SAG0078L", s);
            c.insets.bottom = 0;
        }
        DiskArrayData.addItem(this.panel, c, "SAG0075L", Integer.toString(diskArray.cmpNLogicalDisks));
        s = Util.formatPrefBytes(diskArray.cmpLogicalDiskCapacity * 512L);
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "SAG0076L", s);
        c.insets.bottom = 0;
    }
}

