/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.San.gui.DiskGroupTreeNode;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskGroupTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    private NameList computer;

    public DiskGroupTreeLabel(NameList element) {
        this.setUserObject(MessageLog.getMessageNoID("SAG0026L"));
        this.computer = element;
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.controllerList(request, this.computer.nlID, this.getQualifier());
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        Controller ctlr = null;
        if (status <= 4) {
            ctlr = (Controller)Packer.unpack((Packable[])response.responseData);
        }
        while (ctlr != null) {
            this.addSorted(this.makeNode(ctlr, this.computer));
            ctlr = ctlr.ctlrNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    protected DiskGroupTreeNode makeNode(Controller ctlr, NameList computer) {
        return new DiskGroupTreeNode(ctlr, computer);
    }

    protected short getQualifier() {
        return -1;
    }

    public void addSorted(BaseTreeNode child) {
        BaseTreeNode node;
        int index;
        String childKey = child.getUserObject().toString().substring(2);
        int childCount = this.getChildCount();
        for (index = 0; index < childCount && childKey.compareTo((node = (BaseTreeNode)this.getChildAt(index)).getUserObject().toString().substring(2)) >= 0; ++index) {
        }
        BaseTree.MyTree.insertNodeInto(child, this, index);
    }
}

