/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.common.LunAdjuster;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class LunTable
extends JPanel
implements GuiRequestor {
    private MegaTable lunTable = new MegaTable();
    private GuiReportReq grr;
    private Lun[] lunArray;
    private LunAdjuster adjuster;

    public LunTable(GuiReportReq grr) {
        this.grr = grr;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new LunAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        if (status <= 4) {
            this.lunArray = (Lun[])response.responseData;
        }
        int cnt = 0;
        if (this.lunArray != null) {
            cnt = this.lunArray.length;
        }
        if (cnt == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.lunArray, false);
        this.lunArray = (Lun[])this.adjuster.getArray();
        this.lunTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lunTable.setMouseListener(new SelectionListener());
        this.lunTable.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.lunTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.lunTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.lunTable.setRowIcon(10, true);
        if (this.adjuster.frozenRows > 0) {
            this.lunTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lunTable.setBaseTableModel(new LunTableModel());
        this.lunTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.add((Component)this.lunTable, "Center");
    }

    public class SelectionListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((LunTable)LunTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (dataRow >= ((LunTable)LunTable.this).adjuster.frozenRows) {
                Lun lun = LunTable.this.lunArray[dataRow];
                NameList subsystem = new NameList();
                subsystem.nlID = lun.lunDaID;
                subsystem.nlName = lun.lunDaAlias;
                subsystem.nlID2 = lun.lunOSType;
                new LogicalUnitDDI(null, lun.lunID, subsystem, lun.lunName);
            }
        }
    }

    private class LunTableModel
    extends BaseTableModel {
        LunTableModel() {
            this.columnNames = ((LunTable)LunTable.this).adjuster.colNames;
            this.rowCount = LunTable.this.lunArray.length;
            this.commonAdjuster = LunTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return LunTable.this.adjuster.getCellData(row, LunTable.this.adjuster.translateColumn(col));
        }
    }
}

