/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.aperi.San.gui.DiskArrayData;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class RankDDI
extends DataDisplayInfo {
    private Rank rank;
    private NameList computer;
    private static String unknownMsg = MessageLog.getMessageNoID("GUI0129T");

    public RankDDI(BaseTreeNode node, Rank pRank, NameList pNameList) {
        super(MessageLog.getMessageNoID("SAG0088L") + ":  " + pRank.rankName);
        this.rank = pRank;
        this.computer = pNameList;
        this.treeNode = node;
        this.helpID = "reasss50";
        this.reDisplay();
    }

    public void reDisplay() {
        if (this.panel == null) {
            this.buildPanel();
        }
        this.show();
    }

    private void buildPanel() {
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets.left = 40;
        c.insets.top = 30;
        c.insets.bottom = 20;
        DiskArrayData.addItem(this.panel, c, "SAG0090L", this.rank.rankName);
        c.insets.top = 0;
        c.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, c, "SAG0001L", this.computer.nlName);
        c.insets.bottom = 0;
        String s = Rank.CONFIGS[this.rank.rankConfig];
        DiskArrayData.addItem(this.panel, c, "SAG0091L", s);
        s = this.rank.getRankType(this.rank.rankType);
        DiskArrayData.addItem(this.panel, c, "SAG0092L", s);
        DiskArrayData.addItem(this.panel, c, "SAG0093L", this.rank.rankArraySiteNames);
        DiskArrayData.addItem(this.panel, c, "SAG0094L", Util.formatPrefBytes(this.rank.rankSize * 512L));
        s = this.rank.getRankStatus();
        DiskArrayData.addItem(this.panel, c, "SAG0095L", s);
        DiskArrayData.addItem(this.panel, c, "SAG0096L", this.rank.rankArrays);
        if (this.rank.rankGroup != -1) {
            DiskArrayData.addItem(this.panel, c, "SAG0097L", Short.toString(this.rank.rankGroup));
        } else {
            DiskArrayData.addItem(this.panel, c, "SAG0097L", MessageLog.getMessageNoID("SAG0600L"));
        }
        this.panel.add(Box.createVerticalStrut(14), c);
        GuiUtil.completePanel((JPanel)this.panel);
    }
}

