/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.San.gui.RankTreeNode;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class RankTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    private NameList parent;
    private int ctrlrID;
    private int computerID;

    public RankTreeLabel(NameList element, int cID) {
        this.setUserObject(MessageLog.getMessageNoID("SAG0089L"));
        this.parent = element;
        this.ctrlrID = cID;
        this.computerID = element.nlID;
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.rankList(request, this.computerID, this.ctrlrID);
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        Rank rank = null;
        if (status <= 4) {
            rank = (Rank)Packer.unpack((Packable[])response.responseData);
        }
        while (rank != null) {
            this.addSorted(this.makeNode(rank));
            rank = rank.rankNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    protected RankTreeNode makeNode(Rank rank) {
        return new RankTreeNode(rank, this.parent);
    }

    public void addSorted(BaseTreeNode child) {
        BaseTreeNode node;
        int index;
        String childKey = child.getUserObject().toString();
        int childCount = this.getChildCount();
        for (index = 0; index < childCount && childKey.compareTo((node = (BaseTreeNode)this.getChildAt(index)).getUserObject().toString()) >= 0; ++index) {
        }
        BaseTree.MyTree.insertNodeInto(child, this, index);
    }
}

