/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.RunJobs;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;

public class ServiceUtils {
    public static final int FAILED = 8;
    public static final int WARNING = 4;
    private static IDeviceServiceManager serviceManagerProxy = null;
    private static IDiscover discoveryServiceProxy = null;
    private static IEventMonitorService eventMonitor = null;
    private static int nextNumber = 0;
    public static Hashtable activeJobs = new Hashtable();
    public static Hashtable completedJobResults = new Hashtable();
    public static Hashtable jobResults = new Hashtable();
    public static Hashtable jobExceptions = new Hashtable();
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverRouter";
    public static ILogger traceLogger = null;
    public static String className = ServiceUtils.class.getName();
    public static ILogger auditLogger = null;
    private static final String BUNDLE_NAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";

    public static boolean populateResults(AsyncResult result, boolean removeEntries) {
        AsyncResult[] subResults;
        Exception exception;
        boolean didSomething = false;
        String deviceServerRunID = result.getJobId();
        Result resultForJob = (Result)jobResults.get(deviceServerRunID);
        if (resultForJob != null) {
            if (resultForJob.getSRMMessage() != null) {
                didSomething = true;
                result.setSRMMessage(resultForJob.getSRMMessage());
            }
            if (removeEntries) {
                jobResults.remove(deviceServerRunID);
            }
        }
        if ((exception = (Exception)jobExceptions.get(deviceServerRunID)) != null) {
            didSomething = true;
            result.setReturnException(exception);
            if (removeEntries) {
                jobExceptions.remove(deviceServerRunID);
            }
        }
        if ((subResults = result.getSubJobResults()) != null) {
            for (int i = 0; i < subResults.length; ++i) {
                didSomething |= ServiceUtils.populateResults(subResults[i], removeEntries);
            }
        }
        return didSomething;
    }

    public static String getDiscoverRequestInfo(String pad, Object[] response) {
        StringBuffer output = new StringBuffer();
        long duration = 0L;
        output.append(pad + "Request:" + response[0] + '\n');
        String newPad = pad + "   ";
        for (Object[] r : (ArrayList)response[1]) {
            output.append(ServiceUtils.getDiscoverRequestInfo(newPad, r));
        }
        for (JobInfo job : (ArrayList)response[2]) {
            duration += job.getEndTime() - job.getStartTime();
            output.append(newPad + "Job ID=" + job.getId() + (job.getStatus() == 4 ? " replaced by job " + job.getReplacementJob().getId() : " QueueName=" + job.getResourceQueue() + " Request=" + job.getRequest() + " Duration=" + (job.getEndTime() - job.getStartTime()) / 1000L + " seconds\n"));
        }
        output.append(pad + "total duration = " + duration / 1000L + " seconds\n\n");
        return output.toString();
    }

    public static AsyncResult getJobStatus(String jobId) {
        AsyncResult result = null;
        Object ajob = activeJobs.get(jobId);
        if (ajob != null) {
            if (ajob instanceof org.eclipse.aperi.control.data.JobInfo) {
                ControlEngine ce = ControlEngine.getInstance();
                result = ce.getActiveJobResults(jobId);
            } else if (ajob instanceof AsyncResult) {
                result = (AsyncResult)ajob;
            }
        } else {
            ajob = completedJobResults.get(jobId);
            if (ajob != null && ajob instanceof AsyncResult) {
                completedJobResults.remove(jobId);
                JobEngine.getInstance().cleanupRequestInformation(jobId);
                result = (AsyncResult)ajob;
            } else {
                result = ServiceUtils.getJobRecord(Integer.parseInt(jobId));
            }
        }
        return result;
    }

    public static DBConnection getConnection() {
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            return (DBConnection)ds.getPooledConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createJobRecord(int ID2, int jobID, String description, String logfile) {
        DBConnection connection = null;
        try {
            connection = ServiceUtils.getConnection();
            Timestamp timestamp = CurrentTime.getTimestamp(connection);
            RunJobs persistedJob = new RunJobs();
            persistedJob.setTimeStamp(timestamp.getTime());
            persistedJob.setStartTime(timestamp.getTime());
            persistedJob.setScheduleId(0);
            persistedJob.setSidRunNumber(0);
            persistedJob.setDeviceServerRunId(ID2);
            persistedJob.setJobRunNumber(jobID);
            persistedJob.setComputerId(ServiceUtils.getDeviceServerId());
            persistedJob.setLogFileName(logfile);
            persistedJob.setProcessId(1);
            persistedJob.setReturnCode(-1);
            persistedJob.setSubmitStatus(2);
            persistedJob.insert(connection);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateJobRecord(int ID2, int jobID, int status, int rc) {
        DBConnection connection = null;
        try {
            connection = ServiceUtils.getConnection();
            Timestamp timestamp = CurrentTime.getTimestamp(connection);
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(RunJobs.getColumnInfo("SCHEDULE_ID"), "0");
            whereclause.put(RunJobs.getColumnInfo("SID_RUN_NUMBER"), "0");
            whereclause.put(RunJobs.getColumnInfo("JOB_RUN_NUMBER"), new Integer(jobID).toString());
            whereclause.put(RunJobs.getColumnInfo("DEVICE_SERVER_RUN_ID"), new Integer(ID2).toString());
            Hashtable<ColumnInfo, String> parameters = new Hashtable<ColumnInfo, String>();
            if (rc != 0) {
                rc = rc > 0 ? 8 : 4;
            }
            parameters.put(RunJobs.getColumnInfo("RETURN_CODE"), new Integer(rc).toString());
            parameters.put(RunJobs.getColumnInfo("SUBMIT_STATUS"), new Integer(status).toString());
            parameters.put(RunJobs.getColumnInfo("TIME_STAMP"), new Long(timestamp.getTime()).toString());
            parameters.put(RunJobs.getColumnInfo("FINISH_TIME"), new Long(timestamp.getTime()).toString());
            boolean bl = RunJobs.update(connection, parameters, whereclause) == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncResult[] getJobRecords() {
        DBConnection connection = null;
        ArrayList<AsyncResult> results = new ArrayList<AsyncResult>();
        try {
            connection = ServiceUtils.getConnection();
            String sql = "select distinct DEVICE_SERVER_RUN_ID from " + connection.getSchema() + ".T_RUN_JOBS " + "order by DEVICE_SERVER_RUN_ID asc";
            DBResultSet dbr = null;
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
                ArrayList subResults = new ArrayList();
                while (dbr.next()) {
                    int ID2 = dbr.getInt("DEVICE_SERVER_RUN_ID");
                    results.add(ServiceUtils.getJobRecord(ID2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return results.toArray(new AsyncResult[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncResult getJobRecord(int ID2) {
        DBConnection connection = null;
        AsyncResult baseResult = null;
        try {
            connection = ServiceUtils.getConnection();
            String sql = "select * from " + connection.getSchema() + ".T_RUN_JOBS " + "WHERE " + "\t\tSCHEDULE_ID=0 " + " and\tSID_RUN_NUMBER=0 " + " and\tDEVICE_SERVER_RUN_ID=" + ID2 + " " + "ORDER BY JOB_RUN_NUMBER ASC";
            DBResultSet dbr = null;
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
                ArrayList<AsyncResult> subResults = new ArrayList<AsyncResult>();
                while (dbr.next()) {
                    AsyncResult result = new AsyncResult();
                    result.setRc(dbr.getInt("RETURN_CODE"));
                    result.setStatus(dbr.getInt("SUBMIT_STATUS"));
                    if (baseResult == null) {
                        result.setJobId(dbr.getString("DEVICE_SERVER_RUN_ID"));
                        baseResult = result;
                    } else {
                        result.setJobId(dbr.getString("DEVICE_SERVER_RUN_ID") + ":" + dbr.getString("JOB_RUN_NUMBER"));
                        subResults.add(result);
                        if (baseResult.getStatus() == 1 && result.getStatus() != 1) {
                            baseResult.setStatus(4);
                        }
                    }
                    Object o = activeJobs.get(result.getJobId());
                    if (o != null) {
                        result.setResults(new Object[]{o});
                        continue;
                    }
                    o = completedJobResults.get(result.getJobId());
                    if (o == null) continue;
                    completedJobResults.remove(result.getJobId());
                    JobEngine.getInstance().cleanupRequestInformation(result.getJobId());
                    result.setResults(new Object[]{o});
                }
                if (!subResults.isEmpty()) {
                    baseResult.setSubJobResults(subResults.toArray(new AsyncResult[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (baseResult == null) {
                    baseResult = new AsyncResult(8, 0);
                    baseResult.setJobId(new Integer(ID2).toString());
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (baseResult == null) {
                baseResult = new AsyncResult(8, 0);
                baseResult.setJobId(new Integer(ID2).toString());
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return baseResult;
    }

    public static synchronized int getJobIdentifier(boolean mainProcess, int type) {
        if (mainProcess) {
            try {
                return AutoIdentifier.getIdentifier(type, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (--nextNumber >= 0) {
                nextNumber = -1;
            }
            return nextNumber;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeviceServerId() {
        String methodName = "getDeviceServerComputerId";
        DBConnection dbConn = ServiceUtils.getConnection();
        String deviceServerSql = "Select * from T_RES_SERVER server where server.server_type= ";
        deviceServerSql = deviceServerSql + Integer.toString(1);
        DBResultSet dbr = null;
        try {
            dbr = ComplexQuery.sqlQuery(dbConn, deviceServerSql, null);
            if (dbr.next()) {
                int serverId;
                int n = serverId = dbr.getInt("SERVER_ID");
                return n;
            }
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", e);
            }
        }
        finally {
            block18: {
                if (dbConn != null) {
                    try {
                        dbConn.commit();
                        dbConn.close();
                    }
                    catch (Exception e) {
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, "getDeviceServerComputerId", e);
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, className, "getDeviceServerComputerId", "Invalid device server Id");
        }
        return -999;
    }

    public static void recordInAuditLog(String service, String method, String input, int rc) {
        ServiceUtils.recordInAuditLog(service, method, input, new Integer(rc).toString());
    }

    public static void recordInAuditLog(String service, String method, String input, AsyncResult result) {
        if (result.getStatus() == 2) {
            ServiceUtils.recordInAuditLog(service, method, input, "JobID=" + result.getJobId());
        } else {
            ServiceUtils.recordInAuditLog(service, method, input, result.toString());
        }
    }

    public static void recordInAuditLog(String service, String method, String input, String output) {
        String methodName = "recordInAuditLog";
        Map properties = ServiceUtils.getUserProperties();
        if (properties != null) {
            String user = null;
            Integer role = null;
            String host = null;
            try {
                user = (String)properties.get("USER");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (user != null) {
                try {
                    role = (Integer)properties.get("ROLE");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    host = (String)properties.get("HOST");
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object[] params = new String[]{service + "." + method, user, host, input, output};
                auditLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "TSNMServiceManager_AuthorizedRequest", params);
            }
        }
    }

    public static Map getUserProperties() {
        return RPCSecureJavaProvider.getUserProperties();
    }

    public static IDeviceServiceManager getServiceManagerProxy() {
        if (serviceManagerProxy == null) {
            serviceManagerProxy = (IDeviceServiceManager)Activator._serviceHelper.bindLocal("DeviceServiceManager");
        }
        return serviceManagerProxy;
    }

    public static IDiscover getDiscoveryServiceProxy() {
        if (discoveryServiceProxy == null) {
            discoveryServiceProxy = (IDiscover)Activator._serviceHelper.bindLocal("DiscoverService");
        }
        return discoveryServiceProxy;
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    static {
        auditLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.audit");
        auditLogger.setMessageFile(BUNDLE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }
}

