/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class CimomConfig
implements Packable,
Serializable {
    static final long serialVersionUID = -9214883649970322355L;
    public transient CimomConfig ciNext;
    public int ciID = -1;
    public String ciHost;
    public int ciPort;
    public String ciUserName;
    private String ciPassword;
    public byte ciProtocol;
    public String ciINamespace;
    public static final byte HTTP = 0;
    public static final byte HTTPS = 1;
    public static final String[] PROTOCOL_STRING = new String[]{"http", "https"};

    public CimomConfig() {
        this(null, 5989, "http", null, null, null);
    }

    public CimomConfig(String host, int port, String protocol) {
        this(host, port, protocol, null, null, null);
    }

    public CimomConfig(String host, int port, String protocol, String userName, String password, String inamespace) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "CimomConfig", "host, port, protocol, userName, password, certificate, inamespace");
        }
        this.ciHost = host;
        this.ciPort = port;
        this.ciUserName = userName;
        this.encryptPassword(password);
        this.ciINamespace = inamespace;
        this.setProtocol(protocol);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "CimomConfig");
        }
    }

    public boolean equalsCimom(CimomConfig that) {
        return Util.stringsEqual(this.ciHost, that.ciHost) && this.ciPort == that.ciPort;
    }

    public boolean equals(Object inObj) {
        if (inObj instanceof CimomConfig) {
            return this.equalsCimom((CimomConfig)inObj);
        }
        return false;
    }

    public void setPassword(String password) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setPassword", "password");
        }
        this.ciPassword = password;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setPassword");
        }
    }

    public String getPassword() {
        return this.ciPassword;
    }

    public void encryptPassword(String password) {
        this.ciPassword = password != null ? Encrypt.encrypt(password) : null;
    }

    public String decryptPassword() {
        return this.ciPassword == null ? null : Encrypt.decrypt(this.ciPassword);
    }

    public String getProtocolString() {
        return PROTOCOL_STRING[this.ciProtocol];
    }

    public void setProtocol(String protocol) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setProtocol", "protocol");
        }
        this.ciProtocol = protocol == null || protocol.equalsIgnoreCase(PROTOCOL_STRING[0]) ? (byte)0 : 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setProtocol");
        }
    }

    public Packable getNext() {
        return this.ciNext;
    }

    public void setNext(Packable next) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setNext", "next");
        }
        this.ciNext = (CimomConfig)next;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setNext");
        }
    }
}

