/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputersAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG1281L");
    private static final String IPADDRESS = MessageLog.getMessageNoID("STG1280L");
    private static final String OSTYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String OSVERSION = MessageLog.getMessageNoID("STG1109L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("STG1282L");
    private static final String MANUFACT = MessageLog.getMessageNoID("STG1105L");
    private static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    private static final String SERNUM = MessageLog.getMessageNoID("STG1107L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1110L");
    private static final String SPEED = MessageLog.getMessageNoID("STG1111L");
    private static final String PROCESSORS = MessageLog.getMessageNoID("STG1112L");
    private static final String RAM = MessageLog.getMessageNoID("STG1113L");
    private static final String SWAP = MessageLog.getMessageNoID("STG1114L");
    private static final String DISK_CAP = MessageLog.getMessageNoID("STG1115L");
    private static final String DISK_FREE = MessageLog.getMessageNoID("STG1116L");
    private static final String FS_FREE = MessageLog.getMessageNoID("STG1117L");
    private static final String LAST_BOOT = MessageLog.getMessageNoID("STG1118L");
    private static final String LAST_PROBE = MessageLog.getMessageNoID("STG1119L");
    private static final String PROBE_STAT = MessageLog.getMessageNoID("STG1120L");
    private static final String DISC_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String CPU_ARCH = MessageLog.getMessageNoID("STG1037L");
    private static final String NA = MessageLog.getMessageNoID("GEN0185T");
    public String[] columnNameList = new String[]{COMPUTER, NETWORK, IPADDRESS, OSTYPE, OSVERSION, TIMEZONE, MANUFACT, MODEL, SERNUM, TYPE, SPEED, PROCESSORS, RAM, SWAP, DISK_CAP, DISK_FREE, FS_FREE, LAST_BOOT, LAST_PROBE, PROBE_STAT, DISC_TIME, CPU_ARCH};
    private static final int COMPUTER_COL = 0;
    private static final int NETWORK_COL = 1;
    private static final int IPADDRESS_COL = 2;
    private static final int OSTYPE_COL = 3;
    private static final int OSVERSION_COL = 4;
    private static final int TIMEZONE_COL = 5;
    private static final int MANUFACT_COL = 6;
    private static final int MODEL_COL = 7;
    private static final int SERNUM_COL = 8;
    private static final int TYPE_COL = 9;
    public static final int SPEED_COL = 10;
    public static final int PROCESSORS_COL = 11;
    private static final int RAM_COL = 12;
    private static final int SWAP_COL = 13;
    private static final int DISK_CAP_COL = 14;
    private static final int DISK_FREE_COL = 15;
    private static final int FS_FREE_COL = 16;
    private static final int LAST_BOOT_COL = 17;
    private static final int LAST_PROBE_COL = 18;
    private static final int PROBE_STAT_COL = 19;
    private static final int DISC_TIME_COL = 20;
    private static final int CPU_ARCH_COL = 21;
    public static String[] probeStatus = new String[]{MessageLog.getMessageNoID("STG1121T"), MessageLog.getMessageNoID("STG1122T"), MessageLog.getMessageNoID("STG1123T"), MessageLog.getMessageNoID("STG0019T")};
    private Computer[] computers;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private GuiReportReq grr;
    private Comparator sorter;
    private ComputerList computerList;
    private int[] rendererArray;
    private boolean batch;
    public int frozenRows;
    private int rowCount;
    private short osType;
    private GComputer gcmpTotal;

    public ComputersAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 1;
        switch (grr.reportSubtype) {
            case 38: {
                this.firstColumn = 17;
                this.sorter = new LastBootSorter();
                break;
            }
            case 18: {
                this.firstColumn = 18;
                this.sorter = new LastProbeSorter();
                break;
            }
            case 37: {
                this.firstColumn = 20;
                this.sorter = new DiscTimeSorter();
                break;
            }
            default: {
                this.sorter = new ComputerSorter();
            }
        }
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[12] = 7;
        this.rendererArray[13] = 7;
        this.rendererArray[14] = 7;
        this.rendererArray[15] = 7;
        this.rendererArray[16] = 7;
        this.rendererArray[17] = 1;
        this.rendererArray[18] = 1;
        this.rendererArray[20] = 1;
        this.rendererArray[11] = 5;
        this.rendererArray[10] = 9;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.bHasTotalRow) {
            this.computers[0].gComputer = this.gcmpTotal;
        }
        Arrays.sort(this.computers, this.frozenRows, this.computers.length, this.sorter);
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.computers = (Computer[])dataArray;
        this.rowCount = this.computers.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        if (batch) {
            this.computerList = new ComputerList();
        }
        for (int i = 0; i < this.rowCount; ++i) {
            this.mDate[i] = new Date();
            this.mInt[i] = new MutableInteger();
            this.mLong[i] = new MutableLong();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rowCount; ++i) {
            Computer computer = this.computers[i];
            computer.cmpDiskCapacity *= 512L;
            computer.cmpDiskFreeSpace *= 512L;
            computer.cmpFilesystemFreeSpace *= 512L;
            if (computer.cmpProcessorCount <= 0) {
                computer.cmpProcessorCount = (short)-1;
            }
            computer.gComputer = this.batch ? this.computerList.getComputer(computer.cmpID) : GuiUtil.getComputer(computer.cmpID);
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        colArray[3].cdValidValue = ColumnDescriptor.OS_TYPES;
        colArray[19].cdValidValue = ColumnDescriptor.PROBE_STATUS;
        colArray[21].cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
    }

    public Object getArray() {
        return this.computers;
    }

    public int getNumberRows() {
        return this.computers.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return 1;
    }

    public static String getCPUArchString(short cpuArchitecture) {
        String unknown = Constants.getCPUArchDisplayName(0);
        String result = Constants.getCPUArchDisplayName(cpuArchitecture);
        if (result == unknown) {
            result = "";
        }
        return result;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 0: {
                return this.computers[row].gComputer.gcTSName;
            }
            case 1: {
                return Util.getDotName(this.computers[row].gComputer.gcNetworkName, this.computers[row].gComputer.gcDomainName);
            }
            case 2: {
                if (this.computers[row].gComputer.gcIpAddress.equals(" ")) {
                    return NA;
                }
                return this.computers[row].gComputer.gcIpAddress;
            }
            case 3: {
                this.osType = this.computers[row].cmpOSType;
                if (this.osType > 0) {
                    return MessageLog.getMessageNoID(Constants.OSTYPES[this.osType]);
                }
                return "";
            }
            case 4: {
                if (this.computers[row].cmpOSVersion.equals(" ")) {
                    return NA;
                }
                return this.computers[row].cmpOSVersion;
            }
            case 5: {
                String timezoneID = this.computers[row].gComputer.gcTimezoneID;
                return timezoneID == null ? "" : Util.formatTimeZone(timezoneID);
            }
            case 6: {
                if (this.computers[row].cmpManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.computers[row].cmpManufacturer;
            }
            case 7: {
                if (this.computers[row].cmpModel.equals(" ")) {
                    return NA;
                }
                return this.computers[row].cmpModel;
            }
            case 8: {
                if (this.computers[row].cmpSerialNumber.equals(" ")) {
                    return NA;
                }
                return this.computers[row].cmpSerialNumber;
            }
            case 9: {
                if (this.computers[row].cmpProcessorType.equals(" ")) {
                    return NA;
                }
                return this.computers[row].cmpProcessorType;
            }
            case 10: {
                this.mInt[row].value = this.computers[row].cmpProcessorSpeed;
                return new ComputerHertz(this.mInt[row].value);
            }
            case 11: {
                this.mInt[row].value = this.computers[row].cmpProcessorCount;
                return this.mInt[row];
            }
            case 12: {
                this.mLong[row].value = (long)this.computers[row].cmpRAM << 20;
                if (this.mLong[row].value == 0L) {
                    this.mLong[row].value = -1L;
                }
                return this.mLong[row];
            }
            case 13: {
                this.mLong[row].value = (long)this.computers[row].cmpSwapSpace << 20;
                return this.mLong[row];
            }
            case 14: {
                this.mLong[row].value = this.computers[row].cmpDiskCapacity;
                return this.mLong[row];
            }
            case 15: {
                this.mLong[row].value = this.computers[row].cmpDiskFreeSpace;
                return this.mLong[row];
            }
            case 16: {
                this.mLong[row].value = this.computers[row].cmpFilesystemFreeSpace;
                return this.mLong[row];
            }
            case 17: {
                if (this.computers[row].cmpLastBootTime < 0L) {
                    return NA;
                }
                this.mDate[row].setTime(this.computers[row].cmpLastBootTime);
                return this.mDate[row];
            }
            case 18: {
                this.mDate[row].setTime(this.computers[row].cmpLastProbeTime);
                return this.mDate[row];
            }
            case 19: {
                byte status = this.computers[row].cmpProbeStatus;
                return status < 0 ? "" : probeStatus[status];
            }
            case 20: {
                this.mDate[row].setTime(this.computers[row].cmpDiscoveredTime);
                return this.mDate[row];
            }
            case 21: {
                return ComputersAdjuster.getCPUArchString(this.computers[row].cmpCPUArchitecture);
            }
        }
        return null;
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        Computer[] plusArray = new Computer[this.rowCount + 1];
        this.gcmpTotal = new GComputer();
        this.gcmpTotal.gcTSName = MessageLog.getMessageNoID("STG4136L");
        this.gcmpTotal.gcNetworkName = "";
        this.gcmpTotal.gcIpAddress = "";
        Computer cmpTotal = new Computer();
        cmpTotal.cmpOSType = (short)-1;
        cmpTotal.cmpCPUArchitecture = 0;
        cmpTotal.cmpOSVersion = "";
        cmpTotal.cmpManufacturer = "";
        cmpTotal.cmpModel = "";
        cmpTotal.cmpSerialNumber = "";
        cmpTotal.cmpProcessorType = "";
        cmpTotal.cmpDiskCapacity = -1L;
        cmpTotal.cmpDiskFreeSpace = -1L;
        cmpTotal.cmpProbeStatus = (byte)-1;
        plusArray[0] = cmpTotal;
        for (int ix = 0; ix < this.rowCount; ++ix) {
            Computer cmpRow = this.computers[ix];
            if (cmpRow.cmpProcessorCount > 0) {
                cmpTotal.cmpProcessorCount = (short)(cmpTotal.cmpProcessorCount + cmpRow.cmpProcessorCount);
            }
            if (cmpRow.cmpRAM > 0) {
                cmpTotal.cmpRAM += cmpRow.cmpRAM;
            }
            if (cmpRow.cmpSwapSpace > 0) {
                cmpTotal.cmpSwapSpace += cmpRow.cmpSwapSpace;
            }
            if (cmpRow.cmpFilesystemFreeSpace > 0L) {
                cmpTotal.cmpFilesystemFreeSpace += cmpRow.cmpFilesystemFreeSpace;
            }
            plusArray[ix + 1] = cmpRow;
        }
        this.computers = plusArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object o1, Object o2) {
            GComputer r1 = ((Computer)o1).gComputer;
            GComputer r2 = ((Computer)o2).gComputer;
            return r1.gcTSName.compareTo(r2.gcTSName);
        }
    }

    private class DiscTimeSorter
    implements Comparator {
        private DiscTimeSorter() {
        }

        public int compare(Object o1, Object o2) {
            Computer r1 = (Computer)o1;
            Computer r2 = (Computer)o2;
            if (r1.cmpDiscoveredTime == r2.cmpDiscoveredTime) {
                return 0;
            }
            if (r1.cmpDiscoveredTime > r2.cmpDiscoveredTime) {
                return -1;
            }
            return 1;
        }
    }

    private class LastProbeSorter
    implements Comparator {
        private LastProbeSorter() {
        }

        public int compare(Object o1, Object o2) {
            Computer r1 = (Computer)o1;
            Computer r2 = (Computer)o2;
            if (r1.cmpLastProbeTime == r2.cmpLastProbeTime) {
                return 0;
            }
            if (r1.cmpLastProbeTime > r2.cmpLastProbeTime) {
                return 1;
            }
            return -1;
        }
    }

    private class LastBootSorter
    implements Comparator {
        private LastBootSorter() {
        }

        public int compare(Object o1, Object o2) {
            Computer r1 = (Computer)o1;
            Computer r2 = (Computer)o2;
            if (r1.cmpLastBootTime == r2.cmpLastBootTime) {
                return 0;
            }
            if (r1.cmpLastBootTime > r2.cmpLastBootTime) {
                return 1;
            }
            return -1;
        }
    }

    public static class ComputerHertz
    extends MutableInteger {
        public ComputerHertz(int i) {
            this.value = i;
        }
    }
}

