/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.DevAccess;

public class Device
implements Serializable {
    static final long serialVersionUID = -3174909751779696618L;
    public transient Device devNext;
    public int devID;
    public String devName;
    public String devManufacturer;
    public String devModel;
    public String devFirmwareRev;
    public String devSerialNumber;
    public String devSubsystemSerialNumber;
    public long devManufactureDate;
    public short devUseCount;
    public short devType;
    public long devDiscoveredTime;
    public static final short HARD_DISK = 0;
    public static final short CD_ROM = 1;
    public static final short CD_WRITER = 2;
    public static final short MAGNETO_OPTICAL = 3;
    public static final short FLOPPY = 4;
    public static final short REMOTE_MIRROR = 5;
    public static final short TAPE = 256;
    public static final short SCANNER = 2048;
    public static final short PRINTER = 2304;
    public static final short MEDIUM_CHANGER = 4096;
    public static final short ENCLOSURE = 4352;
    public short devStorageSystemType;
    public short devFlags;
    public static final short GENERATED_MANUFACTURER = 1;
    public static final short GENERATED_SERIAL_NUMBER = 2;
    public static final short NEW_DEVICE = 4;
    public static final short SPARE_DEVICE = 8;
    public boolean devRemovableMedium;
    public boolean devMultiPort;
    public boolean devUnsupportedModel;
    public transient DevAccess devControllers;
    public DevAccess[] devPackedControllers;
    public transient String devCanonicalName;

    private void packControllers() {
        int count = 0;
        DevAccess da = this.devControllers;
        while (da != null) {
            ++count;
            da = da.daNextController;
        }
        this.devPackedControllers = new DevAccess[count];
        count = 0;
        da = this.devControllers;
        while (da != null) {
            this.devPackedControllers[count] = da;
            ++count;
            da = da.daNextController;
        }
    }

    private void unpackControllers() {
        int count = this.devPackedControllers != null ? this.devPackedControllers.length : 0;
        while (count > 0) {
            DevAccess da = this.devPackedControllers[--count];
            da.daNextController = this.devControllers;
            this.devControllers = da;
        }
    }

    public static Device[] pack(Device head) {
        int count = 0;
        Device device = head;
        while (device != null) {
            ++count;
            device.packControllers();
            device = device.devNext;
        }
        Device[] result = new Device[count];
        count = 0;
        while (head != null) {
            result[count] = head;
            ++count;
            device = head.devNext;
            head.devNext = null;
            head = device;
        }
        return result;
    }

    public static Device unpack(Device[] array) {
        Device result;
        int count = 0;
        if (array != null) {
            count = array.length;
        }
        if (count == 0) {
            return null;
        }
        Device prev = result = array[0];
        result.unpackControllers();
        for (int i = 1; i < count; ++i) {
            Device device;
            prev.devNext = device = array[i];
            prev = device;
            device.unpackControllers();
        }
        return result;
    }

    public static boolean isFixedDisk(short deviceType) {
        return deviceType == 0 || deviceType == 5;
    }

    public boolean isFixedDisk() {
        return Device.isFixedDisk(this.devType);
    }
}

