/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.DiskCapacityAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityGrapher
extends Grapher {
    private String title;
    public static final byte CHART_SPACE = 101;
    public static final byte CHART_SPACE_X = 102;
    public static final byte CHART_NET_SPACE = 103;
    public static final byte CHART_NET_CAPACITY = 104;
    public static final String CHART_SELECTED = "STG5556T";
    public static final String CHART_ALL = "STG1294T";
    public static final String CHART_NETWORK_SIZE = "STG5525L";
    public static final String CHART_NETWORK_CAP = "STG5524L";
    public static final String CHART_NETWORK_CAP_ALL = "STG7529L";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_HIST_ALL = "STG7530L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String FREE_PERCENT_HIST_ALL = "STG7531L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String CAPACITY_HIST_ALL = "STG7555L";
    private String legend;
    private static final String DOMAINS = MessageLog.getMessageNoID("STG5004L");
    private static final String COMPGROUPS = MessageLog.getMessageNoID("STG3012L");
    private static final String COMPUTERS = MessageLog.getMessageNoID("STG4041L");
    private static final String DISKS = MessageLog.getMessageNoID("STG1004L");
    private static final String CLUSTERS = MessageLog.getMessageNoID("STG1149L");
    private static final String SUBSYSTEMS = MessageLog.getMessageNoID("SAG0002L");
    private byte action;

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        this.action = grr.chartSubtype;
        if (grr.chartSubtype > 0) {
            return null;
        }
        this.title = grr.histSubtype == 1 ? FREE_HIST : (grr.histSubtype == 2 ? FREE_PERCENT_HIST : CAPACITY_HIST);
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        if (grr.chartSubtype > 0) {
            this.setLegend(grr);
            chart = grr.chartSubtype == 103 ? this.createPieChart(grr, pData, pAdjuster, null, gcsr) : this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public void setLegend(GuiReportReq grr) {
        if (grr.reportType == 72) {
            this.legend = SUBSYSTEMS;
        } else {
            switch (grr.reportSubtype) {
                case 27: {
                    this.legend = DISKS;
                    break;
                }
                case 12: {
                    this.legend = COMPUTERS;
                    break;
                }
                case 13: {
                    this.legend = COMPGROUPS;
                    break;
                }
                case 82: {
                    this.legend = CLUSTERS;
                    break;
                }
                case 14: {
                    this.legend = DOMAINS;
                    break;
                }
                case 77: {
                    this.legend = SUBSYSTEMS;
                }
            }
        }
    }

    public AperiCustomizableChart createPieChart(GuiReportReq grr, Object[] pData, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createPieChart", "grr, pData, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] data = (RespFSspace[])pData;
        DiskCapacityAdjuster adjuster = (DiskCapacityAdjuster)pAdjuster;
        Number[][] chartY = new Number[6][1];
        String[] pointL = new String[1];
        String[] seriesL = new String[6];
        seriesL[0] = DiskCapacityAdjuster.USED_SPACE;
        seriesL[1] = DiskCapacityAdjuster.FREE_SPACE;
        seriesL[2] = DiskCapacityAdjuster.RAW_CAPACITY;
        seriesL[3] = DiskCapacityAdjuster.OVERHEAD;
        seriesL[4] = DiskCapacityAdjuster.UNALLOCATED;
        seriesL[5] = DiskCapacityAdjuster.UNKNOWN_LCAP;
        chartY[0][0] = new Double(data[0].usedSpace);
        chartY[1][0] = new Double(data[0].fsFreeSpace);
        chartY[2][0] = new Double(data[0].fs_capacity);
        chartY[3][0] = new Double(data[0].overhead);
        chartY[4][0] = new Double(data[0].unallocated);
        chartY[5][0] = new Double(data[0].unknown);
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, chartY, seriesL, pointL, new ChartOptions(), grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        AperiCustomizableChart traceResult = chart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createPieChart", traceResult);
        }
        return traceResult;
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] data = (RespFSspace[])pData;
        int rowCount = rows.length;
        Number[][] chartY = new Number[rowCount][1];
        String[] seriesL = new String[rowCount];
        long total = 0L;
        for (int i = 0; i < rowCount; ++i) {
            int row = rows[i];
            chartY[i][0] = new Double(data[row].capacity);
            total += data[row].capacity;
            seriesL[i] = data[row].creator.equals(" ") ? data[row].getName() : data[row].creator + "." + data[row].getName();
        }
        ChartOptions defaults = new ChartOptions();
        defaults.chartType = 3;
        defaults.chartsPerView = 1;
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, chartY, seriesL, new String[]{"Capacity"}, defaults, grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        AperiCustomizableChart traceResult = chart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createChart", traceResult);
        }
        return traceResult;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        RespFSspace[] data = (RespFSspace[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            RespFSspace dataRow = data[rows[i]];
            int objectID = dataRow.id;
            if (grr.reportSubtype == 27) {
                objectID = dataRow.fs_id;
            }
            newGrr.selectedResources[i] = objectID;
            SpaceHistChart.addLegend(newGrr, dataRow.creator, dataRow.getName(), objectID);
        }
        if (actionCommand == FREE_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = 1;
            newGrr.historyTitle = "STG5111L";
        } else if (actionCommand == FREE_PERCENT_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)2;
            newGrr.historyTitle = "STG5112L";
        } else {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = (byte)5;
            newGrr.historyTitle = "STG5113L";
        }
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        GuiReportReq traceResult = newGrr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createHistory", traceResult);
        }
        return traceResult;
    }
}

