/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.xmsg.MessageLog;

public class HistChartProcessor {
    public static void initLegend(GuiReportReq grr) {
        grr.dataObject = new HashMap();
    }

    public static void addLegend(GuiReportReq grr, String s1, String s2, int id) {
        HashMap map = (HashMap)grr.dataObject;
        MutableInteger hashKey = new MutableInteger();
        hashKey.value = id;
        if (map.get(hashKey) == null) {
            MutableInteger key = new MutableInteger(id);
            if (id == -3) {
                if (!Util.isEmpty(s1)) {
                    s2 = MessageLog.getMessageNoID("STG4246L", s1, MessageLog.getMessageNoID("STG2038L"));
                    s1 = null;
                } else {
                    s1 = null;
                    s2 = MessageLog.getMessageNoID("STG2038L");
                }
            }
            if (Util.isEmpty(s1)) {
                map.put(key, s2);
            } else if (Util.isEmpty(s2)) {
                map.put(key, s1);
            } else {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append(s1);
                if (grr.reportSubtype == 8 || grr.reportSubtype == 10 || grr.reportSubtype == 16) {
                    buffer.append(" : ");
                } else {
                    buffer.append('.');
                }
                buffer.append(s2);
                map.put(key, buffer.toString());
            }
        }
    }

    public Object[] processResponse(Object responseData, GuiReportReq grr) {
        Object hist;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HistChartProcessor.class.getName(), "processResponse", "responseData, grr");
        }
        StringBuffer buffer = new StringBuffer(128);
        MutableInteger hashKey = new MutableInteger();
        String sourceName = grr.dataString;
        HashMap legendMap = (HashMap)grr.dataObject;
        Object[] histRows = responseData instanceof PartitionedReport ? (SpaceHistory[])((PartitionedReport)responseData).prData : (SpaceHistory[])responseData;
        int cnt = histRows != null ? histRows.length : 0;
        if (cnt == 0) {
            Object[] traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(HistChartProcessor.class.getName(), "processResponse", traceResult);
            }
            return traceResult;
        }
        for (int i = 0; i < cnt; ++i) {
            hist = histRows[i];
            hashKey.value = ((SpaceHistory)hist).shLegendID1;
            ((SpaceHistory)hist).shLegend = (String)legendMap.get(hashKey);
            if (((SpaceHistory)hist).shLegendID2 == Integer.MIN_VALUE) continue;
            hashKey.value = ((SpaceHistory)hist).shLegendID2;
            String legend2 = (String)legendMap.get(hashKey);
            if (legend2 == null) {
                legend2 = "";
            }
            ((SpaceHistory)hist).shLegend = MessageLog.getMessageNoID("STG4246L", ((SpaceHistory)hist).shLegend, legend2);
        }
        Arrays.sort(histRows);
        int start = 0;
        int fromIndex = 0;
        if (grr.historyLineTitle != null) {
            if (cnt == 1) {
                ++cnt;
                start = 1;
            } else {
                cnt += 2;
                start = 2;
            }
        }
        String[] seriesL = new String[cnt];
        double[] xvalues = new double[cnt];
        double[] yvalues = new double[cnt];
        if (grr.historyLineTitle != null) {
            seriesL[0] = grr.historyLineTitle;
            xvalues[0] = ((SpaceHistory)histRows[0]).shStatisticTime;
            yvalues[0] = grr.historyLineValue;
            if (cnt > 3) {
                seriesL[1] = grr.historyLineTitle;
                xvalues[1] = ((SpaceHistory)histRows[cnt - 3]).shStatisticTime;
                yvalues[1] = grr.historyLineValue;
            }
        }
        for (int i = start; i < cnt; ++i) {
            hist = histRows[fromIndex];
            seriesL[i] = ((SpaceHistory)hist).shLegend;
            xvalues[i] = ((SpaceHistory)hist).shStatisticTime;
            yvalues[i] = grr.chartLabelType == 1 ? (double)(((SpaceHistory)hist).shTotalSize * 512L) : (grr.chartLabelType == 3 ? (double)((SpaceHistory)hist).shFileCount / 10.0 : (double)((SpaceHistory)hist).shFileCount);
            ++fromIndex;
        }
        Object[] result = new Object[]{sourceName, seriesL, xvalues, yvalues};
        Object[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HistChartProcessor.class.getName(), "processResponse", traceResult);
        }
        return traceResult;
    }
}

