/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingAdjuster
extends CustomReportDataAdjuster {
    private GuiReportReq grr;
    private Comparator sorter;
    private PingReport[] tableData;
    private MutableShort[] mShort;
    private MutableInteger[] mInteger;
    private MutableLong[] mLong;
    private Date[] mDate;
    public String[] colNames;
    private int name1Col = -1;
    private int name2Col = -1;
    private int[] rendererArray;
    private boolean batch;
    private String[] statTypeValues;
    private static final int N_STATISTIC_TYPES = 5;
    private static final int PERCENT_COL = 0;
    private static final int TRANSMITTED_COL = 1;
    private static final int RECEIVED_COL = 2;
    private static final int DAMAGED_COL = 3;
    public static final int AVG_TRANSIT_COL = 4;
    public static final int MAX_TRANSIT_COL = 5;
    public static final int MIN_TRANSIT_COL = 6;
    private static final int START_TIME_COL = 7;
    private static final int END_TIME_COL = 8;
    private static final int STAT_TYPE_COL = 9;
    private static final String[] COL_LABELS = new String[]{MessageLog.getMessageNoID("STG4071L"), MessageLog.getMessageNoID("STG4072L"), MessageLog.getMessageNoID("STG4073L"), MessageLog.getMessageNoID("STG4074L"), MessageLog.getMessageNoID("STG4075L"), MessageLog.getMessageNoID("STG4076L"), MessageLog.getMessageNoID("STG4077L"), MessageLog.getMessageNoID("STG4078L"), MessageLog.getMessageNoID("STG4079L")};
    public static final byte TRANSIT_TIME_SCALE = 1;

    public PingAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 1;
        switch (grr.reportSubtype) {
            case 12: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 82: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1136L");
                break;
            }
            case 28: {
                this.sorter = new HistorySorter();
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.sorter = new TwoNameSorter();
                this.name1Col = -2;
                this.frozenColumns = 2;
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG0021L");
                this.colNames[1] = MessageLog.getMessageNoID("STG1103L");
                break;
            }
            case 14: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.colNames = new String[COL_LABELS.length];
            }
        }
        System.arraycopy(COL_LABELS, 0, this.colNames, this.frozenColumns, COL_LABELS.length);
        if (grr.reportSubtype == 28) {
            this.colNames[this.colNames.length - 1] = MessageLog.getMessageNoID("STG1214L");
            this.statTypeValues = new String[5];
            this.statTypeValues[0] = MessageLog.getMessageNoID("STG4094L");
            this.statTypeValues[1] = MessageLog.getMessageNoID("STG4095L");
            this.statTypeValues[2] = MessageLog.getMessageNoID("STG4096L");
            this.statTypeValues[3] = this.statTypeValues[1];
            this.statTypeValues[4] = this.statTypeValues[2];
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.frozenColumns + 0] = 6;
        this.rendererArray[this.frozenColumns + 1] = 5;
        this.rendererArray[this.frozenColumns + 2] = 5;
        this.rendererArray[this.frozenColumns + 3] = 5;
        this.rendererArray[this.frozenColumns + 4] = 2;
        this.rendererArray[this.frozenColumns + 5] = 2;
        this.rendererArray[this.frozenColumns + 6] = 2;
        this.rendererArray[this.frozenColumns + 7] = 1;
        this.rendererArray[this.frozenColumns + 8] = 1;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.sorter != null) {
            Arrays.sort(this.tableData, this.sorter);
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.tableData = (PingReport[])dataArray;
        int rows = this.tableData.length;
        this.mDate = new Date[rows];
        this.mLong = new MutableLong[rows];
        this.mInteger = new MutableInteger[rows];
        this.mShort = new MutableShort[rows];
        for (int i = 0; i < rows; ++i) {
            this.mDate[i] = new Date();
            this.mLong[i] = new MutableLong();
            this.mInteger[i] = new MutableInteger();
            this.mShort[i] = new MutableShort();
        }
    }

    public void adjustData() {
        for (PingReport dataRow : this.tableData) {
            dataRow.prPercentAvailable = (short)((double)dataRow.pngReceived / (double)dataRow.pngTransmitted * 100.0);
            if (dataRow.pngReceived == 0) {
                dataRow.pngAvgTransitTime = -1L;
                dataRow.pngMaxTransitTime = -1;
                dataRow.pngMinTransitTime = -1;
            } else if (this.grr.reportSubtype != 28) {
                dataRow.pngAvgTransitTime /= (long)dataRow.pngReceived;
            }
            if (this.batch) continue;
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                dataRow.prName1 = GuiUtil.getComputer((int)dataRow.prID).gcTSName;
                continue;
            }
            if (this.grr.reportSubtype != 82) continue;
            dataRow.prName1 = dataRow.getPrName2();
        }
    }

    public int getNumberRows() {
        return this.tableData.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getScale() {
        return 10;
    }

    public String getSuffix() {
        return MessageLog.getMessageNoID("STG7558L");
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        for (int i = 0; i < this.tableData.length; ++i) {
            PingReport dataRow = this.tableData[i];
            HistChartProcessor.addLegend(this.grr, dataRow.prName1, dataRow.getPrName2(), dataRow.prID);
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.tableData.length];
        for (int i = 0; i < this.tableData.length; ++i) {
            PingReport dataRow = this.tableData[i];
            IDarray[i] = dataRow.prID;
        }
        return IDarray;
    }

    public Object getCellData(int row, int col) {
        if ((col -= this.frozenColumns) == this.name1Col) {
            return this.tableData[row].prName1;
        }
        if (col == this.name2Col) {
            return this.tableData[row].getPrName2();
        }
        if (col == 0) {
            this.mShort[row].value = this.tableData[row].prPercentAvailable;
            return this.mShort[row];
        }
        if (col == 1) {
            this.mInteger[row].value = this.tableData[row].pngTransmitted;
            return this.mInteger[row];
        }
        if (col == 2) {
            this.mInteger[row].value = this.tableData[row].pngReceived;
            return this.mInteger[row];
        }
        if (col == 3) {
            this.mInteger[row].value = this.tableData[row].pngDamaged;
            return this.mInteger[row];
        }
        if (col == 4) {
            this.mLong[row].value = (int)this.tableData[row].pngAvgTransitTime;
            return this.mLong[row];
        }
        if (col == 5) {
            this.mLong[row].value = this.tableData[row].pngMaxTransitTime;
            return this.mLong[row];
        }
        if (col == 6) {
            this.mLong[row].value = this.tableData[row].pngMinTransitTime;
            return this.mLong[row];
        }
        if (col == 7) {
            this.mDate[row].setTime(this.tableData[row].pngMonitorStart);
            return this.mDate[row];
        }
        if (col == 8) {
            this.mDate[row].setTime(this.tableData[row].pngMonitorEnd);
            return this.mDate[row];
        }
        return this.statTypeValues[this.tableData[row].pngStatisticType];
    }

    private class HistorySorter
    implements Comparator {
        private HistorySorter() {
        }

        public int compare(Object o1, Object o2) {
            PingReport r1 = (PingReport)o1;
            PingReport r2 = (PingReport)o2;
            if (r1.pngMonitorStart > r2.pngMonitorStart) {
                return 1;
            }
            if (r1.pngMonitorStart < r2.pngMonitorStart) {
                return -1;
            }
            if (r1.pngMonitorEnd > r2.pngMonitorEnd) {
                return 1;
            }
            if (r1.pngMonitorEnd < r2.pngMonitorEnd) {
                return -1;
            }
            return 0;
        }
    }

    private class TwoNameSorter
    implements Comparator {
        private TwoNameSorter() {
        }

        public int compare(Object o1, Object o2) {
            PingReport r1 = (PingReport)o1;
            PingReport r2 = (PingReport)o2;
            int x = r1.prName1.compareTo(r2.prName1);
            if (x != 0) {
                return x;
            }
            return r1.getPrName2().compareTo(r2.getPrName2());
        }
    }

    private class OneNameSorter
    implements Comparator {
        private OneNameSorter() {
        }

        public int compare(Object o1, Object o2) {
            PingReport r1 = (PingReport)o1;
            PingReport r2 = (PingReport)o2;
            return r1.prName1.compareTo(r2.prName1);
        }
    }
}

