/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.PrintWriter;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintHistoryChart {
    public int printBatch(GuiReportReq grr, Object responseData, PrintWriter writer, String header) {
        HistChartProcessor processor = new HistChartProcessor();
        return this.print(grr.reportSubtype, processor.processResponse(responseData, grr), writer, header);
    }

    public int print(int reportSubtype, Object[] arrays, PrintWriter writer, String header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PrintHistoryChart.class.getName(), "print", "reportSubtype, arrays, writer, header");
        }
        int rowCount = 0;
        if (header != null) {
            String message = MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[reportSubtype][0]);
            if (message.startsWith("By ")) {
                message = message.substring(3);
            }
            writer.print(message);
            writer.print(",");
            writer.print(MessageLog.getMessageNoID("GEN5000L"));
            writer.print(",");
            writer.println(header);
        }
        Date date = new Date();
        String[] nameArray = (String[])arrays[1];
        double[] timeArray = (double[])arrays[2];
        double[] amountArray = (double[])arrays[3];
        for (int index = 0; index < nameArray.length; ++index) {
            writer.print(WriteReports.adjustString(nameArray[index]));
            writer.print(",");
            long value = (long)timeArray[index];
            date.setTime(value);
            writer.print(date);
            writer.print(",");
            value = (long)amountArray[index];
            writer.println(value);
            ++rowCount;
        }
        int traceResult = rowCount;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PrintHistoryChart.class.getName(), "print", traceResult);
        }
        return traceResult;
    }

    public int printPairs(int reportSubtype, Object[] arrays, PrintWriter writer, String header) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PrintHistoryChart.class.getName(), "printPairs", "reportSubtype, arrays, writer, header");
        }
        int rowCount = 0;
        if (header != null) {
            String message = MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[reportSubtype][0]);
            if (message.startsWith("By ")) {
                message = message.substring(3);
            }
            writer.print(message);
            writer.print(",");
            writer.print(MessageLog.getMessageNoID("GEN5000L"));
            writer.print(",");
            writer.println(header);
        }
        String currentName = " !@#$%^&* ";
        Date date = new Date();
        String[] nameArray = (String[])arrays[1];
        double[] timeArray = (double[])arrays[2];
        double[] amountArray = (double[])arrays[3];
        for (int index = 0; index < nameArray.length; ++index) {
            if (!nameArray[index].equals(currentName)) {
                if (index != 0) {
                    writer.println();
                }
                currentName = nameArray[index];
                String adjustedName = WriteReports.adjustString(currentName);
                writer.print(adjustedName);
                ++rowCount;
            }
            writer.print(",");
            long value = (long)timeArray[index];
            date.setTime(value);
            writer.print(date);
            writer.print(",");
            value = (long)amountArray[index];
            writer.print(value);
        }
        writer.println();
        int traceResult = rowCount;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PrintHistoryChart.class.getName(), "printPairs", traceResult);
        }
        return traceResult;
    }
}

