/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class Rank
implements Serializable,
Packable {
    static final long serialVersionUID = -555478448336753568L;
    public static final byte NO_ACTION = 0;
    public static final byte NEW = 1;
    public static final byte UPDATE = 2;
    public static final byte DELETE = 3;
    public transient Rank rankNext;
    public transient long rankOffset;
    public int rankID;
    public int rankVolGroupID;
    public int rankComputerID;
    public String rankName;
    public String rankOtherName;
    public long rankSize;
    public int rankType;
    public short rankGroup;
    public short rankFlag;
    public int rankDiskCount;
    public int rankDiskIndex;
    public short rankWidth;
    public int rankArrayNumber;
    public short rankConfig;
    public String rankArrays;
    public int rankStatus;
    public Vector rankArraySites;
    public String rankArraySiteNames;
    public long rankDiscoveredTime;
    public long rankProbeTime;
    public static final short RAID5 = 0;
    public static final short RAID10 = 1;
    public static final short JBOD = 2;
    public static final short RAID0 = 3;
    public static final short RAID1 = 4;
    public static final short RAID2 = 5;
    public static final short RAID3 = 6;
    public static final short RAID4 = 7;
    public static final short RAID6 = 8;
    public static final short RAID51 = 9;
    public static final short RAID15 = 10;
    public static final short UNKNOWN_CONFIG = 11;
    public static final short RAIDTYPE_MAX = 12;
    public static final String[] REDUNDANCY = new String[]{"5", "10", "", "0", "1", "2", "3", "4", "6", "51", "15"};
    public static final String[] CONFIGS = new String[]{MessageLog.getMessageNoID("SAG0057I"), MessageLog.getMessageNoID("SAG0058I"), MessageLog.getMessageNoID("SAG0059I"), MessageLog.getMessageNoID("SAG0516I"), MessageLog.getMessageNoID("SAG0517I"), MessageLog.getMessageNoID("SAG0518I"), MessageLog.getMessageNoID("SAG0519I"), MessageLog.getMessageNoID("SAG0520I"), MessageLog.getMessageNoID("SAG0522I"), MessageLog.getMessageNoID("SAG0523I"), MessageLog.getMessageNoID("SAG0524I"), MessageLog.getMessageNoID("SAG0521I")};
    public static final short UNKNOWN_TYPE = 0;
    public static final short FIXED_BLOCK = 1;
    public static final short VARIABLE_BLOCK = 2;
    public static final short CKD = 3;
    public static final String[] FORMATS = new String[]{MessageLog.getMessageNoID("SAG0055I"), MessageLog.getMessageNoID("SAG0087L"), MessageLog.getMessageNoID("SAG0087L"), MessageLog.getMessageNoID("SAG0056I"), MessageLog.getMessageNoID("SAG0056I"), MessageLog.getMessageNoID("SAG0056I"), MessageLog.getMessageNoID("SAG0056I"), MessageLog.getMessageNoID("SAG0056I")};
    public static final short GROUP0 = 0;
    public static final short GROUP1 = 1;
    public static final String[] GROUPS = new String[]{MessageLog.getMessageNoID("SAG0624L"), MessageLog.getMessageNoID("SAG0625L")};
    public static final short UNKNOWN_STATUS = 0;
    public static final short NORMAL = 1;
    public static final short FORMATTING = 2;
    public static final short AVAILABLE = 3;
    public static final short UNASSIGNED = 4;
    public static final short ERRORS = 5;
    public static final short CONFIGURING = 6;
    public static final short DECONFIGURING = 7;
    public static final short DEPOPULATING = 8;
    public static final short RESERVED = 9;
    public static final String[] RANK_STATUS = new String[]{MessageLog.getMessageNoID("SAG0600L"), MessageLog.getMessageNoID("SAG0621L"), MessageLog.getMessageNoID("SAG0622L"), MessageLog.getMessageNoID("SAG0623L"), MessageLog.getMessageNoID("SAG0103L"), MessageLog.getMessageNoID("SAG0626L"), MessageLog.getMessageNoID("SAG0627L"), MessageLog.getMessageNoID("SAG0628L"), MessageLog.getMessageNoID("SAG0629L"), MessageLog.getMessageNoID("SAG0630L")};

    public String getRankType(int type) {
        String rankType = new String();
        for (int i = 0; i < FORMATS.length; ++i) {
            int mask = 1 << i;
            if ((mask & type) == 0) continue;
            rankType = rankType.concat(FORMATS[i]);
            rankType = rankType.concat(", ");
        }
        rankType = rankType.length() != 0 ? rankType.substring(0, rankType.length() - 2) : MessageLog.getMessageNoID("SAG0600L");
        return rankType;
    }

    public boolean equals(Object o) {
        Rank that = (Rank)o;
        return this.rankVolGroupID == that.rankVolGroupID && this.rankComputerID == that.rankComputerID && this.rankID == that.rankID && this.rankSize == that.rankSize && this.rankArrays == that.rankArrays && Util.stringsEqual(this.rankName, that.rankName) && Util.stringsEqual(this.rankOtherName, that.rankOtherName) && this.rankType == that.rankType && this.rankConfig == that.rankConfig && this.rankStatus == that.rankStatus && this.rankGroup == that.rankGroup && this.rankProbeTime == that.rankProbeTime;
    }

    public Packable getNext() {
        return this.rankNext;
    }

    public void setNext(Packable next) {
        this.rankNext = (Rank)next;
    }

    public String getRankStatus() {
        VolGroup vg = new VolGroup();
        return vg.getOperationalStatus(this.rankStatus);
    }

    public String getConfig() {
        String result = MessageLog.getMessageNoID("STG1020L");
        if (this.rankConfig > -1) {
            try {
                result = CONFIGS[this.rankConfig];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getGroup() {
        String result = MessageLog.getMessageNoID("STG1020L");
        if (this.rankGroup > -1) {
            try {
                result = CONFIGS[this.rankGroup];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }
}

