/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ReportDataAdjuster {
    public abstract void adjust(Object[] var1, boolean var2);

    public abstract String[] getLabels();

    public abstract int getNumberRows();

    public abstract int getNumberColumns();

    public abstract int[] getRenderers();

    public abstract Object getCellData(int var1, int var2);

    public abstract boolean hasTotalsRow();

    public void replaceArray(Object dataArray) {
    }

    public Object getArray() {
        throw new UnsupportedOperationException();
    }

    public int getNumberFrozenRows() {
        return 0;
    }

    public int getNumberSpannedRows() {
        return 0;
    }

    public int[] getHiddenColumns() {
        return null;
    }

    public int getFirstColumn() {
        return 0;
    }

    public int getFrozenColumns() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public String getSuffix() {
        return null;
    }

    public int[] initHistoryLegend() {
        return null;
    }

    public int[] getSelectedIDs() {
        return null;
    }

    public int[] getSelectedUsers() {
        return null;
    }

    public String getHelpID() {
        return null;
    }

    public int getRowIndex(int row, int[] rowMap) {
        int mapIndex = -1;
        if (rowMap == null) {
            return row;
        }
        mapIndex = rowMap[row];
        return mapIndex;
    }

    public int[] fixColumnArray(int[] columnArray) {
        if (columnArray != null) {
            int[] hiddenCols = this.getHiddenColumns();
            if (hiddenCols != null && hiddenCols.length > 0) {
                int numberHidden = hiddenCols.length;
                int[] workArray = new int[columnArray.length - numberHidden];
                int workIndex = 0;
                for (int z = 0; z < columnArray.length; ++z) {
                    int testIndex;
                    int column = columnArray[z];
                    for (testIndex = 0; testIndex < numberHidden && hiddenCols[testIndex] != column; ++testIndex) {
                    }
                    if (testIndex != numberHidden || workIndex >= workArray.length) continue;
                    workArray[workIndex] = column;
                    ++workIndex;
                }
                columnArray = workArray;
            }
        } else {
            int numCols = this.getNumberColumns();
            int[] hiddenCols = this.getHiddenColumns();
            int firstColumn = this.getFirstColumn();
            int frozenColumns = this.getFrozenColumns();
            columnArray = new int[numCols];
            for (int a = 0; a < numCols; ++a) {
                columnArray[a] = a;
            }
            if (firstColumn > 0) {
                int c = firstColumn;
                while (c > frozenColumns) {
                    columnArray[c--] = columnArray[c];
                }
                columnArray[c] = firstColumn;
            }
            if (hiddenCols != null) {
                int[] fullArray = columnArray;
                columnArray = new int[numCols - hiddenCols.length];
                int t = 0;
                for (int z = 0; z < numCols; ++z) {
                    int s;
                    for (s = 0; s < hiddenCols.length && hiddenCols[s] != fullArray[z]; ++s) {
                    }
                    if (s != hiddenCols.length || t >= columnArray.length) continue;
                    columnArray[t] = fullArray[z];
                    ++t;
                }
            }
        }
        return columnArray;
    }

    public static ReportDataAdjuster makeAdjuster(GuiReportReq grr) throws GeneralException {
        ReportDataAdjuster result = null;
        StringBuffer buf = new StringBuffer(100);
        Object uncast = ReportDataAdjuster.constructAdjuster(grr, buf);
        try {
            result = (ReportDataAdjuster)uncast;
        }
        catch (ClassCastException e) {
            Object[] parms = new Object[]{new Integer(grr.reportType), buf.toString()};
            String s = MessageLog.getMessage("GEN0507E", parms);
            throw new GeneralException(s);
        }
        return result;
    }

    public static CustomReportDataAdjuster makeCustomAdjuster(GuiReportReq grr) throws GeneralException {
        CustomReportDataAdjuster result = null;
        StringBuffer buf = new StringBuffer(100);
        Object uncast = ReportDataAdjuster.constructAdjuster(grr, buf);
        try {
            result = (CustomReportDataAdjuster)uncast;
        }
        catch (ClassCastException e) {
            Object[] parms = new Object[]{new Integer(grr.reportType), buf.toString()};
            String s = MessageLog.getMessage("GEN0508E", parms);
            throw new GeneralException(s);
        }
        return result;
    }

    private static Object constructAdjuster(GuiReportReq grr, StringBuffer buf) throws GeneralException {
        Object[] parms;
        Object result = null;
        Constructor<?> constructor = null;
        int reportType = grr.reportType;
        String msgID = "GEN0500E";
        String className = GuiReportReq.guiClasses[reportType][3];
        if (className == null) {
            className = "null";
        } else {
            msgID = "GEN0501E";
            try {
                Class<?> clazz = Class.forName(className);
                Class[] parmClasses = new Class[]{GuiReportReq.class};
                msgID = "GEN0502E";
                constructor = clazz.getConstructor(parmClasses);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (constructor != null) {
            try {
                parms = new Object[]{grr};
                result = constructor.newInstance(parms);
                msgID = null;
            }
            catch (InvocationTargetException e1) {
                msgID = "GEN0503E";
                e1.printStackTrace(MessageLog.getThreadLog());
            }
            catch (IllegalAccessException e2) {
                msgID = "GEN0504E";
            }
            catch (IllegalArgumentException e3) {
                msgID = "GEN0505E";
            }
            catch (InstantiationException e4) {
                msgID = "GEN0506E";
            }
        }
        buf.append(className);
        if (msgID != null) {
            parms = new Object[]{new Integer(reportType), className};
            String s = MessageLog.getMessage(msgID, parms);
            throw new GeneralException(s);
        }
        return result;
    }
}

