/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedAdjuster
extends CustomReportDataAdjuster {
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String CLUSTER = MessageLog.getMessageNoID("STG1136L");
    private static final String CREATOR = MessageLog.getMessageNoID("STG0021L");
    private static final String GROUP = MessageLog.getMessageNoID("STG1103L");
    private static final String MOUNTPNT = MessageLog.getMessageNoID("STG1230L");
    public static final String FREESPACE = MessageLog.getMessageNoID("STG1184L");
    public static final String USEDSPACE = MessageLog.getMessageNoID("STG1237L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    private static final String PCT_FREE = MessageLog.getMessageNoID("STG2040L");
    private static final String PCT_USED = MessageLog.getMessageNoID("STG2041L");
    private static final String USED_INODES = MessageLog.getMessageNoID("STG1235L");
    private static final String FREE_INODES = MessageLog.getMessageNoID("STG1236L");
    private static final String PCT_FREEI = MessageLog.getMessageNoID("STG2042L");
    private static final String PCT_USEDI = MessageLog.getMessageNoID("STG2043L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG5048L");
    private static final String FILE_CNT = MessageLog.getMessageNoID("STG2054L");
    private static final String DIR_CNT = MessageLog.getMessageNoID("STG2055L");
    private static final String VOL_GRP = MessageLog.getMessageNoID("STG6101L");
    private static final String VOL_ALLOC = MessageLog.getMessageNoID("STG6211L");
    public String[] colNames;
    public String[] COL_LABELS = new String[]{" ", " ", PCT_FREE, USEDSPACE, FREESPACE, CAPACITY, FILE_CNT, DIR_CNT, PCT_FREE, USED_INODES, FREE_INODES};
    public String[] BYFS_LABELS = new String[]{" ", " ", PCT_FREE, USEDSPACE, FREESPACE, CAPACITY, FILE_CNT, DIR_CNT, PCT_FREE, USED_INODES, FREE_INODES, VOL_GRP, VOL_ALLOC};
    public static final int QUAL_COL = 0;
    public static final int NAME_COL = 1;
    public static final int PCT_FS_COL = 2;
    public static final int USED_COL = 3;
    public static final int FREE_COL = 4;
    public static final int CAPACITY_COL = 5;
    public static final int FILE_CNT_COL = 6;
    public static final int DIR_CNT_COL = 7;
    public static final int PCT_FI_COL = 8;
    public static final int IUSED_COL = 9;
    public static final int IFREE_COL = 10;
    public static final int VGRP_COL = 11;
    public static final int ALLOC_COL = 12;
    private GuiReportReq grr;
    private RespFSspace[] data;
    private MutableLong[] mLong;
    private MutableShort[] mShort;
    private MutableLongExt[] mLongExt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;
    public int frozenRows;
    private boolean ignoreTotalColumn = false;

    public SpaceUsedAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 2;
        this.colNames = grr.reportSubtype == 10 ? this.BYFS_LABELS : this.COL_LABELS;
        if (grr.reportType == 10) {
            this.colNames[2] = PCT_FREE;
            this.colNames[8] = PCT_FREEI;
        } else {
            this.colNames[2] = PCT_USED;
            this.colNames[8] = PCT_USEDI;
        }
        switch (grr.reportSubtype) {
            case 10: {
                this.colNames[0] = COMPUTER;
                this.colNames[1] = MOUNTPNT;
                break;
            }
            case 11: {
                this.colNames[0] = CREATOR;
                this.colNames[1] = GROUP;
                this.ignoreTotalColumn = true;
                break;
            }
            case 12: {
                this.colNames[1] = COMPUTER;
                break;
            }
            case 13: {
                this.colNames[0] = CREATOR;
                this.colNames[1] = GROUP;
                this.ignoreTotalColumn = true;
                break;
            }
            case 82: {
                this.colNames[1] = CLUSTER;
                break;
            }
            case 14: {
                this.colNames[1] = DOMAIN;
                break;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[4] = 7;
        this.rendererArray[3] = 7;
        this.rendererArray[5] = 7;
        this.rendererArray[6] = 5;
        this.rendererArray[7] = 5;
        this.rendererArray[9] = 5;
        this.rendererArray[10] = 5;
        this.rendererArray[2] = 6;
        this.rendererArray[8] = 6;
        if (grr.reportSubtype == 10) {
            this.rendererArray[12] = 7;
        }
        switch (grr.reportSubtype) {
            case 8: {
                this.frozenColumns = 0;
                break;
            }
            case 9: {
                this.frozenColumns = 0;
                break;
            }
            case 12: 
            case 82: {
                this.hiddenColumns = new int[1];
                this.hiddenColumns[0] = 0;
                break;
            }
            case 14: {
                this.hiddenColumns = new int[1];
                this.hiddenColumns[0] = 0;
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.hiddenColumns = new int[2];
                this.hiddenColumns[0] = 0;
                this.hiddenColumns[1] = 1;
            }
        }
        this.firstColumn = grr.reportType == 9 ? 3 : (grr.reportType == 10 ? 4 : 5);
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        int hiIndex = this.data.length;
        if (this.grr.reportType == 9) {
            Arrays.sort(this.data, this.frozenRows, hiIndex, new PercentSorter());
        } else if (this.grr.reportType == 10) {
            Arrays.sort(this.data, this.frozenRows, hiIndex, new PercentSorter());
        } else {
            Arrays.sort(this.data, this.frozenRows, hiIndex, new CapacitySorter());
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.data = (RespFSspace[])dataArray;
        this.rows = this.data.length;
        if (this.rows > 1) {
            this.addTotal();
        }
        this.mLong = new MutableLong[this.rows];
        this.mLongExt = new MutableLongExt[this.rows];
        this.mShort = new MutableShort[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.mLong[i] = new MutableLong();
            this.mLongExt[i] = new MutableLongExt();
            this.mShort[i] = new MutableShort();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rows; ++i) {
            RespFSspace info = this.data[i];
            info.freeSpace *= 512L;
            info.usedSpace *= 512L;
            info.capacity *= 512L;
            if (this.grr.reportType == 10) {
                info.spacePercent = this.getPercent(info.freeSpace, info.usedSpace);
                info.inodePercent = this.getPercent(info.freeInodes, info.usedInodes);
            } else {
                info.spacePercent = this.getPercent(info.usedSpace, info.freeSpace);
                info.inodePercent = this.getPercent(info.usedInodes, info.freeInodes);
            }
            if (i >= this.frozenRows) {
                if (this.batch) continue;
                switch (this.grr.reportSubtype) {
                    case 10: {
                        info.creator = GuiUtil.getComputer((int)info.id).gcTSName;
                        break;
                    }
                    case 12: {
                        info.setName(GuiUtil.getComputer((int)info.id).gcTSName);
                    }
                    case 14: 
                    case 82: {
                        info.creator = " ";
                        break;
                    }
                    case 15: {
                        info.setName(NETWORK);
                        info.creator = " ";
                    }
                }
                continue;
            }
            if (this.grr.reportSubtype != 27 && this.grr.reportSubtype != 13 && this.grr.reportSubtype != 10 && this.grr.reportSubtype != 11) continue;
            info.creator = MessageLog.getMessageNoID("STG4136L");
            info.setName("");
        }
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        for (int i = 0; i < this.data.length; ++i) {
            RespFSspace dataRow = this.data[i];
            int objectID = dataRow.id;
            if (this.grr.reportSubtype == 10) {
                objectID = dataRow.fs_id;
            }
            HistChartProcessor.addLegend(this.grr, dataRow.creator, dataRow.getName(), objectID);
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            RespFSspace dataRow = this.data[i];
            int objectID = dataRow.id;
            if (this.grr.reportSubtype == 10) {
                objectID = dataRow.fs_id;
            }
            IDarray[i] = objectID;
        }
        return IDarray;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 0: {
                return this.data[row].creator;
            }
            case 1: {
                return this.data[row].getName();
            }
            case 2: {
                this.mShort[row].value = this.data[row].spacePercent;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mShort[row];
            }
            case 4: {
                this.mLong[row].value = this.data[row].freeSpace;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLong[row];
            }
            case 3: {
                this.mLong[row].value = this.data[row].usedSpace;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLong[row];
            }
            case 5: {
                this.mLong[row].value = this.data[row].capacity;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLong[row];
            }
            case 6: {
                this.mLongExt[row].value = this.data[row].fileCount;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLongExt[row];
            }
            case 7: {
                this.mLongExt[row].value = this.data[row].directoryCount;
                if (this.mLongExt[row].value < 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLongExt[row];
            }
            case 9: {
                this.mLongExt[row].value = this.data[row].usedInodes;
                if (this.mLongExt[row].value < 0L || this.mLongExt[row].value == 0L && this.data[row].freeInodes == 0L && this.data[row].inodePercent < 0) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLongExt[row];
            }
            case 10: {
                this.mLongExt[row].value = this.data[row].freeInodes;
                if (this.mLongExt[row].value < 0L || this.mLongExt[row].value == 0L && this.data[row].usedInodes == 0L && this.data[row].inodePercent < 0) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLongExt[row];
            }
            case 8: {
                this.mShort[row].value = this.data[row].inodePercent;
                if (this.mShort[row].value < 0) {
                    this.mShort[row].value = (short)-1;
                }
                return this.mShort[row];
            }
            case 11: {
                return this.data[row].serialNumber;
            }
            case 12: {
                this.mLongExt[row].value = this.data[row].unknown;
                if (this.mLongExt[row].value <= 0L) {
                    this.mLongExt[row].value = -1L;
                }
                return this.mLongExt[row];
            }
        }
        return null;
    }

    private short getPercent(long v1, long v2) {
        if (v1 + v2 <= 0L) {
            return -1;
        }
        return (short)(v1 * 100L / (v1 + v2));
    }

    private void addTotal() {
        if (this.ignoreTotalColumn) {
            return;
        }
        this.bHasTotalRow = true;
        RespFSspace[] plusArray = new RespFSspace[this.rows + 1];
        plusArray[0] = new RespFSspace();
        plusArray[0].setName(MessageLog.getMessageNoID("STG4136L"));
        plusArray[0].serialNumber = new String(MessageLog.getMessageNoID("GEN0185T"));
        plusArray[0].creator = " ";
        plusArray[0].inodePercent = 0;
        plusArray[0].spacePercent = 0;
        for (int ix = 0; ix < this.rows; ++ix) {
            if (this.data[ix].capacity > 0L) {
                plusArray[0].capacity += this.data[ix].capacity;
            }
            if (this.data[ix].freeSpace > 0L) {
                plusArray[0].freeSpace += this.data[ix].freeSpace;
            }
            if (this.data[ix].usedSpace > 0L) {
                plusArray[0].usedSpace += this.data[ix].usedSpace;
            }
            if (this.data[ix].usedInodes > 0L) {
                plusArray[0].usedInodes += this.data[ix].usedInodes;
            }
            if (this.data[ix].freeInodes > 0L) {
                plusArray[0].freeInodes += this.data[ix].freeInodes;
            }
            if (this.data[ix].fileCount > 0L) {
                plusArray[0].fileCount += this.data[ix].fileCount;
            }
            if (this.data[ix].directoryCount > 0L) {
                plusArray[0].directoryCount += this.data[ix].directoryCount;
            }
            if (this.data[ix].unknown > 0L) {
                plusArray[0].unknown += this.data[ix].unknown;
            }
            plusArray[ix + 1] = this.data[ix];
        }
        this.data = plusArray;
        this.frozenRows = 1;
        ++this.rows;
    }

    private class CapacitySorter
    implements Comparator {
        private CapacitySorter() {
        }

        public int compare(Object o1, Object o2) {
            RespFSspace r1 = (RespFSspace)o1;
            RespFSspace r2 = (RespFSspace)o2;
            if (r1.capacity > r2.capacity) {
                return -1;
            }
            if (r1.capacity < r2.capacity) {
                return 1;
            }
            return 0;
        }
    }

    private class PercentSorter
    implements Comparator {
        private PercentSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespFSspace r1 = (RespFSspace)o1;
            RespFSspace r2 = (RespFSspace)o2;
            if (r1.spacePercent > r2.spacePercent) {
                return -1;
            }
            if (r1.spacePercent < r2.spacePercent) {
                return 1;
            }
            return 0;
        }
    }
}

