/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.SpaceUsedAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String GRAPH_SIZE_SEL = "STG1251T";
    public static final String GRAPH_SIZE = "STG7528L";
    public static final String GRAPH_SIZE_ALL = "STG1276T";
    public static final String COUNT_HIST = "STG5104L";
    public static final String COUNT_HISTORY = "STG7536L";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_HISTORY = "STG7530L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String FREE_PERCENT_HISTORY = "STG7531L";
    public static final String USED_HIST = "STG5107L";
    public static final String USED_HISTORY = "STG7537L";
    public static final String USED_PERCENT_HIST = "STG5108L";
    public static final String USED_PERCENT_HISTORY = "STG7538L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String CAPACITY_HISTORY = "STG7539L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.chartSubtype > 0) {
            return null;
        }
        this.title = grr.histSubtype == 0 ? COUNT_HIST : (grr.histSubtype == 1 ? FREE_HIST : (grr.histSubtype == 2 ? FREE_PERCENT_HIST : (grr.histSubtype == 3 ? USED_HIST : (grr.histSubtype == 4 ? USED_PERCENT_HIST : CAPACITY_HIST))));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        if (grr.chartSubtype > 0) {
            chart = this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SpaceUsedGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] data = (RespFSspace[])pData;
        SpaceUsedAdjuster adjuster = (SpaceUsedAdjuster)pAdjuster;
        int rowCount = rows.length;
        Number[][] chartY = new Number[2][rowCount];
        String[] pointL = new String[rowCount];
        String[] seriesL = new String[2];
        int k = 0;
        if (grr.reportType == 10) {
            k = 1;
        }
        seriesL[k] = SpaceUsedAdjuster.USEDSPACE;
        seriesL[1 - k] = SpaceUsedAdjuster.FREESPACE;
        block5: for (int i = rowCount - 1; i >= 0; --i) {
            int row = rows[i];
            chartY[k][i] = new Double(data[row].usedSpace);
            chartY[1 - k][i] = new Double(data[row].freeSpace);
            switch (grr.reportSubtype) {
                case 10: {
                    pointL[i] = data[row].creator + " : " + data[row].getName();
                    continue block5;
                }
                case 11: 
                case 13: {
                    pointL[i] = data[row].creator + "." + data[row].getName();
                    continue block5;
                }
                case 12: 
                case 14: 
                case 15: 
                case 82: {
                    pointL[i] = data[row].getName();
                }
            }
        }
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, chartY, seriesL, pointL, new ChartOptions(), grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        return chart;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SpaceUsedGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        RespFSspace[] data = (RespFSspace[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            RespFSspace dataRow = data[rows[i]];
            int objectID = dataRow.id;
            if (grr.reportSubtype == 10) {
                objectID = dataRow.fs_id;
            }
            newGrr.selectedResources[i] = objectID;
            SpaceHistChart.addLegend(newGrr, dataRow.creator, dataRow.getName(), objectID);
        }
        if (actionCommand == COUNT_HIST) {
            newGrr.chartLabelType = (byte)6;
            newGrr.histSubtype = 0;
            newGrr.historyTitle = "STG4118L";
        } else if (actionCommand == FREE_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = 1;
            newGrr.historyTitle = "STG5111L";
        } else if (actionCommand == FREE_PERCENT_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)2;
            newGrr.historyTitle = "STG5112L";
        } else if (actionCommand == USED_HIST) {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = (byte)3;
            newGrr.historyTitle = "STG1278T";
        } else if (actionCommand == USED_PERCENT_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)4;
            newGrr.historyTitle = "STG5110L";
        } else {
            newGrr.chartLabelType = 1;
            newGrr.histSubtype = (byte)5;
            newGrr.historyTitle = "STG5113L";
        }
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        GuiReportReq traceResult = newGrr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SpaceUsedGrapher.class.getName(), "createHistory", traceResult);
        }
        return traceResult;
    }
}

