/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.gui.DiskData;
import org.eclipse.aperi.TStorm.gui.DiskTreeNode;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskDDI
extends DataDisplayInfo {
    private int diskID;
    int logicalDiskID = -1;
    private String path;
    private int computerID;
    private DiskData ddPanel;
    protected int tabDisplayed;
    boolean inDiskArray;
    short diskArrayType = (short)-1;
    String enclosure;
    private boolean changesPending = false;
    private byte newAWRE = (byte)-1;
    private byte newARRE = (byte)-1;
    private byte newNER = (byte)-1;

    public DiskDDI(DiskTreeNode pTreeNode, int pDiskID, String pPath, int pComputerID, String pEnclosure, boolean pInDiskArray, short pDiskArrayType) {
        super(MessageLog.getMessageNoID("STG1293T", new Object[]{pPath, pEnclosure}));
        this.treeNode = pTreeNode;
        this.diskID = pDiskID;
        this.computerID = pComputerID;
        this.path = pPath;
        this.enclosure = pEnclosure;
        this.inDiskArray = pInDiskArray;
        if (this.inDiskArray) {
            this.diskArrayType = pDiskArrayType;
        }
        this.tabDisplayed = 0;
        this.reDisplay();
    }

    public DiskDDI(DiskTreeNode pTreeNode, int pDiskID, String pPath, int pComputerID) {
        this(pTreeNode, pDiskID, pPath, pComputerID, GuiUtil.getComputer((int)pComputerID).gcTSName, false, -1);
    }

    public void reDisplay() {
        if (this.panel == null) {
            this.tabDisplayed = 0;
            this.ddPanel = new DiskData(this.diskID, this.path, this.computerID, this.newAWRE, this.newARRE, this.newNER, this);
            JPanel mainPanel = new JPanel(new BorderLayout());
            if (this.treeNode instanceof AlertableTreeNode) {
                JPopupMenu popup = this.treeNode.getPopupMenuForButtons();
                JPanel buttonPanel = this.getButtonPanel(popup);
                if (this.getActionButtonCount() > 0) {
                    mainPanel.add((Component)buttonPanel, "North");
                }
            }
            mainPanel.add((Component)this.ddPanel, "Center");
            this.panel = mainPanel;
        }
        this.show();
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.ddPanel != null) {
            return this.ddPanel.applyButton.isEnabled();
        }
        return this.changesPending;
    }

    public void panelToBeNulled() {
        this.newAWRE = this.ddPanel.newAWRE;
        this.newARRE = this.ddPanel.newARRE;
        this.newNER = this.ddPanel.newNER;
        this.changesPending = this.ddPanel.applyButton.isEnabled();
        this.ddPanel = null;
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page == 0) {
            this.pf = pf;
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pf.getImageableX(), pf.getImageableY());
            Component p = this.ddPanel.getComponentAt(this.tabDisplayed);
            Color oldBG = p.getBackground();
            p.setBackground(Color.white);
            this.panel.paint(g2);
            p.setBackground(oldBG);
            return 0;
        }
        return 1;
    }

    public String getHelpID() {
        if (this.inDiskArray) {
            switch (this.tabDisplayed) {
                case 0: {
                    return "reascomp5";
                }
                case 1: {
                    return "reasss15";
                }
                case 2: {
                    return "reascomp10";
                }
                case 3: {
                    return "reascomp15";
                }
                case 4: {
                    return "reasss30";
                }
            }
            return null;
        }
        switch (this.tabDisplayed) {
            case 0: {
                return "reasss10";
            }
            case 1: {
                return "reasss15";
            }
            case 2: {
                return "reasss20";
            }
            case 3: {
                return "reasss25";
            }
            case 4: {
                return "reasss30";
            }
        }
        return null;
    }
}

