/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.gui.HostPathTable;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DiskHistTable;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeData;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiUpdateRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskData
extends JTabbedPane
implements ChangeListener,
GuiRequestor,
ActionListener,
ItemListener {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private static GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final Dimension DIM11 = new Dimension(1, 1);
    private static String MB = MessageLog.getMessageNoID("GEN0189T");
    private JPanel hTab = new JPanel(new BorderLayout());
    private String INFO = "  " + MessageLog.getMessageNoID("STG1140L") + "  ";
    private String PATHS = "  " + MessageLog.getMessageNoID("STG6055L") + "  ";
    private String PROBE = "  " + MessageLog.getMessageNoID("STG1141L") + "  ";
    private String HISTORY = "  " + MessageLog.getMessageNoID("STG1142L") + "  ";
    private String LUN = "  " + MessageLog.getMessageNoID("SAG0512L") + "  ";
    private String TRUE = MessageLog.getMessageNoID("GUI0119T");
    private String FALSE = MessageLog.getMessageNoID("GUI0120T");
    private String YES = MessageLog.getMessageNoID("GUI0121T");
    private String NO = MessageLog.getMessageNoID("GUI0122T");
    private String ON = MessageLog.getMessageNoID("GUI0123T");
    private String OFF = MessageLog.getMessageNoID("GUI0124T");
    private String READ = MessageLog.getMessageNoID("GUI0125T");
    private String WRITE = MessageLog.getMessageNoID("GUI0126T");
    private String BOTH = MessageLog.getMessageNoID("GUI0127T");
    private String NONE = MessageLog.getMessageNoID("GUI0128T");
    private String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    private int currentIndex = 0;
    protected static final int INFO_INDEX = 0;
    protected static final int PATH_INDEX = 1;
    protected static final int PROBE_INDEX = 2;
    protected static final int HISTORY_INDEX = 3;
    protected static final int LUN_INDEX = 4;
    private boolean pathTabCreated = false;
    private JPanel pathPanel = new JPanel(new BorderLayout());
    private JScrollPane pathTab = new JScrollPane(this.pathPanel);
    private int serverRequestType;
    private static final int CHANGE_DESIRED_SETTINGS = 101;
    private boolean histTabCreated = false;
    private boolean isLodestoneCluster = false;
    private boolean isFAStT = false;
    private int diskID;
    private Disk disk;
    private String path;
    private int computerID;
    private DiskDDI myDDI;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private boolean tabReset = false;
    private boolean infoTabCreated = false;
    private JPanel iTab = new JPanel(new BorderLayout());
    private boolean probeTabCreated = false;
    private JPanel pPanel = new JPanel(gridBag);
    private JScrollPane pTab = new JScrollPane(this.pPanel);
    private static final String APPLY = "STG1153L";
    private static final String RESET = "STG1154L";
    private TComboBox pdDskDesiredAWRE;
    private TComboBox pdDskDesiredARRE;
    private TComboBox pdDskDesiredNoErrRcvry;
    protected JButton applyButton = new JButton(MessageLog.getMessageNoID("STG1153L"));
    private JButton resetButton = new JButton(MessageLog.getMessageNoID("STG1154L"));
    protected byte oldAWRE;
    protected byte oldARRE;
    protected byte oldNER;
    protected byte newAWRE;
    protected byte newARRE;
    protected byte newNER;
    private boolean lunTabCreated = false;
    private JPanel lTab;
    private DecimalFormat d0Fmt = new DecimalFormat();

    public DiskData(int diskID, String path, int computerID, byte newAWRE, byte newARRE, byte newNER, DiskDDI myDDI) {
        this.diskID = diskID;
        this.path = path;
        this.computerID = computerID;
        this.newAWRE = newAWRE;
        this.newARRE = newARRE;
        this.newNER = newNER;
        this.myDDI = myDDI;
        Object[] diskSettings = new String[Disk.STATES.length - 1];
        System.arraycopy(Disk.STATES, 1, diskSettings, 0, diskSettings.length);
        this.pdDskDesiredAWRE = new TComboBox(diskSettings);
        this.pdDskDesiredARRE = new TComboBox(diskSettings);
        this.pdDskDesiredNoErrRcvry = new TComboBox(diskSettings);
        this.isLodestoneCluster(myDDI.diskArrayType);
        this.getInfo();
        this.setPreferredSize(DIM11);
        this.addTab(this.INFO, this.iTab);
        this.addTab(this.PATHS, this.pathTab);
        this.addTab(this.PROBE, this.pTab);
        this.addTab(this.HISTORY, this.hTab);
        if (GuiUtil.isAnyDiskArrayInstalled()) {
            this.lTab = new JPanel(new BorderLayout());
            this.addTab(this.LUN, this.lTab);
            this.setEnabledAt(4, myDDI.logicalDiskID > 0);
        }
        this.hTab.setPreferredSize(DIM11);
        this.addChangeListener(this);
        DiskData.gbcFill_1.gridheight = 40;
        DiskData.gbcFill_1.weighty = 1.0;
        DiskData.gbcFill_1.ipadx = 60;
        DiskData.gbcFill_2.gridwidth = 4;
        DiskData.gbcFill_2.weightx = 1.0;
        DiskData.gbcLabel.anchor = 17;
        DiskData.gbcLabel.ipadx = 30;
        DiskData.gbcLast.anchor = 17;
        DiskData.gbcLast.gridwidth = 0;
        this.applyButton.setEnabled(false);
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.tabReset) {
            this.myDDI.tabDisplayed = this.currentIndex = this.getSelectedIndex();
            switch (this.currentIndex) {
                case 0: {
                    if (this.infoTabCreated) break;
                    this.getInfo();
                    break;
                }
                case 1: {
                    if (this.pathTabCreated) break;
                    this.getPathInfo();
                    break;
                }
                case 2: {
                    if (this.probeTabCreated) break;
                    this.getProbeInfo();
                    break;
                }
                case 3: {
                    if (this.histTabCreated) break;
                    this.getProbeHistInfo();
                    break;
                }
                case 4: {
                    if (this.lunTabCreated) break;
                    this.getLunInfo();
                }
            }
        } else {
            this.tabReset = true;
            this.setSelectedIndex(2);
            this.tabReset = false;
        }
    }

    private boolean isLodestoneCluster(short osType) {
        if (osType == 21) {
            this.isLodestoneCluster = true;
        }
        return this.isLodestoneCluster;
    }

    private void getInfo() {
        this.serverRequestType = 0;
        Request request = new Request();
        GuiRequest.diskInfo(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    private void getPathInfo() {
        boolean isEnabled;
        JPanel container = null;
        boolean bl = isEnabled = this.disk.dskHostPaths != null;
        if (isEnabled) {
            HostPathTable table = new HostPathTable(this.disk.dskHostPaths);
            container = table;
        } else {
            String s = MessageLog.getMessageNoID("STG0020M");
            JLabel label = new JLabel(s);
            label.setForeground(Color.black);
            label.setFont(BaseTree.boldFont);
            container = new JPanel(new GridBagLayout());
            container.add((Component)label, new GridBagConstraints());
        }
        this.pathPanel.add((Component)container, "Center");
        this.pathTabCreated = true;
    }

    private void getProbeInfo() {
        this.serverRequestType = 2;
        Request request = new Request();
        GuiRequest.diskProbeInfo(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    private void getLunInfo() {
        this.serverRequestType = 4;
        Request request = new Request();
        GuiRequest.lunInfo(request, this.myDDI.logicalDiskID);
        GuiClient.doRequest(this, request);
    }

    private void getProbeHistInfo() {
        this.serverRequestType = 3;
        Request request = new Request();
        GuiRequest.diskHistory(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            if (this.serverRequestType == 0) {
                DevAccess da = (DevAccess)response.responseData;
                if (da != null && da.daDevice instanceof Disk) {
                    this.disk = (Disk)da.daDevice;
                    if (this.getTabCount() > 4) {
                        this.myDDI.logicalDiskID = this.disk.dskLogicalDiskID;
                        this.setEnabledAt(4, this.disk.dskLogicalDiskID > 0);
                    }
                }
                this.createInfoTab(da);
            } else if (this.serverRequestType == 2) {
                Disk disk = (Disk)response.responseData;
                this.createProbeTab(disk);
            } else if (this.serverRequestType == 3) {
                DiskHistory[] history = (DiskHistory[])response.responseData;
                this.createProbeHistTab(history);
            } else if (this.serverRequestType == 4) {
                this.createLunTab((Lun)response.responseData);
            } else if (this.serverRequestType == 101) {
                this.oldAWRE = this.newAWRE;
                this.oldARRE = this.newARRE;
                this.oldNER = this.newNER;
                this.applyButton.setEnabled(false);
                this.resetButton.setEnabled(false);
            }
        }
    }

    private void createInfoTab(DevAccess da) {
        JPanel iPanel = GuiUtil.getBorderedPanel();
        JScrollPane sPanel = new JScrollPane();
        this.iTab.add((Component)iPanel, "North");
        this.iTab.add((Component)sPanel, "Center");
        String s = this.myDDI.inDiskArray ? (this.isLodestoneCluster ? "STG4500L" : "STG4201L") : "STG1102L";
        JLabel ilComputer = new JLabel(MessageLog.getMessageNoID(s));
        JLabel ilPath = new JLabel(MessageLog.getMessageNoID("STG1219L"));
        JLabel ilTarget = new JLabel(MessageLog.getMessageNoID("STG1144L"));
        JLabel ilLUN = new JLabel(MessageLog.getMessageNoID("STG1145L"));
        JLabel ilMfr = new JLabel(MessageLog.getMessageNoID("STG1105L"));
        JLabel ilModel = new JLabel(MessageLog.getMessageNoID("STG1106L"));
        JLabel ilFirmWare = new JLabel(MessageLog.getMessageNoID("STG1146L") + "    ");
        JLabel ilSerNum = new JLabel(MessageLog.getMessageNoID("STG1107L"));
        JLabel ilMfrDate = new JLabel(MessageLog.getMessageNoID("STG1147L"));
        JLabel ilUseCount = new JLabel(MessageLog.getMessageNoID("STG1148L") + "    ");
        JLabel ilMultiPort = new JLabel(MessageLog.getMessageNoID("STG1150L"));
        JLabel ilUnsupported = new JLabel(MessageLog.getMessageNoID("STG1151L"));
        JLabel ilDiscovered = new JLabel(MessageLog.getMessageNoID("STG1134L") + "    ");
        JLabel idComputer = new JLabel();
        JLabel idPath = new JLabel();
        JLabel idTarget = new JLabel();
        JLabel idLUN = new JLabel();
        JLabel idMfr = new JLabel();
        JLabel idModel = new JLabel();
        JLabel idFirmWare = new JLabel();
        JLabel idSerNum = new JLabel();
        JLabel idMfrDate = new JLabel();
        JLabel idUseCount = new JLabel();
        JLabel idMultiPort = new JLabel();
        JLabel idUnsupported = new JLabel();
        JLabel idDiscovered = new JLabel();
        JLabel iBlank1 = new JLabel(" ");
        JLabel iBlank2 = new JLabel(" ");
        JLabel iFiller1 = new JLabel(" ");
        JLabel iFiller2 = new JLabel(" ");
        JLabel iFiller3 = new JLabel("                  ");
        this.infoTabCreated = true;
        Disk dsk = (Disk)da.daDevice;
        dsk.unpack();
        idComputer.setText(this.myDDI.enclosure);
        idPath.setText(da.daPath);
        idTarget.setText(this.numFormat(da.daTarget));
        idLUN.setText(this.numFormat(da.daLUN));
        if ((dsk.devFlags & 1) != 0) {
            idMfr.setText(this.UNKNOWN);
        } else if (dsk.devManufacturer.toLowerCase().equals("unknown")) {
            idMfr.setText(this.UNKNOWN);
        } else {
            idMfr.setText(dsk.devManufacturer);
        }
        if (Util.isEmpty(dsk.devModel)) {
            idModel.setText(this.UNKNOWN);
        } else {
            idModel.setText(dsk.devModel);
        }
        if (Util.isEmpty(dsk.devFirmwareRev)) {
            idFirmWare.setText(this.UNKNOWN);
        } else {
            idFirmWare.setText(dsk.devFirmwareRev);
        }
        if ((dsk.devFlags & 2) != 0) {
            idSerNum.setText(this.UNKNOWN);
        } else if (Util.isEmpty(dsk.devSubsystemSerialNumber)) {
            idSerNum.setText(dsk.devSerialNumber);
        } else {
            idSerNum.setText(dsk.devSubsystemSerialNumber + "/" + dsk.devSerialNumber);
        }
        idMfrDate.setText(dsk.devManufactureDate < 86400000L ? this.UNKNOWN : DateFormat.getDateTimeInstance().format(new Date(dsk.devManufactureDate)));
        idUseCount.setText(this.numFormat(dsk.devUseCount));
        idMultiPort.setText(dsk.devMultiPort ? this.TRUE : this.FALSE);
        idUnsupported.setText(dsk.devUnsupportedModel ? this.TRUE : this.FALSE);
        idDiscovered.setText(DateFormat.getDateTimeInstance().format(new Date(dsk.devDiscoveredTime)));
        iPanel.add((Component)iFiller1, gbcFill_1);
        iPanel.add((Component)iFiller2, gbcFill_2);
        iPanel.add((Component)iFiller3, gbcLast);
        iPanel.add((Component)iBlank1, gbcLast);
        iPanel.add((Component)ilComputer, gbcLabel);
        iPanel.add((Component)idComputer, gbcLast);
        iPanel.add((Component)ilPath, gbcLabel);
        iPanel.add((Component)idPath, gbcLast);
        iPanel.add((Component)ilTarget, gbcLabel);
        iPanel.add((Component)idTarget, gbcLast);
        iPanel.add((Component)ilLUN, gbcLabel);
        iPanel.add((Component)idLUN, gbcLast);
        iPanel.add((Component)ilUseCount, gbcLabel);
        iPanel.add((Component)idUseCount, gbcLast);
        iPanel.add((Component)iBlank1, gbcLast);
        iPanel.add((Component)ilMfr, gbcLabel);
        iPanel.add((Component)idMfr, gbcLast);
        iPanel.add((Component)ilModel, gbcLabel);
        iPanel.add((Component)idModel, gbcLast);
        iPanel.add((Component)ilFirmWare, gbcLabel);
        iPanel.add((Component)idFirmWare, gbcLast);
        iPanel.add((Component)ilSerNum, gbcLabel);
        iPanel.add((Component)idSerNum, gbcLast);
        iPanel.add((Component)ilMfrDate, gbcLabel);
        iPanel.add((Component)idMfrDate, gbcLast);
        iPanel.add((Component)ilDiscovered, gbcLabel);
        iPanel.add((Component)idDiscovered, gbcLast);
        iPanel.add((Component)iBlank2, gbcLast);
        iPanel.add((Component)ilMultiPort, gbcLabel);
        iPanel.add((Component)idMultiPort, gbcLast);
        iPanel.add((Component)ilUnsupported, gbcLabel);
        iPanel.add((Component)idUnsupported, gbcLast);
        iPanel.add((Component)new JLabel(" "), gbcLast);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.path);
        JTree myTree = new JTree(root);
        DefaultTreeModel myModel = (DefaultTreeModel)myTree.getModel();
        myTree.putClientProperty("JTree.lineStyle", "Angled");
        Chunk chk = dsk.dskChunk;
        while (chk != null) {
            String endLength;
            String startLength;
            if (this.isLodestoneCluster) {
                startLength = Util.formatBytes(chk.chkOffset * 0x100000L);
                endLength = Util.formatBytes(chk.chkSize * 0x100000L);
            } else {
                startLength = Util.formatBytes(chk.chkOffset * (long)chk.chkUnitSize);
                endLength = Util.formatBytes(chk.chkSize * (long)chk.chkUnitSize);
            }
            root.add(new DefaultMutableTreeNode(MessageLog.getMessageNoID("STG1242L", new Object[]{startLength, endLength})));
            chk = chk.chkNextOnDisk;
        }
        sPanel.setViewportView(myTree);
        myModel.nodeStructureChanged(root);
    }

    private static byte truncate(byte value) {
        if (value < 1) {
            value = 1;
        }
        return (byte)(value - 1);
    }

    private void createProbeTab(Disk d) {
        JLabel plDskSectorSize = new JLabel(MessageLog.getMessageNoID("STG1155L"));
        JLabel plDskSectorsPerAvgTrack = new JLabel(MessageLog.getMessageNoID("STG1156L") + "    ");
        JLabel plDskSectorsPerOuterTrack = new JLabel(MessageLog.getMessageNoID("STG1157L"));
        JLabel plDskSectorsPerInnerTrack = new JLabel(MessageLog.getMessageNoID("STG1158L"));
        JLabel plDskHeads = new JLabel(MessageLog.getMessageNoID("STG1159L"));
        JLabel plDskCylinders = new JLabel(MessageLog.getMessageNoID("STG1160L"));
        JLabel plDskLogicalBlockSize = new JLabel(MessageLog.getMessageNoID("STG1161L"));
        JLabel plDskCapacity = new JLabel(MessageLog.getMessageNoID("STG1162L"));
        JLabel plDskRPM = new JLabel(MessageLog.getMessageNoID("STG1163L"));
        JLabel plDskMinutesPoweredOn = new JLabel(MessageLog.getMessageNoID("STG1164L"));
        JLabel plDskSpareBlocks = new JLabel(MessageLog.getMessageNoID("STG1165L"));
        JLabel plDskWriteProtected = new JLabel(MessageLog.getMessageNoID("STG1166L"));
        JLabel plDskCacheEnabled = new JLabel(MessageLog.getMessageNoID("STG1167L"));
        JLabel plDskAutoWriteRealloc = new JLabel(MessageLog.getMessageNoID("STG1168L"));
        JLabel plDskAutoReadRealloc = new JLabel(MessageLog.getMessageNoID("STG1169L"));
        JLabel plDskNoErrorRecovery = new JLabel(MessageLog.getMessageNoID("STG1170L") + "    ");
        JLabel plActual = new JLabel(MessageLog.getMessageNoID("STG1171L") + "    ");
        JLabel plDesired = new JLabel(MessageLog.getMessageNoID("STG1172L"));
        JLabel plDskFailurePredicted = new JLabel(MessageLog.getMessageNoID("STG1173L"));
        JLabel plDkhPrimaryDefects = new JLabel(MessageLog.getMessageNoID("STG1174L"));
        JLabel plDkhGrownDefects = new JLabel(MessageLog.getMessageNoID("STG1175L"));
        JLabel plWrite = new JLabel(MessageLog.getMessageNoID("STG1152L") + "             ");
        JLabel plRead = new JLabel(MessageLog.getMessageNoID("STG1176L") + "              ");
        JLabel plVerify = new JLabel(MessageLog.getMessageNoID("STG1177L"));
        JLabel plDkhRecoveredErrors = new JLabel(MessageLog.getMessageNoID("STG1178L"));
        JLabel plDkhUnrecoveredErrors = new JLabel(MessageLog.getMessageNoID("STG1179L"));
        JLabel plDkhBytes = new JLabel(MessageLog.getMessageNoID("STG1180L"));
        JLabel plDkhNonMediumErrors = new JLabel(MessageLog.getMessageNoID("STG1181L"));
        JLabel plDkhTimestamp = new JLabel(MessageLog.getMessageNoID("STG1182L"));
        JLabel plDkhTemperature = new JLabel(MessageLog.getMessageNoID("STG1183L"));
        JLabel plDkhFreeSpace = new JLabel(MessageLog.getMessageNoID("STG4131L"));
        JLabel pdDskSectorSize = new JLabel();
        JLabel pdDskSectorsPerAvgTrack = new JLabel();
        JLabel pdDskSectorsPerOuterTrack = new JLabel();
        JLabel pdDskSectorsPerInnerTrack = new JLabel();
        JLabel pdDskHeads = new JLabel();
        JLabel pdDskCylinders = new JLabel();
        JLabel pdDskLogicalBlockSize = new JLabel();
        JLabel pdDskCapacity = new JLabel();
        JLabel pdDskRPM = new JLabel();
        JLabel pdDskMinutesPoweredOn = new JLabel();
        JLabel pdDskSpareBlocks = new JLabel();
        JLabel pdDskWriteProtected = new JLabel();
        JLabel pdDskCacheEnabled = new JLabel();
        JLabel pdDskAutoWriteRealloc = new JLabel();
        JLabel pdDskAutoReadRealloc = new JLabel();
        JLabel pdDskNoErrorRecovery = new JLabel();
        JLabel pdDskFailurePredicted = new JLabel();
        JLabel pdDkhPrimaryDefects = new JLabel();
        JLabel pdDkhGrownDefects = new JLabel();
        JLabel pdDkhRecoveredWriteErrors = new JLabel();
        JLabel pdDkhUnrecoveredWriteErrors = new JLabel();
        JLabel pdDkhBytesWritten = new JLabel();
        JLabel pdDkhRecoveredReadErrors = new JLabel();
        JLabel pdDkhUnrecoveredReadErrors = new JLabel();
        JLabel pdDkhBytesRead = new JLabel();
        JLabel pdDkhRecoveredVerifyErrors = new JLabel();
        JLabel pdDkhUnrecoveredVerifyErrors = new JLabel();
        JLabel pdDkhNonMediumErrors = new JLabel();
        JLabel pdDkhTimestamp = new JLabel();
        JLabel pdDkhTemperature = new JLabel();
        JLabel pdDkhFreeSpace = new JLabel();
        this.pdDskDesiredAWRE.setEditable(false);
        this.pdDskDesiredARRE.setEditable(false);
        this.pdDskDesiredNoErrRcvry.setEditable(false);
        this.pdDskDesiredAWRE.addItemListener(this);
        this.pdDskDesiredARRE.addItemListener(this);
        this.pdDskDesiredNoErrRcvry.addItemListener(this);
        this.applyButton.setToolTipText(MessageLog.getMessageNoID("STG1185T"));
        this.applyButton.addActionListener(this);
        this.applyButton.setActionCommand(APPLY);
        this.resetButton.setToolTipText(MessageLog.getMessageNoID("STG1186T"));
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand(RESET);
        this.applyButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_APPLY"));
        GuiUtil.setAccessible(this.applyButton, this.applyButton.getText(), this.applyButton.getText());
        this.resetButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_RESET"));
        GuiUtil.setAccessible(this.resetButton, this.resetButton.getText(), this.resetButton.getText());
        JLabel pFiller1 = new JLabel(" ");
        JLabel pFiller2 = new JLabel(" ");
        JLabel pFiller3 = new JLabel(" ");
        JLabel pFiller4 = new JLabel(" ");
        JLabel pFiller5 = new JLabel(" ");
        this.probeTabCreated = true;
        DiskHistory dh = d.dskHistory;
        pdDskSectorSize.setText(this.numFormat(d.dskSectorSize));
        pdDskSectorsPerAvgTrack.setText(this.numFormat(d.dskSectorsPerAvgTrack));
        pdDskSectorsPerOuterTrack.setText(this.numFormat(d.dskSectorsPerOuterTrack));
        pdDskSectorsPerInnerTrack.setText(this.numFormat(d.dskSectorsPerInnerTrack));
        pdDskHeads.setText(this.numFormat(d.dskHeads));
        pdDskCylinders.setText(this.numFormat(d.dskCylinders));
        pdDskLogicalBlockSize.setText(this.numFormat(d.dskLogicalBlockSize));
        if (d.dskCapacity == 0L) {
            pdDskCapacity.setText(MessageLog.getMessageNoID("BTM0570L"));
        } else {
            pdDskCapacity.setText(Util.formatBytes(d.dskCapacity * 512L));
        }
        pdDskRPM.setText(this.numFormat(d.dskRPM));
        pdDskMinutesPoweredOn.setText(GuiUtil.formatElapsed(d.dskMinutesPoweredOn));
        pdDskSpareBlocks.setText(this.numFormat(d.dskSpareBlocks));
        pdDskWriteProtected.setText(d.dskWriteProtected ? this.ON : this.OFF);
        String temp = d.dskReadCacheDisabled ? (d.dskWriteCacheEnabled ? this.WRITE : this.NONE) : (d.dskWriteCacheEnabled ? this.BOTH : this.READ);
        pdDskCacheEnabled.setText(temp);
        pdDskAutoWriteRealloc.setText(d.dskAutoWriteRealloc ? this.ON : this.OFF);
        pdDskAutoReadRealloc.setText(d.dskAutoReadRealloc ? this.ON : this.OFF);
        pdDskNoErrorRecovery.setText(d.dskNoErrorRecovery ? this.ON : this.OFF);
        pdDskFailurePredicted.setText(d.dskFailurePredicted ? this.YES : this.NO);
        this.oldAWRE = d.dskDesiredAWRE;
        this.oldARRE = d.dskDesiredARRE;
        this.oldNER = d.dskDesiredNoErrRcvry;
        if (this.newAWRE != -1 && (this.oldAWRE != this.newAWRE || this.oldARRE != this.newARRE || this.oldNER != this.newNER)) {
            d.dskDesiredARRE = this.newARRE;
            d.dskDesiredAWRE = this.newAWRE;
            d.dskDesiredNoErrRcvry = this.newNER;
            this.applyButton.setEnabled(this.capabilities.isAnyAdmin());
            this.resetButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
        this.pdDskDesiredAWRE.setSelectedIndex(DiskData.truncate(d.dskDesiredAWRE));
        this.pdDskDesiredARRE.setSelectedIndex(DiskData.truncate(d.dskDesiredARRE));
        this.pdDskDesiredNoErrRcvry.setSelectedIndex(DiskData.truncate(d.dskDesiredNoErrRcvry));
        pdDkhPrimaryDefects.setText(this.numFormat(dh.dkhPrimaryDefects));
        pdDkhGrownDefects.setText(this.numFormat(dh.dkhGrownDefects));
        pdDkhRecoveredWriteErrors.setText(this.numFormat(dh.dkhRecoveredWriteErrors));
        pdDkhUnrecoveredWriteErrors.setText(this.numFormat(dh.dkhUnrecoveredWriteErrors));
        pdDkhBytesWritten.setText(Util.formatBytes(dh.dkhBytesWritten) + "      ");
        pdDkhRecoveredReadErrors.setText(this.numFormat(dh.dkhRecoveredReadErrors));
        pdDkhUnrecoveredReadErrors.setText(this.numFormat(dh.dkhUnrecoveredReadErrors));
        pdDkhBytesRead.setText(Util.formatBytes(dh.dkhBytesRead) + "      ");
        pdDkhRecoveredVerifyErrors.setText(this.numFormat(dh.dkhRecoveredVerifyErrors));
        pdDkhUnrecoveredVerifyErrors.setText(this.numFormat(dh.dkhUnrecoveredVerifyErrors));
        pdDkhNonMediumErrors.setText(this.numFormat(dh.dkhNonMediumErrors));
        pdDkhTimestamp.setText(DateFormat.getDateTimeInstance().format(new Date(dh.dkhTimestamp)));
        pdDkhTemperature.setText(this.numFormat(dh.dkhTemperature));
        pdDkhFreeSpace.setText(Util.formatBytes(dh.dkhFreeSpace * 512L));
        this.pPanel.add((Component)pFiller1, gbcFill_1);
        this.pPanel.add((Component)pFiller2, gbcFill_2);
        this.pPanel.add((Component)pFiller3, gbcLast);
        this.pPanel.add((Component)plDskSectorSize, gbcLabel);
        this.pPanel.add((Component)pdDskSectorSize, gbcLast);
        this.pPanel.add((Component)plDskSectorsPerAvgTrack, gbcLabel);
        this.pPanel.add((Component)pdDskSectorsPerAvgTrack, gbcLast);
        this.pPanel.add((Component)plDskSectorsPerOuterTrack, gbcLabel);
        this.pPanel.add((Component)pdDskSectorsPerOuterTrack, gbcLast);
        this.pPanel.add((Component)plDskSectorsPerInnerTrack, gbcLabel);
        this.pPanel.add((Component)pdDskSectorsPerInnerTrack, gbcLast);
        this.pPanel.add((Component)plDskHeads, gbcLabel);
        this.pPanel.add((Component)pdDskHeads, gbcLast);
        this.pPanel.add((Component)plDskCylinders, gbcLabel);
        this.pPanel.add((Component)pdDskCylinders, gbcLast);
        this.pPanel.add((Component)plDskLogicalBlockSize, gbcLabel);
        this.pPanel.add((Component)pdDskLogicalBlockSize, gbcLast);
        this.pPanel.add((Component)plDskCapacity, gbcLabel);
        this.pPanel.add((Component)pdDskCapacity, gbcLast);
        this.pPanel.add((Component)plDskRPM, gbcLabel);
        this.pPanel.add((Component)pdDskRPM, gbcLast);
        this.pPanel.add((Component)plDskMinutesPoweredOn, gbcLabel);
        this.pPanel.add((Component)pdDskMinutesPoweredOn, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)plDskSpareBlocks, gbcLabel);
        this.pPanel.add((Component)pdDskSpareBlocks, gbcLast);
        this.pPanel.add((Component)plDskWriteProtected, gbcLabel);
        this.pPanel.add((Component)pdDskWriteProtected, gbcLast);
        this.pPanel.add((Component)plDskCacheEnabled, gbcLabel);
        this.pPanel.add((Component)pdDskCacheEnabled, gbcLast);
        this.pPanel.add((Component)plDskFailurePredicted, gbcLabel);
        this.pPanel.add((Component)pdDskFailurePredicted, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)plDkhTimestamp, gbcLabel);
        this.pPanel.add((Component)pdDkhTimestamp, gbcLast);
        this.pPanel.add((Component)plDkhFreeSpace, gbcLabel);
        this.pPanel.add((Component)pdDkhFreeSpace, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)plDkhPrimaryDefects, gbcLabel);
        this.pPanel.add((Component)pdDkhPrimaryDefects, gbcLast);
        this.pPanel.add((Component)plDkhGrownDefects, gbcLabel);
        this.pPanel.add((Component)pdDkhGrownDefects, gbcLast);
        this.pPanel.add((Component)plDkhNonMediumErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhNonMediumErrors, gbcLast);
        this.pPanel.add((Component)plDkhTemperature, gbcLabel);
        this.pPanel.add((Component)pdDkhTemperature, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)plWrite, gbcLabel);
        this.pPanel.add((Component)plRead, gbcLabel);
        this.pPanel.add((Component)plVerify, gbcLast);
        this.pPanel.add((Component)plDkhRecoveredErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhRecoveredWriteErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhRecoveredReadErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhRecoveredVerifyErrors, gbcLast);
        this.pPanel.add((Component)plDkhUnrecoveredErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhUnrecoveredWriteErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhUnrecoveredReadErrors, gbcLabel);
        this.pPanel.add((Component)pdDkhUnrecoveredVerifyErrors, gbcLast);
        this.pPanel.add((Component)plDkhBytes, gbcLabel);
        this.pPanel.add((Component)pdDkhBytesWritten, gbcLabel);
        this.pPanel.add((Component)pdDkhBytesRead, gbcLabel);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)plActual, gbcLabel);
        this.pPanel.add((Component)plDesired, gbcLast);
        this.pPanel.add((Component)plDskAutoWriteRealloc, gbcLabel);
        this.pPanel.add((Component)pdDskAutoWriteRealloc, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredAWRE, gbcLast);
        this.pPanel.add((Component)plDskAutoReadRealloc, gbcLabel);
        this.pPanel.add((Component)pdDskAutoReadRealloc, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredARRE, gbcLast);
        this.pPanel.add((Component)plDskNoErrorRecovery, gbcLabel);
        this.pPanel.add((Component)pdDskNoErrorRecovery, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredNoErrRcvry, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)this.applyButton, gbcLabel);
        this.pPanel.add((Component)this.resetButton, gbcLast);
    }

    private void createProbeHistTab(DiskHistory[] history) {
        DiskHistTable table = new DiskHistTable(this.diskID, this.myDDI.diskArrayType, history);
        this.hTab.add((Component)table, "Center");
        this.histTabCreated = true;
    }

    private void createLunTab(Lun lun) {
        JPanel lPanel = GuiUtil.getBorderedPanel();
        JLabel llLUN = new JLabel(MessageLog.getMessageNoID("SAG0514L"));
        JLabel llAlias = new JLabel(MessageLog.getMessageNoID("SAG0513L"));
        JLabel llMfr = new JLabel(MessageLog.getMessageNoID("STG1105L"));
        JLabel llModel = new JLabel(MessageLog.getMessageNoID("STG1106L"));
        JLabel llSerNum = new JLabel(MessageLog.getMessageNoID("SAG0502L"));
        JLabel ldLUN = new JLabel();
        JLabel ldAlias = new JLabel();
        JLabel ldMfr = new JLabel();
        JLabel ldModel = new JLabel();
        JLabel ldSerNum = new JLabel();
        JLabel lBlank1 = new JLabel(" ");
        JLabel lBlank2 = new JLabel(" ");
        JLabel lFiller1 = new JLabel(" ");
        JLabel lFiller2 = new JLabel(" ");
        JLabel lFiller3 = new JLabel("                  ");
        this.lunTabCreated = true;
        ldLUN.setText(lun.lunName);
        ldAlias.setText(lun.lunDaAlias);
        if (lun.lunDaManufacturer.toLowerCase().equals("unknown")) {
            ldMfr.setText(MessageLog.getMessageNoID("STG1020L"));
        } else {
            ldMfr.setText(lun.lunDaManufacturer);
        }
        ldModel.setText(lun.lunDaModel);
        ldSerNum.setText(lun.lunDaSerialNumber);
        int savedRight = DiskData.gbcLabel.insets.right;
        DiskData.gbcLabel.insets.right = 16;
        lPanel.add((Component)lFiller1, gbcFill_1);
        lPanel.add((Component)lFiller2, gbcFill_2);
        lPanel.add((Component)lFiller3, gbcLast);
        lPanel.add((Component)llLUN, gbcLabel);
        lPanel.add((Component)ldLUN, gbcLast);
        if (!Util.isEmpty(lun.lunWWN)) {
            JLabel llLUNWWN = new JLabel(MessageLog.getMessageNoID("SAG0620L"));
            JLabel ldLUNWWN = new JLabel();
            ldLUNWWN.setText(lun.lunWWN);
            lPanel.add((Component)llLUNWWN, gbcLabel);
            lPanel.add((Component)ldLUNWWN, gbcLast);
        }
        lPanel.add((Component)lBlank1, gbcLast);
        lPanel.add((Component)llAlias, gbcLabel);
        lPanel.add((Component)ldAlias, gbcLast);
        lPanel.add((Component)llMfr, gbcLabel);
        lPanel.add((Component)ldMfr, gbcLast);
        lPanel.add((Component)llModel, gbcLabel);
        lPanel.add((Component)ldModel, gbcLast);
        lPanel.add((Component)llSerNum, gbcLabel);
        lPanel.add((Component)ldSerNum, gbcLast);
        lPanel.add((Component)lBlank2, gbcLast);
        DiskData.gbcLabel.insets.right = savedRight;
        lun.lunLogicalDisk.ldPath = lun.lunName;
        this.lTab.add((Component)lPanel, "North");
        this.lTab.add((Component)LogicalVolumeData.getLvTree(lun.lunLogicalDisk, this.myDDI.diskArrayType), "Center");
    }

    public void actionPerformed(ActionEvent event) {
        String source = event.getActionCommand();
        if (source == APPLY) {
            this.disk.dskDesiredAWRE = this.newAWRE;
            this.disk.dskDesiredARRE = this.newARRE;
            this.disk.dskDesiredNoErrRcvry = this.newNER;
            this.serverRequestType = 101;
            Request request = new Request();
            GuiUpdateRequest.updateDisk(request, this.disk);
            GuiClient.doRequest(this, request);
        } else if (source == RESET) {
            this.pdDskDesiredAWRE.setSelectedIndex(DiskData.truncate(this.oldAWRE));
            this.pdDskDesiredARRE.setSelectedIndex(DiskData.truncate(this.oldARRE));
            this.pdDskDesiredNoErrRcvry.setSelectedIndex(DiskData.truncate(this.oldNER));
            this.newAWRE = this.oldAWRE;
            this.newARRE = this.oldARRE;
            this.newNER = this.oldNER;
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    private static byte translateSetting(JComboBox combo) {
        byte index = (byte)combo.getSelectedIndex();
        if (index != 0) {
            index = (byte)(index + 1);
        }
        return index;
    }

    public void itemStateChanged(ItemEvent event) {
        this.newAWRE = DiskData.translateSetting(this.pdDskDesiredAWRE);
        this.newARRE = DiskData.translateSetting(this.pdDskDesiredARRE);
        this.newNER = DiskData.translateSetting(this.pdDskDesiredNoErrRcvry);
        if (this.oldAWRE != this.newAWRE || this.oldARRE != this.newARRE || this.oldNER != this.newNER) {
            this.applyButton.setEnabled(this.capabilities.isAnyAdmin());
            this.resetButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    private String numFormat(int num) {
        return this.numFormat((long)num);
    }

    private String numFormat(short num) {
        return this.numFormat((long)num);
    }

    private String numFormat(long num) {
        this.d0Fmt.setMaximumFractionDigits(2);
        return num < 0L ? MessageLog.getMessageNoID("STG0019T") : this.d0Fmt.format(num);
    }
}

