/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryJobDDI;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryJobTable;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryNameList;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectHistoryRunTable
extends JPanel
implements GuiRequestor {
    MegaTable table = new MegaTable();
    SchHistoryNameList[] elementArray;
    BaseTreeNode node;
    static final String RUN = MessageLog.getMessageNoID("JSS0028L");
    static final String START_TIME = MessageLog.getMessageNoID("JSS0029L");
    static final String STATUS = MessageLog.getMessageNoID("JSS0030L");
    static final String FINISH_TIME = MessageLog.getMessageNoID("JSS0031L");
    static final String NUMBER_JOBS = MessageLog.getMessageNoID("JSS0032L");
    static final String NUMBER_FAILED = MessageLog.getMessageNoID("JSS0033L");
    static final String[] colNames = new String[]{RUN, START_TIME, STATUS, FINISH_TIME, NUMBER_JOBS, NUMBER_FAILED};
    static final int RUN_COL = 0;
    static final int START_TIME_COL = 1;
    static final int STATUS_COL = 2;
    static final int FINISH_TIME_COL = 3;
    static final int NUMBER_JOBS_COL = 4;
    static final int NUMBER_FAILED_COL = 5;
    MutableInteger[] mInteger;

    public EditableObjectHistoryRunTable(int schedule_id, BaseTreeNode node) {
        this.node = node;
        SchHistoryRequestNode historyRequest = new SchHistoryRequestNode();
        historyRequest.queryType = 1;
        historyRequest.queryID = schedule_id;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = historyRequest;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            this.setLayout(new BorderLayout());
            SchHistoryNameList element = (SchHistoryNameList)response.responseData;
            int count = 0;
            while (element != null) {
                ++count;
                element = (SchHistoryNameList)element.nlNext;
            }
            if (count == 0) {
                JPanel nonePanel = new JPanel();
                nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
                this.add((Component)nonePanel, "Center");
            } else {
                this.elementArray = new SchHistoryNameList[count];
                this.mInteger = new MutableInteger[count];
                element = (SchHistoryNameList)response.responseData;
                for (int index = 0; index < count; ++index) {
                    this.elementArray[index] = element;
                    this.mInteger[index] = new MutableInteger();
                    element = (SchHistoryNameList)element.nlNext;
                }
                this.table.setFrozenColumns(1);
                this.table.setMouseListener(new selectListener());
                this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
                this.table.setCellRenderer(Date.class, TableCellRenderers.date);
                this.table.setRowIcon(10, true);
                this.table.setBaseTableModel(new RunTableModel());
                this.add((Component)this.table, "Center");
                this.validate();
            }
        }
    }

    public class RunTableModel
    extends BaseTableModel {
        RunTableModel() {
            this.columnNames = colNames;
            this.rowCount = EditableObjectHistoryRunTable.this.elementArray.length;
        }

        public Object getTableDataItem(int rowNum, int colNum) {
            Object data;
            switch (colNum) {
                case 0: {
                    EditableObjectHistoryRunTable.this.mInteger[rowNum].value = EditableObjectHistoryRunTable.this.elementArray[rowNum].nlID2;
                    data = EditableObjectHistoryRunTable.this.mInteger[rowNum];
                    break;
                }
                case 1: {
                    data = new Date(EditableObjectHistoryRunTable.this.elementArray[rowNum].startTime);
                    break;
                }
                case 2: {
                    data = EditableObjectHistoryJobTable.runStateToStatusText(EditableObjectHistoryRunTable.this.elementArray[rowNum]);
                    break;
                }
                case 3: {
                    data = new Date(EditableObjectHistoryRunTable.this.elementArray[rowNum].finishTime);
                    break;
                }
                case 4: {
                    EditableObjectHistoryRunTable.this.mInteger[rowNum].value = EditableObjectHistoryRunTable.this.elementArray[rowNum].numberJobs;
                    data = EditableObjectHistoryRunTable.this.mInteger[rowNum];
                    break;
                }
                case 5: {
                    EditableObjectHistoryRunTable.this.mInteger[rowNum].value = EditableObjectHistoryRunTable.this.elementArray[rowNum].successfulJobs < 0 ? 0 : EditableObjectHistoryRunTable.this.elementArray[rowNum].numberJobs - EditableObjectHistoryRunTable.this.elementArray[rowNum].successfulJobs;
                    data = EditableObjectHistoryRunTable.this.mInteger[rowNum];
                    break;
                }
                default: {
                    data = null;
                }
            }
            return data;
        }
    }

    private class selectListener
    extends TJCTableMouseAdapter {
        private selectListener() {
        }

        public boolean select(int viewRow, int viewCol) {
            return true;
        }

        public void doubleClick(int dataRow, int dataCol) {
            EditableObjectHistoryJobDDI historyDDI = new EditableObjectHistoryJobDDI(EditableObjectHistoryRunTable.this.elementArray[dataRow], EditableObjectHistoryRunTable.this.node, "", null);
        }
    }
}

