/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryJobDDI;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectNode;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener,
ObjectChangeListener,
NameListToTreeNode {
    private static final String NEW = "N";
    private static final String REFRESH = "R";
    private String label;
    short objectType;
    short resourceType;
    short qualifier;
    String objectLabelID;
    String objectLabel;
    Class editorClass;
    private boolean checkQualifiers;
    private boolean hasKids;
    private boolean neverRefreshed;
    protected JMenuItem newMenu = new JMenuItem();
    private JMenuItem refreshMenu = new JMenuItem();
    private int adminType = 5;

    public EditableObjectLabel(String pObjectLabelID, String collectionLabelID, short pObjectType, Class pEditorClass, short pResourceType, short pQualifier, boolean hasKids) {
        this(pObjectLabelID, collectionLabelID, pObjectType, pEditorClass, pResourceType, pQualifier, hasKids, 5);
    }

    public EditableObjectLabel(String pObjectLabelID, String collectionLabelID, short pObjectType, Class pEditorClass, short pResourceType, short pQualifier, boolean hasKids, int adminType) {
        this.adminType = adminType;
        this.objectType = pObjectType;
        this.checkQualifiers = pResourceType != -1;
        this.resourceType = this.checkQualifiers ? pResourceType : (short)0;
        this.qualifier = pQualifier;
        this.editorClass = pEditorClass;
        this.objectLabelID = pObjectLabelID;
        this.objectLabel = Util.getString(this.objectLabelID);
        Object[] args = new Object[]{this.objectLabel};
        this.newMenu.setText(MessageLog.getMessageNoID("GUI2013L", args));
        this.newMenu.setActionCommand(NEW);
        this.newMenu.addActionListener(this);
        boolean adminCapable = false;
        switch (adminType) {
            case 4: {
                adminCapable = this.capabilities.isAnyAdmin();
                break;
            }
            case 1: {
                adminCapable = this.capabilities.isDataAdmin();
                break;
            }
            case 2: {
                adminCapable = this.capabilities.isDiskAdmin();
                break;
            }
            case 3: {
                adminCapable = this.capabilities.isFabricAdmin();
                break;
            }
            case 5: {
                adminCapable = this.capabilities.isAperiAdmin();
                break;
            }
            case 6: {
                adminCapable = this.capabilities.isTapeAdmin();
                break;
            }
            default: {
                adminCapable = this.capabilities.isAperiAdmin();
            }
        }
        if (!adminCapable) {
            this.newMenu.setEnabled(false);
        }
        this.refreshMenu.setText(MessageLog.getMessageNoID("ADG0003L"));
        this.refreshMenu.setActionCommand(REFRESH);
        this.refreshMenu.addActionListener(this);
        this.setUserObject(Util.getString(collectionLabelID));
        ChangeManager.addListener(this, this.objectType);
        this.hasKids = hasKids;
        this.neverRefreshed = true;
    }

    public EditableObjectLabel(String pNewObjectID, String pLabelID, short pObjectType, Class pEditorClass, boolean hasKids) {
        this(pNewObjectID, pLabelID, pObjectType, pEditorClass, -1, 0, hasKids, 5);
    }

    public void showPopupMenu(MouseEvent event) {
        this.showPopupMenu(this.createPopup(), event);
    }

    public JPopupMenu createPopup() {
        JPopupMenu menu = this.getPopupMenu();
        menu.add(this.newMenu);
        menu.add(this.refreshMenu);
        return menu;
    }

    public static Request makeRequest(short objectType, short resourceType, short qualifier) {
        Request request = new Request();
        GuiRequest.computerList(request);
        GuiListReq requestData = (GuiListReq)request.requestData;
        requestData.listRequested = 10000 + objectType;
        requestData.resourceType = resourceType;
        requestData.qualifier = qualifier;
        return request;
    }

    public static Request makeRequest(short objectType) {
        return EditableObjectLabel.makeRequest(objectType, (short)0, (short)0);
    }

    private void sendRequest() {
        Request request = null;
        request = EditableObjectLabel.makeRequest(this.objectType, this.resourceType, this.qualifier);
        GuiClient.doRequest(this, request);
    }

    public void expand(TreeExpansionEvent event) {
        if (this.neverRefreshed) {
            this.sendRequest();
        }
    }

    public BaseTreeNode makeChild(NameList element) {
        return new EditableObjectNode(element, this, this.hasKids, this.adminType);
    }

    public int getKey(NameList element) {
        return element.nlID;
    }

    public static void refresh(BaseTreeNode parent, Response response, NameListToTreeNode generator) {
        MutableInteger key;
        BaseTreeNode node;
        NameList head = GuiUtil.sortNameList((NameList)response.responseData);
        int selectedID = Integer.MIN_VALUE;
        TreePath path = BaseTree.pBaseTree.getSelectionPath();
        BaseTreeNode selectedNode = path != null ? (BaseTreeNode)path.getLastPathComponent() : null;
        HashMap<MutableInteger, DataDisplayInfo> map = new HashMap<MutableInteger, DataDisplayInfo>();
        BaseTreeNode[] children = new BaseTreeNode[parent.getChildCount()];
        int index = 0;
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            node = (BaseTreeNode)e.nextElement();
            NameList element = (NameList)node.getUserObject();
            element.nlName = Util.getTranslatedName(element.nlName);
            key = new MutableInteger(generator.getKey(element));
            map.put(key, node.ddi);
            if (node == selectedNode) {
                selectedID = key.value;
            }
            children[index] = node;
            ++index;
        }
        for (index = 0; index < children.length; ++index) {
            BaseTree.MyTree.removeNodeFromParent(children[index]);
        }
        selectedNode = null;
        key = new MutableInteger();
        index = 0;
        while (head != null) {
            DataDisplayInfo ddi;
            head.nlName = Util.getTranslatedName(head.nlName);
            if (generator instanceof HistoryHelper && ((HistoryHelper)generator).getTreeNode() instanceof EditableObjectNode) {
                head.nlInfo = ((EditableObjectNode)((HistoryHelper)generator).getTreeNode()).element.nlInfo;
            }
            node = generator.makeChild(head);
            key.value = generator.getKey(head);
            if (key.value == selectedID) {
                selectedNode = node;
            }
            if ((ddi = (DataDisplayInfo)map.get(key)) != null) {
                if (ddi instanceof EditableObjectHistoryJobDDI && node instanceof EditableObjectHistoryNode) {
                    ((EditableObjectHistoryJobDDI)ddi).element = ((EditableObjectHistoryNode)node).element;
                }
                node.ddi = ddi;
                ddi.treeNode = node;
            }
            BaseTree.MyTree.insertNodeInto(node, parent, index);
            ++index;
            head = head.nlNext;
        }
        if (selectedNode != null) {
            BaseTree.pBaseTree.reselect(selectedNode);
        }
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        this.neverRefreshed = false;
        EditableObjectLabel.refresh(this, response, this);
    }

    CreateOrEditDDI makeDDI() {
        CreateOrEditDDI ddi = new CreateOrEditDDI();
        if (this.checkQualifiers) {
            ddi.nlID2 = this.resourceType;
            ddi.nlID3 = this.qualifier;
        }
        return ddi;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == REFRESH) {
            this.sendRequest();
        } else if (command == NEW) {
            CreateOrEditDDI ddi = this.makeDDI();
            ddi.treeNode = this;
            ddi.buildEditor(this.editorClass, this.objectType);
        }
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        guiMain.getBaseTree().requestFocus();
    }

    private MutableTreeNode find(int id) {
        DefaultMutableTreeNode child = null;
        boolean going = true;
        Enumeration<TreeNode> e = this.children();
        while (going && e.hasMoreElements()) {
            child = (DefaultMutableTreeNode)e.nextElement();
            NameList element = (NameList)child.getUserObject();
            if (element.nlID != id) continue;
            going = false;
        }
        if (going) {
            child = null;
        }
        return child;
    }

    private void addInRightPlace(MutableTreeNode child, NameList name) {
        DefaultMutableTreeNode node = null;
        int index = 0;
        Enumeration<TreeNode> e = this.children();
        int x = 1;
        while (x > 0 && e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            NameList element = (NameList)node.getUserObject();
            x = name.nlName.compareTo(element.nlName);
            ++index;
        }
        if (x == 0) {
            node.setUserObject(name);
        } else {
            if (x < 0) {
                --index;
            }
            BaseTree.MyTree.insertNodeInto(child, this, index);
        }
    }

    public void changeOccurred(int changeType, NameList name) {
        switch (changeType) {
            case 1: {
                BaseTreeNode treeNode;
                if (this.checkQualifiers && (name.nlID2 != this.resourceType || name.nlID3 != this.qualifier)) break;
                BaseTreeNode child = this.makeChild(name);
                this.addInRightPlace(child, name);
                DataDisplayInfo currentDDI = DataDisplayInfo.getCurrent();
                if (currentDDI.treeNode != null) {
                    currentDDI.treeNode.ddi = null;
                }
                currentDDI.treeNode = treeNode = child;
                treeNode.ddi = currentDDI;
                BaseTree.pBaseTree.reselect(treeNode, true);
                break;
            }
            case 0: {
                MutableTreeNode child = this.find(name.nlID);
                if (child == null) break;
                BaseTree.MyTree.removeNodeFromParent(child);
                child.setUserObject(name);
                this.addInRightPlace(child, name);
                break;
            }
            case -1: {
                MutableTreeNode child = this.find(name.nlID);
                if (child == null) break;
                BaseTree.MyTree.removeNodeFromParent(child);
            }
        }
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        renderer.setIcon(NameListTreeCellRenderer.iconForType(this.objectType));
        renderer.setFont(BaseTree.boldFont);
    }

    public void select(TreeSelectionEvent event) {
    }
}

