/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.server.guireq.GComputer;

public class FSGroupSelectorHelper
implements Comparator {
    public static NameList getSelectedFilesystems(TreeSelector pSelector) {
        NameList list2 = pSelector.getNameList();
        NameList head = null;
        NameList prev = null;
        while (list2 != null) {
            NameList next = list2.nlNext;
            list2.nlNext = null;
            if (list2.nlInfo == 3) {
                if (prev == null) {
                    head = list2;
                } else {
                    prev.nlNext = list2;
                }
                prev = list2;
            }
            list2 = next;
        }
        TreeMap<Integer, NameList> map = new TreeMap<Integer, NameList>();
        int computerID = -3;
        while (head != null) {
            if (head.nlID2 != computerID) {
                computerID = head.nlID2;
                map.put(new Integer(computerID), head);
            }
            head = head.nlNext;
        }
        prev = null;
        head = null;
        for (NameList list2 : map.values()) {
            if (prev != null) {
                prev.nlNext = list2;
            } else {
                head = list2;
            }
            computerID = list2.nlID2;
            do {
                prev = list2;
            } while ((list2 = list2.nlNext) != null && list2.nlID2 == computerID);
            prev.nlNext = null;
        }
        return head;
    }

    public static NameList getSelectedComputers(TreeSelector pSelector) {
        NameList list = pSelector.getNameList();
        NameList head = null;
        NameList prev = null;
        while (list != null) {
            NameList next = list.nlNext;
            list.nlNext = null;
            if (list.nlInfo == 1) {
                if (prev == null) {
                    head = list;
                } else {
                    prev.nlNext = list;
                }
                prev = list;
            }
            list = next;
        }
        return head;
    }

    public TreeSelector getTreeSelector(NameList available, NameList selected, boolean byCluster) {
        return this.getFSTreeSelector(available, selected, byCluster);
    }

    public TreeSelector getFSTreeSelector(NameList available, NameList selected, boolean byCluster) {
        NameList selectedFS = selected;
        NameList availableFS = available;
        NameList prevFS = null;
        int compare = -1;
        TreeSelector selector = null;
        while (availableFS != null) {
            while (selectedFS != null) {
                compare = selectedFS.nlID2 - availableFS.nlID2;
                if (compare == 0) {
                    compare = selectedFS.nlName.compareTo(availableFS.nlName);
                }
                if (compare >= 0) break;
                selectedFS = selectedFS.nlNext;
            }
            if (selectedFS == null) break;
            if (compare == 0) {
                if (prevFS == null) {
                    available = availableFS.nlNext;
                } else {
                    prevFS.nlNext = availableFS.nlNext;
                }
            } else {
                prevFS = availableFS;
            }
            availableFS = availableFS.nlNext;
        }
        selector = new TreeSelector(this.makeFsTree(available, byCluster), this.makeFsTree(selected, byCluster), true);
        selector.setCleanupDepth(0);
        return selector;
    }

    public TreeSelector getComputerTreeSelector(NameList available, NameList selected, boolean byCluster) {
        TreeSelector selector = null;
        NameList newAvailable = null;
        NameList prev = null;
        boolean index = false;
        while (available != null) {
            boolean found = false;
            NameList curSelected = selected;
            while (curSelected != null && !found) {
                if (available.nlID == curSelected.nlID) {
                    found = true;
                }
                curSelected = curSelected.nlNext;
            }
            if (!found) {
                if (newAvailable == null) {
                    newAvailable = (NameList)available.clone();
                    newAvailable.nlNext = null;
                    prev = newAvailable;
                } else {
                    prev = prev.nlNext = (NameList)available.clone();
                    prev.nlNext = null;
                }
            }
            available = available.nlNext;
        }
        available = newAvailable;
        selector = new TreeSelector(this.makeComputerTree(available, byCluster), this.makeComputerTree(selected, byCluster), true);
        selector.setCleanupDepth(0);
        return selector;
    }

    public JTree makeFsTree(NameList list, boolean byCluster) {
        ComputerTreeNode compAvailHead = null;
        NameList prevFS = null;
        HashMap hashm = null;
        if (byCluster) {
            hashm = new HashMap();
        }
        int lastComputerID = -3;
        while (list != null) {
            GComputer structure = GuiUtil.getComputer(list.nlID2);
            if (list.nlID2 != lastComputerID) {
                ComputerTreeNode compNode;
                Integer id;
                if (byCluster && structure.gcClusterID > 0 && !hashm.containsKey(id = new Integer(structure.gcClusterID))) {
                    hashm.put(id, null);
                    compNode = new ComputerTreeNode();
                    compNode.computer = new NameList();
                    compNode.computer.nlClusterID = structure.gcClusterID;
                    compNode.computer.nlName = structure.gcClusterName + "-" + structure.gcDomainName;
                    compNode.computer.nlClusterName = structure.gcClusterName;
                    compNode.computer.nlInfo = (short)99;
                    compNode.next = compAvailHead;
                    compAvailHead = compNode;
                }
                lastComputerID = list.nlID2;
                compNode = new ComputerTreeNode();
                compNode.filesystems = list;
                compNode.computer = new NameList();
                compNode.computer.nlInfo = 1;
                compNode.computer.nlID = lastComputerID;
                compNode.computer.nlName = structure.gcTSName;
                compNode.computer.nlClusterID = structure.gcClusterID;
                compNode.computer.nlID2 = structure.gcOsType;
                compNode.computer.nlClusterName = structure.gcClusterName;
                compNode.computer.nlClusterDomain = structure.gcDomainName;
                compNode.computer.nlHostName = structure.gcHostedNodeName;
                compNode.next = compAvailHead;
                compAvailHead = compNode;
                if (prevFS != null) {
                    prevFS.nlNext = null;
                }
            }
            prevFS = list;
            list = list.nlNext;
        }
        return new JTree(this.sortAndMakeTree(compAvailHead, byCluster, false));
    }

    public JTree makeComputerTree(NameList list, boolean byCluster) {
        ComputerTreeNode compAvailHead = null;
        NameList prevComp = null;
        HashMap hashm = null;
        if (byCluster) {
            hashm = new HashMap();
        }
        while (list != null) {
            ComputerTreeNode compNode;
            Integer id;
            if (byCluster && list.nlClusterID > 0 && !hashm.containsKey(id = new Integer(list.nlClusterID))) {
                hashm.put(id, null);
                compNode = new ComputerTreeNode();
                compNode.computer = new NameList();
                compNode.computer.nlClusterID = list.nlClusterID;
                compNode.computer.nlName = list.nlClusterName + "-" + list.nlClusterDomain;
                compNode.computer.nlClusterName = list.nlClusterName;
                compNode.computer.nlInfo = (short)99;
                compNode.next = compAvailHead;
                compAvailHead = compNode;
            }
            compNode = new ComputerTreeNode();
            compNode.computer = new NameList();
            compNode.computer.nlInfo = 1;
            compNode.computer.nlID = list.nlID;
            compNode.computer.nlName = list.nlName;
            compNode.computer.nlClusterID = list.nlClusterID;
            compNode.computer.nlID2 = list.nlID2;
            compNode.computer.nlClusterName = list.nlClusterName;
            compNode.computer.nlClusterDomain = list.nlClusterDomain;
            compNode.computer.nlHostName = list.nlHostName;
            compNode.next = compAvailHead;
            compAvailHead = compNode;
            if (prevComp != null) {
                prevComp.nlNext = null;
            }
            prevComp = list;
            list = list.nlNext;
        }
        return new JTree(this.sortAndMakeTree(compAvailHead, byCluster, true));
    }

    private DefaultMutableTreeNode sortAndMakeTree(ComputerTreeNode compAvailHead, boolean byCluster, boolean computerTree) {
        TreeMap<Object, ComputerTreeNode> sorter = byCluster ? new TreeMap(this) : new TreeMap<Object, ComputerTreeNode>();
        ComputerTreeNode compNode = compAvailHead;
        while (compNode != null) {
            if (byCluster) {
                sorter.put(compNode.computer, compNode);
            } else {
                sorter.put(compNode.computer.toString(), compNode);
            }
            compNode = compNode.next;
        }
        NameList element = new NameList();
        element.nlID = -1;
        element.nlInfo = (short)-1;
        TreeSelectorNode root = new TreeSelectorNode(element, false, false, true);
        TreeSelectorNode clusterNode = null;
        Iterator iterator = sorter.values().iterator();
        int lastClusterId = -3;
        boolean firstTime = true;
        while (iterator.hasNext()) {
            compNode = (ComputerTreeNode)iterator.next();
            if (byCluster && compNode.computer.nlClusterID != lastClusterId) {
                lastClusterId = compNode.computer.nlClusterID;
                if (compNode.computer.nlInfo == 99) {
                    clusterNode = new TreeSelectorNode(compNode.computer, false, false, true);
                    clusterNode.setButtonFlag(false);
                    root.add(clusterNode);
                } else if (firstTime) {
                    firstTime = false;
                    NameList nl = new NameList();
                    nl.nlName = Util.getString("LABEL_NON_CLUSTERED");
                    clusterNode = new TreeSelectorNode(nl, false, false, true);
                    clusterNode.setButtonFlag(false);
                    clusterNode.setNonClusteredLabel();
                    root.add(clusterNode);
                }
            }
            if (compNode.computer.nlInfo == 99) continue;
            TreeSelectorNode treeNode = new TreeSelectorNode(compNode.computer, computerTree, false, !computerTree, false, null, !byCluster, true);
            if (!computerTree) {
                treeNode.setButtonFlag(false);
            }
            if (byCluster) {
                clusterNode.add(treeNode);
            } else {
                root.add(treeNode);
            }
            element = compNode.filesystems;
            while (element != null) {
                treeNode.add(new TreeSelectorNode(element, true, false, false));
                element = element.nlNext;
            }
        }
        return root;
    }

    public int compare(Object o1, Object o2) {
        NameList n1 = (NameList)o1;
        NameList n2 = (NameList)o2;
        String s1 = n1.nlClusterName;
        String s2 = n2.nlClusterName;
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (s1.equals(s2)) {
            if (n1.nlInfo == 99) {
                return -1;
            }
            if (n2.nlInfo == 99) {
                return -1;
            }
            int x = n1.toString().compareTo(n2.toString());
            return x;
        }
        if (s1.equals("")) {
            return 1;
        }
        if (s2.equals("")) {
            return -1;
        }
        return n1.nlClusterName.compareTo(n2.nlClusterName);
    }

    private static class ComputerTreeNode {
        public ComputerTreeNode next;
        public NameList computer;
        public NameList filesystems;

        private ComputerTreeNode() {
        }
    }
}

