/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSGroupEditor;
import org.eclipse.aperi.TStorm.gui.FSGroupSelectorHelper;
import org.eclipse.aperi.TStorm.gui.MultiPicker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.tape.common.TapeConstants;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
Runnable {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private MultiPicker picker;
    private TreeSelector selector;
    private FSGroupEditor editor;

    public GroupCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition def = (GroupDefinition)this.createHeaderPanel.getData();
        def.members = this.DDI.nlInfo == 0 ? FSGroupSelectorHelper.getSelectedComputers(this.selector) : this.picker.getData(0);
        return def;
    }

    public void validate(CreateHeader header) throws GeneralException {
        GroupDefinition def = (GroupDefinition)header;
        if (def.members == null) {
            String s = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(s);
        }
    }

    private void create(GroupDefinition def) {
        this.createHeaderPanel = new CreateHeaderPanel(def, this, this.DDI);
        if (this.DDI.nlInfo == 0) {
            this.editor = new FSGroupEditor(def.members, this, true);
        } else {
            NameList[] initiallySelected = new NameList[]{def.members};
            String[] selectionListTitleIds = new String[]{"STG4030L"};
            short pickerObject = (short)(this.DDI.nlInfo + 1);
            this.picker = new MultiPicker(pickerObject, initiallySelected, null, "STG4029L", null, null, selectionListTitleIds, null, false);
            this.createHeaderPanel.add(this.picker.getComponent(), "Center");
            this.DDI.panel = this.createHeaderPanel;
            this.DDI.show();
            this.createHeaderPanel.gettingFocus();
        }
    }

    public void run() {
        this.selector = this.editor.selector;
        this.editor = null;
        this.createHeaderPanel.add((Component)this.selector, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader newHeader) {
        this.createHeaderPanel.replace(newHeader);
        NameList dummy = new NameList();
        dummy.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, dummy);
    }

    private void submitRetrieve(int ID2) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GroupDefinition def = new GroupDefinition();
        def.ID = ID2;
        def.groupType = this.DDI.nlInfo;
        def.members = null;
        request.requestData = def;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition def = new GroupDefinition();
        def.groupType = this.DDI.nlInfo;
        this.create(def);
        this.DDI.oldCreateHeader = (CreateHeader)def.clone();
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        GroupDefinition def = (GroupDefinition)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)def.clone();
        this.create(def);
    }

    public String getHelpID(int tab) {
        switch (this.DDI.nlInfo) {
            case 0: {
                return "mogr5";
            }
            case 77: {
                return "mogr7";
            }
            case 113: {
                return FabricGuiUtil.FHELP_GROUPS_FABRIC;
            }
            case 133: {
                return TapeConstants.LIBRARY_GROUPS_HELP;
            }
        }
        return null;
    }
}

