/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrimitiveConditionEditor
implements ActionListener,
ComponentListener {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    public JDialog dialog;
    public JLabel text;
    public JComboBox column;
    public JComboBox operator;
    public Container valuePanel;
    public JButton okButton;
    public boolean accepted = false;
    private Dimension minimumSize;
    private JButton helpButton;

    public void actionPerformed(ActionEvent event) {
        this.dialog.dispose();
    }

    public void accept() {
        this.accepted = true;
        this.dialog.dispose();
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        Component component = event.getComponent();
        Dimension dim = component.getSize();
        boolean tooSmall = false;
        if (dim.width < this.minimumSize.width) {
            tooSmall = true;
            dim.width = this.minimumSize.width;
        }
        if (dim.height < this.minimumSize.height) {
            tooSmall = true;
            dim.height = this.minimumSize.height;
        }
        if (tooSmall) {
            component.setSize(dim);
        }
    }

    public PrimitiveConditionEditor(String title) {
        String s = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(s);
        GuiUtil.setAccessible(this.okButton, s, s);
        s = MessageLog.getMessageNoID("GUI0114L");
        JButton cancelButton = new JButton(s);
        GuiUtil.setAccessible(cancelButton, s, s);
        s = MessageLog.getMessageNoID("GUI0072L");
        this.helpButton = new JButton(s);
        GuiUtil.setAccessible(this.helpButton, s, s);
        cancelButton.addActionListener(this);
        this.text = new JLabel();
        this.dialog = new JDialog(this.guiMain.getFrame(), title, true);
        GuiUtil.setAccessible(this.dialog, title, title);
        this.dialog.setDefaultCloseOperation(2);
        Container pane = this.dialog.getContentPane();
        Color background = pane.getBackground();
        JPanel superPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        superPanel.add((Component)this.text, c);
        c.weightx = 0.0;
        c.fill = 2;
        superPanel.add((Component)new HorizontalSeparator(background), c);
        c.fill = 0;
        superPanel.add(Box.createVerticalStrut(10), c);
        JPanel panel = new JPanel(new GridBagLayout());
        this.column = new TComboBox();
        c.gridwidth = 1;
        c.weightx = 0.5;
        c.anchor = 13;
        panel.add((Component)this.column, c);
        c.anchor = 10;
        c.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(10), c);
        this.operator = new TComboBox();
        c.weightx = 0.5;
        c.anchor = 17;
        c.gridwidth = 0;
        panel.add((Component)this.operator, c);
        c.anchor = 10;
        c.weightx = 0.0;
        superPanel.add((Component)panel, c);
        superPanel.add(Box.createVerticalStrut(10), c);
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        c.fill = 1;
        c.weighty = 1.0;
        superPanel.add((Component)this.valuePanel, c);
        c.weighty = 0.0;
        c.insets.top = 5;
        c.fill = 2;
        superPanel.add((Component)new HorizontalSeparator(background), c);
        c.insets.top = 0;
        c.fill = 0;
        superPanel.add(Box.createVerticalStrut(10), c);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.okButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(cancelButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.helpButton);
        c.gridheight = 0;
        superPanel.add((Component)panel, c);
        pane.setLayout(new GridBagLayout());
        c.insets = new Insets(0, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        pane.add((Component)superPanel, c);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.setHelpID("welcome_htm");
        this.helpButton.addActionListener(Help.getDisplayHelpFromSource());
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.dialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    public void enforceMinimumSize(Dimension pMinimumSize) {
        this.minimumSize = pMinimumSize;
        this.dialog.addComponentListener(this);
    }

    public void setHelpID(String helpID) {
        Help.setHelpID(this.helpButton, helpID);
        Help.setHelpID(this.dialog.getRootPane(), helpID);
    }

    public static class HorizontalSeparator
    extends Separator {
        public HorizontalSeparator(Color background) {
            super(background);
            this.reqMax = new Dimension(Short.MAX_VALUE, 2);
            this.reqMin = new Dimension(0, 2);
            this.reqPreferred = new Dimension(0, 2);
        }

        public void paint(Graphics gc) {
            Rectangle rectangle = gc.getClipBounds();
            int x = rectangle.x;
            int y = rectangle.y;
            int right = x + rectangle.width;
            Color saved = gc.getColor();
            gc.setColor(this.shadow);
            gc.drawLine(x, y, right, y);
            gc.setColor(this.highlight);
            gc.drawLine(x, y + 1, right, y + 1);
            gc.setColor(saved);
        }
    }

    public static abstract class Separator
    extends Component {
        protected Color shadow;
        protected Color highlight;
        protected Dimension reqMax;
        protected Dimension reqMin;
        protected Dimension reqPreferred;

        public Separator(Color background) {
            this.shadow = background.darker();
            this.highlight = background.brighter();
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPreferred;
        }
    }
}

