/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.ProbeAlertEditor;
import org.eclipse.aperi.TStorm.gui.ProbeGroupSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    private static final int COMPUTERS_TAB = 0;
    private static final int SCHEDULE_TAB = 1;
    private static final int ALERT_TAB = 2;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    protected JSgcScheduleCreateWhenData scheduleDefiner;
    protected ProbeGroupSelector selector;
    protected AbstractAlertEditor alertEditor;

    public ProbeCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiProbeHndlr";
    }

    public CreateHeader getData() {
        this.scheduleDefiner.getData();
        ProbePing probe = (ProbePing)this.createHeaderPanel.getData();
        this.getSelectorData(probe);
        probe.pbAlert = this.alertEditor.getData();
        return probe;
    }

    public void getSelectorData(ProbePing probe) {
        NameList[] array = this.selector.getData();
        probe.pbComputers = array[0];
        probe.pbComputerGroups = array[1];
        probe.pbDiskArrays = array[2];
        probe.pbDiskArrayGroups = array[3];
        probe.pbClusters = array[4];
        probe.pbFabrics = array[5];
        probe.pbFabricGroups = array[6];
        probe.pbLibraries = array[7];
        probe.pbLibrariesGroups = array[8];
        probe.pbAllComputers = this.selector.allCompsSelected;
        probe.pbAllDiskArrays = this.selector.allDisksSelected;
        probe.pbAllFabrics = this.selector.allFabricsSelected;
        probe.pbAllLibraries = this.selector.allLibrariesSelected;
    }

    public void validate(CreateHeader newHeader) throws GeneralException {
        ProbePing probe = (ProbePing)newHeader;
        if (probe.isEmpty()) {
            String s = MessageLog.getMessageNoTS("STG4048E", null);
            this.DDI.exceptionTabIndex = 0;
            throw new GeneralException(s);
        }
        this.DDI.exceptionTabIndex = 1;
        this.scheduleDefiner.validate(probe);
        this.DDI.exceptionTabIndex = 2;
        this.alertEditor.validateData();
    }

    protected void makeSelectorAndAlertEditor(ProbePing probe) {
        this.selector = new ProbeGroupSelector(probe.pbComputers, probe.pbComputerGroups, probe.pbClusters, probe.pbDiskArrays, probe.pbDiskArrayGroups, probe.pbFabrics, probe.pbFabricGroups, probe.pbLibraries, probe.pbLibrariesGroups, probe.pbAllComputers, probe.pbAllDiskArrays, probe.pbAllFabrics, probe.pbAllLibraries);
        this.alertEditor = probe.pbAlert == null ? new ProbeAlertEditor() : new ProbeAlertEditor(probe.pbAlert);
    }

    private void create(ProbePing probe) {
        this.createHeaderPanel = new CreateHeaderPanel(probe, this, this.DDI);
        this.scheduleDefiner = new JSgcScheduleCreateWhenData(this.DDI.nlInfo, this.DDI);
        JPanel whenPanel = this.scheduleDefiner.build(probe);
        this.makeSelectorAndAlertEditor(probe);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String s = Util.getString("WHAT_TO_PROBE");
        this.tabs.addTab(s, this.getSelectorComponent());
        s = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(s, whenPanel);
        s = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(s, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
        this.DDI.addObjectChangeListener(this, (short)0);
    }

    public Component getSelectorComponent() {
        return this.selector.getComponent();
    }

    public void replace(CreateHeader newHeader) {
        ProbePing probe = (ProbePing)newHeader;
        this.createHeaderPanel.replace(probe);
        this.scheduleDefiner.replace(probe);
        this.selectorReplace(probe);
    }

    public void selectorReplace(ProbePing probe) {
        this.selector.replace(probe.pbComputers, probe.pbComputerGroups, probe.pbClusters, probe.pbDiskArrays, probe.pbDiskArrayGroups, probe.pbFabrics, probe.pbFabricGroups, probe.pbLibraries, probe.pbLibrariesGroups, probe.pbAllComputers, probe.pbAllDiskArrays, probe.pbAllFabrics, probe.pbAllLibraries);
    }

    private void submitRetrieve(int ID2) {
        ProbePing probe = new ProbePing(this.DDI.nlInfo);
        probe.ID = ID2;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr", probe);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        ProbePing probe = new ProbePing(this.DDI.nlInfo);
        this.create(probe);
        probe.pbAlert = this.alertEditor.getData();
        this.DDI.oldCreateHeader = (CreateHeader)probe.clone();
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        ProbePing probe = (ProbePing)createHeader;
        this.create(probe);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
        this.tabs.setSelectedIndex(tabIndex);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        ProbePing probe = (ProbePing)response.responseData;
        this.create(probe);
        this.DDI.oldCreateHeader = (CreateHeader)probe.clone();
    }

    public void stateChanged(ChangeEvent event) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.selector.invalidateGroups(name.nlInfo);
        } else if (changeType == 1) {
            this.selector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "moprob5";
            }
            case 1: {
                return "moprob10";
            }
            case 2: {
                return "moprob15";
            }
        }
        return null;
    }
}

