/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList compSelections;
    private NameList compGroupSelections;
    private NameList clusterSelections;
    private NameList diskSelections;
    private NameList diskGroupSelections;
    private NameList fabricSelections;
    private NameList fabricGroupSelections;
    private NameList librariesSelections;
    private NameList librariesGroupSelections;
    private NameList rootName;
    public boolean allCompsSelected;
    public boolean allDisksSelected;
    public boolean allFabricsSelected;
    public boolean allLibrariesSelected;
    private TreeSet compIncludeSet = new TreeSet();
    private TreeSet compExcludeSet = new TreeSet();
    private TreeSet diskIncludeSet = new TreeSet();
    private TreeSet diskExcludeSet = new TreeSet();
    private TreeSet fabricIncludeSet = new TreeSet();
    private TreeSet fabricExcludeSet = new TreeSet();
    private TreeSet libraryIncludeSet = new TreeSet();
    private TreeSet libraryExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode sourceDiskGroupLabel;
    private TreeSelectorNode sourceFabricGroupLabel;
    private TreeSelectorNode sourceLibraryGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean clusterExpanding;
    private boolean groupExpanding;
    private static final int ROOT_ID = -10;
    private static final int COMP_GROUP_ID = -9;
    private static final int COMP_ID = -8;
    private static final int CLUSTER_ID = -7;
    private static final int DISK_GROUP_ID = -2;
    private static final int DISK_ID = -1;
    private static final int FABRIC_GROUP_ID = -6;
    private static final int FABRIC_ID = -5;
    private static final int LIBRARIES_ID = -3;
    private static final int LIBRARIES_GROUP_ID = -4;
    private static final int ALL_COMP_ID = Integer.MAX_VALUE;
    private static final int ALL_DISK_ID = 0x7FFFFFFE;
    private static final int ALL_FABRICS_ID = 0x7FFFFFFD;
    private static final int ALL_LIBRARIES_ID = 0x7FFFFFFC;
    public static final int COMP_IX = 0;
    public static final int COMP_GROUP_IX = 1;
    public static final int DISK_IX = 2;
    public static final int DISK_GROUP_IX = 3;
    public static final int CLUSTER_IX = 4;
    public static final int FABRIC_IX = 5;
    public static final int FABRIC_GROUP_IX = 6;
    public static final int LIBRARIES_IX = 7;
    public static final int LIBRARIES_GROUP_IX = 8;
    private static final String COMP_GROUP_MSG = MessageLog.getMessageNoID("STG3012L");
    private static final String COMP_MSG = MessageLog.getMessageNoID("STG4041L");
    private static final String ALL_COMP_MSG = MessageLog.getMessageNoID("STG3100L");
    private static final String CLUSTER_MSG = Util.getString("LABEL_CLUSTERS");
    private static final String DISK_GROUP_MSG = MessageLog.getMessageNoID("STG5500L");
    private static final String DISK_MSG = MessageLog.getMessageNoID("STG4191L");
    private static final String ALL_DISK_MSG = MessageLog.getMessageNoID("STG5501L");
    private static final String FABRIC_GROUP_MSG = MessageLog.getMessageNoID("STG7573L");
    private static final String FABRIC_MSG = MessageLog.getMessageNoID("STG7574L");
    private static final String ALL_FABRICS_MSG = MessageLog.getMessageNoID("STG7575L");
    private static final String LIBRARIES_GROUP_MSG = MessageLog.getMessageNoID("STG7736L");
    private static final String LIBRARY_MSG = MessageLog.getMessageNoID("STG7737L");
    private static final String ALL_LIBRARY_MSG = MessageLog.getMessageNoID("STG7735L");

    public ProbeGroupSelector(NameList pCompSelections, NameList pCompGroupSelections, NameList pClusterSelections, NameList pDiskSelections, NameList pDiskGroupSelections, NameList pFabricSelections, NameList pFabricGroupSelections, NameList pLibrariesSelections, NameList pLibrariesGroupSelections, boolean pAllCompsSelected, boolean pAllDisksSelected, boolean pAllFabricsSelected, boolean pAllLibrariesSelected) {
        this.compSelections = pCompSelections;
        this.compGroupSelections = pCompGroupSelections;
        this.clusterSelections = pClusterSelections;
        this.diskSelections = pDiskSelections;
        this.diskGroupSelections = pDiskGroupSelections;
        this.fabricSelections = pFabricSelections;
        this.fabricGroupSelections = pFabricGroupSelections;
        this.librariesSelections = pLibrariesSelections;
        this.librariesGroupSelections = pLibrariesGroupSelections;
        this.allCompsSelected = pAllCompsSelected;
        this.allDisksSelected = pAllDisksSelected;
        this.allFabricsSelected = pAllFabricsSelected;
        this.allLibrariesSelected = pAllLibrariesSelected;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] listHead = new NameList[9];
        NameList[] listTail = new NameList[9];
        NameList element = null;
        this.allCompsSelected = false;
        this.allDisksSelected = false;
        this.allFabricsSelected = false;
        this.allLibrariesSelected = false;
        NameList selList = this.selector.getNameList();
        while (selList != null) {
            int ix = -999;
            if (selList.nlInfo == 0) {
                ix = 1;
            } else if (selList.nlInfo == 1) {
                ix = 0;
            } else if (selList.nlInfo == 77) {
                ix = 3;
            } else if (selList.nlInfo == 78) {
                ix = 2;
            } else if (selList.nlInfo == 99) {
                ix = 4;
            }
            if (selList.nlInfo == 113) {
                ix = 6;
            } else if (selList.nlInfo == 114) {
                ix = 5;
            } else if (selList.nlInfo == 13) {
                this.allCompsSelected = true;
            } else if (selList.nlInfo == 54) {
                this.allDisksSelected = true;
            } else if (selList.nlInfo == 115) {
                this.allFabricsSelected = true;
            } else if (selList.nlInfo == 133) {
                ix = 8;
            } else if (selList.nlInfo == 134) {
                ix = 7;
            } else if (selList.nlInfo == 135) {
                this.allLibrariesSelected = true;
            }
            if (ix < 0) {
                selList = selList.nlNext;
                continue;
            }
            element = selList;
            selList = element.nlNext;
            element.nlNext = null;
            if (listTail[ix] == null) {
                listHead[ix] = element;
            } else {
                listTail[ix].nlNext = element;
            }
            listTail[ix] = element;
        }
        return listHead;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.sourceCompGroupLabel = this.addLabelNode(COMP_GROUP_MSG, -9, root);
        this.addLabelNode(COMP_MSG, -8, root);
        this.addLabelNode(CLUSTER_MSG, -7, root);
        this.sourceFabricGroupLabel = this.addLabelNode(FABRIC_GROUP_MSG, -6, root);
        this.addLabelNode(FABRIC_MSG, -5, root);
        this.sourceLibraryGroupLabel = this.addLabelNode(LIBRARIES_GROUP_MSG, -4, root);
        this.addLabelNode(LIBRARY_MSG, -3, root);
        this.sourceDiskGroupLabel = this.addLabelNode(DISK_GROUP_MSG, -2, root);
        this.addLabelNode(DISK_MSG, -1, root);
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode compGroupLabel = null;
        TreeSelectorNode compLabel = null;
        TreeSelectorNode compExcludeLabel = null;
        TreeSelectorNode clusterLabel = null;
        TreeSelectorNode diskGroupLabel = null;
        TreeSelectorNode diskLabel = null;
        TreeSelectorNode diskExcludeLabel = null;
        TreeSelectorNode fabricGroupLabel = null;
        TreeSelectorNode fabricLabel = null;
        TreeSelectorNode fabricExcludeLabel = null;
        TreeSelectorNode libraryGroupLabel = null;
        TreeSelectorNode libraryLabel = null;
        TreeSelectorNode libraryExcludeLabel = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.compGroupSelections;
        while (name != null) {
            if (compGroupLabel == null) {
                compGroupLabel = this.addLabelNode(COMP_GROUP_MSG, -9, root);
            }
            compGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null, true, true));
            name = name.nlNext;
        }
        this.fillSets(this.compSelections, this.compIncludeSet, this.compExcludeSet, true, false);
        if (this.allCompsSelected || !this.compIncludeSet.isEmpty()) {
            compLabel = this.addLabelNode(COMP_MSG, -8, root);
            if (this.allCompsSelected) {
                this.addAllMembersNode(ALL_COMP_MSG, Integer.MAX_VALUE, 13, compLabel, true);
            }
            this.addTreeSet(compLabel, this.compIncludeSet);
        }
        if (!this.compExcludeSet.isEmpty()) {
            compExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(compExcludeLabel);
            this.addTreeSet(compExcludeLabel, this.compExcludeSet);
        }
        name = this.clusterSelections;
        while (name != null) {
            if (clusterLabel == null) {
                clusterLabel = this.addLabelNode(CLUSTER_MSG, -7, root);
            }
            clusterLabel.add(new TreeSelectorNode(name, true, false, true, true, null, false, true));
            name = name.nlNext;
        }
        name = this.fabricGroupSelections;
        while (name != null) {
            if (fabricGroupLabel == null) {
                fabricGroupLabel = this.addLabelNode(FABRIC_GROUP_MSG, -6, root);
            }
            fabricGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        this.fillSets(this.fabricSelections, this.fabricIncludeSet, this.fabricExcludeSet, true, false);
        if (this.allFabricsSelected || !this.fabricIncludeSet.isEmpty()) {
            fabricLabel = this.addLabelNode(FABRIC_MSG, -5, root);
            if (this.allFabricsSelected) {
                this.addAllMembersNode(ALL_FABRICS_MSG, 0x7FFFFFFD, 115, fabricLabel, true);
            }
            this.addTreeSet(fabricLabel, this.fabricIncludeSet);
        }
        if (!this.fabricExcludeSet.isEmpty()) {
            fabricExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(fabricExcludeLabel);
            this.addTreeSet(fabricExcludeLabel, this.fabricExcludeSet);
        }
        if (!GuiUtil.isAnyDiskArrayInstalled()) {
            return root;
        }
        name = this.diskGroupSelections;
        while (name != null) {
            if (diskGroupLabel == null) {
                diskGroupLabel = this.addLabelNode(DISK_GROUP_MSG, -2, root);
            }
            diskGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        this.fillSets(this.diskSelections, this.diskIncludeSet, this.diskExcludeSet, true, false);
        if (this.allDisksSelected || !this.diskIncludeSet.isEmpty()) {
            diskLabel = this.addLabelNode(DISK_MSG, -1, root);
            if (this.allDisksSelected) {
                this.addAllMembersNode(ALL_DISK_MSG, 0x7FFFFFFE, 54, diskLabel, true);
            }
            this.addTreeSet(diskLabel, this.diskIncludeSet);
        }
        if (!this.diskExcludeSet.isEmpty()) {
            diskExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(diskExcludeLabel);
            this.addTreeSet(diskExcludeLabel, this.diskExcludeSet);
        }
        name = this.librariesGroupSelections;
        while (name != null) {
            if (libraryGroupLabel == null) {
                libraryGroupLabel = this.addLabelNode(LIBRARIES_GROUP_MSG, -4, root);
            }
            libraryGroupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        this.fillSets(this.librariesSelections, this.libraryIncludeSet, this.libraryExcludeSet, true, false);
        if (this.allLibrariesSelected || !this.libraryIncludeSet.isEmpty()) {
            libraryLabel = this.addLabelNode(LIBRARY_MSG, -3, root);
            if (this.allLibrariesSelected) {
                this.addAllMembersNode(ALL_LIBRARY_MSG, 0x7FFFFFFC, 135, libraryLabel, true);
            }
            this.addTreeSet(libraryLabel, this.libraryIncludeSet);
        }
        if (!this.libraryExcludeSet.isEmpty()) {
            libraryExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(libraryExcludeLabel);
            this.addTreeSet(libraryExcludeLabel, this.libraryExcludeSet);
        }
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList pCompSelections, NameList pCompGroupSelections, NameList pClusterSelections, NameList pDiskSelections, NameList pDiskGroupSelections, NameList pFabricSelections, NameList pFabricGroupSelections, NameList pLibrarySelections, NameList pLibraryGroupSelections, boolean pAllCompsSelected, boolean pAllDisksSelected, boolean pAllFabricsSelected, boolean pAllLibrariesSelected) {
        this.compSelections = pCompSelections;
        this.compGroupSelections = pCompGroupSelections;
        this.clusterSelections = pClusterSelections;
        this.diskSelections = pDiskSelections;
        this.diskGroupSelections = pDiskGroupSelections;
        this.fabricSelections = pFabricSelections;
        this.fabricGroupSelections = pFabricGroupSelections;
        this.librariesSelections = pLibrarySelections;
        this.librariesGroupSelections = pLibraryGroupSelections;
        this.allCompsSelected = pAllCompsSelected;
        this.allDisksSelected = pAllDisksSelected;
        this.allFabricsSelected = pAllFabricsSelected;
        this.allLibrariesSelected = pAllLibrariesSelected;
        this.compIncludeSet.clear();
        this.compExcludeSet.clear();
        this.diskIncludeSet.clear();
        this.diskExcludeSet.clear();
        this.fabricIncludeSet.clear();
        this.fabricExcludeSet.clear();
        this.libraryIncludeSet.clear();
        this.libraryExcludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, TreeSet includeSet, TreeSet excludeSet, boolean memberSelectable, boolean memberExcludeable) {
        boolean showClusterName = true;
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if (Constants.isVirtualServer(memberList.nlID2)) {
                memberList = memberList.nlNext;
                continue;
            }
            if ((memberList.nlState & 1) != 0) {
                set = excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = includeSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            if (this.clusterExpanding) {
                showClusterName = false;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, showClusterName, true);
            if (this.clusterExpanding || this.groupExpanding) {
                member.setButtonFlag(false);
            }
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        TreeSelectorNode sourceGroupLabel;
        if (name.nlID == -9) {
            sourceGroupLabel = this.sourceCompGroupLabel;
        } else if (name.nlID == -2) {
            sourceGroupLabel = this.sourceDiskGroupLabel;
        } else if (name.nlID == -6) {
            sourceGroupLabel = this.sourceFabricGroupLabel;
        } else if (name.nlID == -4) {
            sourceGroupLabel = this.sourceLibraryGroupLabel;
        } else {
            return;
        }
        if (!sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        this.clusterExpanding = false;
        this.groupExpanding = false;
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -9) {
                this.sendRequest((short)0, -1);
            } else if (name.nlID == -8) {
                this.sendRequest((short)1, -1);
            } else if (name.nlID == -2) {
                this.sendRequest((short)77, -1);
            } else if (name.nlID == -1) {
                this.sendRequest((short)78, -1);
            } else if (name.nlID == -7) {
                this.sendRequest((short)101, -1);
            } else if (name.nlID == -5) {
                this.sendRequest((short)114, -1);
            } else if (name.nlID == -6) {
                this.sendRequest((short)113, -1);
            } else if (name.nlID == -3) {
                this.sendRequest((short)134, -1);
            } else if (name.nlID == -4) {
                this.sendRequest((short)133, -1);
            }
        } else if (name.nlInfo == 0) {
            this.sendRequest((short)1, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 99) {
            this.clusterExpanding = true;
            this.sendRequest(name.nlInfo, name.nlID);
        } else if (name.nlInfo == 113) {
            this.sendRequest((short)114, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 133) {
            this.sendRequest((short)134, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 13) {
            this.sendRequest((short)1, -1);
        } else if (name.nlInfo == 77) {
            this.sendRequest((short)78, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 54) {
            this.sendRequest((short)78, -1);
        } else if (name.nlInfo == 115) {
            this.sendRequest((short)114, -1);
        } else if (name.nlInfo == 135) {
            this.sendRequest((short)134, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeListRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        if (resourceType == 99) {
            requestData.listRequested = 11;
        } else {
            if (resourceType == 101) {
                resourceType = (short)99;
            }
            requestData.listRequested = 10000 + resourceType;
            requestData.groupID = groupID;
        }
        return requestData;
    }

    protected GroupDefinition makeGroupRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        Request request;
        if (resourceType == 99) {
            GroupDefinition lData = this.makeGroupRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", lData);
        } else {
            GuiListReq gData = this.makeListRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", gData);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        boolean showClusterName = true;
        Serializable obj = response.responseData;
        NameList nameList = null;
        if (obj instanceof GroupDefinition) {
            GroupDefinition gdef = (GroupDefinition)response.responseData;
            nameList = gdef.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 0 || nameList.nlInfo == 113 || nameList.nlInfo == 77 || nameList.nlInfo == 99 || nameList.nlInfo == 133) {
            if (nameList.nlInfo == 99) {
                showClusterName = false;
            }
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, true, false, false, true, null, showClusterName, true);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else {
            boolean exclude;
            boolean select = this.expansionTree == this.sourceTree;
            boolean bl = exclude = !select;
            if (nameList.nlInfo == 1) {
                if (select) {
                    this.addAllMembersNode(ALL_COMP_MSG, Integer.MAX_VALUE, 13, this.expansionNode, false);
                }
                this.compIncludeSet.clear();
                this.fillSets(nameList, this.compIncludeSet, this.compExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.compIncludeSet);
            } else if (nameList.nlInfo == 114) {
                if (select) {
                    this.addAllMembersNode(ALL_FABRICS_MSG, 0x7FFFFFFD, 115, this.expansionNode, false);
                }
                this.fabricIncludeSet.clear();
                this.fillSets(nameList, this.fabricIncludeSet, this.fabricExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.fabricIncludeSet);
            } else if (nameList.nlInfo == 134) {
                if (select) {
                    this.addAllMembersNode(ALL_LIBRARY_MSG, 0x7FFFFFFC, 135, this.expansionNode, false);
                }
                this.libraryIncludeSet.clear();
                this.fillSets(nameList, this.libraryIncludeSet, this.libraryExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.libraryIncludeSet);
            } else {
                if (select) {
                    this.addAllMembersNode(ALL_DISK_MSG, 0x7FFFFFFE, 54, this.expansionNode, false);
                }
                this.diskIncludeSet.clear();
                this.fillSets(nameList, this.diskIncludeSet, this.diskExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.diskIncludeSet);
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -10, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String label, int id, TreeSelectorNode root) {
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(String label, int id, int resourceID, TreeSelectorNode root, boolean expandable) {
        NameList name = this.newNameList(label, id, resourceID);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }
}

