/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.ResourceSettingsEditor;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.TStorm.gui.SettingsEditor;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class RemovedResourceSettingsEditor
extends ResourceSettingsEditor
implements SettingsEditor {
    private static final int FILESYSTEM = 0;
    private static final int DISK = 1;
    private static final int FILERS = 2;
    private static final int SUBSYSTEMS = 3;
    private static final int FABRIC = 4;
    private static final int TAPE = 5;
    private static final int TOTAL_FIELDS = 6;
    private static final itemDescriptor[] labelIDs = new itemDescriptor[]{new itemDescriptor("STG2600L", "NAME_FILESYSTEMS", "DESCRIPTION_FILESYSTEMS", "MNEMONIC_DAYSTOKEEPFORFS"), new itemDescriptor("STG1004L", "NAME_DISKS", "DESCRIPTION_DISKS", "MNEMONIC_DAYSTOKEEPFORDISK"), new itemDescriptor("FILERS", "FILERS", "DESCRIPTION_FILERS", "MNEMONIC_DAYSTOKEEPFORFILER"), new itemDescriptor("SUBSYSTEMS", "SUBSYSTEMS", "DESCRIPTION_SYBSYSTEMS", "MNEMONIC_DAYSTOKEEPFORSUBSYSTEM"), new itemDescriptor("LABEL_FABRIC", "LABEL_FABRIC", "DESCRIPTION_FABRIC", "MNEMONIC_DAYSTOKEEPFORFABRIC"), new itemDescriptor("LABEL_TAPE", "LABEL_TAPE", "DESCRIPTION_TAPE", "MNEMONIC_DAYSTOKEEPFORTAPE")};
    private String forString;

    public RemovedResourceSettingsEditor(SettingsDDI pDDI) {
        this.ddi = pDDI;
    }

    protected void fillSettingsFromValues(Settings settings) {
        int index = 0;
        settings.seKeepRemovedFS = this.values[index++];
        settings.seKeepRemovedDev = this.values[index++];
        settings.seKeepRemovedFilers = this.values[index++];
        settings.seKeepRemovedSubsystems = this.values[index++];
        settings.seKeepRemovedFabric = this.values[index++];
        settings.seKeepRemovedTape = this.values[index++];
    }

    protected void fillValuesFromSettings(Settings settings) {
        int index = 0;
        this.values[index++] = settings.seKeepRemovedFS;
        this.values[index++] = settings.seKeepRemovedDev;
        this.values[index++] = settings.seKeepRemovedFilers;
        this.values[index++] = settings.seKeepRemovedSubsystems;
        this.values[index++] = settings.seKeepRemovedFabric;
        this.values[index++] = settings.seKeepRemovedTape;
    }

    private JCheckBox newCheckBox(int index) {
        JCheckBox checkBox = new JCheckBox(Util.getString(RemovedResourceSettingsEditor.labelIDs[index].itemLabel));
        GuiUtil.setAccessible(checkBox, RemovedResourceSettingsEditor.labelIDs[index].itemComponent, RemovedResourceSettingsEditor.labelIDs[index].itemDescription);
        this.checkBoxes[index] = checkBox;
        return checkBox;
    }

    private JLabel newLabel(int index, String s) {
        this.leadingLabels[index] = new JLabel(s);
        this.leadingLabels[index].setForeground(Color.black);
        return this.leadingLabels[index];
    }

    private JTextField newTextField(int index) {
        this.fields[index] = TTextField.newTTextField(null, 3, 5, true);
        this.fields[index].setEnabled(true);
        return this.fields[index];
    }

    private JLabel makeRow(int index, Container panel, GridBagConstraints c) {
        JCheckBox checkBox = this.newCheckBox(index);
        c.gridwidth = 1;
        c.insets.left = 23;
        panel.add((Component)checkBox, c);
        JLabel label = this.newLabel(index, this.forString);
        c.insets.left = 0;
        panel.add((Component)label, c);
        JTextField field = this.newTextField(index);
        GuiUtil.setAccessibleLabel(label, field, RemovedResourceSettingsEditor.labelIDs[index].itemMnemonic, RemovedResourceSettingsEditor.labelIDs[index].itemLabel, RemovedResourceSettingsEditor.labelIDs[index].itemLabel);
        c.insets.left = 3;
        panel.add((Component)field, c);
        label = new JLabel("");
        c.gridwidth = 0;
        return label;
    }

    public JComponent getComponent(Settings settings) {
        this.checkBoxes = new JCheckBox[6];
        this.fields = new JTextField[6];
        this.leadingLabels = new JLabel[6];
        this.forString = MessageLog.getMessageNoID("STG3260L");
        String s = MessageLog.getMessageNoID("STG3249L");
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.insets.top = 6;
        c.insets.left = 6;
        c.anchor = 17;
        panel.add((Component)label, c);
        c.insets.top = 0;
        label = this.makeRow(0, panel, c);
        c.weightx = 1.0;
        panel.add((Component)label, c);
        c.insets.top = 0;
        label = this.makeRow(1, panel, c);
        c.weightx = 1.0;
        panel.add((Component)label, c);
        c.insets.top = 0;
        label = this.makeRow(2, panel, c);
        c.weightx = 1.0;
        panel.add((Component)label, c);
        c.insets.top = 0;
        label = this.makeRow(3, panel, c);
        c.weightx = 1.0;
        panel.add((Component)label, c);
        c.weightx = 0.0;
        c.insets.top = 0;
        label = this.makeRow(4, panel, c);
        panel.add((Component)label, c);
        c.weightx = 0.0;
        c.insets.top = 0;
        label = this.makeRow(5, panel, c);
        panel.add((Component)label, c);
        c.gridheight = 0;
        c.weighty = 1.0;
        panel.add(Box.createVerticalStrut(1), c);
        this.values = new short[6];
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].addChangeListener(this);
        }
        this.pushSettingsOntoPanel(settings);
        return panel;
    }

    private static final class itemDescriptor {
        String itemLabel;
        String itemComponent;
        String itemDescription;
        String itemMnemonic;

        public itemDescriptor(String itemLabel, String itemComponent, String itemDescription, String itemMnemonic) {
            this.itemLabel = itemLabel;
            this.itemComponent = itemComponent;
            this.itemDescription = itemDescription;
            this.itemMnemonic = itemMnemonic;
        }
    }
}

