/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.DataReportColumnSelector;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ReportColumnSelector
implements ListSelectionListener,
ActionListener,
ListCellRenderer,
Comparator {
    private static final char ADD = 'A';
    private static final char REMOVE = '-';
    private static final char UP = 'U';
    private static final char DOWN = 'D';
    private static final char RESET = 'R';
    private Container panel;
    private Container wrhPanel;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    protected JList availableList;
    protected DefaultListModel availableModel;
    private JList selectedList;
    protected DefaultListModel selectedModel;
    private ListCellRenderer renderer;
    private int frozenColumns;
    protected CustomReportDataAdjuster adjuster;
    protected GuiReportReq grr;
    private boolean selectionMightRecurse;

    public static ReportColumnSelector createInstance(GuiReportReq grr, CustomReportDataAdjuster adjuster) {
        DataReportColumnSelector result = null;
        result = new DataReportColumnSelector(grr, adjuster);
        return result;
    }

    protected ReportColumnSelector(GuiReportReq pGRR, CustomReportDataAdjuster pAdjuster) {
        this.grr = pGRR;
        this.constructModels(pAdjuster);
        this.selectedList = new JList(this.selectedModel);
        this.renderer = this.selectedList.getCellRenderer();
        this.selectedList.setCellRenderer(this);
        this.selectedList.addListSelectionListener(this);
        this.availableList = new JList(this.availableModel);
        this.availableList.addListSelectionListener(this);
        this.wrhPanel = new JPanel();
        this.wrhPanel.setLayout(new BorderLayout());
        Container subPanel = ReportColumnSelector.makeListPanel(this.availableList, "STG3248L");
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.fill = 1;
        c.insets.left = 13;
        c.insets.top = 10;
        this.panel.add((Component)subPanel, c);
        this.addButton = new JButton(">>");
        this.addButton.setActionCommand(ReportingSelectionDriver.charToString('A'));
        this.removeButton = new JButton("<<");
        this.removeButton.setActionCommand(ReportingSelectionDriver.charToString('-'));
        subPanel = this.makeButtonPanel(this.addButton, this.removeButton);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 0;
        c.anchor = 10;
        c.fill = 0;
        c.insets.left = 0;
        this.panel.add((Component)subPanel, c);
        subPanel = ReportColumnSelector.makeListPanel(this.selectedList, "STG3262L");
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        this.panel.add((Component)subPanel, c);
        ImageIcon icon = IconFactory.getUpIcon();
        this.upButton = new JButton(icon);
        this.upButton.setActionCommand(ReportingSelectionDriver.charToString('U'));
        icon = IconFactory.getDownIcon();
        this.downButton = new JButton(icon);
        this.downButton.setActionCommand(ReportingSelectionDriver.charToString('D'));
        subPanel = this.makeButtonPanel(this.upButton, this.downButton);
        String s = MessageLog.getMessageNoID("STG1154L");
        JPanel ppp = new JPanel();
        ppp.setLayout(new FlowLayout(2));
        JButton button = new JButton(s);
        Dimension size = button.getPreferredSize();
        JPanel midLevel = new JPanel(new GridBagLayout());
        c.insets.top = 0;
        c.insets.left = 10;
        c.insets.right = 10;
        c.weightx = 0.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        midLevel.add(Box.createVerticalStrut(size.height), c);
        c.weighty = 1.0;
        midLevel.add((Component)subPanel, c);
        c.weighty = 0.0;
        c.gridheight = 0;
        midLevel.add((Component)button, c);
        button.setActionCommand(ReportingSelectionDriver.charToString('R'));
        button.addActionListener(this);
        c.insets.left = 0;
        c.insets.right = 0;
        c.insets.top = 10;
        c.weightx = 0.0;
        this.panel.add((Component)midLevel, c);
        ppp.add(button);
        this.wrhPanel.add((Component)ppp, "South");
        this.wrhPanel.add((Component)this.panel, "Center");
    }

    public void refresh(CustomReportDataAdjuster pAdjuster) {
        this.constructModels(pAdjuster);
        this.selectedList.setModel(this.selectedModel);
        this.availableList.setModel(this.availableModel);
    }

    private void constructModels(CustomReportDataAdjuster pAdjuster) {
        this.adjuster = pAdjuster;
        this.selectionMightRecurse = false;
        ColumnDescriptor firstDesc = this.adjuster.getColumnDescriptors();
        short highestColID = -1;
        this.frozenColumns = 0;
        ColumnDescriptor desc = firstDesc;
        while (desc != null) {
            if (desc.cdIsFrozen && (desc.cdTwin == null || desc.cdTwin == desc.cdNext)) {
                ++this.frozenColumns;
            }
            if (desc.cdID > highestColID) {
                highestColID = desc.cdID;
            }
            desc = desc.cdNext;
        }
        NameList[] idMap = new NameList[highestColID + 1];
        int nCols = 0;
        desc = firstDesc;
        while (desc != null) {
            ++nCols;
            if (desc.cdTwin == null || desc.cdTwin == desc.cdNext) {
                NameList element = new NameList();
                element.nlID = desc.cdID;
                element.nlID2 = nCols;
                element.nlID3 = desc.cdTwin == null ? -1 : (int)desc.cdTwin.cdID;
                element.nlState = desc.cdIsFrozen ? (byte)1 : 0;
                element.nlName = desc.cdShortName;
                idMap[element.nlID] = element;
            }
            desc = desc.cdNext;
        }
        int[] selectedColumnIDs = this.grr.selectedColumns;
        if (selectedColumnIDs == null) {
            selectedColumnIDs = new int[nCols];
            nCols = 0;
            desc = firstDesc;
            while (desc != null) {
                selectedColumnIDs[nCols] = desc.cdID;
                ++nCols;
                desc = desc.cdNext;
            }
        }
        nCols = 0;
        this.selectedModel = new DefaultListModel();
        for (int i = 0; i < selectedColumnIDs.length; ++i) {
            int columnID = selectedColumnIDs[i];
            NameList element = idMap[columnID];
            if (element == null) continue;
            this.selectedModel.add(nCols, element);
            ++nCols;
            idMap[columnID] = null;
        }
        nCols = 0;
        this.availableModel = new DefaultListModel();
        desc = firstDesc;
        while (desc != null) {
            NameList element = idMap[desc.cdID];
            if (element != null) {
                this.availableModel.add(nCols, element);
                ++nCols;
            }
            desc = desc.cdNext;
        }
    }

    private Container makeButtonPanel(AbstractButton above, AbstractButton below) {
        above.addActionListener(this);
        above.setEnabled(false);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 10;
        c.insets.left = 10;
        c.insets.right = 10;
        c.insets.top = 0;
        c.insets.bottom = 0;
        result.add((Component)above, c);
        result.add(Box.createVerticalStrut(10), c);
        below.addActionListener(this);
        below.setEnabled(false);
        c.gridheight = 0;
        result.add((Component)below, c);
        return result;
    }

    private static Container makeListPanel(Component list, String msgID) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets.bottom = 3;
        result.add((Component)ReportColumnSelector.makeLabel(msgID), c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridheight = 0;
        c.insets.bottom = 0;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(list);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        result.add((Component)scrollPane, c);
        return result;
    }

    private static JLabel makeLabel(String msgID) {
        String s = MessageLog.getMessageNoID(msgID);
        JLabel result = new JLabel(s);
        result.setForeground(Color.black);
        result.setFont(BaseTree.boldFont);
        return result;
    }

    public Component getPanel() {
        return this.wrhPanel;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.selectedList) {
            this.selectedSelectionChanged();
        } else {
            this.availableSelectionChanged();
        }
    }

    private void selectedSelectionChanged() {
        boolean anySelected;
        if (this.selectionMightRecurse) {
            return;
        }
        ListSelectionModel model = this.selectedList.getSelectionModel();
        boolean frozenSelected = false;
        int i = 0;
        while (!frozenSelected && i < this.frozenColumns) {
            if (model.isSelectedIndex(i)) {
                frozenSelected = true;
                continue;
            }
            ++i;
        }
        if (frozenSelected) {
            this.selectionMightRecurse = true;
            model.removeSelectionInterval(0, this.frozenColumns - 1);
            this.selectionMightRecurse = false;
        }
        boolean firstSelected = false;
        boolean lastSelected = false;
        boolean bl = anySelected = !model.isSelectionEmpty();
        if (anySelected) {
            i = this.selectedModel.size() - 1;
            if (i >= this.frozenColumns) {
                if (model.isSelectedIndex(this.frozenColumns)) {
                    firstSelected = true;
                }
                if (model.isSelectedIndex(i)) {
                    lastSelected = true;
                }
            }
            this.availableList.clearSelection();
        }
        this.removeButton.setEnabled(anySelected);
        this.upButton.setEnabled(anySelected && !firstSelected);
        this.downButton.setEnabled(anySelected && !lastSelected);
    }

    private void availableSelectionChanged() {
        boolean anySelected;
        boolean bl = anySelected = !this.availableList.isSelectionEmpty();
        if (anySelected) {
            this.selectedList.clearSelection();
        }
        this.addButton.setEnabled(anySelected);
    }

    public void actionPerformed(ActionEvent event) {
        char cmd = event.getActionCommand().charAt(0);
        switch (cmd) {
            case 'A': {
                this.addPressed();
                break;
            }
            case '-': {
                this.removePressed();
                break;
            }
            case 'U': {
                this.upPressed();
                break;
            }
            case 'D': {
                this.downPressed();
                break;
            }
            case 'R': {
                this.reset();
            }
        }
    }

    private void addPressed() {
        List selectedIndices = ReportColumnSelector.enumSelectedIndices(this.availableList);
        this.availableList.clearSelection();
        int selectedPosition = this.selectedModel.size();
        for (Integer index : selectedIndices) {
            Object element = this.availableModel.remove(index);
            this.selectedModel.add(selectedPosition, element);
        }
    }

    private void removePressed() {
        List selectedIndices = ReportColumnSelector.enumSelectedIndices(this.selectedList);
        this.selectedList.clearSelection();
        for (Integer index : selectedIndices) {
            NameList element = (NameList)this.selectedModel.remove(index);
            this.addToAvailable(element);
        }
    }

    private void addToAvailable(NameList element) {
        int last = this.availableModel.size();
        boolean going = true;
        int i = 0;
        while (going && i < last) {
            NameList alreadyThere = (NameList)this.availableModel.get(i);
            if (alreadyThere.nlID2 < element.nlID2) {
                ++i;
                continue;
            }
            going = false;
        }
        this.availableModel.add(i, element);
    }

    private void downPressed() {
        List ranges = ReportColumnSelector.enumSelectedRanges(this.selectedList);
        this.selectedList.clearSelection();
        for (Range range : ranges) {
            Object element = this.selectedModel.remove(range.last + 1);
            this.selectedModel.add(range.first, element);
        }
        ReportColumnSelector.reselect(this.selectedList, ranges, 1);
    }

    private void upPressed() {
        List ranges = ReportColumnSelector.enumSelectedRanges(this.selectedList);
        this.selectedList.clearSelection();
        for (Range range : ranges) {
            Object element = this.selectedModel.remove(range.first - 1);
            this.selectedModel.add(range.last, element);
        }
        ReportColumnSelector.reselect(this.selectedList, ranges, -1);
    }

    private void reset() {
        this.availableList.clearSelection();
        this.selectedList.clearSelection();
        int nAvailable = this.availableModel.size();
        int nSelected = this.selectedModel.size();
        Object[] array = new NameList[nAvailable + nSelected];
        this.selectedModel.copyInto(array);
        while (nAvailable > 0) {
            array[nSelected + --nAvailable] = (NameList)this.availableModel.getElementAt(nAvailable);
        }
        Arrays.sort(array, this);
        this.selectedModel = new DefaultListModel();
        for (nSelected = 0; nSelected < array.length; ++nSelected) {
            this.selectedModel.add(nSelected, array[nSelected]);
        }
        this.selectedList.setModel(this.selectedModel);
        this.availableModel.clear();
    }

    private static void reselect(JList listCtrl, List rangeList, int delta) {
        ListSelectionModel model = listCtrl.getSelectionModel();
        for (Range range : rangeList) {
            model.addSelectionInterval(range.first + delta, range.last + delta);
        }
    }

    private static List enumSelectedRanges(JList listCtrl) {
        Range current = null;
        ListSelectionModel model = listCtrl.getSelectionModel();
        LinkedList<Range> result = new LinkedList<Range>();
        int max = listCtrl.getModel().getSize();
        for (int i = 0; i < max; ++i) {
            if (model.isSelectedIndex(i)) {
                if (current != null) {
                    current.last = i;
                    continue;
                }
                current = new Range(i);
                continue;
            }
            if (current == null) continue;
            result.add(current);
            current = null;
        }
        if (current != null) {
            result.add(current);
        }
        return result;
    }

    private static List enumSelectedIndices(JList listCtrl) {
        ListSelectionModel model = listCtrl.getSelectionModel();
        LinkedList<Integer> result = new LinkedList<Integer>();
        int i = listCtrl.getModel().getSize();
        while (i > 0) {
            if (!model.isSelectedIndex(--i)) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    protected abstract void setSelectedColumns() throws GeneralException;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean isFrozen;
        boolean bl = isFrozen = index < this.frozenColumns;
        if (isFrozen) {
            cellHasFocus = false;
        }
        Component result = this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (isFrozen) {
            result.setEnabled(false);
        }
        return result;
    }

    public void setEnabled(boolean enabled, CustomReportDataAdjuster pAdjuster) {
        this.availableList.setEnabled(enabled);
        this.selectedList.setEnabled(enabled);
        this.refresh(pAdjuster);
    }

    public int compare(Object pLeft, Object pRight) {
        NameList left = (NameList)pLeft;
        NameList right = (NameList)pRight;
        return left.nlID2 - right.nlID2;
    }

    static class Range {
        public int first;
        public int last;

        public Range(int index) {
            this.first = index;
            this.last = index;
        }
    }
}

