/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.gui.JobAlertEditor;
import org.eclipse.aperi.TStorm.gui.ReportOptions;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportSelector;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor {
    public CreateOrEditDDI ddi;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private ReportSelector reportEditor;
    private ReportingSelectionDriver selectionEditor;
    private ReportOptions optionsEditor;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private JobAlertEditor alertEditor;
    public Report report;
    private Object[] objectName = new Object[1];
    private GeneralException exception;
    private int prevReportType = 0;
    private int prevReportSubtype = 0;
    private byte prevDbmsType;
    private int boxReportType = 0;
    private int boxReportSubtype = 0;
    static final int REPORT_TAB = 0;
    static final int SELECTION_TAB = 1;
    static final int OPTIONS_TAB = 2;
    static final int SCHEDULE_TAB = 3;
    static final int ALERT_TAB = 4;
    static final String REPORT_TAB_TITLE = MessageLog.getMessageNoID("STG4153L");
    static final String SELECTION_TAB_TITLE = MessageLog.getMessageNoID("STG5049L");
    static final String OPTIONS_TAB_TITLE = MessageLog.getMessageNoID("STG3175L");
    static final String ALERT_TAB_TITLE = MessageLog.getMessageNoID("STG4036L");
    static final String NO_REPORT_LABEL = MessageLog.getMessageNoID("STG5156L");
    static final String NO_SELECTION_LABEL = MessageLog.getMessageNoID("STG5170L");
    private short devType;

    public ReportCreateOrEdit(CreateOrEditDDI ddi) {
        this.ddi = ddi;
        ddi.showEnabled = true;
        ddi.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        ddi.subType = "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr";
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.report = (Report)createHeader;
        this.create();
    }

    public CreateHeader getData() {
        this.exception = null;
        this.createHeaderPanel.getData();
        if (this.reportEditor.getData() && this.report.batchReport.grr.reportType > 0) {
            if (this.selectionEditor == null || this.report.batchReport.grr.reportType != this.prevReportType || this.report.batchReport.grr.reportSubtype != this.prevReportSubtype || this.report.batchReport.grr.dbmsType != this.prevDbmsType) {
                this.setPrefs(this.report.batchReport.grr);
            } else {
                try {
                    this.selectionEditor.getData();
                }
                catch (GeneralException e) {
                    this.exception = e;
                }
            }
        }
        this.optionsEditor.getData();
        this.scheduleEditor.getData();
        this.report.alert = this.alertEditor.getData();
        this.report.batchReport.spaceUnits = Variables.spaceUnits;
        return this.report;
    }

    private void setPrefs(GuiReportReq grr) {
        ReportPrefs prefs = ReportPrefsManager.getOne(grr.reportType);
        grr.profile = prefs.rpProfileID;
        switch (grr.reportSubtype) {
            case 8: {
                grr.rowsToReturn = prefs.rpDirMaxRows;
                break;
            }
            case 9: {
                grr.rowsToReturn = prefs.rpDirGrpMaxRows;
                break;
            }
            case 10: {
                grr.rowsToReturn = prefs.rpFSMaxRows;
                break;
            }
            case 11: {
                grr.rowsToReturn = prefs.rpFSGrpMaxRows;
                break;
            }
            case 12: {
                grr.rowsToReturn = prefs.rpComputerMaxRows;
                break;
            }
            case 13: 
            case 82: {
                grr.rowsToReturn = prefs.rpCompGrpMaxRows;
                break;
            }
            case 14: {
                grr.rowsToReturn = prefs.rpDomMaxRows;
                break;
            }
            case 15: {
                grr.rowsToReturn = prefs.rpNetMaxRows;
                break;
            }
            case 16: {
                grr.rowsToReturn = prefs.rpQuotaMaxRows;
            }
        }
        this.clearGrrSelectionData(grr);
    }

    public void clearGrrSelectionData(GuiReportReq grr) {
        grr.selectedResources = null;
        grr.selectedUsers = null;
        grr.selectedColumns = null;
        grr.columnFilters = null;
        grr.filtersIgnoreCase = false;
        grr.orFilters = false;
    }

    public void validate(CreateHeader newHeader) throws GeneralException {
        Report report = (Report)newHeader;
        if (report.batchReport.grr.reportType == 0) {
            this.ddi.exceptionTabIndex = 0;
            throw new GeneralException(MessageLog.getMessageNoTS("STG5156L"));
        }
        if (this.exception != null) {
            this.ddi.exceptionTabIndex = 1;
            throw this.exception;
        }
        this.ddi.exceptionTabIndex = 2;
        if (report.batchReport.grr.reportType != this.boxReportType || report.batchReport.grr.reportSubtype != this.boxReportSubtype) {
            this.optionsEditor.validateData(true);
            report.batchReport.saveChartSettingsReq = null;
        } else {
            this.optionsEditor.validateData(false);
        }
        this.ddi.exceptionTabIndex = 3;
        this.scheduleEditor.validate(report);
        this.ddi.exceptionTabIndex = 4;
        this.alertEditor.validateData();
    }

    private void submitRetrieve(int ID2) {
        Report report = new Report(this.ddi.nlInfo);
        report.ID = ID2;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr", report);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        this.report = new Report(this.ddi.nlInfo);
        this.report.batchReport = new BatchReport();
        this.report.batchReport.grr = new GuiReportReq();
        this.create();
    }

    public void setOldCreateHeader() {
        this.ddi.oldCreateHeader = (Report)this.report.clone();
    }

    private void create() {
        this.createHeaderPanel = new CreateHeaderPanel(this.report, this, this.ddi);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        this.reportEditor = new ReportSelector(this.report.batchReport.grr, this.ddi.nlInfo);
        JPanel reportPanel = this.reportEditor.build();
        this.tabs.addTab(REPORT_TAB_TITLE, reportPanel);
        if (this.reportEditor.getData() && this.report.batchReport.grr.reportType > 0) {
            this.setObjectType();
            this.selectionEditor = new ReportingSelectionDriver(null, this.report.batchReport.grr, ReportingTreeLabel.selectionServiceArray[this.report.batchReport.grr.reportType], this.objectName);
            this.tabs.addTab(SELECTION_TAB_TITLE, this.selectionEditor);
            this.prevReportType = this.report.batchReport.grr.reportType;
            this.prevReportSubtype = this.report.batchReport.grr.reportSubtype;
            this.prevDbmsType = this.report.batchReport.grr.dbmsType;
        } else {
            this.selectionEditor = null;
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = this.report.batchReport.grr.reportType > 0 ? new JLabel(NO_SELECTION_LABEL) : new JLabel(NO_REPORT_LABEL);
            panel.add((Component)label, "Center");
            this.tabs.addTab(SELECTION_TAB_TITLE, panel);
            this.prevReportType = 0;
            this.prevReportSubtype = 0;
            this.prevDbmsType = 0;
        }
        this.optionsEditor = new ReportOptions(this.report, this);
        this.tabs.addTab(OPTIONS_TAB_TITLE, this.optionsEditor);
        this.boxReportType = 0;
        this.boxReportSubtype = 0;
        if (this.report.batchReport.grr.reportType == 0) {
            this.optionsEditor.disableHistory();
        } else {
            this.setHistoryBox(true);
        }
        this.scheduleEditor = new JSgcScheduleCreateWhenData(this.ddi.nlInfo, this.ddi);
        JPanel whenPanel = this.scheduleEditor.build(this.report);
        String s = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(s, whenPanel);
        short alertType = 10;
        this.alertEditor = this.report.alert == null ? new JobAlertEditor(alertType) : new JobAlertEditor(alertType, this.report.alert);
        this.tabs.addTab(ALERT_TAB_TITLE, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.ddi.tabIndex);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        this.ddi.panel = this.createHeaderPanel;
        this.ddi.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader newHeader) {
        Report newReport = (Report)newHeader;
        newReport.batchReport.grr = this.report.batchReport.grr;
        this.report = newReport;
        this.createHeaderPanel.replace(this.report);
        this.optionsEditor.replace(this.report);
        this.scheduleEditor.replace(this.report);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
        this.tabs.setSelectedIndex(tabIndex);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            Serializable data = response.responseData;
            if (data instanceof GuiChartSettingsReq) {
                return;
            }
            this.report = (Report)response.responseData;
            this.ddi.oldCreateHeader = (Report)this.report.clone();
            this.create();
        }
    }

    public void stateChanged(ChangeEvent event) {
        this.ddi.tabIndex = this.tabs.getSelectedIndex();
        if (this.ddi.tabIndex == 1) {
            boolean needSelections = this.reportEditor.getData();
            if (this.report.batchReport.grr.reportType != this.prevReportType || this.report.batchReport.grr.reportSubtype != this.prevReportSubtype || this.report.batchReport.grr.dbmsType != this.prevDbmsType) {
                this.tabs.removeTabAt(1);
                this.report.batchReport.grr.profile = 0;
                this.report.batchReport.grr.rowsToReturn = 0;
                this.clearGrrSelectionData(this.report.batchReport.grr);
                if (needSelections && this.report.batchReport.grr.reportType > 0) {
                    this.setObjectType();
                    this.selectionEditor = new ReportingSelectionDriver(null, this.report.batchReport.grr, ReportingTreeLabel.selectionServiceArray[this.report.batchReport.grr.reportType], this.objectName);
                    this.tabs.insertTab(SELECTION_TAB_TITLE, null, this.selectionEditor, null, 1);
                    this.prevReportType = this.report.batchReport.grr.reportType;
                    this.prevReportSubtype = this.report.batchReport.grr.reportSubtype;
                    this.prevDbmsType = this.report.batchReport.grr.dbmsType;
                } else {
                    this.selectionEditor = null;
                    JPanel panel = new JPanel(new BorderLayout());
                    JLabel label = this.report.batchReport.grr.reportType > 0 ? new JLabel(NO_SELECTION_LABEL) : new JLabel(NO_REPORT_LABEL);
                    panel.add((Component)label, "Center");
                    this.tabs.insertTab(SELECTION_TAB_TITLE, null, panel, null, 1);
                    this.prevReportType = 0;
                    this.prevReportSubtype = 0;
                    this.prevDbmsType = 0;
                }
            }
        } else if (this.ddi.tabIndex == 2) {
            this.report.batchReport.grr.histSubtype = 0;
            this.setHistoryBox(false);
        }
    }

    private void setHistoryBox(boolean setBoxIndex) {
        this.reportEditor.getData();
        GuiReportReq grr = this.report.batchReport.grr;
        if (grr.reportType != this.boxReportType || grr.reportSubtype != this.boxReportSubtype) {
            this.report.batchReport.saveChartSettingsReq = null;
            this.boxReportType = grr.reportType;
            this.boxReportSubtype = grr.reportSubtype;
            if (this.boxReportType == 0) {
                this.optionsEditor.disableHistory();
            } else {
                Class<?> tableClass = null;
                try {
                    tableClass = Class.forName(GuiReportReq.guiClasses[this.boxReportType][0]);
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                    return;
                }
                boolean hasHistory = false;
                Class<?>[] interfaces = tableClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    String name = interfaces[i].getName();
                    if (!name.equals("org.eclipse.aperi.gui.HistoryChoiceInterface")) continue;
                    hasHistory = true;
                    break;
                }
                if (!hasHistory) {
                    this.optionsEditor.disableHistory();
                } else {
                    HistoryChoiceInterface table = null;
                    try {
                        Class[] argdef = new Class[]{String.class, String.class, String.class, String.class};
                        Constructor<?> constr = tableClass.getConstructor(argdef);
                        Object[] args = new Object[]{"x", "x", "x", "x"};
                        table = (HistoryChoiceInterface)constr.newInstance(args);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        e.printStackTrace();
                        return;
                    }
                    Object[] histArray = table.getChoices(this.boxReportType, this.boxReportSubtype);
                    Object[] chartArray = table.getCharts(this.boxReportType, this.boxReportSubtype);
                    if (histArray == null && chartArray == null) {
                        this.optionsEditor.disableHistory();
                    } else {
                        String[] messageArray = null;
                        byte[] labelArray = null;
                        byte[] subtypeArray = null;
                        String[] rangeMsgArray = null;
                        byte[] rangeArray = null;
                        String[] chartMsgArray = null;
                        byte[] chartTypeArray = null;
                        if (histArray != null) {
                            messageArray = (String[])histArray[0];
                            labelArray = (byte[])histArray[1];
                            subtypeArray = (byte[])histArray[2];
                            if (histArray.length > 3) {
                                rangeMsgArray = (String[])histArray[3];
                                rangeArray = (byte[])histArray[4];
                            }
                            for (int j = 0; j < messageArray.length; ++j) {
                                messageArray[j] = ReportCreateOrEdit.adjustHistoryName(messageArray[j]);
                            }
                            if (rangeMsgArray != null) {
                                for (int k = 0; k < rangeMsgArray.length; ++k) {
                                    rangeMsgArray[k] = MessageLog.getMessageNoID(rangeMsgArray[k]);
                                }
                            }
                        }
                        if (chartArray != null) {
                            chartMsgArray = (String[])chartArray[0];
                            chartTypeArray = (byte[])chartArray[1];
                            for (int m = 0; m < chartMsgArray.length; ++m) {
                                chartMsgArray[m] = ReportCreateOrEdit.adjustHistoryName(chartMsgArray[m]);
                            }
                        }
                        this.optionsEditor.replaceHistoryArrays(messageArray, labelArray, subtypeArray, rangeMsgArray, rangeArray, setBoxIndex, chartMsgArray, chartTypeArray);
                    }
                }
            }
        }
    }

    public static String adjustHistoryName(String messageID) {
        String message = messageID;
        if (messageID.length() == 8) {
            message = MessageLog.getMessageNoID(messageID);
        }
        return message;
    }

    private void setObjectType() {
        switch (this.report.batchReport.grr.reportSubtype) {
            case 8: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3143L");
                break;
            }
            case 9: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3116T");
                break;
            }
            case 10: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3135T");
                break;
            }
            case 11: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3124T");
                break;
            }
            case 12: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3125T");
                break;
            }
            case 14: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2038L");
                break;
            }
            case 27: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                break;
            }
            case 16: {
                this.objectName[0] = MessageLog.getMessageNoID("STG0022T");
                break;
            }
            case 6: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3122T");
                break;
            }
            case 74: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                break;
            }
            case 75: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4202L");
                break;
            }
            case 76: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                break;
            }
            case 73: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4203L");
                break;
            }
            default: {
                this.objectName[0] = MessageLog.getMessageNoID("STG5057L");
            }
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "mr20";
            }
            case 1: {
                return "mr25";
            }
            case 2: {
                return "mr30";
            }
            case 3: {
                return "mr35";
            }
            case 4: {
                return "mr40";
            }
        }
        return null;
    }

    public boolean isChartCustPending() {
        return this.report.batchReport.saveChartSettingsReq != null;
    }

    public void saveChartCust(int batchId) {
        ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).batchId = batchId;
        Request req = this.report.batchReport.saveChartSettingsReq;
        this.report.batchReport.saveChartSettingsReq = null;
        GuiClient.doRequest(this, req);
    }
}

