/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class TJCPartitionedTableData
extends BaseTableModel
implements ActionListener {
    protected PartitionedReport partition;
    protected MegaTable table;
    private JPanel tablePanel;
    private GuiRequestor requestor;
    private LinkedList sortList;
    private boolean ignoreSort;
    private JButton moreButton;

    public TJCPartitionedTableData(PartitionedReport partition, MegaTable table, JPanel tablePanel, GuiRequestor requestor) {
        this.partition = partition;
        this.table = table;
        this.tablePanel = tablePanel;
        this.requestor = requestor;
        if (!partition.prLastPart) {
            this.sortList = new LinkedList();
            if (tablePanel != null) {
                JPanel p = new JPanel();
                this.moreButton = new JButton(MessageLog.getMessageNoID("STG4159L"));
                GuiUtil.setAccessible(this.moreButton, this.moreButton.getText(), this.moreButton.getText());
                p.add(this.moreButton);
                tablePanel.add((Component)p, "North");
                this.moreButton.addActionListener(this);
            }
        }
    }

    public void appendRows(Object newArray, Object currArray, PartitionedReport partition, ReportDataAdjuster adjuster) {
        int sortCount;
        this.partition = partition;
        if (partition.prLastPart) {
            this.moreButton.setEnabled(false);
        }
        Serializable appendArray = partition.prData;
        int currLength = Array.getLength(currArray);
        int appendLength = Array.getLength(appendArray);
        this.rowCount += appendLength;
        System.arraycopy(currArray, 0, newArray, 0, currLength);
        System.arraycopy(appendArray, 0, newArray, currLength, appendLength);
        adjuster.replaceArray(newArray);
        this.fireTableDataChanged();
        if (this.sortList != null && (sortCount = this.sortList.size()) > 0) {
            int[] colArray = new int[sortCount];
            int[] dirArray = new int[sortCount];
            sortCount = 0;
            ListIterator i = this.sortList.listIterator(0);
            while (i.hasNext()) {
                SortCol sort = (SortCol)i.next();
                colArray[sortCount] = sort.column;
                dirArray[sortCount++] = sort.direction;
            }
            this.ignoreSort = true;
        }
    }

    private Object extendArray(Object array, int newLength) {
        int currLength = Array.getLength(array);
        Object element = Array.get(array, 0);
        Object newArray = Array.newInstance(element.getClass(), newLength);
        System.arraycopy(array, 0, newArray, 0, currLength);
        return newArray;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.moreButton) {
            PartitionedReport clone = (PartitionedReport)this.partition.clone();
            clone.prPartition = (short)(clone.prPartition + 1);
            clone.prData = null;
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
            request.requestData = clone;
            GuiClient.doRequest(this.requestor, request);
        }
    }

    private class SortCol {
        int column;
        int direction;

        SortCol(int column, int direction) {
            this.column = column;
            this.direction = direction;
            ListIterator i = TJCPartitionedTableData.this.sortList.listIterator(0);
            while (i.hasNext()) {
                SortCol col = (SortCol)i.next();
                if (col.column != column) continue;
                i.remove();
            }
            TJCPartitionedTableData.this.sortList.addFirst(this);
            if (TJCPartitionedTableData.this.sortList.size() > 4) {
                TJCPartitionedTableData.this.sortList.removeLast();
            }
        }
    }
}

