/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class TapeLibraryGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private static boolean test = false;
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList tapeLibrarySelections;
    private NameList zoneSelections;
    private NameList zoneSetsSelections;
    public boolean allTapeLibrarySelected;
    public boolean allZonesSelected;
    public boolean allZoneSetsSelected;
    private NameList rootName;
    private TreeSet tapeLibraryIncludeSet = new TreeSet();
    private TreeSet tapeLibraryExcludeSet = new TreeSet();
    private TreeSet zoneIncludeSet = new TreeSet();
    private TreeSet zoneExcludeSet = new TreeSet();
    private TreeSet zoneSetIncludeSet = new TreeSet();
    private TreeSet zoneSetExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceTapeLibraryZoneLabel;
    private TreeSelectorNode sourceTapeLibraryZoneSetLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean zoneExpanding;
    private boolean zonesetExpanding;
    private static final int ROOT_ID = -5;
    private static final int TAPE_LIBRARY_ID = -4;
    private static final int ZONE_ID = -3;
    private static final int ZONESET_ID = -2;
    private static final int ALL_TAPE_LIBRARY_ID = Integer.MAX_VALUE;
    private static final int ALL_ZONE_ID = 0x7FFFFFFE;
    private static final int ALL_ZONESET_ID = 0x7FFFFFFD;
    public static final int TAPE_LIBRARY_IX = 7;
    public static final int ZONE_IX = 1;
    public static final int ZONESET_IX = 2;
    private static final String TAPE_LIBRARY_LABEL = Util.getString("TapeLibraryAlert_TapeLibraryTabTitle");
    private static final String ZONE_LABEL = Util.getString("FabricAlert_FabricZoneLabel");
    private static final String ZONESET_LABEL = Util.getString("TapeLibraryAlert_TapeLibraryZoneSetLabel");
    private static final String ALL_TAPE_LIBRARY_LABEL = Util.getString("TapeLibraryAlert_AllTapeLibraryLabel");
    private static final String ALL_ZONE_LABEL = Util.getString("TapeLibraryAlert_AllZoneLabel");
    private static final String ALL_ZONESET_LABEL = Util.getString("TapeLibraryAlert_AllZoneSetLabel");

    public TapeLibraryGroupSelector(NameList pTapeLibrarySelections, NameList pZoneSelections, NameList pZoneSetsSelections, boolean pAllTapeLibrarySelected, boolean pAllZonesSelected, boolean pAllZoneSetsSelected) {
        this.tapeLibrarySelections = pTapeLibrarySelections;
        this.zoneSelections = pZoneSelections;
        this.zoneSetsSelections = pZoneSetsSelections;
        this.allTapeLibrarySelected = pAllTapeLibrarySelected;
        this.allZonesSelected = pAllZonesSelected;
        this.allZoneSetsSelected = pAllZoneSetsSelected;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] listHead = new NameList[5];
        NameList[] listTail = new NameList[5];
        NameList element = null;
        this.allTapeLibrarySelected = false;
        this.allZonesSelected = false;
        this.allZoneSetsSelected = false;
        NameList selList = this.selector.getNameList();
        while (selList != null) {
            int ix = -999;
            if (selList.nlInfo == 134) {
                ix = 7;
            } else if (selList.nlInfo == 135) {
                this.allTapeLibrarySelected = true;
            }
            if (ix < 0) {
                selList = selList.nlNext;
                continue;
            }
            element = selList;
            selList = element.nlNext;
            element.nlNext = null;
            if (listTail[ix] == null) {
                listHead[ix] = element;
            } else {
                listTail[ix].nlNext = element;
            }
            listTail[ix] = element;
        }
        return listHead;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.addLabelNode(TAPE_LIBRARY_LABEL, -4, root);
        this.sourceTapeLibraryZoneLabel = this.addLabelNode(ZONE_LABEL, -3, root);
        this.sourceTapeLibraryZoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, root);
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode tapeLibraryLabel = null;
        TreeSelectorNode tapeLibraryExcludeLabel = null;
        TreeSelectorNode zoneLabel = null;
        Object zoneExcludeLabel = null;
        TreeSelectorNode zoneSetLabel = null;
        Object zoneSetExcludeLabel = null;
        TreeSelectorNode root = this.newRoot();
        this.fillSets(this.tapeLibrarySelections, this.tapeLibraryIncludeSet, this.tapeLibraryExcludeSet, true, false);
        if (this.allTapeLibrarySelected || !this.tapeLibraryIncludeSet.isEmpty()) {
            tapeLibraryLabel = this.addLabelNode(TAPE_LIBRARY_LABEL, -4, root);
            if (this.allTapeLibrarySelected) {
                this.addAllMembersNode(ALL_TAPE_LIBRARY_LABEL, Integer.MAX_VALUE, 135, tapeLibraryLabel, true);
            }
            this.addTreeSet(tapeLibraryLabel, this.tapeLibraryIncludeSet);
        }
        if (!this.tapeLibraryExcludeSet.isEmpty()) {
            tapeLibraryExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(tapeLibraryExcludeLabel);
            this.addTreeSet(tapeLibraryExcludeLabel, this.tapeLibraryExcludeSet);
        }
        if (this.allZonesSelected) {
            zoneLabel = this.addLabelNode(ZONE_LABEL, -3, root);
            if (this.allZonesSelected) {
                this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 13, zoneLabel, true);
            }
            this.addTreeSet(zoneLabel, this.zoneIncludeSet);
        }
        NameList name = this.zoneSelections;
        while (name != null) {
            if (zoneLabel == null) {
                zoneLabel = this.addLabelNode(ZONE_LABEL, -3, root);
            }
            zoneLabel.add(new TreeSelectorNode(name, true, false, true, true, null, true, true));
            name = name.nlNext;
        }
        if (this.allZonesSelected || !this.zoneIncludeSet.isEmpty()) {
            zoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, root);
            if (this.allZonesSelected) {
                this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFE, 13, zoneSetLabel, true);
            }
        }
        name = this.zoneSetsSelections;
        while (name != null) {
            if (zoneSetLabel == null) {
                zoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, root);
            }
            zoneSetLabel.add(new TreeSelectorNode(name, true, false, true, true, null, false, true));
            name = name.nlNext;
        }
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList ptapeLibrarySelections, NameList pzoneSelections, NameList pzoneSetsSelections, boolean pallTapeLibrarySelected, boolean pallZonesSelected, boolean pallZoneSetsSelected) {
        this.tapeLibrarySelections = ptapeLibrarySelections;
        this.zoneSelections = pzoneSelections;
        this.zoneSetsSelections = pzoneSetsSelections;
        this.allTapeLibrarySelected = pallTapeLibrarySelected;
        this.allZonesSelected = pallZonesSelected;
        this.allZoneSetsSelected = pallZoneSetsSelected;
        this.tapeLibraryIncludeSet.clear();
        this.tapeLibraryExcludeSet.clear();
        this.zoneIncludeSet.clear();
        this.zoneExcludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, TreeSet includeSet, TreeSet excludeSet, boolean memberSelectable, boolean memberExcludeable) {
        boolean showClusterName = true;
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if (Constants.isVirtualServer(memberList.nlID2)) {
                memberList = memberList.nlNext;
                continue;
            }
            if ((memberList.nlState & 1) != 0) {
                set = excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = includeSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            if (this.zoneExpanding) {
                showClusterName = false;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, showClusterName, true);
            if (this.zoneExpanding || this.zonesetExpanding) {
                member.setButtonFlag(false);
            }
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        TreeSelectorNode sourceGroupLabel;
        if (name.nlID == -3) {
            sourceGroupLabel = this.sourceTapeLibraryZoneLabel;
        } else if (name.nlID == -2) {
            sourceGroupLabel = this.sourceTapeLibraryZoneSetLabel;
        } else {
            return;
        }
        if (!sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        this.zoneExpanding = false;
        this.zonesetExpanding = false;
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -3) {
                this.sendRequest((short)0, -1);
            } else if (name.nlID == -4) {
                this.sendRequest((short)134, -1);
            } else if (name.nlID == -2) {
                this.sendRequest((short)77, -1);
            }
        } else if (name.nlInfo == 134) {
            this.sendRequest((short)134, name.nlID);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeListRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        if (resourceType == 99) {
            requestData.listRequested = 11;
        } else {
            if (resourceType == 101) {
                resourceType = (short)99;
            }
            requestData.listRequested = 10000 + resourceType;
            requestData.groupID = groupID;
        }
        return requestData;
    }

    protected GroupDefinition makeGroupRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        Request request;
        if (resourceType == 99) {
            GroupDefinition lData = this.makeGroupRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", lData);
        } else {
            GuiListReq gData = this.makeListRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", gData);
        }
        GuiClient.doRequest(this, request);
    }

    private NameList makeFakeData() {
        NameList nameList = null;
        NameList name = this.expansionNode.getNameList();
        if (name.nlID == -4) {
            NameList item = new NameList();
            item.nlName = "tapeLibrary1";
            item.nlInfo = (short)134;
            item.nlNext = nameList;
            nameList = item;
            item = new NameList();
            item.nlName = "tapeLibrary2";
            item.nlInfo = (short)134;
            item.nlNext = nameList;
            nameList = item;
        }
        return nameList;
    }

    public void handleResponse(short status, Response response) {
        boolean exclude;
        NameList nameList = null;
        if (test) {
            nameList = this.makeFakeData();
        } else {
            if (status > 4) {
                return;
            }
            boolean showClusterName = true;
            Serializable obj = response.responseData;
            if (obj instanceof GroupDefinition) {
                GroupDefinition gdef = (GroupDefinition)response.responseData;
                nameList = gdef.members;
            } else {
                nameList = (NameList)response.responseData;
            }
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        boolean select = this.expansionTree == this.sourceTree;
        boolean bl = exclude = !select;
        if (nameList.nlInfo == 134) {
            if (select) {
                this.addAllMembersNode(ALL_TAPE_LIBRARY_LABEL, Integer.MAX_VALUE, 135, this.expansionNode, false);
            }
            this.tapeLibraryIncludeSet.clear();
            this.fillSets(nameList, this.tapeLibraryIncludeSet, this.tapeLibraryExcludeSet, select, exclude);
            this.addTreeSet(this.expansionNode, this.tapeLibraryIncludeSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String label, int id, TreeSelectorNode root) {
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(String label, int id, int resourceID, TreeSelectorNode root, boolean expandable) {
        NameList name = this.newNameList(label, id, resourceID);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }
}

