/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupData
implements ReportingObjectBuilder {
    public static final int GROUP_SEPARATION = 12;
    private boolean isLodestoneCluster = false;
    private boolean isFAStT = false;
    private boolean isDiskArray = false;

    public Component build(Object object) {
        RespVolGroup vg = (RespVolGroup)object;
        if (vg.rvgComputerOsType == 21) {
            this.isLodestoneCluster = true;
        }
        if (vg.rvgComputerOsType == 15) {
            this.isFAStT = true;
        }
        if (Constants.isDiskArray(vg.rvgComputerOsType)) {
            this.isDiskArray = true;
        }
        JPanel panel = GuiUtil.getPanel();
        String msgID = vg.vgType == 2 || vg.vgType == 4 || vg.vgType == 5 ? "SAG0060I" : (vg.vgType == 3 || vg.vgType == 6 ? (this.isLodestoneCluster ? "SAG0063I" : "SAG0062I") : (vg.vgType == 1 ? "SAG0061I" : "STG6210L"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets.left = 40;
        c.insets.top = 30;
        c.insets.bottom = 20;
        VolGroupData.addItem(panel, c, msgID, vg.vgName);
        c.insets.top = 0;
        if (vg.vgType == 2 || vg.vgType == 4 || vg.vgType == 5 || vg.vgType == 3 || vg.vgType == 6) {
            String unsurfacedLunCap;
            String surfacedLunCap;
            c.insets.bottom = 12;
            msgID = this.isLodestoneCluster ? "STG4500L" : "SAG0001L";
            VolGroupData.addItem(panel, c, msgID, vg.rvgComputerName);
            c.insets.bottom = 0;
            if (vg.vgType == 2 || vg.vgType == 4 || vg.vgType == 5) {
                if (vg.vgType == 4 || vg.vgType == 5) {
                    VolGroupData.addItem(panel, c, "SAG0093L", vg.getArraySitesforDisplay());
                    VolGroupData.addItem(panel, c, "SAG0101L", vg.vgRank);
                    VolGroupData.addItem(panel, c, "SAG0099L", vg.getConfigsforDisplay());
                } else {
                    VolGroupData.addItem(panel, c, "SAG0027L", vg.vgDiskGroup);
                    VolGroupData.addItem(panel, c, "STG6105L", vg.vgLSS);
                    VolGroupData.addItem(panel, c, "STG1132L", vg.getConfig());
                }
                VolGroupData.addItem(panel, c, "SAG0038L", vg.getTrackFormat());
            } else if (vg.vgType == 6) {
                VolGroupData.addItem(panel, c, "SAG0099L", vg.getConfigsforDisplay());
            }
            if (this.isFAStT) {
                VolGroupData.addItem(panel, c, "STG1132L", vg.getConfig());
            }
            c.insets.bottom = 12;
            String Status2 = null;
            Status2 = this.isDiskArray ? vg.getOperationalStatus(vg.vgOperationalStatus) : vg.getStatus();
            VolGroupData.addItem(panel, c, "SAG0042L", Status2);
            if (this.isLodestoneCluster) {
                c.insets.bottom = 12;
                VolGroupData.addItem(panel, c, "SAG0064L", Util.formatPrefBytes(vg.vgExtentSize * 1024 * 1024));
                String totalSpace = Util.formatPrefBytes(vg.vgTotalSpace * 512L);
                String freeSpace = Util.formatPrefBytes(vg.vgFreeSpace * 512L);
                surfacedLunCap = Util.formatPrefBytes(vg.vgSurfacedLunCap * 512L);
                unsurfacedLunCap = Util.formatPrefBytes(vg.vgUnSurfacedLunCap * 512L);
                c.insets.bottom = 0;
                VolGroupData.addItem(panel, c, "SAG0073L", totalSpace);
                c.insets.bottom = 12;
                VolGroupData.addItem(panel, c, "SAG0074L", freeSpace);
            } else {
                String totalSpace = Util.formatPrefBytes(vg.vgTotalSpace << 9);
                String freeSpace = Util.formatPrefBytes(vg.vgFreeSpace << 9);
                surfacedLunCap = Util.formatPrefBytes(vg.vgSurfacedLunCap << 9);
                unsurfacedLunCap = Util.formatPrefBytes(vg.vgUnSurfacedLunCap << 9);
                c.insets.bottom = 0;
                VolGroupData.addItem(panel, c, "SAG0037L", totalSpace);
                c.insets.bottom = 12;
                VolGroupData.addItem(panel, c, "SAG0041L", freeSpace);
            }
            c.insets.bottom = 0;
            VolGroupData.addItem(panel, c, "SAG0008L", Integer.toString(vg.vgDisks));
            VolGroupData.addItem(panel, c, "SAG0009L", Integer.toString(vg.vgVolumes));
            VolGroupData.addItem(panel, c, "SAG0039L", surfacedLunCap);
            VolGroupData.addItem(panel, c, "SAG0040L", unsurfacedLunCap);
            if (vg.vgType == 4 || vg.vgType == 5) {
                long extOverhead = vg.vgTotalSpace - vg.vgFreeSpace - vg.vgSurfacedLunCap - vg.vgUnSurfacedLunCap;
                String lunExtentOverhead = Util.formatPrefBytes(extOverhead << 9);
                VolGroupData.addItem(panel, c, "SAG0102L", lunExtentOverhead);
            }
        } else {
            c.insets.bottom = 12;
            VolGroupData.addItem(panel, c, "STG1102L", vg.rvgComputerName);
            VolGroupData.addItem(panel, c, "STG1132L", vg.getType());
            c.insets.bottom = 0;
            String s = Integer.toString(vg.vgDisks);
            VolGroupData.addItem(panel, c, "STG6057L", s);
            c.insets.bottom = 12;
            s = Integer.toString(vg.vgVolumes);
            VolGroupData.addItem(panel, c, "STG6202L", s);
            c.insets.bottom = 0;
            s = Util.formatPrefBytes(vg.vgTotalSpace << 9);
            VolGroupData.addItem(panel, c, "STG1162L", s);
            c.insets.bottom = 12;
            s = Util.formatPrefBytes(vg.vgFreeSpace << 9);
            VolGroupData.addItem(panel, c, "STG1184L", s);
            c.insets.bottom = 0;
            s = DateFormat.getDateTimeInstance().format(new Date(vg.vgDiscoveredTime));
            VolGroupData.addItem(panel, c, "STG1134L", s);
            s = DateFormat.getDateTimeInstance().format(new Date(vg.vgProbeTime));
            VolGroupData.addItem(panel, c, "STG1119L", s);
        }
        GuiUtil.completePanel(panel);
        return panel;
    }

    public static void addItem(Container panel, GridBagConstraints c, String msgID, String value) {
        String s = MessageLog.getMessageNoID(msgID);
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        c.gridwidth = 1;
        panel.add((Component)label, c);
        label = new JLabel(value);
        label.setFont(BaseTree.plainFont);
        label.setForeground(Color.black);
        c.gridwidth = 0;
        int leftMargin = c.insets.left;
        c.insets.left = 24;
        panel.add((Component)label, c);
        c.insets.left = leftMargin;
    }
}

