/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeGroupData
implements GuiRequestor {
    public static final int GROUP_SEPARATION = 12;
    private boolean isLodestoneCluster = false;
    private boolean isFAStT = false;
    private boolean isDiskArray = false;
    private boolean isHPSW = false;
    private NameList volgroup;
    private NameList computer;
    private JPanel panel;

    public static void addItem(Container panel, GridBagConstraints c, String msgID, String value) {
        String s = MessageLog.getMessageNoID(msgID);
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        label.setForeground(Color.black);
        c.gridwidth = 1;
        panel.add((Component)label, c);
        label = new JLabel(value);
        label.setFont(BaseTree.plainFont);
        label.setForeground(Color.black);
        c.gridwidth = 0;
        int leftMargin = c.insets.left;
        c.insets.left = 24;
        panel.add((Component)label, c);
        c.insets.left = leftMargin;
    }

    public VolumeGroupData(NameList pVolgroup, NameList pComputer) {
        this.volgroup = pVolgroup;
        this.computer = pComputer;
        this.panel = null;
        if (this.computer.nlID2 == 21) {
            this.isLodestoneCluster = true;
        }
        if (this.computer.nlID2 == 15) {
            this.isFAStT = true;
        }
        if (this.computer.nlID2 == 18) {
            this.isHPSW = true;
        }
        if (Constants.isDiskArray((short)this.computer.nlID2)) {
            this.isDiskArray = true;
        }
    }

    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        Request request = GuiRequest.makeVolumeGroupInfoRequest(this.volgroup.nlID, this.volgroup.nlID2);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        VolGroup vg = (VolGroup)response.responseData;
        if (vg == null) {
            return;
        }
        String msgID = vg.vgType == 2 || vg.vgType == 4 || vg.vgType == 5 ? "SAG0060I" : (vg.vgType == 3 || vg.vgType == 6 ? (this.isLodestoneCluster ? "SAG0063I" : "SAG0062I") : (vg.vgType == 1 ? "SAG0061I" : "STG6210L"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets.left = 40;
        c.insets.top = 30;
        c.insets.bottom = 20;
        VolumeGroupData.addItem(this.panel, c, msgID, vg.vgName);
        c.insets.top = 0;
        if (vg.vgType == 2 || vg.vgType == 4 || vg.vgType == 5 || vg.vgType == 3 && this.computer.nlID2 != 8 || vg.vgType == 6 && this.computer.nlID2 != 8) {
            String unsurfacedLunCap;
            String surfacedLunCap;
            c.insets.bottom = 12;
            msgID = this.isLodestoneCluster ? "STG4500L" : "SAG0001L";
            VolumeGroupData.addItem(this.panel, c, msgID, this.computer.nlName);
            c.insets.bottom = 0;
            if (vg.vgType == 2) {
                VolumeGroupData.addItem(this.panel, c, "SAG0027L", vg.vgDiskGroup);
                VolumeGroupData.addItem(this.panel, c, "STG6105L", vg.vgLSS);
                VolumeGroupData.addItem(this.panel, c, "STG1132L", vg.getConfig());
                VolumeGroupData.addItem(this.panel, c, "SAG0038L", vg.getTrackFormat());
            }
            if (vg.vgType == 4 || vg.vgType == 5) {
                VolumeGroupData.addItem(this.panel, c, "SAG0093L", vg.getArraySitesforDisplay());
                VolumeGroupData.addItem(this.panel, c, "SAG0101L", vg.vgRank);
                VolumeGroupData.addItem(this.panel, c, "SAG0099L", vg.getConfigsforDisplay());
                VolumeGroupData.addItem(this.panel, c, "SAG0038L", vg.getTrackFormat());
            }
            if (vg.vgType == 6) {
                VolumeGroupData.addItem(this.panel, c, "SAG0099L", vg.getConfigsforDisplay());
            }
            if (this.isFAStT || this.isHPSW) {
                VolumeGroupData.addItem(this.panel, c, "STG1132L", vg.getConfig());
            }
            c.insets.bottom = 12;
            String Status2 = null;
            Status2 = this.isDiskArray ? vg.getOperationalStatus(vg.vgOperationalStatus) : vg.getStatus();
            VolumeGroupData.addItem(this.panel, c, "SAG0042L", Status2);
            if (this.isLodestoneCluster) {
                c.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, c, "SAG0064L", Util.formatPrefBytes(vg.vgExtentSize * 1024 * 1024));
                String totalSpace = Util.formatPrefBytes(vg.vgTotalSpace * 512L);
                String freeSpace = Util.formatPrefBytes(vg.vgFreeSpace * 512L);
                surfacedLunCap = Util.formatPrefBytes(vg.vgSurfacedLunCap * 512L);
                unsurfacedLunCap = Util.formatPrefBytes(vg.vgUnSurfacedLunCap * 512L);
                c.insets.bottom = 0;
                VolumeGroupData.addItem(this.panel, c, "SAG0073L", totalSpace);
                c.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, c, "SAG0074L", freeSpace);
            } else {
                String totalSpace = Util.formatPrefBytes(vg.vgTotalSpace << 9);
                String freeSpace = Util.formatPrefBytes(vg.vgFreeSpace << 9);
                surfacedLunCap = Util.formatPrefBytes(vg.vgSurfacedLunCap << 9);
                unsurfacedLunCap = Util.formatPrefBytes(vg.vgUnSurfacedLunCap << 9);
                c.insets.bottom = 0;
                VolumeGroupData.addItem(this.panel, c, "SAG0037L", totalSpace);
                c.insets.bottom = 12;
                VolumeGroupData.addItem(this.panel, c, "SAG0041L", freeSpace);
            }
            c.insets.bottom = 0;
            VolumeGroupData.addItem(this.panel, c, "SAG0008L", Integer.toString(vg.vgDisks));
            VolumeGroupData.addItem(this.panel, c, "SAG0009L", Integer.toString(vg.vgVolumes));
            VolumeGroupData.addItem(this.panel, c, "SAG0039L", surfacedLunCap);
            VolumeGroupData.addItem(this.panel, c, "SAG0040L", unsurfacedLunCap);
            if (vg.vgType == 4 || vg.vgType == 5) {
                long extOverhead = vg.vgTotalSpace - vg.vgFreeSpace - vg.vgSurfacedLunCap - vg.vgUnSurfacedLunCap;
                String lunExtentOverhead = Util.formatPrefBytes(extOverhead << 9);
                VolumeGroupData.addItem(this.panel, c, "SAG0102L", lunExtentOverhead);
            }
        } else {
            String s;
            c.insets.bottom = 12;
            VolumeGroupData.addItem(this.panel, c, "STG1102L", this.computer.nlName);
            VolumeGroupData.addItem(this.panel, c, "STG1132L", vg.getType());
            if (this.computer.nlID2 != 8) {
                c.insets.bottom = 0;
                s = Integer.toString(vg.vgDisks);
                VolumeGroupData.addItem(this.panel, c, "STG6057L", s);
            }
            c.insets.bottom = 12;
            s = Integer.toString(vg.vgVolumes);
            VolumeGroupData.addItem(this.panel, c, "STG6202L", s);
            c.insets.bottom = 0;
            s = Util.formatPrefBytes(vg.vgTotalSpace << 9);
            VolumeGroupData.addItem(this.panel, c, "STG1162L", s);
            c.insets.bottom = 12;
            s = Util.formatPrefBytes(vg.vgFreeSpace << 9);
            VolumeGroupData.addItem(this.panel, c, "STG1184L", s);
            c.insets.bottom = 0;
            s = DateFormat.getDateTimeInstance().format(new Date(vg.vgDiscoveredTime));
            VolumeGroupData.addItem(this.panel, c, "STG1134L", s);
            s = DateFormat.getDateTimeInstance().format(new Date(vg.vgProbeTime));
            VolumeGroupData.addItem(this.panel, c, "STG1119L", s);
        }
        GuiUtil.completePanel(this.panel);
    }
}

