/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationEditorHelper;
import org.eclipse.aperi.TStorm.gui.rptfilter.TimestampWidget;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DurationBetweenEditor
implements ValueEditor {
    private ColumnFilter filter;
    private TimestampWidget leftWidget;
    private TimestampWidget rightWidget;
    private Component panel;

    private static Component makeBorderedPanel(Component contained, String msgID) {
        JPanel result = new JPanel(new BorderLayout());
        String s = MessageLog.getMessageNoID(msgID);
        result.setBorder(GuiUtil.getBorder(s));
        result.add(Box.createHorizontalStrut(5), "West");
        result.add(Box.createHorizontalStrut(5), "East");
        result.add(Box.createVerticalStrut(5), "South");
        result.add(contained, "Center");
        return result;
    }

    public static Component makeBetweenPanel(Component left, Component right) {
        Component leftPanel = DurationBetweenEditor.makeBorderedPanel(left, "STG3271L");
        Component rightPanel = DurationBetweenEditor.makeBorderedPanel(right, "STG3272L");
        JPanel result = new JPanel(new BorderLayout());
        result.add(leftPanel, "West");
        result.add(rightPanel, "East");
        result.add(Box.createHorizontalStrut(15), "Center");
        return result;
    }

    static boolean userConfirmsValueSwap(ValueEditor editor) throws GeneralException {
        if (!GuiUtil.getConfirmation(editor.getWholeComponent().getParent(), "STG3284L", "STG3283T", true)) {
            throw new GeneralException();
        }
        return true;
    }

    public DurationBetweenEditor(ColumnFilter pFilter) {
        this.filter = pFilter;
        ColumnFilterValue first = this.filter.clfValueList;
        ColumnFilterValue second = first != null ? first.fvNext : null;
        DurationEditorHelper helper = new DurationEditorHelper(first);
        this.leftWidget = helper.widget;
        Component leftComponent = helper.panel;
        helper = new DurationEditorHelper(second);
        this.rightWidget = helper.widget;
        Component rightComponent = helper.panel;
        this.panel = DurationBetweenEditor.makeBetweenPanel(leftComponent, rightComponent);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void getData() throws GeneralException {
        MutableLong second;
        MutableLong first;
        long leftNumber = this.leftWidget.number;
        long rightNumber = this.rightWidget.number;
        if (leftNumber > rightNumber && DurationBetweenEditor.userConfirmsValueSwap(this)) {
            first = new MutableLong(rightNumber);
            second = new MutableLong(leftNumber);
        } else {
            first = new MutableLong(leftNumber);
            second = new MutableLong(rightNumber);
        }
        this.filter.clfValueList = new ColumnFilterValue(first);
        this.filter.clfValueList.fvNext = new ColumnFilterValue(second);
    }

    public void setFocus() {
        this.leftWidget.setFocus();
    }
}

