/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.ListElementEditor;

public class EnumeratedMultipleEditor
implements ValueEditor,
ListElementEditor {
    private ColumnFilter filter;
    private JComboBox comboBox;
    private DefaultComboBoxModel model;
    private EditableList list;
    private ValueEditorDialog dialog;

    public EnumeratedMultipleEditor(ColumnFilter pFilter, ValueEditorDialog pDialog) {
        this.filter = pFilter;
        this.dialog = pDialog;
        EnumeratedFreeForm obj = new EnumeratedFreeForm(this.filter);
        this.comboBox = obj.combo;
        this.model = (DefaultComboBoxModel)this.comboBox.getModel();
        this.list = new EditableList("", this, null, 15);
        ColumnFilterValue value = this.filter.clfValueList;
        while (value != null) {
            int index = obj.getItemIndex(value);
            Object element = this.comboBox.getItemAt(index);
            this.list.addObject(element);
            this.comboBox.removeItemAt(index);
            value = value.fvNext;
        }
        if (this.model.getSize() > 0) {
            this.list.setAddEnabled(true);
        }
        if (this.filter.clfValueList == null) {
            this.dialog.setOKEnabled(false);
        }
    }

    public Component getWholeComponent() {
        return this.list;
    }

    public void getData() {
        Object[] array = this.list.getElements();
        ColumnFilterValue tail = null;
        this.filter.clfValueList = null;
        for (int i = 0; i < array.length; ++i) {
            NameList element = (NameList)array[i];
            ColumnFilterValue value = new ColumnFilterValue();
            value.fvValueID = element.nlID;
            if (tail != null) {
                tail.fvNext = value;
            } else {
                this.filter.clfValueList = value;
            }
            tail = value;
        }
    }

    public void setFocus() {
        this.comboBox.requestFocus();
    }

    public void setObject(Object ignored) {
    }

    public void setEnabled(boolean ignored) {
    }

    public Component getComponent() {
        return this.comboBox;
    }

    public Object getObject() {
        Object item = this.comboBox.getSelectedItem();
        this.comboBox.removeItem(item);
        if (this.model.getSize() <= 0) {
            this.list.setAddEnabled(false);
            this.comboBox.setEnabled(false);
        }
        this.dialog.setOKEnabled(true);
        return item;
    }

    public void objectRemoved(Object uncast) {
        int nItems = this.model.getSize();
        if (nItems <= 0) {
            this.list.setAddEnabled(true);
            this.comboBox.setEnabled(true);
        }
        NameList element = (NameList)uncast;
        boolean going = true;
        int index = 0;
        while (going && index < nItems) {
            NameList alreadyThere = (NameList)this.comboBox.getItemAt(index);
            if (element.nlID2 > alreadyThere.nlID2) {
                ++index;
                continue;
            }
            going = false;
        }
        this.comboBox.insertItemAt(element, index);
        if (nItems <= 0) {
            this.comboBox.setSelectedIndex(0);
        }
        if (this.list.editList.getModel().getSize() <= 0) {
            this.dialog.setOKEnabled(false);
        }
    }
}

