/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleFreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class StorageFreeForm
extends FreeForm {
    private static final int FRACTION_DIGITS = 2;
    public static double addAmt = 0.005;
    public static double subAmt = -0.005;
    private static final String UNITS = "bkMGT";
    private static final String CAPITAL_UNITS = "bkMGT".toUpperCase();

    private static char getUnitLetter(short inputUnit) {
        char result = '\u0000';
        if (inputUnit >= 0 && inputUnit < UNITS.length()) {
            result = UNITS.charAt(inputUnit);
        }
        return result;
    }

    private static boolean validateNumber(String s, MutableInteger pos) {
        boolean foundDecimal = false;
        boolean foundDigit = false;
        int length = s.length();
        boolean going = true;
        while (going && pos.value < length) {
            char c = s.charAt(pos.value);
            if (Character.isDigit(c)) {
                foundDigit = true;
            } else if (c == IntegerFreeForm.decimalPoint && !foundDecimal) {
                foundDecimal = true;
            } else {
                going = false;
            }
            if (!going) continue;
            ++pos.value;
        }
        return foundDigit;
    }

    public static ColumnFilterValue parse(String s, MutableInteger pos, boolean allowMore) throws GeneralException {
        return StorageFreeForm.parse(s, pos, allowMore, false, 0.0);
    }

    public static ColumnFilterValue parse(String s, MutableInteger pos, boolean allowMore, boolean adjustForRounding, double adjAmt) throws GeneralException {
        StringMultipleFreeForm.breezeBySpace(s, pos);
        ColumnFilterValue result = null;
        int start = pos.value;
        if (StorageFreeForm.validateNumber(s, pos)) {
            boolean looksOK = true;
            short inputUnit = 0;
            String numberString = s.substring(start, pos.value);
            int length = s.length();
            StringMultipleFreeForm.breezeBySpace(s, pos);
            if (pos.value < length) {
                char c = Character.toUpperCase(s.charAt(pos.value));
                short index = (short)CAPITAL_UNITS.indexOf(c);
                if (index >= 0) {
                    inputUnit = index;
                    ++pos.value;
                    StringMultipleFreeForm.breezeByNonSpace(s, pos);
                } else if (!allowMore) {
                    looksOK = false;
                }
            }
            if (looksOK) {
                long value = -1L;
                if (inputUnit == 0) {
                    try {
                        value = Long.parseLong(numberString);
                    }
                    catch (NumberFormatException ignored) {}
                } else {
                    numberString = StorageFreeForm.trimDecimal(numberString);
                    NumberFormat formatter = NumberFormat.getInstance();
                    Number number = null;
                    try {
                        number = formatter.parse(numberString);
                    }
                    catch (ParseException shouldNotHappen) {
                        // empty catch block
                    }
                    if (number != null) {
                        double x = number.doubleValue();
                        x *= (double)StorageFreeForm.longFromUnit(inputUnit);
                        if (adjustForRounding) {
                            x += adjAmt * (double)StorageFreeForm.longFromUnit(inputUnit);
                        }
                        value = (long)x;
                    }
                }
                if (value >= 0L) {
                    MutableLong obj = new MutableLong(value);
                    result = new ColumnFilterValue(obj, inputUnit);
                }
            }
        }
        if (result == null) {
            Object[] parms = new Object[]{s.substring(start)};
            String msg = MessageLog.getMessageNoTS("STG3267E", parms);
            throw new GeneralException(msg);
        }
        return result;
    }

    public static String format(MutableLong obj, short inputUnit) {
        String result;
        long value = obj.value;
        if (inputUnit <= 0) {
            result = Long.toString(value);
        } else {
            long scale = StorageFreeForm.longFromUnit(inputUnit);
            double converted = (double)value / (double)scale;
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setGroupingUsed(false);
            StringBuffer buf = new StringBuffer(40);
            buf.append(formatter.format(converted));
            char c = StorageFreeForm.getUnitLetter(inputUnit);
            if (c != '\u0000') {
                buf.append(c);
            }
            result = buf.toString();
        }
        return result;
    }

    public StorageFreeForm(ColumnFilter pFilter) {
        super(pFilter);
    }

    public void refresh(boolean adjustForRounding) {
        String s = "";
        ColumnFilterValue value = this.filter.clfValueList;
        if (value != null) {
            Object obj = value.fvValue;
            if (!(obj instanceof MutableLong)) {
                s = "***ERROR***";
            } else {
                MutableLong x = (MutableLong)obj;
                if (adjustForRounding) {
                    x = this.adjustForRounding(x);
                }
                s = StorageFreeForm.format(x, value.fvInputUnit);
            }
        }
        this.textField.setText(s);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void getAdjustedData(double adjAmt) throws GeneralException {
        this.ensureNonEmpty();
        String s = this.textField.getText();
        byte op = (byte)this.filter.clfCondition;
        this.filter.clfValueList = StorageFreeForm.parse(s, new MutableInteger(), false, true, adjAmt);
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        String s = this.textField.getText();
        this.filter.clfValueList = StorageFreeForm.parse(s, new MutableInteger(), false);
    }

    public static String trimDecimal(String numberString) {
        int newIndex = numberString.indexOf(IntegerFreeForm.decimalPoint);
        if (newIndex >= 0 && numberString.length() > (newIndex += 2) + 1) {
            numberString = numberString.substring(0, newIndex + 1);
        }
        return numberString;
    }
}

