/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleFreeForm;
import org.eclipse.aperi.common.GeneralException;

public class StringFreeForm
extends FreeForm {
    public StringFreeForm(ColumnFilter pFilter) {
        super(pFilter);
    }

    public void refresh() {
        String s = "";
        ColumnFilterValue value = this.filter.clfValueList;
        if (value != null) {
            Object obj = value.fvValue;
            if (!(obj instanceof String)) {
                s = "***ERROR***";
            } else {
                int length;
                s = (String)obj;
                char quoteChar = StringMultipleFreeForm.quoteAt(s, 0);
                if (quoteChar != '\u0000' && (length = s.length()) > 1 && s.charAt(length - 1) == quoteChar) {
                    StringBuffer buf = new StringBuffer(200);
                    StringMultipleFreeForm.appendQuoted(buf, s);
                    s = buf.toString();
                }
            }
        }
        this.textField.setText(s);
    }

    private static String undoubleQuotes(String s, char quoteChar) {
        int length = s.length();
        StringBuffer buf = new StringBuffer(length);
        boolean wasQuote = false;
        for (int pos = 0; pos < length; ++pos) {
            boolean isQuote;
            char c = s.charAt(pos);
            boolean bl = isQuote = c == quoteChar;
            if (wasQuote && isQuote) {
                wasQuote = false;
                continue;
            }
            buf.append(c);
            wasQuote = isQuote;
        }
        return buf.toString();
    }

    public void getData() throws GeneralException {
        int length;
        this.ensureNonEmpty();
        String s = this.textField.getText();
        char quoteChar = StringMultipleFreeForm.quoteAt(s, 0);
        if (quoteChar != '\u0000' && (length = s.length()) > 1 && s.charAt(length - 1) == quoteChar) {
            s = s.substring(1, length - 1);
            s = StringFreeForm.undoubleQuotes(s, quoteChar);
        }
        this.filter.clfValueList = new ColumnFilterValue(s);
    }
}

