/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.File;
import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class DaemonLogFileReader
extends LogFileReader {
    private String logFileDirectory;

    public DaemonLogFileReader(String pLogFileDirectory) {
        this.logFileDirectory = pLogFileDirectory;
    }

    private String extend(String prefix, LogFilePos position) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "extend", "prefix, position");
        }
        String traceResult = prefix + CurtailedWriter.extension.format(position.fileSeqNo);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "extend", traceResult);
        }
        return traceResult;
    }

    private String generateName(String prefix, LogFilePos position) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "generateName", "prefix, position");
        }
        String traceResult = this.logFileDirectory + File.separatorChar + this.extend(prefix, position);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateName", traceResult);
        }
        return traceResult;
    }

    private String generateHeader(String prefix, LogFilePos position) {
        int i;
        String name;
        int totalDashes;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "generateHeader", "prefix, position");
        }
        if ((totalDashes = 77 - (name = this.extend(prefix, position)).length()) < 2) {
            String traceResult = name + '\n';
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateHeader", traceResult);
            }
            return traceResult;
        }
        StringBuffer buf = new StringBuffer(80);
        int dashes = totalDashes >> 1;
        for (i = 0; i < dashes; ++i) {
            buf.append('-');
        }
        buf.append(' ');
        buf.append(name);
        buf.append(' ');
        dashes = totalDashes - dashes;
        for (i = 0; i < dashes; ++i) {
            buf.append('-');
        }
        buf.append('\n');
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateHeader", traceResult);
        }
        return traceResult;
    }

    protected MutableInteger open(ReadLogRequest requestData, Response response) {
        MutableInteger traceResult;
        LocalizableException exc;
        int fd;
        String name;
        int seqNo;
        LogFilePos position;
        block22: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(DaemonLogFileReader.class.getName(), "open", "requestData, response");
            }
            byte direction = requestData.direction;
            position = requestData.position;
            if (position.offset < 0L && direction == 1) {
                position.offset = 0L;
            }
            String prefix = requestData.name + "_";
            seqNo = position.fileSeqNo;
            if (seqNo < 0) {
                int prefixLength = prefix.length();
                File dir = new File(this.logFileDirectory);
                String[] allLogs = dir.list();
                int max = Integer.MIN_VALUE;
                int min = Integer.MAX_VALUE;
                if (allLogs != null) {
                    for (int i = 0; i < allLogs.length; ++i) {
                        int j;
                        name = allLogs[i];
                        if (!name.startsWith(prefix) || !name.endsWith(".log")) continue;
                        name = name.substring(prefixLength, name.length() - 4);
                        try {
                            j = Integer.parseInt(name);
                        }
                        catch (NumberFormatException e) {
                            if (!TraceLogger.enableTrace) continue;
                            TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", e);
                            continue;
                        }
                        if (j < 0) continue;
                        if (j < min) {
                            min = j;
                        }
                        if (j <= max) continue;
                        max = j;
                    }
                }
                if (max == Integer.MIN_VALUE) {
                    Object[] args = new Object[]{requestData.name};
                    response.errorMessage = MessageLog.getMessage("GEN0049E", args);
                    MutableInteger traceResult2 = null;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", traceResult2);
                    }
                    return traceResult2;
                }
                position.fileSeqNo = direction == 1 ? min : max;
            }
            name = this.generateName(prefix, position);
            fd = -1;
            exc = null;
            try {
                fd = this.openFile(name, (int)position.offset);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", e);
                }
                exc = e;
            }
            if (fd < 0 && seqNo < 0 && direction == 1) {
                ++position.fileSeqNo;
                String newName = this.generateName(prefix, position);
                try {
                    fd = this.openFile(newName, (int)position.offset);
                }
                catch (LocalizableException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", e);
                }
            }
        }
        if (fd < 0) {
            if (seqNo < 0) {
                Object[] args = exc.getParameters();
                args[args.length - 1] = name;
                response.errorMessage = exc.getMessage();
            } else {
                response.status = 0;
                ReadLogResponse responseData = new ReadLogResponse();
                responseData.status = (byte)2;
                response.responseData = responseData;
            }
            traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", traceResult);
            }
            return traceResult;
        }
        if (position.offset < 0L) {
            position.offset = this.getFilePosition(fd);
        }
        traceResult = new MutableInteger(fd);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", traceResult);
        }
        return traceResult;
    }

    protected int read(MutableInteger handle, LogFilePos pos, ReadLogRequest requestData, ReadLogResponse rd, Response response) {
        int traceResult;
        int lines;
        boolean another;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "read", "handle, pos, requestData, rd, response");
        }
        String[] lineArray = rd.lineArray;
        int done = 0;
        byte direction = requestData.direction;
        String name = requestData.name;
        String prefix = name + '_';
        do {
            int newFD;
            LogFilePos newPos;
            int fd;
            block12: {
                another = false;
                if (pos.offset == 0L && direction == 1) {
                    lineArray[done] = this.generateHeader(prefix, pos);
                    if (++done >= lineArray.length) {
                        rd.lineArray = new String[done + 1];
                        System.arraycopy(lineArray, 0, rd.lineArray, 0, done);
                        lineArray = rd.lineArray;
                    }
                }
                requestData.name = this.generateName(prefix, pos);
                fd = handle.value;
                lines = this.basicRead(fd, pos, requestData, lineArray, done, response);
                requestData.name = name;
                if (lines < 0) continue;
                done += lines;
                if (pos.offset == 0L && direction == -1 && lines > 0) {
                    if (done >= lineArray.length) {
                        rd.lineArray = new String[done + 1];
                        System.arraycopy(lineArray, 0, rd.lineArray, 1, done);
                        lineArray = rd.lineArray;
                    }
                    lineArray[lineArray.length - ++done] = this.generateHeader(prefix, pos);
                }
                if (done >= lineArray.length) continue;
                newPos = new LogFilePos();
                newPos.fileSeqNo = pos.fileSeqNo + direction;
                newPos.offset = direction - 1 >> 1;
                newFD = -1;
                String newName = this.generateName(prefix, newPos);
                try {
                    newFD = this.openFile(newName, (int)newPos.offset);
                }
                catch (LocalizableException e) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "read", e);
                }
            }
            if (newFD < 0) continue;
            this.closeFile(fd);
            handle.value = newFD;
            if (newPos.offset < 0L) {
                newPos.offset = this.getFilePosition(newFD);
            }
            newPos.copy(pos);
            another = true;
        } while (another);
        if (lines >= 0) {
            traceResult = done;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "read", traceResult);
            }
            return traceResult;
        }
        traceResult = lines;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "read", traceResult);
        }
        return traceResult;
    }

    protected boolean setPosition(MutableInteger handle, ReadLogRequest rq, LogFilePos newPos) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "setPosition", "handle, rq, newPos");
        }
        if (newPos.fileSeqNo == rq.position.fileSeqNo) {
            this.setFilePosition(handle.value, (int)newPos.offset);
            boolean traceResult2 = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "setPosition", traceResult2);
            }
            return traceResult2;
        }
        this.closeFile(handle.value);
        String path = this.generateName(rq.name + '_', newPos);
        handle.value = -1;
        try {
            handle.value = this.openFile(path, (int)newPos.offset);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(DaemonLogFileReader.class.getName(), "setPosition", e);
            }
            Object[] args = e.getParameters();
            args[args.length - 1] = path;
            e.print();
        }
        boolean bl = traceResult = handle.value != -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "setPosition", traceResult);
        }
        return traceResult;
    }
}

