/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DbGenerateClasses {
    private static Connection connect(String dbUrl, String user, String password) throws SQLException {
        Connection DBCon = null;
        DBCon = DriverManager.getConnection(dbUrl, user, password);
        return DBCon;
    }

    private static Connection connect(String driver, String dbUrl, String user, String password) throws ClassNotFoundException, SQLException {
        Class.forName(driver);
        Connection DBCon = DbGenerateClasses.connect(dbUrl, user, password);
        return DBCon;
    }

    private static void printHeader(PrintWriter outputStream, String className) {
        outputStream.println("/********************************************************* {COPYRIGHT-TOP} ***");
        outputStream.println("* Aperi Storage Manager");
        outputStream.println("* (C) Copyright IBM Corp. 2005, 2006");
        outputStream.println("* All rights reserved. This program and the accompanying materials");
        outputStream.println("* are made available under the terms of the Eclipse Public License v1.0");
        outputStream.println("* which accompanies this distribution, and is available at");
        outputStream.println("* http://www.eclipse.org/legal/epl-v10.html");
        outputStream.println("********************************************************** {COPYRIGHT-END} **/");
    }

    public static String columnNameToMemberName(String inputString) {
        char[] input = inputString.toLowerCase().toCharArray();
        StringBuffer output = new StringBuffer(inputString.length());
        for (int x = 0; x < inputString.length(); ++x) {
            if (x != 0 && input[x] != '_') {
                output.append(input[x]);
                continue;
            }
            if (input[x] == '_') {
                ++x;
            }
            output.append(Character.toUpperCase(input[x]));
        }
        return output.toString();
    }

    private static String sqlTypeToJavaTypeString(short dataType) {
        String typeString = new String();
        switch (dataType) {
            case 2005: {
                typeString = "java.sql.Clob";
                break;
            }
            case -6: {
                typeString = "byte";
                break;
            }
            case -5: {
                typeString = "long";
                break;
            }
            case 4: {
                typeString = "int";
                break;
            }
            case 5: {
                typeString = "short";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                typeString = "String";
                break;
            }
            case 6: 
            case 8: {
                typeString = "double";
                break;
            }
            case 7: {
                typeString = "float";
                break;
            }
            case 2: 
            case 3: {
                typeString = "double";
                break;
            }
            case 91: {
                typeString = "java.sql.Date";
                break;
            }
            case -7: {
                typeString = "boolean";
                break;
            }
            case 1111: {
                typeString = "Object";
                break;
            }
            case 93: {
                typeString = "java.sql.Timestamp";
                break;
            }
            case 92: {
                typeString = "java.sql.Time";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeString = "byte[]";
                break;
            }
            default: {
                typeString = "Object";
            }
        }
        return typeString;
    }

    private static String sqlTypeToJavaTypeCapString(short dataType) {
        String typeString = new String();
        switch (dataType) {
            case -6: {
                typeString = "Byte";
                break;
            }
            case -5: {
                typeString = "Long";
                break;
            }
            case 4: {
                typeString = "Int";
                break;
            }
            case 5: {
                typeString = "Short";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                typeString = "String";
                break;
            }
            case 6: 
            case 8: {
                typeString = "Double";
                break;
            }
            case 7: {
                typeString = "Float";
                break;
            }
            case 2: 
            case 3: {
                typeString = "Double";
                break;
            }
            case 91: {
                typeString = "Date";
                break;
            }
            case -7: {
                typeString = "Boolean";
                break;
            }
            case 1111: {
                typeString = "Object";
                break;
            }
            case 93: {
                typeString = "Timestamp";
                break;
            }
            case 92: {
                typeString = "Time";
                break;
            }
            case 2005: {
                typeString = "Clob";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeString = "Bytes";
                break;
            }
            default: {
                typeString = "Object";
            }
        }
        return typeString;
    }

    private static String sqlTypeToSqlTypeString(short dataType) {
        String typeString = new String();
        switch (dataType) {
            case -6: {
                typeString = "TINYINT";
                break;
            }
            case -5: {
                typeString = "BIGINT";
                break;
            }
            case 4: {
                typeString = "INTEGER";
                break;
            }
            case 5: {
                typeString = "SMALLINT";
                break;
            }
            case 1: {
                typeString = "CHAR";
                break;
            }
            case 12: {
                typeString = "VARCHAR";
                break;
            }
            case -1: {
                typeString = "LONGVARCHAR";
                break;
            }
            case 2005: {
                typeString = "CLOB";
                break;
            }
            case 8: {
                typeString = "DOUBLE";
                break;
            }
            case 6: {
                typeString = "FLOAT";
                break;
            }
            case 7: {
                typeString = "REAL";
                break;
            }
            case 2: {
                typeString = "NUMERIC";
                break;
            }
            case 3: {
                typeString = "DECIMAL";
                break;
            }
            case 91: {
                typeString = "DATE";
                break;
            }
            case -7: {
                typeString = "BIT";
                break;
            }
            case 1111: {
                typeString = "OTHER";
                break;
            }
            case 93: {
                typeString = "TIMESTAMP";
                break;
            }
            case 92: {
                typeString = "TIME";
                break;
            }
            case -2: {
                typeString = "BINARY";
                break;
            }
            case -3: {
                typeString = "VARBINARY";
                break;
            }
            case -4: {
                typeString = "LONGVARBINARY";
            }
        }
        return typeString;
    }

    private static String trimTypeString(String javaType) {
        if (javaType.indexOf(".") >= 0) {
            String[] parts = javaType.split("\\.");
            return parts[parts.length - 1];
        }
        return javaType;
    }

    private static String invalidValueString(short dataType) {
        switch (dataType) {
            case 2005: {
                return "DBConstants.INVALID_CLOB_VALUE";
            }
            case -6: 
            case 5: {
                return "DBConstants.INVALID_SHORT_VALUE";
            }
            case -1: 
            case 1: 
            case 12: {
                return "DBConstants.INVALID_STRING_VALUE";
            }
            case -5: {
                return "DBConstants.INVALID_LONG_VALUE";
            }
            case 91: {
                return "DBConstants.INVALID_DATE_VALUE";
            }
            case 92: {
                return "DBConstants.INVALID_TIME_VALUE";
            }
            case 1111: {
                return "DBConstants.INVALID_STRING_VALUE";
            }
            case -4: 
            case -3: 
            case -2: {
                return "DBConstants.INVALID_BYTE_ARRAY_VALUE";
            }
            case 4: {
                return "DBConstants.INVALID_INT_VALUE";
            }
            case 6: 
            case 7: {
                return "DBConstants.INVALID_FLOAT_VALUE";
            }
            case 2: 
            case 3: 
            case 8: {
                return "DBConstants.INVALID_DOUBLE_VALUE";
            }
            case 93: {
                return "DBConstants.INVALID_TIMESTAMP_VALUE";
            }
        }
        return "null";
    }

    private static String buildSetStatement(String columnName, String memberName, short dataType) {
        StringBuffer result = new StringBuffer();
        String typeString = DbGenerateClasses.sqlTypeToJavaTypeString(dataType);
        result.append("\tpublic void set");
        result.append(columnName);
        result.append("( ");
        result.append(typeString);
        result.append(" ");
        result.append(columnName);
        result.append(") { this.");
        result.append(memberName);
        result.append(" = ");
        result.append(columnName);
        result.append(";}");
        return result.toString();
    }

    private static boolean basicDataType(short dataType) {
        switch (dataType) {
            case -6: 
            case 5: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return false;
            }
            case -5: {
                return true;
            }
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return false;
            }
            case 4: {
                return true;
            }
            case 6: 
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static String buildClearStatement(String memberName, short dataType) {
        StringBuffer result = new StringBuffer();
        result.append(memberName);
        result.append(" = ");
        switch (dataType) {
            case -6: 
            case 5: {
                result.append("DBConstants.INVALID_SHORT_VALUE");
                break;
            }
            case 2005: {
                result.append("DBConstants.INVALID_CLOB_VALUE");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                result.append("DBConstants.INVALID_STRING_VALUE");
                break;
            }
            case -5: {
                result.append("DBConstants.INVALID_LONG_VALUE");
                break;
            }
            case 1111: {
                result.append("DBConstants.INVALID_STRING_VALUE");
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result.append("DBConstants.INVALID_BYTE_ARRAY_VALUE");
                break;
            }
            case 4: {
                result.append("DBConstants.INVALID_INT_VALUE");
                break;
            }
            case 6: 
            case 7: {
                result.append("DBConstants.INVALID_FLOAT_VALUE");
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                result.append("DBConstants.INVALID_DOUBLE_VALUE");
                break;
            }
            case 93: {
                result.append("DBConstants.INVALID_TIMESTAMP_VALUE");
                break;
            }
            case 92: {
                result.append("DBConstants.INVALID_TIME_VALUE");
                break;
            }
            case 91: {
                result.append("DBConstants.INVALID_DATE_VALUE");
                break;
            }
            default: {
                result.append("null");
            }
        }
        result.append(";\n");
        return result.toString();
    }

    private static String convertToString(String memberName, short dataType) {
        switch (dataType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "String.valueOf(this." + memberName + ")";
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2005: {
                return "this." + memberName;
            }
            case -4: 
            case -3: 
            case -2: {
                return "(new String(this." + memberName + "))";
            }
        }
        return "null";
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        if (args.length < 1) {
            System.out.println("Usage: ");
            System.out.println("Select tables: java DBGenerateClasses <path-config-file> <table1> ... <tableN>");
            System.out.println("All tables: java DBGenerateClasses <path-config-file>");
            System.exit(1);
        }
        String configFileName = args[0];
        Connection con = null;
        String getTablenameString = new String("public static String getTablename() { \n\t return TABLE_NM; }\n");
        StringBuffer clearMethodString = new StringBuffer("public void clear () {\n");
        String javaTypeString = new String();
        if (configFileName == null) {
            System.err.println("ERROR: You must enter config file name on command line");
            System.err.println("Usage: java -DConfigFileName=<config file name> <table1> .. <tableN>");
            System.exit(1);
        }
        try {
            props.load(new FileInputStream(configFileName));
        }
        catch (IOException eIO) {
            System.err.println("ERROR: load of " + configFileName + " failed: " + eIO.getMessage());
            System.exit(2);
        }
        String jdbcDriver = props.getProperty("Driver");
        String dbUrl = props.getProperty("DbUrl");
        String user = props.getProperty("User");
        String password = props.getProperty("Password");
        String dbSchema = props.getProperty("Schema");
        String location = props.getProperty("Root");
        String normalFields = props.getProperty("NormalFields");
        String normalTables = props.getProperty("NormalTables");
        String legacyTables = props.getProperty("LegacyTables");
        try {
            con = DbGenerateClasses.connect(jdbcDriver, dbUrl, user, password);
        }
        catch (ClassNotFoundException eClass) {
            System.err.println("ERROR: Driver couldn't be loaded for: " + jdbcDriver);
            System.err.println("Error message is: " + eClass.getMessage());
            System.exit(3);
        }
        catch (SQLException eSQL) {
            System.err.println("ERROR: connect failed: " + eSQL.getMessage());
            System.err.println("Check your configuration file: " + configFileName);
            System.exit(3);
        }
        try {
            DatabaseMetaData metadata = con.getMetaData();
            String[] TableNames = null;
            if (args.length > 1) {
                TableNames = new String[args.length - 1];
                for (int i = 0; i < args.length - 1; ++i) {
                    TableNames[i] = new String(args[i + 1]);
                }
            } else {
                ResultSet tblResults = metadata.getTables(null, dbSchema, null, null);
                Vector<String> Names = new Vector<String>();
                while (tblResults.next()) {
                    Names.add(tblResults.getString("TABLE_NAME"));
                }
                int numTables = Names.size();
                TableNames = new String[numTables];
                for (int j = 0; j < numTables; ++j) {
                    TableNames[j] = (String)Names.elementAt(j);
                }
            }
            String[] normalArray = normalFields.split(" ");
            Hashtable<String, String> normalHash = new Hashtable<String, String>();
            for (int i = 0; i < normalArray.length; ++i) {
                normalHash.put(normalArray[i], normalArray[i]);
            }
            String[] normalTableArray = normalTables.split(" ");
            Hashtable<String, String> normalTableHash = new Hashtable<String, String>();
            for (int i = 0; i < normalTableArray.length; ++i) {
                normalTableHash.put(normalTableArray[i], normalTableArray[i]);
            }
            String[] legacyTablesArray = legacyTables.split(" ");
            Hashtable<String, String> legacyTablesHash = new Hashtable<String, String>();
            for (int i = 0; i < legacyTablesArray.length; ++i) {
                legacyTablesHash.put(legacyTablesArray[i], legacyTablesArray[i]);
            }
            for (int argCounter = 0; argCounter < TableNames.length; ++argCounter) {
                String member;
                String keyName;
                short colType;
                String columnName;
                String DBColumnName;
                int i;
                int i2;
                String columnName2;
                short colType2;
                String DBColumnName2;
                int i3;
                String className;
                System.out.println("Processing Table Name: " + TableNames[argCounter]);
                String Selectors = null;
                String SetMethods = null;
                String Constructor2 = null;
                clearMethodString = null;
                String PublicString = null;
                Selectors = new String("");
                SetMethods = new String("");
                Constructor2 = new String("");
                PublicString = new String("");
                String ToString = new String("public String toString () {\n\tStringBuffer output = new StringBuffer();\n");
                clearMethodString = new StringBuffer("\tpublic void clear () {\n");
                String StaticInitializer = new String("static {\n\tm_colList = new Hashtable();\n\tColumnInfo colInfo;\n");
                String saveClassName = className = DbGenerateClasses.columnNameToMemberName(TableNames[argCounter]);
                className = className + "Table";
                String fileName = className + ".java";
                String memberName = "";
                System.out.println("Writing table class: " + fileName);
                File outputFile = new File(location + "\\tables\\" + fileName);
                FileOutputStream fileOutput = new FileOutputStream(outputFile);
                PrintWriter outputStream = new PrintWriter(fileOutput);
                DbGenerateClasses.printHeader(outputStream, className);
                outputStream.println("package org.eclipse.aperi.infrastructure.database.tables;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBTable;");
                outputStream.println("import java.sql.Types;");
                outputStream.println("import java.util.Hashtable;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.ColumnInfo;\n");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBConstants;\n");
                outputStream.println("public abstract class " + className + " extends DBTable {");
                outputStream.println("//constant for database table name");
                String tableName = TableNames[argCounter].toUpperCase();
                outputStream.println("\tprotected static final String TABLE_NM = \"" + tableName + "\";");
                outputStream.println("\tprivate static Hashtable m_colList;");
                outputStream.println("//member variables for columns");
                ResultSet colResults = metadata.getColumns(null, dbSchema, tableName, null);
                Hashtable<String, String> colTypeHash = new Hashtable<String, String>();
                Vector<String> colVec = new Vector<String>();
                while (colResults.next()) {
                    String DBColumnName3 = colResults.getString("COLUMN_NAME");
                    String columnName3 = DbGenerateClasses.columnNameToMemberName(DBColumnName3);
                    short colType3 = colResults.getShort("DATA_TYPE");
                    if (!colResults.getString("TABLE_NAME").equals(tableName)) continue;
                    outputStream.print("\tprotected ");
                    StaticInitializer = StaticInitializer + "\tcolInfo = new ColumnInfo();\n";
                    StaticInitializer = StaticInitializer + "\tcolInfo.setTableName(TABLE_NM);\n";
                    StaticInitializer = StaticInitializer + "\tcolInfo.setName(" + DBColumnName3 + ");\n";
                    ToString = ToString + "\toutput.append(" + DBColumnName3 + "+\":\\t\\t\");\n";
                    ToString = ToString + "\toutput.append(get" + columnName3 + "());\n";
                    ToString = ToString + "\toutput.append(\"\\n\");\n";
                    javaTypeString = DbGenerateClasses.sqlTypeToJavaTypeString(colType3);
                    String sqlTypeString = DbGenerateClasses.sqlTypeToSqlTypeString(colType3);
                    memberName = "m_" + columnName3;
                    colVec.add(DBColumnName3);
                    colTypeHash.put(DBColumnName3, String.valueOf(colType3));
                    outputStream.println(javaTypeString + " " + memberName + ";");
                    PublicString = PublicString + "\tpublic static final String " + DBColumnName3 + " = \"" + DBColumnName3 + "\";\n";
                    Selectors = Selectors + "\tpublic " + javaTypeString + " get" + columnName3;
                    Selectors = Selectors + "() {return " + memberName + ";}\n";
                    StaticInitializer = StaticInitializer + "\tcolInfo.setDataType(Types." + sqlTypeString + ");\n";
                    StaticInitializer = StaticInitializer + "\tm_colList.put(" + DBColumnName3 + ", colInfo);\n";
                    clearMethodString.append("\t\t").append(DbGenerateClasses.buildClearStatement(memberName, colType3));
                    SetMethods = SetMethods + DbGenerateClasses.buildSetStatement(columnName3, memberName, colType3) + "\n";
                }
                Constructor2 = "public " + className + " ( ) {}\n";
                StaticInitializer = StaticInitializer + " \n}";
                ToString = ToString + "\n\treturn output.toString();\n}\n";
                clearMethodString.append("\n\t}\n");
                outputStream.println("\t//Public Column Names");
                outputStream.println(PublicString);
                outputStream.println("\t//Static Initializer");
                outputStream.println(StaticInitializer);
                outputStream.println("\t//Constructor");
                outputStream.println(Constructor2);
                outputStream.println("\t//Selectors");
                outputStream.println(Selectors);
                outputStream.println("\t//Set Methods");
                outputStream.println(SetMethods);
                outputStream.println("\t//ToString method");
                outputStream.println(ToString);
                outputStream.println("\t//clear method");
                outputStream.println(clearMethodString.toString());
                outputStream.println("\t//getTablename method");
                outputStream.println(getTablenameString);
                outputStream.println("public static ColumnInfo getColumnInfo (String colName) { return (ColumnInfo) m_colList.get(colName); }");
                outputStream.println("public static Hashtable getColumns () { return (Hashtable)m_colList.clone(); }");
                outputStream.println("} // class " + className);
                outputStream.close();
                colResults.close();
                int cutoffIndex = 1;
                if (legacyTablesHash.get(TableNames[argCounter]) == null) {
                    cutoffIndex = TableNames[argCounter].indexOf(95, 2);
                }
                String cutTableName = TableNames[argCounter].substring(cutoffIndex + 1);
                String objClassName = DbGenerateClasses.columnNameToMemberName(cutTableName);
                String parentClassName = className;
                className = saveClassName;
                fileName = objClassName + ".java";
                System.out.println("Writing object class: " + fileName);
                outputFile = new File(location + "\\objects\\" + fileName);
                fileOutput = new FileOutputStream(outputFile);
                outputStream = new PrintWriter(fileOutput);
                DbGenerateClasses.printHeader(outputStream, objClassName);
                outputStream.println("package org.eclipse.aperi.infrastructure.database.objects;\n");
                outputStream.println("import java.sql.Timestamp;");
                outputStream.println("import java.sql.Statement;");
                outputStream.println("import java.sql.Date;");
                outputStream.println("import java.sql.Time;");
                outputStream.println("import java.sql.Clob;");
                outputStream.println("import java.sql.SQLException;");
                outputStream.println("import java.util.Hashtable;");
                outputStream.println("import java.util.Vector;\n");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.ColumnInfo;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBConnection;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBConstants;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBCursor;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBResultSet;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBTable;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.Normalizer;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.tables." + parentClassName + ";\n");
                outputStream.println("public class " + objClassName + " extends " + className + "Table {\n");
                for (i3 = 0; i3 < colVec.size(); ++i3) {
                    DBColumnName2 = (String)colVec.elementAt(i3);
                    colType2 = Short.parseShort((String)colTypeHash.get(DBColumnName2));
                    if (normalHash.get(DBColumnName2) != null && normalTableHash.get(TableNames[argCounter]) == null && colType2 == 5) {
                        columnName2 = DbGenerateClasses.columnNameToMemberName(DBColumnName2);
                        javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType2));
                        memberName = "m_" + columnName2;
                        outputStream.println("\tprivate String " + memberName + "_str;");
                    }
                    if (i3 != colVec.size() - 1) continue;
                    outputStream.println("");
                }
                for (i3 = 0; i3 < colVec.size(); ++i3) {
                    DBColumnName2 = (String)colVec.elementAt(i3);
                    colType2 = Short.parseShort((String)colTypeHash.get(DBColumnName2));
                    if (normalHash.get(DBColumnName2) == null || normalTableHash.get(TableNames[argCounter]) != null || colType2 != 5) continue;
                    columnName2 = DbGenerateClasses.columnNameToMemberName(DBColumnName2);
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType2));
                    memberName = "m_" + columnName2;
                    String trimColumnName = columnName2.substring(0, columnName2.length() - 2);
                    outputStream.print("\tpublic void set" + trimColumnName + "(String el) { ");
                    outputStream.print("this." + memberName + "_str = el; }\n\n");
                    outputStream.print("\tpublic String get" + trimColumnName + "() { ");
                    outputStream.print("return this." + memberName + "_str; }\n\n");
                    if (i3 != colVec.size() - 1) continue;
                    outputStream.println("");
                }
                outputStream.println("\tpublic static class " + objClassName + "Cursor extends DBCursor {\n");
                outputStream.println("\t\tprivate " + objClassName + " element = new " + objClassName + "();");
                outputStream.println("\t\tprivate DBConnection con;\n");
                boolean stated = false;
                for (i2 = 0; i2 < colVec.size(); ++i2) {
                    String DBColumnName4 = (String)colVec.elementAt(i2);
                    columnName2 = DbGenerateClasses.columnNameToMemberName(DBColumnName4);
                    short colType4 = Short.parseShort((String)colTypeHash.get(DBColumnName4));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType4));
                    memberName = "m_" + columnName2;
                    if (normalHash.get(DBColumnName4) == null || normalTableHash.get(TableNames[argCounter]) != null || colType4 != 5) continue;
                    if (!stated) {
                        outputStream.println("\t\tprivate static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {\n\n");
                        outputStream.print("\t\t\tif (htWhereClause == null) return null;\n\n");
                        stated = true;
                    }
                    outputStream.print("\t\t\tif (htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName4 + ")) != null)\n");
                    outputStream.print("\t\t\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + DBColumnName4 + "), String.valueOf(Normalizer." + columnName2.substring(0, columnName2.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName4 + ")))));\n\n");
                }
                if (stated) {
                    outputStream.println("\t\t\treturn htWhereClause;\n\t\t}\n");
                }
                outputStream.println("\t\tpublic " + objClassName + "Cursor (DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {\n");
                if (stated) {
                    outputStream.println("\t\t\tsuper(TABLE_NM, con, normalize(con, htWhereClause), columns);\n");
                } else {
                    outputStream.println("\t\t\tsuper(TABLE_NM, con, htWhereClause, columns);\n");
                }
                outputStream.println("\t\t\tthis.con = con;\n");
                outputStream.println("\t\t}\n");
                outputStream.println("\t\tpublic " + objClassName + " getObject() throws SQLException {\n");
                outputStream.println("\t\t\t" + objClassName + " el = null;\n");
                outputStream.println("\t\t\tif (DBrs != null) {");
                outputStream.println("\t\t\t\tel = new " + objClassName + "();");
                outputStream.println("\t\t\t\tel.setFields(con, DBrs);");
                outputStream.println("\t\t\t}\n");
                outputStream.println("\t\t\treturn el;");
                outputStream.println("\t\t}\n");
                outputStream.println("\t\tpublic " + objClassName + " getAttributes() throws SQLException {\n");
                outputStream.println("\t\t\tif (DBrs != null) {");
                outputStream.println("\t\t\t\telement.setFields(con, DBrs);");
                outputStream.println("\t\t\t\treturn element;");
                outputStream.println("\t\t\t}\n");
                outputStream.println("\t\t\telse return null;");
                outputStream.println("\t\t}\n");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static " + objClassName + "Cursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns)" + " throws SQLException{\n");
                outputStream.println("\t\treturn new " + objClassName + "Cursor(con, htWhereClause, columns);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic " + objClassName + "() { clear(); }\n");
                outputStream.print("\tpublic " + objClassName + "(");
                for (i2 = 0; i2 < colVec.size(); ++i2) {
                    String DBColumnName5 = (String)colVec.elementAt(i2);
                    columnName2 = DbGenerateClasses.columnNameToMemberName(DBColumnName5);
                    short colType5 = Short.parseShort((String)colTypeHash.get(DBColumnName5));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType5));
                    memberName = "m_" + columnName2;
                    outputStream.print("\t\t" + javaTypeString + " " + columnName2);
                    if (i2 == colVec.size() - 1) {
                        outputStream.println(")");
                        continue;
                    }
                    outputStream.println(",");
                }
                outputStream.println("\t{");
                outputStream.println("\t\tthis.clear();\n");
                for (i2 = 0; i2 < colVec.size(); ++i2) {
                    String DBColumnName6 = (String)colVec.elementAt(i2);
                    columnName2 = DbGenerateClasses.columnNameToMemberName(DBColumnName6);
                    short colType6 = Short.parseShort((String)colTypeHash.get(DBColumnName6));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType6));
                    memberName = "m_" + columnName2;
                    outputStream.print("\t\tthis." + memberName + " = " + columnName2);
                    outputStream.println(";");
                }
                outputStream.println("\t}\n");
                colResults = metadata.getPrimaryKeys(null, dbSchema, tableName);
                Hashtable<String, String> keyHash = new Hashtable<String, String>();
                Hashtable<String, String> keyTypeHash = new Hashtable<String, String>();
                Vector<String> keyVec = new Vector<String>();
                while (colResults.next()) {
                    String DBColumnName7 = colResults.getString("COLUMN_NAME");
                    String columnName4 = DbGenerateClasses.columnNameToMemberName(DBColumnName7);
                    memberName = "m_" + columnName4;
                    keyHash.put(DBColumnName7, memberName);
                    keyVec.add(DBColumnName7);
                    System.out.println("Primary key:" + DBColumnName7);
                }
                colResults.close();
                if (keyVec.size() == 0) {
                    System.out.println("No primary keys for " + tableName);
                }
                outputStream.println("\tprivate void setNonKeyValues(Hashtable htColsAndValues) {\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    colType = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType));
                    memberName = "m_" + columnName;
                    if (keyHash.get(DBColumnName) != null) {
                        keyTypeHash.put(DBColumnName, String.valueOf(colType));
                        continue;
                    }
                    outputStream.println("\t\tif (" + memberName + " != " + DbGenerateClasses.invalidValueString(colType) + ") {");
                    outputStream.println("\t\t\thtColsAndValues.put(" + objClassName + ".getColumnInfo(" + parentClassName + "." + DBColumnName + ")," + DbGenerateClasses.convertToString(memberName, colType) + ");}\n");
                }
                outputStream.println("\t}\n");
                outputStream.println("\tpublic boolean insert(DBConnection con) throws SQLException {\n");
                outputStream.println("\t\thtColsAndValues.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    colType = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType != 5) continue;
                    outputStream.print("\t\tif (this." + memberName + "_str != null) this." + memberName + " = Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("this." + memberName + "_str);\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (this." + member + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(keyType)) + "){");
                    outputStream.println("\t\t\tthrow new SQLException(\"ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtColsAndValues.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + DbGenerateClasses.convertToString(member, (short)Integer.parseInt(keyType)) + ");");
                }
                outputStream.println("\t\tthis.setNonKeyValues(htColsAndValues);\n");
                outputStream.println("\t\treturn DBQueryAssistant.performInsert(TABLE_NM, con, htColsAndValues);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic boolean insert(DBConnection con, Hashtable htinput) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType7 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType7));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType7 != 5) continue;
                    outputStream.print("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtinput.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")) == null) {");
                    outputStream.println("\t\t\tthrow new SQLException(\" ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                }
                outputStream.println("\t\treturn DBQueryAssistant.performInsert(TABLE_NM, con, htinput);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic int update(DBConnection con) throws SQLException {\n");
                outputStream.println("\t\thtColsAndValues.clear();\n");
                outputStream.println("\t\thtWhereClause.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType8 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType8));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType8 != 5) continue;
                    outputStream.print("\t\tif (this." + memberName + "_str != null) this." + memberName + " = Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("this." + memberName + "_str);\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (this." + member + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(keyType)) + "){");
                    outputStream.println("\t\t\tthrow new SQLException(\"ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + DbGenerateClasses.convertToString(member, (short)Integer.parseInt(keyType)) + ");");
                }
                outputStream.println("\t\tthis.setNonKeyValues(htColsAndValues);\n");
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htColsAndValues, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic int update(DBConnection con, Hashtable htinput) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                outputStream.println("\t\thtWhereClause.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType9 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType9));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType9 != 5) continue;
                    outputStream.print("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtinput.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")) == null) {");
                    outputStream.println("\t\t\tthrow new SQLException(\" ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + "htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")));\n");
                }
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htinput, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic int delete(DBConnection con) throws SQLException {\n");
                outputStream.println("\t\thtWhereClause.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType10 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType10));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType10 != 5) continue;
                    outputStream.print("\t\tif (this." + memberName + "_str != null) this." + memberName + " = Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("this." + memberName + "_str);\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (this." + member + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(keyType)) + "){");
                    outputStream.println("\t\t\tthrow new SQLException(\"ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + DbGenerateClasses.convertToString(member, (short)Integer.parseInt(keyType)) + ");");
                }
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic int delete(DBConnection con, Hashtable htinput) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                outputStream.println("\t\thtWhereClause.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType11 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType11));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType11 != 5) continue;
                    outputStream.print("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtinput.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")) == null) {");
                    outputStream.println("\t\t\tthrow new SQLException(\" ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + "htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")));");
                }
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic boolean retrieve(DBConnection con) throws SQLException {\n");
                outputStream.println("\t\thtWhereClause.clear();\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType12 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType12));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType12 != 5) continue;
                    outputStream.print("\t\tif (this." + memberName + "_str != null) this." + memberName + " = Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("this." + memberName + "_str);\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (this." + member + " == " + DbGenerateClasses.invalidValueString((short)Integer.parseInt(keyType)) + "){");
                    outputStream.println("\t\t\tthrow new SQLException(\"ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + DbGenerateClasses.convertToString(member, (short)Integer.parseInt(keyType)) + ");");
                }
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\tDBResultSet DBrs = null;");
                outputStream.println("\t\tboolean res = false;");
                outputStream.println("\t\ttry {");
                outputStream.println("\t\t\tDBrs = DBQueryAssistant.performRetrieve(TABLE_NM, con, htWhereClause, null);");
                outputStream.println("\t\t\tif (DBrs.next()) { setFields(con, DBrs); res = true; }");
                outputStream.println("\t\t}");
                outputStream.println("\t\tfinally {");
                outputStream.println("\t\t\tif (DBrs != null) { DBrs.getStatement().close(); }");
                outputStream.println("\t\t}");
                outputStream.println("\t\treturn res;");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static " + objClassName + " retrieve(DBConnection con, Hashtable htinput) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htinput == null) throw new SQLException(\"ERROR invalid input\");");
                outputStream.println("\t\tHashtable htWhereClause = new Hashtable();");
                outputStream.println("\t\t" + objClassName + " el = null;");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType13 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType13));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType13 != 5) continue;
                    outputStream.print("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtinput.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                for (i = 0; i < keyVec.size(); ++i) {
                    keyName = (String)keyVec.elementAt(i);
                    member = (String)keyHash.get(keyName);
                    String keyType = (String)keyTypeHash.get(keyName);
                    outputStream.println("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")) == null) {");
                    outputStream.println("\t\t\tthrow new SQLException(\" ERROR: key " + keyName + " not found\");");
                    outputStream.println("\t\t}\n");
                    outputStream.println("\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + keyName + ")," + "htinput.get(getColumnInfo(" + parentClassName + "." + keyName + ")));");
                }
                outputStream.println("\t\tif (htWhereClause.size() == 0) throw new SQLException(\"Method does not work as no primary keys are specified for this table\");");
                outputStream.println("\t\tDBResultSet DBrs = null;");
                outputStream.println("\t\ttry {");
                outputStream.println("\t\t\tDBrs = DBQueryAssistant.performRetrieve(TABLE_NM, con, htWhereClause, null);");
                outputStream.println("\t\t\tif (DBrs.next()) { el = new " + objClassName + "(); el.setFields(con, DBrs); }");
                outputStream.println("\t\t}");
                outputStream.println("\t\tfinally {");
                outputStream.println("\t\t\tif (DBrs != null) { DBrs.getStatement().close(); }");
                outputStream.println("\t\t}");
                outputStream.println("\t\treturn el;");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htinput == null || htWhereClause == null) throw new SQLException(\"ERROR invalid input\");");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType14 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType14));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType14 != 5) continue;
                    outputStream.print("\t\tif (htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtinput.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htinput.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType15 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType15));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType15 != 5) continue;
                    outputStream.print("\t\tif (htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                outputStream.println("\t\treturn DBQueryAssistant.performUpdate(TABLE_NM, con, htinput, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {\n");
                outputStream.println("\t\tif (con == null || htWhereClause == null) throw new SQLException(\"ERROR invalid input\");");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType16 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.trimTypeString(DbGenerateClasses.sqlTypeToJavaTypeString(colType16));
                    memberName = "m_" + columnName;
                    if (normalHash.get(DBColumnName) == null || normalTableHash.get(TableNames[argCounter]) != null || colType16 != 5) continue;
                    outputStream.print("\t\tif (htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")) != null)\n");
                    outputStream.print("\t\t\thtWhereClause.put(getColumnInfo(" + parentClassName + "." + DBColumnName + "), String.valueOf(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetID(con, ");
                    outputStream.print("(String)htWhereClause.get(getColumnInfo(" + parentClassName + "." + DBColumnName + ")))));\n\n");
                }
                outputStream.println("\t\treturn DBQueryAssistant.performDelete(TABLE_NM, con, htWhereClause);");
                outputStream.println("\t}\n");
                outputStream.println("\tprotected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {\n");
                for (i = 0; i < colVec.size(); ++i) {
                    DBColumnName = (String)colVec.elementAt(i);
                    columnName = DbGenerateClasses.columnNameToMemberName(DBColumnName);
                    short colType17 = Short.parseShort((String)colTypeHash.get(DBColumnName));
                    javaTypeString = DbGenerateClasses.sqlTypeToJavaTypeCapString(colType17);
                    memberName = "m_" + columnName;
                    outputStream.println("\t\tthis.set" + columnName + "(DBrs.get" + javaTypeString + "(" + parentClassName + "." + DBColumnName + "));");
                    if (normalHash.get(DBColumnName) != null && normalTableHash.get(TableNames[argCounter]) == null && colType17 == 5) {
                        outputStream.println("\t\tthis.set" + columnName.substring(0, columnName.length() - 2) + "(Normalizer." + columnName.substring(0, columnName.length() - 2) + "GetName(con, this." + memberName + "));");
                    }
                    if (i != colVec.size() - 1) continue;
                    outputStream.println("\t}\n");
                }
                outputStream.println("}\n");
                outputStream.close();
                fileName = "Sql" + objClassName + ".java";
                System.out.println("Writing sql class: " + fileName);
                outputFile = new File(location + "\\sql\\" + fileName);
                fileOutput = new FileOutputStream(outputFile);
                outputStream = new PrintWriter(fileOutput);
                DbGenerateClasses.printHeader(outputStream, "Sql" + objClassName);
                outputStream.println("package org.eclipse.aperi.infrastructure.database.sql;\n");
                outputStream.println("import java.sql.SQLException;\n");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.ComplexQuery;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBResultSet;");
                outputStream.println("import org.eclipse.aperi.infrastructure.database.DBConnection;\n");
                outputStream.println("import java.util.Hashtable;\n");
                outputStream.println("public class Sql" + objClassName + " {\n");
                outputStream.println("//This is a auto-generated comment: please do not touch");
                outputStream.println("//Please add your query to sqlArray and index it with a integer public variable");
                outputStream.println("//An example is shown below:");
                outputStream.println("//\tpublic static int maxSizeQuery = 0;");
                outputStream.println("//\tpublic static int minSizeQuery = 1;");
                outputStream.println("//\tprivate static String sqlArray[] = { \"SELECT MAX(CAPACITY) FROM STORAGE_VOLUME\",\n//\t\t\"SELECT MIN(CAPACITY) FROM STORAGE_VOLUME\" };");
                outputStream.println("//Please do NOT modify a checked-in query as someone else may use it -- create a new one\n\n");
                outputStream.println("\tprivate static String sqlArray[] = {}; \n");
                outputStream.println("\tpublic static int sqlUpdate(DBConnection con, int sqlIndex, Hashtable params) throws SQLException {");
                outputStream.println("\t\treturn ComplexQuery.sqlUpdate(con, sqlArray[sqlIndex], params);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static DBResultSet sqlQuery(DBConnection con, int sqlIndex, Hashtable params) throws SQLException {");
                outputStream.println("\t\treturn ComplexQuery.sqlQuery(con, sqlArray[sqlIndex], params);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static int sqlUpdate(DBConnection con, int sqlIndex, String concat, Hashtable params) throws SQLException {");
                outputStream.println("\t\treturn ComplexQuery.sqlUpdate(con, sqlArray[sqlIndex] + concat, params);");
                outputStream.println("\t}\n");
                outputStream.println("\tpublic static DBResultSet sqlQuery(DBConnection con, int sqlIndex, String concat, Hashtable params) throws SQLException {");
                outputStream.println("\t\treturn ComplexQuery.sqlQuery(con, sqlArray[sqlIndex] + concat, params);");
                outputStream.println("\t}\n");
                outputStream.println("}\n");
                outputStream.close();
                System.out.println("\n");
            }
            con.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: exception caught: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

