/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.ReusableObjectPool;

public class LockResource
implements Serializable,
Cloneable,
Packable {
    static final long serialVersionUID = -4938072426549870056L;
    public LockResource lrsNext;
    public short lrsProductID;
    public String lrsResource;
    public LockRequestor lrsHolders;
    public LockRequestor lrsWaitersHead;
    public transient LockRequestor lrsWaitersTail;
    private Packable[] lrsHoldersPacked;
    private Packable[] lrsWaitersPacked;
    public static final int MAX_PRODUCTS = 5;
    public static final short TSTORM = 0;
    public static final short TTIME = 1;
    public static final short SERVER = 2;
    public static final short DB = 3;
    public static final short NAS = 4;
    public static final String[] productName = new String[]{"T-Storm", "T-Time", "Server", "Db", "Nas"};
    private static ReusableObjectPool pool = new ReusableObjectPool(30);

    public static LockResource getLockResource(short productID, String resource) {
        LockResource lrs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockResource.class.getName(), "getLockResource", "productID, resource");
        }
        if ((lrs = (LockResource)pool.getObject()) == null) {
            lrs = new LockResource();
        }
        lrs.lrsProductID = productID;
        lrs.lrsResource = resource;
        LockResource traceResult = lrs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockResource.class.getName(), "getLockResource", traceResult);
        }
        return traceResult;
    }

    public void returnLockResource() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockResource.class.getName(), "returnLockResource", "");
        }
        this.lrsNext = null;
        this.lrsResource = null;
        this.lrsWaitersHead = null;
        this.lrsWaitersTail = null;
        this.lrsHolders = null;
        pool.returnObject(this);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockResource.class.getName(), "returnLockResource");
        }
    }

    public Object clone() {
        LockResource copy = LockResource.getLockResource(this.lrsProductID, this.lrsResource);
        copy.lrsHolders = this.cloneRequestors(this.lrsHolders);
        copy.lrsWaitersHead = this.cloneRequestors(this.lrsWaitersHead);
        return copy;
    }

    public LockRequestor cloneRequestors(LockRequestor sourceList) {
        LockRequestor copyList = null;
        LockRequestor prevCopy = null;
        while (sourceList != null) {
            LockRequestor copy = (LockRequestor)sourceList.clone();
            if (prevCopy == null) {
                copyList = copy;
            } else {
                prevCopy.lrqNext = copy;
            }
            prevCopy = copy;
            sourceList = sourceList.lrqNext;
        }
        return copyList;
    }

    public static LockResource[] pack(LockResource head) {
        LockResource node = head;
        while (node != null) {
            node.lrsHoldersPacked = (Packable[])Packer.pack(node.lrsHolders);
            node.lrsWaitersPacked = (Packable[])Packer.pack(node.lrsWaitersHead);
            node = node.lrsNext;
        }
        return (LockResource[])Packer.pack(head);
    }

    public static LockResource unpack(LockResource[] array) {
        LockResource head;
        LockResource node = head = (LockResource)Packer.unpack(array);
        while (node != null) {
            node.lrsHolders = (LockRequestor)Packer.unpack(node.lrsHoldersPacked);
            node.lrsWaitersHead = (LockRequestor)Packer.unpack(node.lrsWaitersPacked);
            node = node.lrsNext;
        }
        return head;
    }

    public Packable getNext() {
        return this.lrsNext;
    }

    public void setNext(Packable next) {
        this.lrsNext = (LockResource)next;
    }
}

