/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Calendar;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintOptions
implements Serializable {
    static final long serialVersionUID = -3533266123877784522L;
    public static final byte PRINTER = 1;
    public static final byte PDF = 2;
    public static final byte HTML = 3;
    public static final byte PS = 4;
    public static final byte PCL = 5;
    public static final byte SCREEN = 6;
    public static final byte CSV = 7;
    public static final byte FORMATTED = 8;
    public static final byte PORTRAIT = 1;
    public static final byte LANDSCAPE = 2;
    public static final byte LETTER = 1;
    public static final byte A4 = 2;
    public Object printer;
    public FileOutputStream outFile;
    public byte outputType;
    public byte orientation;
    public byte size = 1;
    public boolean includeHeaders;
    public boolean includeTotals;
    public String creator;
    public String title;
    public String fileMask;
    public String fileName;
    public boolean partialLandscape;
    public int defaultWidth;
    public int defaultHeight;
    public transient AperiChart htmlChart;

    public void printTitle(FileOutputStream fos) {
        String createdBy = MessageLog.getMessageNoID("GEN0192L");
        String printed = MessageLog.getMessageNoID("GEN0193L");
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (Exception e1) {
            GuiUtil.displayErrorMessage(e1.getMessage());
        }
        writer = new PrintWriter((Writer)osw, true);
        if (writer != null) {
            writer.println("<html>");
            if (this.title != null) {
                writer.println(this.title);
                writer.println("");
            }
            if (this.creator != null) {
                writer.println(createdBy + " " + this.creator + "      " + printed + " " + Util.formatDateTime(Calendar.getInstance().getTime()));
                writer.println("");
            }
        }
    }
}

