/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;

public class SoftwareVersion
implements Serializable,
Comparable {
    static final long serialVersionUID = 2952212367749539552L;
    private static final int VENDOR_MULTIPLIER = 10000000;
    private static final int VERSION_MULTIPLIER = 1000000;
    private static final int RELEASE_MULTIPLIER = 10000;
    private static final int MODIFICATION_MULTIPLIER = 100;
    public static final int VERSION_2_1_0 = SoftwareVersion.encode(2, 1, 0);
    public static final int VERSION_1_4_0 = SoftwareVersion.encode(1, 4, 0);
    public static final int VERSION_1_3_3 = SoftwareVersion.encode(1, 3, 3);
    public static final int VERSION_2_2_1 = SoftwareVersion.encode(2, 2, 1);
    public SoftwareVersion svNext;
    public byte svVersion = 0;
    public byte svRelease = 0;
    public short svModification = 0;
    public byte svVendor = 0;
    public short svSubModification = 0;
    public static final byte APERI = 0;
    public static final byte IBM = 1;

    public static byte getVendor() {
        return 0;
    }

    public SoftwareVersion(byte version, byte release, short modification, short submodification, byte vendor) {
        this.svVersion = version;
        this.svRelease = release;
        this.svModification = modification;
        this.svSubModification = submodification;
        this.svVendor = vendor;
    }

    public SoftwareVersion() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        buf.append(Byte.toString(this.svVersion));
        buf.append('.');
        buf.append(Byte.toString(this.svRelease));
        buf.append('.');
        buf.append(Short.toString(this.svModification));
        return buf.toString();
    }

    public int compareTo(Object pRight) {
        SoftwareVersion right = (SoftwareVersion)pRight;
        int x = this.svVendor - right.svVendor;
        if (x == 0 && (x = this.svVersion - right.svVersion) == 0 && (x = this.svRelease - right.svRelease) == 0 && (x = this.svModification - right.svModification) == 0) {
            x = this.svSubModification - right.svSubModification;
        }
        return x;
    }

    public boolean equals(Object pOther) {
        return this.compareTo(pOther) == 0;
    }

    public static int encode(int vendor, int version, int release, int modification, int submodification) {
        return vendor * 10000000 + version * 1000000 + release * 10000 + modification * 100 + submodification;
    }

    public static int encode(int version, int release, int modification) {
        return SoftwareVersion.encode(0, version, release, modification, 0);
    }

    public static String decode(int encodedVersion) {
        StringBuffer buffer = new StringBuffer();
        int vrm = encodedVersion % 10000000;
        buffer.append(encodedVersion / 10000000);
        buffer.append('.');
        int releaseAndModification = vrm % 1000000;
        buffer.append(vrm / 1000000);
        buffer.append('.');
        int modAndSubmod = releaseAndModification % 10000;
        buffer.append(releaseAndModification / 10000);
        buffer.append('.');
        int submod = modAndSubmod % 100;
        buffer.append(modAndSubmod / 100);
        buffer.append('.');
        buffer.append(submod);
        return buffer.toString();
    }

    public static SoftwareVersion decodeToSV(int encodedVersion) {
        SoftwareVersion sv = new SoftwareVersion();
        int vrm = encodedVersion % 10000000;
        sv.svVendor = (byte)(encodedVersion / 10000000);
        int releaseAndModification = vrm % 1000000;
        sv.svVersion = (byte)(vrm / 1000000);
        int modAndSubmod = releaseAndModification % 10000;
        sv.svRelease = (byte)(releaseAndModification / 10000);
        int submod = modAndSubmod % 100;
        sv.svModification = (short)(modAndSubmod / 100);
        sv.svSubModification = (short)submod;
        return sv;
    }
}

