/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;

public class AsyncResult
extends Result {
    static final long serialVersionUID = -8141904872480418282L;
    public static final int WAITING = -2;
    public static final int SUBMITTED = -1;
    public static final int FAILED = 0;
    public static final int SUCCESSFUL = 1;
    public static final int RUNNING = 2;
    public static final int WARNING = 3;
    public static final int PARTIAL_FAILURE = 4;
    public static final int CANCELLED = 5;
    protected String jobId = "-1";
    protected int status = 1;
    protected Exception returnException = null;
    protected AsyncResult[] subJobResults = null;

    public AsyncResult() {
    }

    public AsyncResult(int rc) {
        this.rc = rc;
    }

    public AsyncResult(int rc, int status) {
        this.rc = rc;
        this.status = status;
    }

    public AsyncResult(int rc, int status, SRMMessage msg) {
        this.rc = rc;
        this.status = status;
        this.msg = msg;
    }

    public Exception getReturnException() {
        return this.returnException;
    }

    public int getStatus() {
        return this.status;
    }

    public void setReturnException(Exception exception) {
        this.returnException = exception;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public AsyncResult[] getSubJobResults() {
        return this.subJobResults;
    }

    public void setSubJobResults(AsyncResult[] results) {
        this.subJobResults = results;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String i) {
        this.jobId = i;
    }

    public String toString() {
        int i;
        String text = System.getProperty("line.separator") + "AsyncResult@" + Integer.toHexString(this.hashCode()) + ":" + System.getProperty("line.separator") + " Status=" + this.status + ", JobId =" + this.jobId + ", ReturnCode=" + this.rc + ",";
        text = text + (this.msg == null ? "" : System.getProperty("line.separator") + " Message=" + this.getMessage().toString());
        text = text + (this.returnException == null ? "" : System.getProperty("line.separator") + " ReturnException = " + this.returnException.toString());
        if (this.results != null) {
            text = text + System.getProperty("line.separator") + " Results:";
            for (i = 0; i < this.results.length; ++i) {
                if (this.results[i] == null) continue;
                text = text + System.getProperty("line.separator") + this.results[i].toString();
            }
        }
        if (this.subJobResults != null) {
            text = text + System.getProperty("line.separator") + " SubJobResults:";
            for (i = 0; i < this.subJobResults.length; ++i) {
                text = text + System.getProperty("line.separator") + this.subJobResults[i].toString();
            }
        }
        return text;
    }
}

