/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.dbaccess;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.dbaccess.FabricDBConstants;
import org.eclipse.aperi.fabric.api.DataPath;
import org.eclipse.aperi.fabric.api.DeviceAgent;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.FabricScanner;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Cluster;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.util.SRMCrypto;

public class FabricDbAccess {
    static final String TRACE_NAME = "aperi.logger.trace.FabricAccess";
    private static ILogger traceLogger = null;
    static final String className = FabricDbAccess.class.getName();
    public static final String PORT_TO_P2P_CMP = " (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2) ";
    public static final String P2P_IDS_TO_S2P_ID_CMP = " (P2P.PORT_ID1 = S2P.PORT_ID OR P2P.PORT_ID2 = S2P.PORT_ID) ";
    public static final String S2P_SWWN_TO_F2S_SWWN_CMP = " S2P.SWITCH_WWN = F2S.SWITCH_WWN ";
    public static final String F2S_WWN_TO_FABRIC_WWN_CMP = "  F2S.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SWITCH_PORT_NAME = " case when SWITCH.DOMAIN is not null and SWITCH.DOMAIN !='' then SWITCH.DOMAIN || ',' || P1.PORT_NUMBER else P1.NAME end ";
    public static final String SWITCH2PORT_FILTER = " (S2P.DETECTABLE = 1 or (S2P.Detectable = 0 and Port.Detectable = 0)) ";
    public static final String SWITCH2P1_FILTER = " (S2P.DETECTABLE = 1 or (S2P.Detectable = 0 and P1.Detectable = 0)) ";
    public static final String SWITCH2P2_FILTER = " (S2P2.DETECTABLE = 1 or (S2P2.Detectable = 0 and P2.Detectable = 0)) ";
    public static String DEAD_END_NODES;
    public static String DEAD_END_PORTS;
    public static final String SAN_ASSETS_ALL;
    public static final String SAN_ASSETS_SWITCHES = "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end , 0 , 0  as TYPE,  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end , SWITCH.IP_ADDRESS, VENDOR.VENDOR_NAME, MODEL.MODEL_NAME, SWITCH.VERSION, SWITCH.SERIAL_NUMBER, SWITCH.SWITCH_ID, SWITCH.MANAGEMENT_ID, SWITCH.MGMT_URL_ADDR, SWITCH.DOMAIN, SWITCH.CONTACT, SWITCH.SWITCH_WWN, SWITCH.LOCATION, SWITCH.PARENT_SWITCH_WWN from T_RES_SWITCH as SWITCH left outer join T_RES_FABRIC2SWITCH as F2S on (SWITCH.SWITCH_WWN = F2S.SWITCH_WWN) left outer join T_RES_FABRIC as FABRIC on (F2S.FABRIC_WWN = FABRIC.FABRIC_WWN), T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL where SWITCH.VENDOR_ID = VENDOR.VENDOR_ID and SWITCH.MODEL_ID = MODEL.MODEL_ID and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1) or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))";
    public static final String SAN_ASSETS_CONNECTED_DEV;
    public static final String PORT_CONNECTIONS;
    public static final String GET_HBA_TABLE_INFO_STRING;
    public static final String REQ_GET_INFO_STRING = "SELECT T_RES_DEVICE_AGENT.DEVICE_AGENT_ID, T_RES_DEVICE_AGENT.STATUS, T_RES_HOST.IP_ADDRESS, T_RES_HOST.HOST_NAME, T_RES_HOST.OS_TYPE, T_STAT_COMPUTER.OS_VERSION FROM T_RES_DEVICE_AGENT AS T_RES_DEVICE_AGENT, T_RES_HOST AS T_RES_HOST LEFT OUTER JOIN T_STAT_COMPUTER AS T_STAT_COMPUTER ON ( T_STAT_COMPUTER.COMPUTER_ID = T_RES_HOST.COMPUTER_ID ) WHERE T_RES_DEVICE_AGENT.HOST_ID = T_RES_HOST.COMPUTER_ID AND T_RES_DEVICE_AGENT.DEVICE_AGENT_ID=";
    public static final String REQ_REMOVE_AGENT_STRING = "select host_id from t_res_device_agent where device_agent_id = ";
    public static final String REMOVE_DEVICE_AGENT_STRING = "delete from t_res_device_agent where device_agent_id = ";
    public static final String REQ_CHECK_AGENT_STRING = "SELECT T_RES_DEVICE_AGENT.STATUS, T_RES_HOST.COMPUTER_ID FROM T_RES_DEVICE_AGENT AS T_RES_DEVICE_AGENT, T_RES_HOST AS T_RES_HOST WHERE T_RES_DEVICE_AGENT.HOST_ID = T_RES_HOST.COMPUTER_ID AND T_RES_DEVICE_AGENT.DEVICE_AGENT_ID = ";

    /*
     * Loose catch block
     */
    public static String[] getFabrics(HashMap attributes) throws Exception {
        ArrayList<Object> fabricIds;
        String methodName;
        block24: {
            Exception e2;
            Fabric.FabricCursor cursor;
            DBConnection connection;
            block23: {
                methodName = "getFabrics";
                String input = null;
                if (attributes != null) {
                    input = "attributes: " + attributes.toString();
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, input);
                }
                fabricIds = new ArrayList<Object>();
                connection = ServiceUtils.getConnection();
                cursor = null;
                Hashtable htWhereClause = null;
                if (attributes != null) {
                    Iterator it = attributes.keySet().iterator();
                    if (it.hasNext()) {
                        htWhereClause = new Hashtable();
                    }
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        htWhereClause.put(Fabric.getColumnInfo(key), attributes.get(key));
                    }
                }
                Vector<String> attribs = new Vector<String>(1);
                attribs.add("FABRIC_WWN");
                cursor = Fabric.getCursor(connection, htWhereClause, attribs);
                while (cursor.next()) {
                    Object[] ids = cursor.getAttribute(attribs);
                    fabricIds.add(ids[0]);
                }
                connection.commit();
                Object var10_10 = null;
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e2) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block23;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block24;
            }
            catch (Exception e2) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                }
                break block24;
            }
            {
                catch (Exception e3) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e3);
                    }
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                block26: {
                    block25: {
                        Object var10_11 = null;
                        try {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                        catch (Exception e2) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block25;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e2) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block26;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricIds.toString());
        }
        return fabricIds.toArray(new String[0]);
    }

    public static HashMap[] getFabricAttributes(String[] fabricIDs, String[] attribList) throws Exception {
        String methodName = "getFabricAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.FABRIC_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Fabric.", "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end ", methodName);
        HashMap[] attribArray = new HashMap[fabricIDs.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_FABRIC as Fabric" + " where " + "FABRIC_WWN" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < fabricIDs.length; ++i) {
            String query = attrQuery + "'" + fabricIDs[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "fabricID = " + fabricIDs[i]);
            }
            HashMap[] fabricAttribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = fabricAttribs[0];
        }
        return attribArray;
    }

    public static SNMPAgent[] getOutbandAgents(String ipAddress) throws Exception {
        String methodName = "getOutbandAgents";
        SNMPAgent[] agents = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, ipAddress);
        }
        String[] attribList = new String[]{"community", "community_rw", "user1", "ipadd", "enabled", "password", "host"};
        String query = "select max(scanner.enabled) as enabled, iptarget.ip_address as ipadd, iptarget.HOST_NAME as host, iptarget.READ_COMMUNITY_NAME as community, iptarget.RW_COMMUNITY_NAME as community_rw,iptarget.USER_ID as user1, iptarget.PASSWORD as password from T_Res_Scanner scanner right outer join t_res_Ip_target iptarget on iptarget.ip_address = scanner.agent_name ";
        if (ipAddress != null && !ipAddress.equals("")) {
            query = query + "where iptarget.ip_address = '" + ipAddress + "' ";
        }
        query = query + "group by iptarget.ip_address, iptarget.password, iptarget.host_name, " + "iptarget.user_id, iptarget.read_community_name,iptarget.rw_community_name";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        agents = new SNMPAgent[attribArray.length];
        if (attribArray != null && attribArray.length > 0) {
            for (int i = 0; i < attribArray.length; ++i) {
                String password;
                HashMap currAgent = attribArray[i];
                Integer enableInt = (Integer)currAgent.get("enabled");
                int enabled = -1;
                if (enableInt != null) {
                    enabled = enableInt;
                }
                if ((password = (String)currAgent.get("password")) != null && !password.equals("")) {
                    password = SRMCrypto.decrypt(password);
                }
                agents[i] = new SNMPAgent((String)currAgent.get("ipadd"), (String)currAgent.get("host"), (String)currAgent.get("community"), (String)currAgent.get("community_rw"), (String)currAgent.get("user"), password, enabled);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, agents.toString());
        }
        return agents;
    }

    /*
     * Loose catch block
     */
    public static String[] getComputers(HashMap attributes) throws Exception {
        ArrayList<Object> computerIds;
        String methodName;
        block23: {
            Exception e2;
            Host.HostCursor cursor;
            DBConnection connection;
            block22: {
                methodName = "getComputers";
                String input = null;
                if (attributes != null) {
                    input = "attributes: " + attributes.toString();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, input);
                }
                computerIds = new ArrayList<Object>();
                connection = ServiceUtils.getConnection();
                cursor = null;
                Hashtable htWhereClause = new Hashtable();
                if (attributes != null) {
                    for (String key : attributes.keySet()) {
                        htWhereClause.put(Host.getColumnInfo(key), attributes.get(key));
                    }
                }
                Vector<String> attribs = new Vector<String>(1);
                attribs.add("HOST_URL");
                cursor = Host.getCursor(connection, htWhereClause, attribs);
                while (cursor.next()) {
                    Object[] ids = cursor.getAttribute(attribs);
                    computerIds.add(ids[0]);
                }
                connection.commit();
                Object var10_10 = null;
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e2) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block22;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block23;
            }
            catch (Exception e2) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                }
                break block23;
            }
            {
                catch (Exception e3) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e3);
                    }
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    block24: {
                        Object var10_11 = null;
                        try {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                        catch (Exception e2) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block24;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e2) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block25;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, computerIds.toString());
        }
        return computerIds.toArray(new String[0]);
    }

    public static HashMap[] getComputerAttributes(String[] computerNames, String[] attribList) throws Exception {
        String methodName = "getComputerAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.COMPUTER_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Host.", " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end ", methodName);
        HashMap[] attribArray = new HashMap[computerNames.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_HOST as Host" + " where " + "HOST_URL" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < computerNames.length; ++i) {
            String query = attrQuery + "'" + computerNames[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "computerName = " + computerNames[i]);
            }
            HashMap[] computerAttribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = computerAttribs[0];
        }
        return attribArray;
    }

    public static String[] getPortsForComputer(String computerName, HashMap attributes) throws Exception {
        String methodName = "getPortsForComputer";
        String query = "Select distinct PORT.NAME PORT_WWN from T_RES_HOST HOST, T_RES_HBA HBA, T_RES_NODE2HBA NODE2HBA, T_RES_NODE NODE, T_RES_PORT PORT where      HOST.COMPUTER_ID = HBA.HOST_ID and       HBA.HBA_ID = NODE2HBA.HBA_ID and       NODE2HBA.NODE_ID = NODE.NODE_ID and       NODE.NODE_ID = PORT.NODE_ID and      HOST.HOST_URL = '" + computerName + "'";
        if (attributes != null && !attributes.isEmpty()) {
            Iterator it = attributes.keySet().iterator();
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)attributes.get(key);
                ColumnInfo colinfo = Port.getColumnInfo(key);
                if (colinfo == null || value == null) continue;
                htWhereClause.put(colinfo, value);
            }
            String attribWhereClause = FabricDbAccess.createAttribWhereClause(htWhereClause, "Port.", methodName);
            query = query + " AND " + attribWhereClause;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "PORT_WWN", methodName);
        return portIds;
    }

    public static String[] getSwitches(String fabricID, HashMap attributes) throws Exception {
        String methodName = "getSwitches";
        String attributestr = null;
        if (attributes != null) {
            attributestr = "attributes: " + attributes.toString();
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, attributestr);
        }
        String query = "";
        if (attributes == null || attributes.isEmpty()) {
            query = fabricID == null || fabricID.equals("") ? "Select distinct SWITCH_WWN from T_RES_SWITCH" : "Select distinct SWITCH_WWN from T_RES_FABRIC2SWITCH F2S where  FABRIC_WWN='" + fabricID + "'";
        } else {
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            query = fabricID == null || fabricID.equals("") ? "Select SWITCH.SWITCH_WWN as SWITCH_WWN from T_RES_SWITCH SWITCH where " : "Select SWITCH.SWITCH_WWN as SWITCH_WWN from T_RES_FABRIC2SWITCH F2S, T_RES_SWITCH SWITCH where  F2S.FABRIC_WWN='" + fabricID + "' and " + "F2S.SWITCH_WWN = SWITCH.SWITCH_WWN";
            for (String key : attributes.keySet()) {
                String value = (String)attributes.get(key);
                ColumnInfo colinfo = Switch.getColumnInfo(key);
                if (colinfo == null || value == null) continue;
                htWhereClause.put(colinfo, value);
            }
            String attribWhereClause = FabricDbAccess.createAttribWhereClause(htWhereClause, "Switch.", methodName);
            query = query + " and " + attribWhereClause;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] switchIds = FabricDbAccess.getIds(query, "SWITCH_WWN", methodName);
        return switchIds;
    }

    public static HashMap[] getSwitchAttributes(String[] switchIDs, String[] attribList) throws Exception {
        String methodName = "getSwitchAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.SWITCH_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Switch.", "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end ", methodName);
        HashMap[] attribArray = new HashMap[switchIDs.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_SWITCH as Switch" + " where " + "SWITCH_WWN" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < switchIDs.length; ++i) {
            String query = attrQuery + "'" + switchIDs[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "switchID= " + switchIDs[i]);
            }
            HashMap[] switchAttribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = switchAttribs[0];
        }
        return attribArray;
    }

    public static HashMap[] getSwitchConnections(String fabricWWN) throws Exception {
        String methodName = "getSwitchConnections";
        String[] attribList = new String[]{"SWITCHNAME", "SWITCHWWN", "DOMAIN", "SWITCHPORTWWN", "PORTPHY", "EPFCID", "EPPORTTYPE", "EPPORTWWN", "PORTSTATE", "SWITCH2PORTSTATE", "FABRIC2SWITCHSTATE"};
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "fabricWWN: " + fabricWWN);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.SWITCH_ATTRS;
        }
        String query = "SELECT   case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end  as SWITCHNAME, SWITCH.SWITCH_WWN as SWITCHWWN, SWITCH.DOMAIN as DOMAIN, P1.NAME as SWITCHPORTWWN, P1.PORT_NUMBER as PORTPHY, P2.FC_PORT_ID as EPFCID, P2.TYPE as EPPORTTYPE, P2.NAME as EPPORTWWN, F2S.DETECTABLE as FABRIC2SWITCHSTATE, S2P.DETECTABLE as SWITCH2PORTSTATE, P1.DETECTABLE as PORTSTATE FROM T_RES_FABRIC2SWITCH as F2S join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN) join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN) join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID) left outer join T_RES_PORT2PORT as P2P on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2) left outer join T_RES_PORT as P2 on (not (P2.PORT_ID = P1.PORT_ID) and not (P2.PORT_ID = S2P.PORT_ID) and (P2.PORT_ID = P2P.PORT_ID1 or P2.PORT_ID = P2P.PORT_ID2)) where F2S.FABRIC_WWN = '" + fabricWWN + "' ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static String[] getPortsForSwitch(String switchID, HashMap attributes) throws Exception {
        String methodName = "getPortsForSwitch";
        String query = "Select Port.NAME as PORT_WWN from T_RES_SWITCH2PORT as S2P, T_RES_PORT as Port where S2P.SWITCH_WWN='" + switchID + "' and " + "S2P." + "PORT_ID = " + "Port." + "PORT_ID";
        if (attributes != null && !attributes.isEmpty()) {
            Iterator it = attributes.keySet().iterator();
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)attributes.get(key);
                ColumnInfo colinfo = Port.getColumnInfo(key);
                if (colinfo == null || value == null) continue;
                htWhereClause.put(colinfo, value);
            }
            String attribWhereClause = FabricDbAccess.createAttribWhereClause(htWhereClause, "Port.", methodName);
            query = query + " and " + attribWhereClause;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "PORT_WWN", methodName);
        return portIds;
    }

    public static HashMap[] getPortAttributes(String[] portIDs, String[] attribList) throws Exception {
        String methodName = "getPortAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.PORT_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Port.", "       case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end ", methodName);
        HashMap[] attribArray = new HashMap[portIDs.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_PORT as Port" + " where " + "NAME" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < portIDs.length; ++i) {
            String query = attrQuery + "'" + portIDs[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "portID= " + portIDs[i]);
            }
            HashMap[] portAttribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = portAttribs[0];
        }
        return attribArray;
    }

    /*
     * Loose catch block
     */
    public static String[] getZoneSets(String fabricID, boolean activeOnly) throws Exception {
        ArrayList<Object> zoneSetIds;
        String methodName;
        block20: {
            Exception e2;
            Zset.ZsetCursor cursor;
            DBConnection connection;
            block19: {
                methodName = "getZoneSets";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, "activeOnly: " + activeOnly);
                }
                zoneSetIds = new ArrayList<Object>();
                connection = ServiceUtils.getConnection();
                cursor = null;
                Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
                htWhereClause.put(Zset.getColumnInfo("FABRIC_WWN"), fabricID);
                int activeVal = activeOnly ? 1 : 0;
                htWhereClause.put(Zset.getColumnInfo("ACTIVE"), String.valueOf(activeVal));
                Vector<String> attribs = new Vector<String>(1);
                attribs.add("ZSET_NAME");
                cursor = Zset.getCursor(connection, htWhereClause, attribs);
                while (cursor.next()) {
                    Object[] ids = cursor.getAttribute(attribs);
                    zoneSetIds.add(ids[0]);
                }
                connection.commit();
                Object var11_11 = null;
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (Exception e2) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block20;
            }
            catch (Exception e2) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                }
                break block20;
            }
            {
                catch (Exception e3) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e3);
                    }
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                block22: {
                    block21: {
                        Object var11_12 = null;
                        try {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                        catch (Exception e2) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block21;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing cursor: ", e2);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e2) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block22;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection: ", e2);
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, zoneSetIds.toString());
        }
        return zoneSetIds.toArray(new String[0]);
    }

    public static HashMap[] getZoneSetAttributes(String fabricID, String[] zonesetNames, boolean active, String[] attribList) throws Exception {
        String methodName = "getZoneSetAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.ZSET_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Zset.", null, methodName);
        int activeVal = active ? 1 : 0;
        HashMap[] attribArray = new HashMap[zonesetNames.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_Zset as Zset" + " where " + "FABRIC_WWN" + " = '" + fabricID + "' and " + "zset.active = " + activeVal + " and " + "ZSET_NAME" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < zonesetNames.length; ++i) {
            String query = attrQuery + "'" + zonesetNames[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "zoneset = " + zonesetNames[i]);
            }
            HashMap[] attribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = attribs[0];
        }
        return attribArray;
    }

    public static String[] getZones(String fabricID, String zonesetName, boolean activeOnly) throws Exception {
        String methodName = "getZones";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "fabricID: " + fabricID + "zonesetName: " + zonesetName);
        }
        String query = "";
        int activeVal = 0;
        if (activeOnly) {
            activeVal = 1;
        }
        query = zonesetName == null ? "Select distinct zone.zone_name as ZONE_NAME from T_RES_Zone zone where  zone.fabric_wwn ='" + fabricID + "'" : "Select distinct zone.zone_name as ZONE_NAME from T_RES_ZSET2Zone Z2Z, T_RES_Zone zone, T_RES_ZSET zset where  zset.zset_name ='" + zonesetName + "' and " + " zone.fabric_wwn ='" + fabricID + "' and " + " zset.fabric_wwn ='" + fabricID + "' and " + "z2z.zone_ID = zone.zone_ID" + " and " + "z2z.zset_ID = zset.zset_ID";
        query = query + " and zone.active = " + activeVal;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] zoneNames = FabricDbAccess.getIds(query, "ZONE_NAME", methodName);
        return zoneNames;
    }

    public static String[] getZonesAliases(String fabricID, String zoneName, boolean active) throws Exception {
        String methodName = "getZoneAliases";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "fabricID: " + fabricID + "zoneName: " + zoneName);
        }
        String query = "";
        int activeVal = 0;
        if (active) {
            activeVal = 1;
        }
        query = zoneName == null ? "Select distinct alias.alias_name as ALIAS_NAME,  alias.description as DESCRIPTION from T_RES_Alias alias where  alias.fabric_wwn ='" + fabricID + "'" : "Select distinct alias.alias_name as ALIAS_NAME,  alias.description as DESCRIPTION from T_RES_ZONE2ALIAS Z2A, T_RES_Zone zone, T_RES_ALIAS alias where  zone.zone_name ='" + zoneName + "' and " + " zone.fabric_wwn ='" + fabricID + "' and " + " zone.active = " + activeVal + " and alias.fabric_wwn ='" + fabricID + "' and " + "z2a.zone_ID = zone.zone_ID" + " and " + "z2a.alias_ID = alias.alias_ID";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] aliasNames = FabricDbAccess.getIds(query, "ALIAS_NAME", methodName);
        return aliasNames;
    }

    public static HashMap[] getZoneAttributes(String fabricID, String[] zoneNames, boolean active, String[] attribList) throws Exception {
        String methodName = "getZoneAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.ZONE_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Zone.", null, methodName);
        int activeVal = active ? 1 : 0;
        HashMap[] attribArray = new HashMap[zoneNames.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_ZONE as Zone" + " where " + "FABRIC_WWN" + " = '" + fabricID + "' and " + "zone.active = " + activeVal + " and " + "ZONE_NAME" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < zoneNames.length; ++i) {
            String query = attrQuery + "'" + zoneNames[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "zone = " + zoneNames[i]);
            }
            HashMap[] attribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = attribs[0];
        }
        return attribArray;
    }

    public static HashMap[] getZoneMembers(String fabricID, String zoneName, boolean active) throws Exception {
        String methodName = "getZoneMembers";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, "zoneName: " + zoneName + "active: " + active);
        }
        String[] attribList = new String[]{"NAME", "TYPE", "VENDOR_TYPE"};
        int activeVal = active ? 1 : 0;
        String query = "Select zmember.Member_name NAME, zmember.type TYPE, zmember.vendor_type VENDOR_TYPE from T_RES_Zone_Member ZMember, T_RES_Zone zone, T_RES_Zone2Member z2member  where  zone.zone_name ='" + zoneName + "' and " + " zone.fabric_wwn ='" + fabricID + "' and " + "zone.active = " + activeVal + " and " + "z2member.zone_ID = zone.zone_ID" + " and " + "z2member.zone_member_ID = zmember.zone_member_ID";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] members = FabricDbAccess.getAttributes(query, attribList, methodName);
        return members;
    }

    public static HashMap[] getZoneMembersInZoneAlias(String fabricID, String zoneAliasName) throws Exception {
        String methodName = "getZoneMembersInZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        String[] attribList = new String[]{"NAME", "TYPE"};
        String query = "Select zmember.Member_name NAME, zmember.type TYPE from T_RES_Zone_Member ZMember, T_RES_Alias Alias, T_RES_Alias2Member a2member  where  alias.alias_name ='" + zoneAliasName + "' and " + " alias.fabric_wwn ='" + fabricID + "' and " + "a2member.alias_ID = alias.alias_ID" + " and " + "a2member.zone_member_ID = zmember.zone_member_ID";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] members = FabricDbAccess.getAttributes(query, attribList, methodName);
        return members;
    }

    public static HashMap[] getZoneAliasAttributes(String fabricID, String[] zoneAliasNames, String[] attribList) throws Exception {
        String methodName = "getZoneAliasAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.ZONEALIAS_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Alias.", null, methodName);
        HashMap[] attribArray = new HashMap[zoneAliasNames.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_ALIAS as Alias" + " where " + "FABRIC_WWN" + " = '" + fabricID + "' and " + "ALIAS_NAME" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < zoneAliasNames.length; ++i) {
            String query = attrQuery + "'" + zoneAliasNames[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "Alias = " + zoneAliasNames[i]);
            }
            HashMap[] attribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = attribs[0];
        }
        return attribArray;
    }

    public static String[] getPortsInZone(String fabricID, String zoneName, boolean active) throws Exception {
        String methodName = "getPortsInZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, "zoneName: " + zoneName + "active: " + active);
        }
        HashMap[] zoneMembers = FabricDbAccess.getZoneMembers(fabricID, zoneName, active);
        ArrayList portsList = new ArrayList();
        for (int i = 0; i < zoneMembers.length; ++i) {
            portsList.addAll(FabricDbAccess.getPortsForMember(fabricID, zoneMembers[i], methodName));
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, portsList.toString());
        }
        String[] ports = portsList.toArray(new String[0]);
        return ports;
    }

    private static ArrayList getPortsForMember(String fabricID, HashMap member, String methodName) throws Exception {
        ArrayList<String> portslist = new ArrayList<String>();
        String memberName = (String)member.get("NAME");
        int memberType = (Integer)member.get("TYPE");
        switch (memberType) {
            case 11: {
                portslist.add(memberName);
                break;
            }
            case 12: {
                int endIndex = memberName.indexOf(",");
                String domainId = memberName.substring(0, endIndex);
                String portId = memberName.substring(endIndex);
                HashMap<String, String> attribs = new HashMap<String, String>();
                attribs.put("DOMAIN", domainId);
                String[] switches = FabricDbAccess.getSwitches(fabricID, attribs);
                if (switches == null || switches.length != 1) break;
                HashMap<String, String> portAttribs = new HashMap<String, String>();
                portAttribs.put("PORT_NUMBER", portId);
                String[] ports = FabricDbAccess.getPortsForSwitch(switches[0], portAttribs);
                if (ports == null || ports.length != 1) break;
                String[] attachedPorts = FabricDbAccess.getPortsConnectedTo(ports[0]);
                portslist.addAll(Arrays.asList(attachedPorts));
                break;
            }
            case 13: {
                String query = "Select NAME as PORT_NAME from T_RES_PORT where FC_PORT_ID = " + Integer.parseInt(memberName, 16);
                String[] ports = FabricDbAccess.getIds(query, "PORT_NAME", methodName);
                portslist.addAll(Arrays.asList(ports));
                break;
            }
            case 14: {
                String query = "Select PORT.NAME as PORT_NAME from T_RES_PORT PORT, T_RES_NODE NODE where NODE.NAME =  '" + memberName + "'  and NODE.NODE_ID = PORT.NODE_ID";
                String[] ports = FabricDbAccess.getIds(query, "PORT_NAME", methodName);
                portslist.addAll(Arrays.asList(ports));
                break;
            }
            case 15: {
                HashMap[] members = FabricDbAccess.getZoneMembersInZoneAlias(fabricID, memberName);
                for (int i = 0; i < members.length; ++i) {
                    portslist.addAll(FabricDbAccess.getPortsForMember(fabricID, members[i], methodName));
                }
                break;
            }
            case 16: {
                String[] ports = FabricDbAccess.getPortsForSwitch(memberName, null);
                if (ports == null) break;
                for (int j = 0; j < ports.length; ++j) {
                    String[] attachedPorts = FabricDbAccess.getPortsConnectedTo(ports[j]);
                    portslist.addAll(Arrays.asList(attachedPorts));
                }
                break;
            }
        }
        return portslist;
    }

    public static HashMap getPortsWithMembersInZone(String fabricID, String zoneName, boolean active) throws Exception {
        String methodName = "getPortsInZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, "zoneName: " + zoneName + "active: " + active);
        }
        HashMap[] zoneMembers = FabricDbAccess.getZoneMembers(fabricID, zoneName, active);
        HashMap<String, HashMap> portsMap = new HashMap<String, HashMap>();
        for (int i = 0; i < zoneMembers.length; ++i) {
            HashMap member = zoneMembers[i];
            ArrayList portsList = FabricDbAccess.getPortsForMember(fabricID, member, methodName);
            member.put("AllPorts", portsList);
            String[] ports = portsList.toArray(new String[0]);
            for (int k = 0; k < ports.length; ++k) {
                portsMap.put(ports[k], member);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, portsMap.toString());
        }
        return portsMap;
    }

    public static String[] getNonStandardZones(String fabricID, boolean activeOnly) throws Exception {
        String methodName = "getNonStandardZones";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "fabricID: " + fabricID);
        }
        String query = "";
        query = "Select distinct zone.zone_name as ZONE_NAME from T_RES_Zone zone, T_RES_ZONE_MEMBER ZONE_MEMBER where  zone.fabric_wwn ='" + fabricID + "' and " + " ((ZONE.VENDOR_TYPE != 0 and ZONE.VENDOR_TYPE != 1)  or (ZONE_MEMBER.TYPE > 14 or ZONE_MEMBER.TYPE < 10)) ";
        if (activeOnly) {
            int activeVal = 1;
            query = query + " and zone.active = " + activeVal;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] zoneNames = FabricDbAccess.getIds(query, "ZONE_NAME", methodName);
        return zoneNames;
    }

    public static boolean verifyZoneSet(String fabricID, String zoneSetName) throws Exception {
        String methodName = "verifyZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID: " + fabricID, "zonesetName: " + zoneSetName);
        }
        String query = "Select zset.zset_ID as ZSET_ID from T_RES_ZSET zset where  zset.fabric_wwn ='" + fabricID + "' and " + " zset.zset_name ='" + zoneSetName + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] zsetids = FabricDbAccess.getIds(query, "ZSET_ID", methodName);
        boolean bExists = true;
        if (zsetids == null || zsetids.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifyZone(String fabricID, String zoneName) throws Exception {
        String methodName = "verifyZone";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID:  " + fabricID, "zoneName: " + zoneName);
        }
        String query = "Select zone.zone_ID as ZONE_ID from T_RES_Zone zone where  zone.fabric_wwn ='" + fabricID + "' and " + " zone.zone_name ='" + zoneName + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] zoneids = FabricDbAccess.getIds(query, "ZONE_ID", methodName);
        boolean bExists = true;
        if (zoneids == null || zoneids.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static String[] getDeadEndPorts() throws Exception {
        String methodName = "getDeadEndPorts";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        String query = "Select distinct PORT.NAME PORT_WWN " + DEAD_END_PORTS;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "PORT_WWN", methodName);
        return portIds;
    }

    public static HashMap[] getDeadEndPortsForSan(String fabricWWN) throws Exception {
        String methodName = "getDeadEndPortsForSan";
        String[] attribList = new String[]{"WWN", "Label", "NODEWWN", "PORTWWN"};
        String query = "Select distinct PORT.NAME PORTWWN, PORT.NAME as WWN,        case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as Label, '' as NODEWWN " + DEAD_END_PORTS + " and Fabric.FABRIC_WWN = '" + fabricWWN + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static String[] getDeadEndNodes() throws Exception {
        String methodName = "getDeadEndNodes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        String query = "Select distinct NODE.NAME NODE_WWN " + DEAD_END_NODES;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] nodeIds = FabricDbAccess.getIds(query, "NODE_WWN", methodName);
        return nodeIds;
    }

    public static HashMap[] getDeadEndNodesForSan(String fabricWWN) throws Exception {
        String methodName = "getDeadEndNodesForSan";
        String[] attribList = new String[]{"WWN", "Label", "NODEWWN", "PORTWWN"};
        String query = "Select distinct NODE.NAME as NODEWWN,  NODE.NAME as WWN,        case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end  as Label,  NODE.NAME as NODEWWN, PORT.NAME as PORTWWN " + DEAD_END_NODES + " and FABRIC.FABRIC_WWN = '" + fabricWWN + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static HashMap[] getNodeAttributes(String[] nodeIDs, String[] attribList) throws Exception {
        String methodName = "getNodeAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "Node.", "       case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end ", methodName);
        HashMap[] attribArray = new HashMap[nodeIDs.length];
        String attrQuery = "Select " + attribListStr + " from " + "T_RES_NODE as Node" + " where " + "NAME" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            String query = attrQuery + "'" + nodeIDs[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "nodeID= " + nodeIDs[i]);
            }
            HashMap[] nodeAttribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = nodeAttribs[0];
        }
        return attribArray;
    }

    /*
     * Loose catch block
     */
    public static DataPath[] getComputerToSubsystemDataPaths(String computerName, String subsystemName) throws Exception {
        ArrayList<DataPath> datapaths;
        block23: {
            DBResultSet dbr;
            DBConnection connection;
            String methodName;
            block20: {
                Exception e22;
                block19: {
                    methodName = "getComputerToSubsystemDataPaths";
                    if (traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "computerName: " + computerName, "subsystemName: " + subsystemName);
                    }
                    String[] keys = subsystemName.split("\\+");
                    subsystemName = keys[0];
                    String query = "         SELECT distinct           FABRIC2SWITCH.FABRIC_WWN as FABRIC_WWN,          PORT2.NAME as SUBSYSTEM_PORT,          PORT3.NAME as HOST_PORT          FROM          T_RES_FABRIC2SWITCH FABRIC2SWITCH,T_RES_SWITCH2PORT SWITCH2PORT,          T_RES_PORT2PORT PORT2PORT, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM, T_RES_PORT PORT1, T_RES_PORT PORT2,          T_RES_HOST HOST, T_RES_HBA HBA, T_RES_NODE2HBA NODE2HBA,          T_RES_PORT PORT3, T_RES_PORT PORT4, T_RES_PORT2PORT PORT2PORT2,          T_RES_FABRIC2SWITCH FABRIC2SWITCH2, T_RES_SWITCH2PORT SWITCH2PORT2          WHERE          HOST.HOST_URL= '" + computerName + "' and " + "\t    \tHOST.COMPUTER_ID = HBA.HOST_ID and " + "         HBA.HBA_ID = NODE2HBA.HBA_ID and " + "         NODE2HBA.NODE_ID = PORT3.NODE_ID and " + "         ((PORT3.PORT_ID = PORT2PORT2.PORT_ID1 AND PORT4.PORT_ID = PORT2PORT2.PORT_ID2) OR " + "          (PORT3.PORT_ID = PORT2PORT2.PORT_ID2 AND PORT4.PORT_ID = PORT2PORT2.PORT_ID1)) AND " + "         PORT4.PORT_ID = SWITCH2PORT2.PORT_ID and " + "         SWITCH2PORT2.SWITCH_WWN = FABRIC2SWITCH2.SWITCH_WWN and " + "         FABRIC2SWITCH2.FABRIC_WWN = FABRIC2SWITCH.FABRIC_WWN AND " + "         FABRIC2SWITCH.SWITCH_WWN = SWITCH2PORT.SWITCH_WWN AND " + "         SWITCH2PORT.PORT_ID = PORT1.PORT_ID AND " + "         ((PORT1.PORT_ID = PORT2PORT.PORT_ID1 AND PORT2.PORT_ID = PORT2PORT.PORT_ID2) OR " + "          (PORT1.PORT_ID = PORT2PORT.PORT_ID2 AND PORT2.PORT_ID = PORT2PORT.PORT_ID1)) AND " + "         PORT2.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID AND " + "         SUBSYSTEM.NAME = '" + subsystemName + "'";
                    connection = ServiceUtils.getConnection();
                    datapaths = new ArrayList<DataPath>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, null);
                    while (dbr.next()) {
                        String compPort = dbr.getString("HOST_PORT");
                        String subsysPort = dbr.getString("SUBSYSTEM_PORT");
                        String fabricWWN = dbr.getString("FABRIC_WWN");
                        DataPath dp = new DataPath(compPort, subsysPort, fabricWWN);
                        datapaths.add(dp);
                    }
                    connection.commit();
                    Object var13_13 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block20;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, datapaths.toString());
            }
            break block23;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Exception e22;
                    block21: {
                        Object var13_14 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block21;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block22;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, datapaths.toString());
                }
                throw throwable;
            }
        }
        DataPath[] datapathArray = datapaths.toArray(new DataPath[0]);
        return datapathArray;
    }

    public static String[] getPortsConnectedTo(String portWWN) throws Exception {
        String methodName = "getPortsConnectedTo";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "portWWN: " + portWWN);
        }
        String query = "SELECT portOut.name as PORT_WWN FROM T_RES_Port portIn, T_RES_Port portOut, T_RES_Port2Port p2p WHERE portIn.name ='" + portWWN + "' and " + "((p2p.PORT_ID1 = portIn.port_id and portOut.port_id = p2p.PORT_ID2)" + " or " + "(p2p.port_ID2 = portIn.port_id and portOut.port_id = p2p.port_id1))";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "PORT_WWN", methodName);
        return portIds;
    }

    public static boolean verifyFabric(String fabricID) throws Exception {
        String methodName = "verifyFabric";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "fabricID: " + fabricID);
        }
        String query = "Select fabric.fabric_ID as FABRIC_ID from T_RES_Fabric fabric where  fabric.fabric_wwn ='" + fabricID + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] fabricids = FabricDbAccess.getIds(query, "FABRIC_ID", methodName);
        boolean bExists = true;
        if (fabricids == null || fabricids.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifySwitch(String switchWWN) throws Exception {
        String methodName = "verifySwitch";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "switchWWN: " + switchWWN);
        }
        String query = "Select distinct SWITCH_ID from T_RES_SWITCH where SWITCH_WWN ='" + switchWWN + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "SWITCH_ID", methodName);
        boolean bExists = true;
        if (portIds == null || portIds.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifyComputer(String computerName) throws Exception {
        String methodName = "verifyComputer";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "computerName: " + computerName);
        }
        String query = "Select distinct COMPUTER_ID from T_RES_HOST where HOST_URL ='" + computerName + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "COMPUTER_ID", methodName);
        boolean bExists = true;
        if (portIds == null || portIds.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifyPort(String portWWN) throws Exception {
        String methodName = "verifyPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "portWWN: " + portWWN);
        }
        String query = "Select distinct PORT.PORT_ID as PORT_ID from T_RES_PORT PORT where  PORT.NAME ='" + portWWN + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "PORT_ID", methodName);
        boolean bExists = true;
        if (portIds == null || portIds.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifyZoneAlias(String fabricID, String zoneAliasName) throws Exception {
        String methodName = "verifyZoneAlias";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName, "fabricID:  " + fabricID, "zoneAliasName: " + zoneAliasName);
        }
        String query = "Select ALIAS.ALIAS_ID as ALIAS_ID from T_RES_ALIAS ALIAS where  ALIAS.FABRIC_WWN ='" + fabricID + "' and " + " ALIAS.ALIAS_NAME ='" + zoneAliasName + "'";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] aliasIds = FabricDbAccess.getIds(query, "ALIAS_ID", methodName);
        boolean bExists = true;
        if (aliasIds == null || aliasIds.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    public static boolean verifySubsystem(String subsystemName) throws Exception {
        String methodName = "verifySubsystem";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, "subsystemName: " + subsystemName);
        }
        String[] keys = subsystemName.split("\\+");
        subsystemName = keys[0];
        String nameformat = "";
        if (keys.length > 1) {
            nameformat = keys[1];
        }
        String query = "Select distinct SUBSYSTEM_ID from T_RES_STORAGE_SUBSYSTEM where NAME ='" + subsystemName + "'";
        if (nameformat != "") {
            query = query + " and NAME_FORMAT = " + nameformat;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        String[] portIds = FabricDbAccess.getIds(query, "SUBSYSTEM_ID", methodName);
        boolean bExists = true;
        if (portIds == null || portIds.length == 0) {
            bExists = false;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bExists);
        }
        return bExists;
    }

    private static String createAttribStr(String[] attribList, String prefix, String labelSQL, String methodName) {
        String attribListStr = "";
        for (int i = 0; i < attribList.length; ++i) {
            attribListStr = attribList[i].equals("LABEL") ? attribListStr + labelSQL + " as LABEL" : attribListStr + prefix + attribList[i] + " as " + attribList[i];
            if (i >= attribList.length - 1) continue;
            attribListStr = attribListStr + ", ";
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "attribListStr = " + attribListStr);
        }
        return attribListStr;
    }

    private static String createAttribWhereClause(Hashtable attributes, String prefix, String methodName) {
        String attribWhereClause = "";
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            ColumnInfo collInfo = (ColumnInfo)it.next();
            String key = collInfo.getName();
            int datatype = collInfo.getDataType();
            String val = attributes.get(collInfo).toString();
            attribWhereClause = prefix + key + " = ";
            attribWhereClause = datatype == 12 || datatype == 1 ? attribWhereClause + "'" + val + "'" : attribWhereClause + val;
            if (!it.hasNext()) continue;
            attribWhereClause = attribWhereClause + " and ";
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "attribWhereClause = " + attribWhereClause);
        }
        return attribWhereClause;
    }

    /*
     * Loose catch block
     */
    private static HashMap[] getAttributes(String query, String[] attribList, String methodName) throws Exception {
        ArrayList attributes;
        block23: {
            DBResultSet dbr;
            DBConnection connection;
            block20: {
                Exception e22;
                block19: {
                    connection = ServiceUtils.getConnection();
                    attributes = new ArrayList();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, null);
                    while (dbr.next()) {
                        HashMap<String, Object> attribMap = new HashMap<String, Object>();
                        for (int i = 0; i < attribList.length; ++i) {
                            String key = attribList[i];
                            attribMap.put(key, dbr.getObject(key));
                        }
                        attributes.add(attribMap);
                    }
                    connection.commit();
                    Object var10_10 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block20;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, attributes.toString());
            }
            break block23;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Exception e22;
                    block21: {
                        Object var10_11 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block21;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block22;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, attributes.toString());
                }
                throw throwable;
            }
        }
        HashMap[] attribArray = attributes.toArray(new HashMap[0]);
        return attribArray;
    }

    /*
     * Loose catch block
     */
    private static String[] getIds(String query, String key, String methodName) throws Exception {
        ArrayList<String> ids;
        block22: {
            DBResultSet dbr;
            DBConnection connection;
            block19: {
                Exception e22;
                block18: {
                    connection = ServiceUtils.getConnection();
                    ids = new ArrayList<String>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, new Hashtable());
                    while (dbr.next()) {
                        String id = dbr.getString(key);
                        ids.add(id);
                    }
                    connection.commit();
                    Object var8_8 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, ids.toString());
            }
            break block22;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Exception e22;
                    block20: {
                        Object var8_9 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block21;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, ids.toString());
                }
                throw throwable;
            }
        }
        return ids.toArray(new String[0]);
    }

    static void safeHashPut(Hashtable hash, String key, String value) {
        if (value == null) {
            value = "";
        }
        hash.put(key, value);
    }

    static String messageValue(String value) {
        String result = value == null || value.trim().equals("") ? "NULL" : "'" + value + "'";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getClusterDetail(DBConnection con, String id, String key1, String key2, Hashtable detailTable) throws Exception {
        String methodName = "getClusterDetail";
        Hashtable<ColumnInfo, String> table = new Hashtable<ColumnInfo, String>();
        Cluster.ClusterCursor cursor = null;
        table.put(Cluster.getColumnInfo("CLUSTER_ID"), String.valueOf(id));
        try {
            cursor = Cluster.getCursor(con, table, null);
            while (cursor.next()) {
                Cluster cls = cursor.getObject();
                FabricDbAccess.safeHashPut(detailTable, key1, cls.getClusterName());
                FabricDbAccess.safeHashPut(detailTable, key2, String.valueOf(cls.getClusterId()));
            }
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        finally {
            block15: {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                catch (SQLException e) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getFabricDetail(DBConnection con, String id) {
        String methodName = "getFabricDetail";
        String FABRIC_DETAIL_SELECT_SQL = "Select        case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as Label, Fabric.IS_PHYSICAL as TYPE, Fabric.USER_ATTRIB1 as USER_ATTRIB1, Fabric.USER_ATTRIB2 as USER_ATTRIB2, Fabric.USER_ATTRIB3 as USER_ATTRIB3, Fabric.FABRIC_WWN as FWWN from T_RES_FABRIC as Fabric where Fabric.FABRIC_ID = " + id;
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, FABRIC_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setFabricDetail(DBConnection con, String id, String label, String userAttrib1, String userAttrib2, String userAttrib3) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "setFabricDetail";
            String FABRIC_DETAIL_UPDATE_SQL = "Update T_RES_FABRIC as Fabric set Fabric.DISPLAY_NAME =" + FabricDbAccess.messageValue(label) + ", " + "Fabric." + "USER_ATTRIB1 = '" + userAttrib1 + "'" + ", " + "Fabric." + "USER_ATTRIB2 = '" + userAttrib2 + "'" + ", " + "Fabric." + "USER_ATTRIB3 = '" + userAttrib3 + "'" + " where " + "Fabric." + "FABRIC_ID = " + id;
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, FABRIC_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getComputerDetail(DBConnection con, String id) {
        String methodName = "getComputerDetail";
        String HOST_DETAIL_SELECT_SQL = "Select  case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end  as LABEL, " + FabricDBConstants.getDeviceStatus("Host", true) + " as STATUS, " + "Host." + "OS_TYPE as TYPE, " + "Host." + "IP_ADDRESS as IP, " + "Host." + "HOST_URL as URL, " + "Host." + "GUID as GUID, " + " USER_ATTRIB1 as USER_ATTRIB1," + " USER_ATTRIB2 as USER_ATTRIB2," + " USER_ATTRIB3 as USER_ATTRIB3 " + "from " + "T_RES_HOST as Host" + " where " + "Host." + "COMPUTER_ID =" + id;
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, HOST_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setComputerDetail(DBConnection con, String id, String label, String userAttrib1, String userAttrib2, String userAttrib3) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "setComputerDetail";
            String COMPUTER_DETAIL_UPDATE_SQL = "Update T_RES_HOST as Host set Host.NETWORK_NAME ='" + label + "'" + ", " + "Host." + "USER_ATTRIB1 = '" + userAttrib1 + "'" + ", " + "Host." + "USER_ATTRIB2 = '" + userAttrib2 + "'" + ", " + "Host." + "USER_ATTRIB3 = '" + userAttrib3 + "'" + " where " + "Host." + "COMPUTER_ID = " + id;
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, COMPUTER_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPhyPeDetail(DBConnection con, String id) {
        String methodName = "getPhyPeDetail";
        String PE_DETAIL_SELECT_SQL = "Select " + FabricDBConstants.PE_TYPE_SQL + " as TYPE, " + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as LABEL, " + "PE." + "SERIAL_NUMBER as NUM,  " + "Vendor." + "VENDOR_NAME as VNAME, " + "PE." + "FIRMWARE_REVISION as REV, " + "PE." + "MGMT_URL_ADDR as ADDR " + "from " + "T_RES_MODEL as MODEL" + ", " + "T_RES_PHY_PE as PE" + ", " + "T_RES_VENDOR as VENDOR" + " where " + "PE." + "PHY_PE_ID = " + id + " and " + "PE." + "VENDOR_ID = " + "Vendor." + "VENDOR_ID";
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, PE_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setPhyPeDetail(DBConnection con, String id, String label) {
        int updateCount;
        block2: {
            String methodName = "setPhyPeDetail";
            String PE_DETAIL_UPDATE_SQL = "Update T_RES_PHY_PE as PE set PE.DISPLAY_NAME =" + FabricDbAccess.messageValue(label) + " where " + "PE." + "PHY_PE_ID = " + id;
            updateCount = -1;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, PE_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        boolean isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getHBADetail(DBConnection con, String id) {
        String methodName = "getHBADetail";
        String HBA_DETAIL_SELECT_SQL = "Select        case            when (HBA.NAME is not null) then HBA.NAME            else HBA.HBA_WWN   end  as LABEL, HBA.SERIAL_NUMBER as NUM,  Vendor.VENDOR_NAME as VNAME, Model.MODEL_NAME as MNAME, Model.MODEL_DESCRIPTION as MDES, HBA.DRIVER_NAME as DNAME, HBA.DRIVER_VERSION as DVER, HBA.ROM_VERSION as ROMVER, HBA.HW_VERSION as HWVER, HBA.FIRMWARE_VERSION as FWVER, HBA.API_VERSION as AVER from T_RES_HBA as HBA, T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL where HBA.HBA_ID = " + id + " and " + "HBA." + "VENDOR_ID = " + "Vendor." + "VENDOR_ID " + "and " + "HBA." + "MODEL_ID = " + "Model." + "MODEL_ID";
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, HBA_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPortDetail(DBConnection con, String id) {
        String methodName = "getPortDetail";
        String PORT_DETAIL_SELECT_SQL = "Select        case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as LABEL, Port.DISPLAY_ICON_TYPE as ICON,  cast (case  when (PORT.DISPLAY_ICON_TYPE is not null) then cast (PORT.DISPLAY_ICON_TYPE as char(2))  when (PORT.TYPE is not null) then cast (PORT.TYPE as char(2))  end as smallint)  as TYPE, Port.NAME as NAME from T_RES_PORT as Port where Port.PORT_ID = " + id;
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, PORT_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setPortDetail(DBConnection con, String id, String label, String icon) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "setPortDetail";
            String PORT_DETAIL_UPDATE_SQL = "Update T_RES_PORT as Port set Port.DISPLAY_NAME =" + FabricDbAccess.messageValue(label) + ", " + "Port." + "DISPLAY_ICON_TYPE =" + icon + " where " + "Port." + "PORT_ID = " + id;
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, PORT_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getNodeDetail(DBConnection con, String id) {
        String methodName = "getNodeDetail";
        String NODE_DETAIL_SELECT_SQL = "Select        case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end  as LABEL, Node.DISPLAY_ICON_TYPE as ICON, " + FabricDBConstants.NODE_TYPE_SQL + " as TYPE, " + "Node." + "NAME as NAME" + " from " + "T_RES_NODE as Node" + " where " + "Node." + "NODE_ID = " + id;
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, NODE_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setNodeDetail(DBConnection con, String id, String label, String icon) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "setNodeDetail";
            String NODE_DETAIL_UPDATE_SQL = "Update T_RES_NODE as Node set Node.DISPLAY_NAME =" + FabricDbAccess.messageValue(label) + ", " + "Node." + "DISPLAY_ICON_TYPE =" + icon + " where " + "Node." + "NODE_ID = " + id;
            System.out.println(NODE_DETAIL_UPDATE_SQL);
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, NODE_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getSwitchDetail(DBConnection con, String id) {
        String methodName = "getSwitchDetail";
        String SWITCH_DETAIL_SELECT_SQL = "Select   case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end  as Label,  CASE WHEN Switch.DESCRIPTION is not null THEN Switch.DESCRIPTION  ELSE  (SELECT Switch2.DESCRIPTION  from T_RES_SWITCH as Switch2  where Switch2.SWITCH_WWN = Switch.PARENT_SWITCH_WWN) END as DES, " + FabricDBConstants.getDeviceStatus("Switch", true) + " as DSS, " + " CASE WHEN " + "Switch." + "IP_ADDRESS is not null" + " THEN " + "Switch." + "IP_ADDRESS " + " ELSE " + " (SELECT Switch2.IP_ADDRESS " + " from T_RES_SWITCH as Switch2 " + " where Switch2.SWITCH_WWN = " + "Switch." + "PARENT_SWITCH_WWN)" + " END as IP, " + "LOGICAL_NAME as LNAME, " + "Vendor." + "VENDOR_NAME as VNAME, " + "Model." + "MODEL_NAME as MNAME, " + "Switch." + "VERSION as VER, " + "Switch." + "SERIAL_NUMBER as SNUM, " + "Switch." + "SWITCH_ID as ID, " + "Switch." + "MANAGEMENT_ID as MID, " + "Switch." + "MGMT_URL_ADDR as MUA, " + "Switch." + "DOMAIN as DOM, " + " CASE WHEN " + "Switch." + "CONTACT is not null" + " THEN " + "Switch." + "CONTACT " + " ELSE " + " (SELECT Switch2.CONTACT " + " from T_RES_SWITCH as Switch2 " + " where Switch2.SWITCH_WWN = " + "Switch." + "PARENT_SWITCH_WWN)" + " END as CON, " + "Switch." + "SWITCH_WWN as WWN, " + " CASE WHEN " + "Switch." + "LOCATION is not null" + " THEN " + "Switch." + "LOCATION " + " ELSE " + " (SELECT Switch2.LOCATION " + " from T_RES_SWITCH as Switch2 " + " where Switch2.SWITCH_WWN = " + "Switch." + "PARENT_SWITCH_WWN)" + " END as LOC, " + "  case  when Switch.PARENT_SWITCH_WWN is not null then Switch.PARENT_SWITCH_WWN  else Switch.SWITCH_WWN end " + " as PWWN, " + "Switch." + " USER_ATTRIB1 as USER_ATTRIB1," + "Switch." + " USER_ATTRIB2 as USER_ATTRIB2," + "Switch." + " USER_ATTRIB3 as USER_ATTRIB3 " + "from " + "T_RES_SWITCH as Switch" + ", " + "T_RES_VENDOR as VENDOR" + ", " + "T_RES_MODEL as MODEL" + " where " + "Switch." + "VENDOR_ID = " + "Vendor." + "VENDOR_ID and " + "Switch." + "MODEL_ID = " + "Model." + "MODEL_ID and " + "Switch." + "SWITCH_ID = " + id;
        DBResultSet rs = null;
        try {
            rs = ComplexQuery.sqlQuery(con, SWITCH_DETAIL_SELECT_SQL, null);
            con.commit();
        }
        catch (SQLException e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        return rs;
    }

    public static boolean setSwitchDetail(DBConnection con, String id, String label, String userAttrib1, String userAttrib2, String userAttrib3) {
        int updateCount;
        block2: {
            String methodName = "setSwitchDetail";
            String SWITCH_DETAIL_UPDATE_SQL = "Update T_RES_SWITCH as Switch set Switch.DISPLAY_NAME =" + FabricDbAccess.messageValue(label) + ", " + "Switch." + "USER_ATTRIB1 = '" + userAttrib1 + "'" + ", " + "Switch." + "USER_ATTRIB2 = '" + userAttrib2 + "'" + ", " + "Switch." + "USER_ATTRIB3 = '" + userAttrib3 + "'" + "where " + "Switch." + "SWITCH_ID = " + id;
            updateCount = -1;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, SWITCH_DETAIL_UPDATE_SQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        boolean isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getSwitchBlades(DBConnection con, String switchWWN) {
        String methodName = "getSwitchBlades";
        DBResultSet rs = null;
        String sqlStmnt = "select SWTB.SWITCH_BLADE_ID as ID,SWTB.SLOT as SLOT,SWTB.SWITCH_BLADE_TYPE_ID as TYPE,SWTB.OPERATIONAL_STATUS as STATUS,SWTB.FIRMWARE_REVISION as FIRMWARE,Vendor.VENDOR_NAME as VNAME,Model.MODEL_NAME as MNAME from T_RES_SWITCH_BLADE as SWTB,T_RES_VENDOR as VENDOR,T_RES_MODEL as MODEL where SWITCH_WWN='" + switchWWN + "' and " + "SWTB." + "VENDOR_ID = " + "Vendor." + "VENDOR_ID and " + "SWTB." + "MODEL_ID = " + "Model." + "MODEL_ID";
        try {
            rs = ComplexQuery.sqlQuery(con, sqlStmnt, null);
            con.commit();
        }
        catch (SQLException sqle) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqle);
            }
        }
        return rs;
    }

    public static HashMap[] getPeripheralEntitiesForSan(String sanWWN) throws Exception {
        String methodName = "getPeripheralEntitiesForSan";
        String[] attribList = new String[]{"WWN", "Label", "NODEWWN", "PORTWWN"};
        String query = "select distinct PE.PE_NAME as WWN,  PE.PE_NAME as Label,  NODE.NAME as NODEWWN,  PORT.NAME as PORTWWN  from  T_RES_PORT PORT, T_RES_SWITCH2PORT S2P, T_RES_FABRIC2SWITCH F2S,  T_RES_PORT2PORT P2P, T_RES_NODE NODE, T_RES_PE2NODE PE2NODE,  T_RES_PHY_PE PE  where  F2S.FABRIC_WWN = '" + sanWWN + "' and " + " F2S.SWITCH_WWN = S2P.SWITCH_WWN and " + " ((S2P.PORT_ID = P2P.PORT_ID1 and PORT.PORT_ID = P2P.PORT_ID2) or " + "  (PORT.PORT_ID = P2P.PORT_ID1 and S2P.PORT_ID = P2P.PORT_ID2)) and " + " PORT.NODE_ID = NODE.NODE_ID and " + " PE2NODE.NODE_ID = NODE.NODE_ID and " + " PE2NODE.PHY_PE_ID = PE.PHY_PE_ID ";
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static HashMap[] getComputersForSan(String sanWWN) throws Exception {
        String methodName = "getComputersForSan";
        String[] attribList = new String[]{"WWN", "Label", "NODEWWN", "PORTWWN"};
        String query = "Select HOST.GUID as WWN, HOST.HOST_NAME as Label,  NODE.NAME as NODEWWN, PORT.NAME as PORTWWN  from T_RES_PORT PORT, T_RES_NODE2HBA NODE2HBA,  T_RES_HBA HBA, T_RES_HOST HOST, T_RES_SWITCH2PORT S2P,  T_RES_FABRIC2SWITCH F2S, T_RES_PORT2PORT P2P, T_RES_NODE NODE  where F2S.FABRIC_WWN = '" + sanWWN + "' and F2S.SWITCH_WWN = S2P.SWITCH_WWN and " + " ((S2P.PORT_ID = P2P.PORT_ID1 and PORT.PORT_ID = P2P.PORT_ID2) or " + "  (PORT.PORT_ID = P2P.PORT_ID1 and S2P.PORT_ID = P2P.PORT_ID2)) " + " and PORT.NODE_ID = NODE.NODE_ID " + " and NODE.NODE_ID = NODE2HBA.NODE_ID " + " and NODE2HBA.HBA_ID = HBA.HBA_ID " + " and HBA.HOST_ID = HOST.COMPUTER_ID";
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static HashMap[] getSubsystemsForSan(String sanWWN) throws Exception {
        String methodName = "getSubsystemsForSan";
        String[] attribList = new String[]{"SUBSYSTEMWWN", "PORTWWN"};
        String query = "Select SUBSYSTEM.NAME as SUBSYSTEMWWN,  PORT.NAME as PORTWWN  from T_RES_PORT PORT, T_RES_SWITCH2PORT S2P,  T_RES_FABRIC2SWITCH F2S, T_RES_PORT2PORT P2P, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM  where F2S.FABRIC_WWN = '" + sanWWN + "' and F2S.SWITCH_WWN = S2P.SWITCH_WWN and " + " ((S2P.PORT_ID = P2P.PORT_ID1 and PORT.PORT_ID = P2P.PORT_ID2) or " + "  (PORT.PORT_ID = P2P.PORT_ID1 and S2P.PORT_ID = P2P.PORT_ID2)) " + " and PORT.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID";
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static boolean saveZoneDescription(DBConnection con, String zoneDescription, String zoneName) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "saveZoneDescription";
            String updateSQL = "Update T_RES_ZONE set T_RES_ZONE.DESCRIPTION =" + FabricDbAccess.messageValue(zoneDescription) + " where " + "T_RES_ZONE.ZONE_NAME = '" + zoneName + "'";
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, updateSQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    public static boolean saveZoneSetDescription(DBConnection con, String zsDescription, String zsName) {
        boolean isUpdate;
        int updateCount;
        block2: {
            String methodName = "saveZoneSetDescription";
            String updateSQL = "Update T_RES_ZSET set T_RES_ZSET.DESCRIPTION =" + FabricDbAccess.messageValue(zsDescription) + " where " + "T_RES_ZSET.ZSET_NAME = '" + zsName + "'";
            updateCount = -1;
            isUpdate = false;
            try {
                updateCount = ComplexQuery.sqlUpdate(con, updateSQL, null);
                con.commit();
            }
            catch (SQLException e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        isUpdate = updateCount > 0;
        return isUpdate;
    }

    /*
     * Loose catch block
     */
    public static String[] getFabricsForIPAddress(String IPAddress) throws Exception {
        ArrayList<String> wwns;
        block24: {
            DBResultSet dbr;
            DBConnection connection;
            String methodName;
            block21: {
                Exception e22;
                block20: {
                    methodName = "getFabricsForIPAddress";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, IPAddress);
                    }
                    String query = "select distinct FABRIC.FABRIC_WWN as WWN, FABRIC.PARENT_FABRIC_WWN as PWWN from T_RES_SWITCH SWITCH, T_RES_FABRIC2SWITCH F2S, T_RES_FABRIC FABRIC where SWITCH.IP_ADDRESS ='" + IPAddress + "' AND SWITCH.SWITCH_WWN=F2S.SWITCH_WWN " + "AND F2S.FABRIC_WWN = FABRIC.FABRIC_WWN " + "union " + "select distinct " + "FABRIC.FABRIC_WWN as WWN, FABRIC.PARENT_FABRIC_WWN as PWWN " + "from " + "T_RES_FABRIC FABRIC, T_RES_FABRIC2SWITCH F2S, T_RES_SWITCH2PORT S2P, " + "T_RES_PORT PORT, T_RES_PORT2PORT P2P, " + "T_RES_NODE2HBA N2H, T_RES_HBA HBA, T_RES_HOST HOST " + "where " + "HOST.IP_ADDRESS ='" + IPAddress + "' AND HOST.COMPUTER_ID=HBA.HOST_ID " + "AND HBA.HBA_ID=N2H.HBA_ID " + "AND N2H.NODE_ID=PORT.NODE_ID " + "AND (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2) " + "AND (P2P.PORT_ID1 = S2P.PORT_ID OR P2P.PORT_ID2 = S2P.PORT_ID) " + "AND S2P.SWITCH_WWN = F2S.SWITCH_WWN " + "AND F2S.FABRIC_WWN = FABRIC.FABRIC_WWN";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
                    }
                    connection = ServiceUtils.getConnection();
                    wwns = new ArrayList<String>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, new Hashtable());
                    while (dbr.next()) {
                        String wwn = dbr.getString("WWN");
                        wwns.add(wwn);
                        String pwwn = dbr.getString("PWWN");
                        if (pwwn == null || wwns.contains(pwwn)) continue;
                        wwns.add(pwwn);
                    }
                    connection.commit();
                    Object var9_9 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block20;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, wwns.toString());
            }
            break block24;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Exception e22;
                    block22: {
                        Object var9_10 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block22;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block23;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, wwns.toString());
                }
                throw throwable;
            }
        }
        return wwns.toArray(new String[0]);
    }

    public static HashMap[] getFabricsForZoning() throws Exception {
        String methodName = "getFabricsForZoning";
        String[] attribList = new String[]{"WWN", "Label", "Active", "State"};
        String query = "Select distinct FABRIC.FABRIC_WWN as WWN,        case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as Label, Fabric.Active as Active, Fabric.Detectable as State from T_RES_FABRIC Fabric, T_RES_SWITCH Switch , T_RES_FABRIC2SWITCH F2S where Fabric.FABRIC_WWN = F2S.FABRIC_WWN and F2S.Switch_WWN = SWITCH.SWITCH_WWN and ((Fabric.Detectable = 1) OR (Fabric.Detectable = 0 and Switch.Detectable =0))";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
        }
        HashMap[] attribArray = FabricDbAccess.getAttributes(query, attribList, methodName);
        return attribArray;
    }

    public static HashMap[] getIPTargetAttributes(String[] IPAddresses, String[] attribList) throws Exception {
        String methodName = "getIPTargetAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        if (attribList == null || attribList.length == 0) {
            attribList = FabricManagerConstants.IPTARGET_ATTRS;
        }
        String attribListStr = FabricDbAccess.createAttribStr(attribList, "IPT.", null, methodName);
        HashMap[] attribArray = new HashMap[IPAddresses.length];
        String attrQuery = "Select " + attribListStr + " from T_RES_IP_TARGET as IPT" + " where " + "IP_ADDRESS" + " = ";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + attrQuery);
        }
        for (int i = 0; i < IPAddresses.length; ++i) {
            String query = attrQuery + "'" + IPAddresses[i] + "'";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "IPaddress= " + IPAddresses[i]);
            }
            HashMap[] attribs = FabricDbAccess.getAttributes(query, attribList, methodName);
            attribArray[i] = attribs[0];
        }
        return attribArray;
    }

    public static byte agentStateToByte(String status) {
        byte result = -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDbAccess.class.getName(), "agentStateToByte", status);
        }
        if (status != null) {
            if (status.startsWith("IA")) {
                result = 0;
            } else if (status.startsWith("AC")) {
                result = 1;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDbAccess.class.getName(), "agentStateToByte", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getInbandAgents() {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String outOfBandAgentQuery = "SELECT case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end as LABEL, DEVICE_AGENT.DEVICE_AGENT_ID as ID, DEVICE_AGENT.STATUS as STATUS FROM  T_RES_DEVICE_AGENT DEVICE_AGENT, T_RES_HOST HOST WHERE DEVICE_AGENT.HOST_ID = HOST.COMPUTER_ID ";
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(outOfBandAgentQuery);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlID = resultSet.getInt("ID");
                    n.nlName = resultSet.getString("LABEL");
                    n.nlState = FabricDbAccess.agentStateToByte(resultSet.getString("STATUS"));
                    prev.nlNext = n;
                    prev = n;
                }
                resultSet.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getInbandAgents", e);
                }
            }
            finally {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignore) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getInbandAgents", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * Loose catch block
     */
    public static DeviceAgent[] getDeviceAgents() throws Exception {
        ArrayList<DeviceAgent> das;
        block25: {
            DBResultSet dbr;
            DBConnection connection;
            String methodName;
            block22: {
                Exception e22;
                block21: {
                    methodName = "getDeviceAgents";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
                    }
                    String query = "select HOST.HOST_URL as URL, HOST.GUID as GUID, HOST.IP_ADDRESS as IPADDRESS, HOST.NETWORK_NAME as NAME, HOST.DOMAIN_NAME as DOMAIN, AGENT.PORT as PORT, AGENT.VERSION as VERSION, AGENT.STATUS as STATUS, AGENT.HOST_ID as HOSTID from T_RES_HOST HOST, T_RES_DEVICE_AGENT AGENT where AGENT.HOST_ID = HOST.COMPUTER_ID ";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
                    }
                    connection = ServiceUtils.getConnection();
                    das = new ArrayList<DeviceAgent>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, new Hashtable());
                    while (dbr.next()) {
                        DeviceAgent da = new DeviceAgent(dbr.getString("URL"), dbr.getString("PORT"), dbr.getString("VERSION"), dbr.getString("STATUS"), dbr.getString("IPADDRESS"), dbr.getString("NAME"), dbr.getString("DOMAIN"), dbr.getString("GUID"), dbr.getString("HOSTID"));
                        if (dbr.getString("GUID") != null) {
                            da.setGuid(dbr.getString("GUID").trim());
                        }
                        das.add(da);
                    }
                    connection.commit();
                    Object var7_7 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block21;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block22;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, das.toString());
            }
            break block25;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Exception e22;
                    block23: {
                        Object var7_8 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block23;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block24;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, das.toString());
                }
                throw throwable;
            }
        }
        return das.toArray(new DeviceAgent[0]);
    }

    /*
     * Loose catch block
     */
    public static FabricScanner[] getScannersForAgent(String agentId) throws Exception {
        ArrayList<FabricScanner> scs;
        block28: {
            DBResultSet dbr;
            DBConnection connection;
            String methodName;
            block25: {
                Exception e22;
                block24: {
                    methodName = "getScannersForAgent";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, agentId);
                    }
                    String query = "select SCANNER.SCANNER_ID as ID, SCANNER.VERSION as VERSION, SCANNER.TYPE as TYPE, SCANNER.INACTIVE_PROCESSED as INACTIVE_PROCESSED, SCANNER.PORT as PORT, SCANNER.AGENT_NAME as AGENT_NAME, SCANNER.ENABLED as ENABLED, SCANNER.BENCHMARK as BENCHMARK from T_RES_SCANNER SCANNER where SCANNER.AGENT_NAME = '" + agentId + "'" + " AND " + "((SCANNER.ENABLED = 1) OR " + "((SCANNER.ENABLED = 0) AND (SCANNER.INACTIVE_PROCESSED = 0)))";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
                    }
                    connection = ServiceUtils.getConnection();
                    scs = new ArrayList<FabricScanner>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, new Hashtable());
                    while (dbr.next()) {
                        FabricScanner sc = new FabricScanner();
                        if (dbr.getString("ID") != null) {
                            sc.setScanId(dbr.getString("ID").trim());
                        }
                        if (dbr.getString("VERSION") != null) {
                            sc.setVersion(dbr.getString("VERSION").trim());
                        }
                        if (dbr.getString("TYPE") != null) {
                            sc.setType(dbr.getString("TYPE").trim());
                        }
                        if (dbr.getString("AGENT_NAME") != null) {
                            sc.setAgentName(dbr.getString("AGENT_NAME").trim());
                        }
                        sc.setInactiveProcessed(dbr.getInt("INACTIVE_PROCESSED"));
                        sc.setPort(dbr.getInt("PORT"));
                        sc.setEnabled(dbr.getShort("ENABLED"));
                        sc.setBenchmark(dbr.getInt("BENCHMARK"));
                        scs.add(sc);
                    }
                    connection.commit();
                    Object var8_8 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block24;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block25;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, scs.toString());
            }
            break block28;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Exception e22;
                    block26: {
                        Object var8_9 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block26;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block27;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, scs.toString());
                }
                throw throwable;
            }
        }
        return scs.toArray(new FabricScanner[0]);
    }

    /*
     * Loose catch block
     */
    public static FabricScanner[] getScannersWithoutAgent() throws Exception {
        ArrayList<FabricScanner> scs;
        block28: {
            DBResultSet dbr;
            DBConnection connection;
            String methodName;
            block25: {
                Exception e22;
                block24: {
                    methodName = "getScannersWithoutAgent";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
                    }
                    String query = "select SCANNER.SCANNER_ID as ID, SCANNER.VERSION as VERSION, SCANNER.TYPE as TYPE, SCANNER.INACTIVE_PROCESSED as INACTIVE_PROCESSED, SCANNER.PORT as PORT, SCANNER.AGENT_NAME as AGENT_NAME, SCANNER.ENABLED as ENABLED, SCANNER.BENCHMARK as BENCHMARK from T_RES_SCANNER SCANNER where SCANNER.INACTIVE_PROCESSED = 0 and SCANNER.AGENT_NAME NOT IN ((select TARGET.IP_ADDRESS from T_RES_IP_TARGET TARGET) union (select HOST.GUID from T_RES_HOST HOST))";
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "query = " + query);
                    }
                    connection = ServiceUtils.getConnection();
                    scs = new ArrayList<FabricScanner>();
                    dbr = null;
                    dbr = ComplexQuery.sqlQuery(connection, query, new Hashtable());
                    while (dbr.next()) {
                        FabricScanner sc = new FabricScanner();
                        if (dbr.getString("ID") != null) {
                            sc.setScanId(dbr.getString("ID").trim());
                        }
                        if (dbr.getString("VERSION") != null) {
                            sc.setVersion(dbr.getString("VERSION").trim());
                        }
                        if (dbr.getString("TYPE") != null) {
                            sc.setType(dbr.getString("TYPE").trim());
                        }
                        if (dbr.getString("AGENT_NAME") != null) {
                            sc.setAgentName(dbr.getString("AGENT_NAME").trim());
                        }
                        sc.setInactiveProcessed(dbr.getInt("INACTIVE_PROCESSED"));
                        sc.setPort(dbr.getInt("PORT"));
                        sc.setEnabled(dbr.getShort("ENABLED"));
                        sc.setBenchmark(dbr.getInt("BENCHMARK"));
                        scs.add(sc);
                    }
                    connection.commit();
                    Object var7_7 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block24;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e22) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block25;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, scs.toString());
            }
            break block28;
            {
                catch (Exception e) {
                    connection.rollback();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Exception e22;
                    block26: {
                        Object var7_8 = null;
                        try {
                            if (dbr != null) {
                                dbr.getStatement().close();
                            }
                        }
                        catch (Exception e22) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block26;
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing statement and resultset : ", e22);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e22) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block27;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName + " Error closing connection : ", e22);
                    }
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, scs.toString());
                }
                throw throwable;
            }
        }
        return scs.toArray(new FabricScanner[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getFabricsForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT case when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN) else '' end  as LABEL, Fabric.fabric_wwn as WWN, Attr.resource_ID as ID from T_RES_ATTRIBUTE Attr, T_RES_FABRIC Fabric where Attr.attribute_id = " + alertID + " and Attr.resource_id = Fabric.fabric_id " + " and Attr.resource_type = " + 114;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)114;
                    n.nlID = resultSet.getInt("ID");
                    String label = resultSet.getString("LABEL");
                    if (label == "") {
                        label = "Fabric." + resultSet.getString("WWN");
                    }
                    n.nlName = label;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getFabricsForAlert", e);
                }
            }
            finally {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getFabricsForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getZonesForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT Zone.ZONE_NAME as NAME, Attr.resource_ID as ID,        case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as FabricLabel from T_RES_ATTRIBUTE Attr, T_RES_ZONE Zone, T_RES_FABRIC Fabric where Attr.attribute_id = " + alertID + " and Attr.resource_id = Zone.zone_id " + " and Attr.resource_type = " + 127 + " and Zone.fabric_wwn = Fabric.fabric_wwn";
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)127;
                    n.nlID = resultSet.getInt("ID");
                    n.nlName = resultSet.getString("NAME") + "(Fabric " + resultSet.getString("FabricLabel") + ")";
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getZonesForAlert", e);
                }
            }
            finally {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getZonesForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getZoneSetsForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT ZoneSet.ZSET_NAME as NAME, Attr.resource_ID as ID, Fabric.DISPLAY_NAME as FabricLabel from T_RES_ATTRIBUTE Attr, T_RES_ZSET ZoneSet, T_RES_FABRIC Fabric where Attr.attribute_id = " + alertID + " and Attr.resource_id = ZoneSet.zset_id " + " and Attr.resource_type = " + 126 + " and ZoneSet.fabric_wwn = Fabric.fabric_wwn";
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)126;
                    n.nlID = resultSet.getInt("ID");
                    n.nlName = resultSet.getString("NAME") + "(Fabric " + resultSet.getString("FabricLabel") + ")";
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneSetsForAlert", e);
                }
            }
            finally {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneSetsForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getSwitchesForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT Switch.DISPLAY_NAME as NAME, Switch.SWITCH_WWN as WWN, Attr.resource_ID as ID from T_RES_ATTRIBUTE Attr, T_RES_SWITCH Switch where Attr.attribute_id = " + alertID + " and Attr.resource_id = Switch.switch_id " + " and Attr.resource_type = " + 121;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)121;
                    n.nlID = resultSet.getInt("ID");
                    String label = resultSet.getString("NAME");
                    if (label == null || label == "") {
                        label = "Switch." + resultSet.getString("WWN");
                    }
                    n.nlName = label;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getSwitchesForAlert", e);
                }
            }
            finally {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getSwitchesForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getPeripheralEntitiesForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT PE.DISPLAY_NAME as LABEL, PE.PE_NAME as NAME, Attr.resource_ID as ID from T_RES_ATTRIBUTE Attr, T_RES_PHY_PE PE where Attr.attribute_id = " + alertID + " and Attr.resource_id = PE.phy_pe_id " + " and Attr.resource_type = " + 139;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)139;
                    n.nlID = resultSet.getInt("ID");
                    String label = resultSet.getString("LABEL");
                    if (label == null || label == "") {
                        label = "PhysicalEntity." + resultSet.getString("NAME");
                    }
                    n.nlName = label;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getPeripheralEntitiesForAlert", e);
                }
            }
            finally {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getPeripheralEntitiesForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getPortsForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT PORT.DISPLAY_NAME as DISPLAYNAME, PORT.NAME as NAME, Attr.resource_ID as ID from T_RES_ATTRIBUTE Attr, T_RES_PORT PORT where Attr.attribute_id = " + alertID + " and Attr.resource_id = PORT.port_id " + " and Attr.resource_type = " + 137;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)137;
                    n.nlID = resultSet.getInt("ID");
                    String label = resultSet.getString("DISPLAYNAME");
                    if (label == null || label == "") {
                        label = "Port." + resultSet.getString("NAME");
                    }
                    n.nlName = label;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getPortsForAlert", e);
                }
            }
            finally {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getPortsForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NameList getNodesForAlert(int alertID) {
        NameList root;
        NameList prev = root = new NameList();
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT NODE.DISPLAY_NAME as DISPLAYNAME, NODE.NAME as NAME, Attr.resource_ID as ID from T_RES_ATTRIBUTE Attr, T_RES_NODE NODE where Attr.attribute_id = " + alertID + " and Attr.resource_id = NODE.node_id " + " and Attr.resource_type = " + 138;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    NameList n = new NameList();
                    n.nlInfo = (short)138;
                    n.nlID = resultSet.getInt("ID");
                    String label = resultSet.getString("DISPLAYNAME");
                    if (label == null || label == "") {
                        label = "Node." + resultSet.getString("NAME");
                    }
                    n.nlName = label;
                    prev.nlNext = n;
                    prev = n;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getNodesForAlert", e);
                }
            }
            finally {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getNodesForAlert", e1);
                    }
                }
            }
        }
        return root.nlNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZoneNameForZone(int zoneID) {
        String zoneName = null;
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT ZONE.ZONE_NAME as ZONENAME from T_RES_ZONE ZONE where ZONE.ZONE_ID = " + zoneID;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                DBResultSet resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    zoneName = resultSet.getString("ZONENAME");
                }
                resultSet.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneNameForZone", e);
                }
            }
            finally {
                block15: {
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneNameForZone", e1);
                    }
                }
            }
        }
        return zoneName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZoneSetNameForZoneSet(int zoneSetID) {
        String zoneName = null;
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT ZSET.ZSET_NAME as ZONESETNAME from T_RES_ZSET ZSET where ZSET.ZSET_ID = " + zoneSetID;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                DBResultSet resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    zoneName = resultSet.getString("ZONESETNAME");
                }
                resultSet.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneSetNameForZone", e);
                }
            }
            finally {
                block15: {
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getZoneSetNameForZoneSet", e1);
                    }
                }
            }
        }
        return zoneName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricLabel(String fabricWWN) {
        String fabricLabel = fabricWWN;
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT        case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as fabricLabel from T_RES_FABRIC Fabric where Fabric.FABRIC_WWN = '" + fabricWWN + "'";
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                DBResultSet resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    fabricLabel = resultSet.getString("fabricLabel");
                }
                resultSet.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "getFabricLabel", e);
                }
            }
            finally {
                block15: {
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block15;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "getFabricLabel", e1);
                    }
                }
            }
        }
        return fabricLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyAllResourcesSelected(int alertID, short resourceType) {
        boolean allResourcesSelected = false;
        DBConnection dbc = ServiceUtils.getConnection();
        if (dbc != null) {
            String query = "SELECT  Attr.resource_type as TYPE from T_RES_ATTRIBUTE Attr where Attr.attribute_id = " + alertID + " and Attr.resource_id = -1 " + " and Attr.resource_type = " + resourceType;
            DBResultSet resultSet = null;
            try {
                DBPreparedStatement selectStmt = dbc.prepareStatement(query);
                resultSet = selectStmt.executeQuery();
                if (resultSet != null && resultSet.next()) {
                    allResourcesSelected = true;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDbAccess.class.getName(), "verifyAllResourcesSelected", e);
                }
            }
            finally {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {}
                    try {
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(FabricDbAccess.class.getName(), "verifyAllResourcesSelected", e1);
                    }
                }
            }
        }
        return allResourcesSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getZoneControllerInfo(String SAN) {
        String methodName = "getZoneControllerInfo";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "trying to find zone control agent for SAN " + SAN);
        }
        DBConnection connection = null;
        ArrayList agents = new ArrayList();
        String agentType = null;
        try {
            connection = ServiceUtils.getConnection();
            String schema = connection.getSchema();
            String sql = " Select \t\t'GS-3' as TYPE, scanner.scanner_id as SCANNERID, host.IP_ADDRESS as ADDRESS, agent.PORT as PORT, 'N/A' as userid, 'N/A' as password,  agent.VERSION as VERSION \tfrom \t\t" + schema + ".T_RES_SCANNER scanner, " + schema + ".T_RES_ELEMENT_PROBE_STATUS state, " + schema + ".T_RES_DEVICE_AGENT agent, " + schema + ".T_RES_FABRIC fabric, " + schema + ".T_RES_HOST host" + "\twhere " + "\t\tfabric.FABRIC_WWN = '" + SAN.trim() + "' and" + "\t\tfabric.DETECTABLE = 1 and" + "\t\tstate.ELEMENT_ID = fabric.FABRIC_ID and " + "\t\tstate.scanner_id = scanner.scanner_id and " + "\t\tscanner.enabled = 1 and " + "\t\tscanner.type = '" + "PI1" + "' and " + "\t\tagent.HOST_ID = host.computer_id and " + "\t\tagent.PORT = scanner.port and " + "\t\tagent.STATUS = 'AC'";
            DBResultSet dbr = null;
            try {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "sql statement to find zone control agent for SAN " + SAN + " is " + sql);
                }
                if ((dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable())).next()) {
                    agentType = dbr.getString("TYPE").trim();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Found potential agent for zone control => for SAN " + SAN);
                        if (agentType != null) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "agent type of zone control agent for SAN " + SAN + " is " + agentType);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                }
            }
            finally {
                block35: {
                    try {
                        if (dbr != null) {
                            dbr.close();
                        }
                    }
                    catch (Exception e) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block35;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
            }
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
        }
        finally {
            block36: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block36;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                    }
                }
            }
        }
        if (agentType == null) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "no zone control agent found for SAN " + SAN);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return agentType;
    }

    public static ZoneCapabilities populateCapabilitiesForOutbandAgent(String SAN) {
        String methodName = "populateCapabilitiesForOutbandAgent";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "determining zone control capabilities for outband agent for SAN " + SAN);
            }
            ZoneCapabilities capabilities = new ZoneCapabilities();
            capabilities.setSupportsAliases(true);
            capabilities.setAllowsNumericNameStart(true);
            capabilities.setSupportsNodeWWN(true);
            capabilities.setMaxMembersInAlias(-1);
            capabilities.setMaxMembersInZone(-1);
            capabilities.setMaxNameLength(64);
            capabilities.setMaxZones(-1);
            capabilities.setMaxZoneSets(-1);
            capabilities.setMaxZonesInSet(-1);
            capabilities.setSupportsDomainPort(true);
            capabilities.setSupportsEmptyZoneAliases(false);
            capabilities.setSupportsEmptyZones(false);
            capabilities.setSupportsEmptyZoneSets(false);
            capabilities.setSupportsFCID(false);
            capabilities.setSupportsFullZoneDB(true);
            capabilities.setSupportsOrphanZoneAliases(true);
            capabilities.setSupportsOrphanZones(true);
            capabilities.setSupportsSpecialCharacters(false);
            capabilities.setZcAgentType(0);
            capabilities.setMaxZoneAliases(-1);
            capabilities.setMaxZoneMembers(-1);
            capabilities.setSupportsSameZoneSetAndZoneName(false);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Capabilities of SAN " + SAN + " are " + capabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
            return capabilities;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ZoneCapabilities populateCapabilitiesForInbandAgent(String SAN) {
        String methodName = "populateCapabilitiesForInbandAgent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "determining zone control capabilities for inband agent for SAN " + SAN);
        }
        try {
            ZoneCapabilities capabilities = new ZoneCapabilities();
            capabilities.setSupportsNodeWWN(false);
            capabilities.setSupportsAliases(false);
            capabilities.setAllowsNumericNameStart(false);
            capabilities.setMaxMembersInAlias(-1);
            capabilities.setMaxMembersInZone(-1);
            capabilities.setMaxNameLength(64);
            capabilities.setMaxZones(-1);
            capabilities.setMaxZoneSets(-1);
            capabilities.setMaxZonesInSet(-1);
            capabilities.setSupportsEmptyZoneAliases(false);
            capabilities.setSupportsEmptyZones(false);
            capabilities.setSupportsEmptyZoneSets(false);
            capabilities.setMaxZoneAliases(0);
            capabilities.setMaxZoneMembers(-1);
            capabilities.setSupportsSameZoneSetAndZoneName(false);
            boolean domainportsupport = true;
            if (SAN.indexOf("0060DF") != -1) {
                domainportsupport = false;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a CNT switch, domain/port not supported");
                }
            }
            if (SAN.indexOf("00000C") != -1 || SAN.indexOf("000142") != -1 || SAN.indexOf("000143") != -1 || SAN.indexOf("000163") != -1 || SAN.indexOf("000164") != -1 || SAN.indexOf("000196") != -1 || SAN.indexOf("000197") != -1 || SAN.indexOf("0001C7") != -1 || SAN.indexOf("0001C9") != -1 || SAN.indexOf("000216") != -1 || SAN.indexOf("000217") != -1 || SAN.indexOf("00024A") != -1 || SAN.indexOf("00024B") != -1 || SAN.indexOf("00027D") != -1 || SAN.indexOf("00027E") != -1 || SAN.indexOf("0002B9") != -1 || SAN.indexOf("0002BA") != -1 || SAN.indexOf("0002FC") != -1 || SAN.indexOf("0002FD") != -1 || SAN.indexOf("000331") != -1 || SAN.indexOf("000332") != -1 || SAN.indexOf("00036B") != -1 || SAN.indexOf("00036C") != -1 || SAN.indexOf("00039F") != -1 || SAN.indexOf("0003A0") != -1 || SAN.indexOf("0003E3") != -1 || SAN.indexOf("0003E4") != -1 || SAN.indexOf("0003FD") != -1 || SAN.indexOf("0003FE") != -1 || SAN.indexOf("000427") != -1 || SAN.indexOf("000428") != -1 || SAN.indexOf("00044D") != -1 || SAN.indexOf("00044E") != -1 || SAN.indexOf("00046D") != -1 || SAN.indexOf("00046E") != -1 || SAN.indexOf("00049A") != -1 || SAN.indexOf("00049B") != -1 || SAN.indexOf("0004C0") != -1 || SAN.indexOf("0004C1") != -1 || SAN.indexOf("0004DD") != -1 || SAN.indexOf("0004DE") != -1 || SAN.indexOf("000500") != -1 || SAN.indexOf("000501") != -1 || SAN.indexOf("000531") != -1 || SAN.indexOf("000532") != -1 || SAN.indexOf("00055E") != -1 || SAN.indexOf("00055F") != -1 || SAN.indexOf("000573") != -1 || SAN.indexOf("000574") != -1 || SAN.indexOf("00059A") != -1 || SAN.indexOf("00059B") != -1 || SAN.indexOf("0005DC") != -1 || SAN.indexOf("0005DD") != -1 || SAN.indexOf("000628") != -1 || SAN.indexOf("00062A") != -1 || SAN.indexOf("000652") != -1 || SAN.indexOf("000653") != -1 || SAN.indexOf("00067C") != -1 || SAN.indexOf("0006C1") != -1 || SAN.indexOf("0006D6") != -1 || SAN.indexOf("0006D7") != -1 || SAN.indexOf("00070D") != -1 || SAN.indexOf("00070E") != -1 || SAN.indexOf("00074F") != -1 || SAN.indexOf("000750") != -1 || SAN.indexOf("000784") != -1 || SAN.indexOf("000785") != -1 || SAN.indexOf("0007B3") != -1 || SAN.indexOf("0007B4") != -1 || SAN.indexOf("0007EB") != -1 || SAN.indexOf("0007EC") != -1 || SAN.indexOf("000820") != -1 || SAN.indexOf("000821") != -1 || SAN.indexOf("00087C") != -1 || SAN.indexOf("00087D") != -1 || SAN.indexOf("0008A3") != -1 || SAN.indexOf("0008A4") != -1 || SAN.indexOf("0008C2") != -1 || SAN.indexOf("0008E2") != -1 || SAN.indexOf("0008E3") != -1 || SAN.indexOf("000911") != -1 || SAN.indexOf("000912") != -1 || SAN.indexOf("000943") != -1 || SAN.indexOf("000944") != -1 || SAN.indexOf("00097B") != -1 || SAN.indexOf("00097C") != -1 || SAN.indexOf("0009B6") != -1 || SAN.indexOf("0009B7") != -1 || SAN.indexOf("0009E8") != -1 || SAN.indexOf("0009E9") != -1 || SAN.indexOf("000A41") != -1 || SAN.indexOf("000A42") != -1 || SAN.indexOf("000A8A") != -1 || SAN.indexOf("000A8B") != -1 || SAN.indexOf("000AB7") != -1 || SAN.indexOf("000AB8") != -1 || SAN.indexOf("000AF3") != -1 || SAN.indexOf("000AF4") != -1 || SAN.indexOf("000B5F") != -1 || SAN.indexOf("000B60") != -1 || SAN.indexOf("000BBE") != -1 || SAN.indexOf("000BBF") != -1 || SAN.indexOf("000BFC") != -1 || SAN.indexOf("000BFD") != -1 || SAN.indexOf("000C85") != -1 || SAN.indexOf("000C86") != -1 || SAN.indexOf("000CCE") != -1 || SAN.indexOf("000CCF") != -1 || SAN.indexOf("000D65") != -1 || SAN.indexOf("000D66") != -1 || SAN.indexOf("000DBC") != -1 || SAN.indexOf("000DBD") != -1 || SAN.indexOf("000DEC") != -1 || SAN.indexOf("000DED") != -1 || SAN.indexOf("000E38") != -1 || SAN.indexOf("000E39") != -1 || SAN.indexOf("000E83") != -1 || SAN.indexOf("000E84") != -1 || SAN.indexOf("000ED6") != -1 || SAN.indexOf("000ED7") != -1 || SAN.indexOf("000F23") != -1 || SAN.indexOf("000F24") != -1 || SAN.indexOf("000F34") != -1 || SAN.indexOf("000F35") != -1 || SAN.indexOf("000F8F") != -1 || SAN.indexOf("000F90") != -1 || SAN.indexOf("000FF7") != -1 || SAN.indexOf("001007") != -1 || SAN.indexOf("00100B") != -1 || SAN.indexOf("00100D") != -1 || SAN.indexOf("001011") != -1 || SAN.indexOf("001014") != -1 || SAN.indexOf("00101F") != -1 || SAN.indexOf("001029") != -1 || SAN.indexOf("00102F") != -1 || SAN.indexOf("001054") != -1 || SAN.indexOf("001079") != -1 || SAN.indexOf("00107B") != -1 || SAN.indexOf("0010A6") != -1 || SAN.indexOf("0010F6") != -1 || SAN.indexOf("0010FF") != -1 || SAN.indexOf("003019") != -1 || SAN.indexOf("003024") != -1 || SAN.indexOf("003040") != -1 || SAN.indexOf("003071") != -1 || SAN.indexOf("003078") != -1 || SAN.indexOf("00307B") != -1 || SAN.indexOf("003080") != -1 || SAN.indexOf("003085") != -1 || SAN.indexOf("003094") != -1 || SAN.indexOf("003096") != -1 || SAN.indexOf("0030A3") != -1 || SAN.indexOf("0030B6") != -1 || SAN.indexOf("0030F2") != -1 || SAN.indexOf("00400B") != -1 || SAN.indexOf("00500B") != -1 || SAN.indexOf("00500F") != -1 || SAN.indexOf("005014") != -1 || SAN.indexOf("00502A") != -1 || SAN.indexOf("00503E") != -1 || SAN.indexOf("005050") != -1 || SAN.indexOf("005053") != -1 || SAN.indexOf("005054") != -1 || SAN.indexOf("005073") != -1 || SAN.indexOf("005080") != -1 || SAN.indexOf("0050A2") != -1 || SAN.indexOf("0050A7") != -1 || SAN.indexOf("0050BD") != -1 || SAN.indexOf("0050D1") != -1 || SAN.indexOf("0050E2") != -1 || SAN.indexOf("0050F0") != -1 || SAN.indexOf("006009") != -1 || SAN.indexOf("00602F") != -1 || SAN.indexOf("00603E") != -1 || SAN.indexOf("006047") != -1 || SAN.indexOf("00605C") != -1 || SAN.indexOf("006070") != -1 || SAN.indexOf("006083") != -1 || SAN.indexOf("00900C") != -1 || SAN.indexOf("009021") != -1 || SAN.indexOf("00902B") != -1 || SAN.indexOf("00905F") != -1 || SAN.indexOf("00906D") != -1 || SAN.indexOf("00906F") != -1 || SAN.indexOf("009086") != -1 || SAN.indexOf("009092") != -1 || SAN.indexOf("0090A6") != -1 || SAN.indexOf("0090AB") != -1 || SAN.indexOf("0090B1") != -1 || SAN.indexOf("0090BF") != -1 || SAN.indexOf("0090D9") != -1 || SAN.indexOf("0090F2") != -1 || SAN.indexOf("00B04A") != -1 || SAN.indexOf("00B064") != -1 || SAN.indexOf("00B08E") != -1 || SAN.indexOf("00B0C2") != -1 || SAN.indexOf("00D006") != -1 || SAN.indexOf("00D058") != -1 || SAN.indexOf("00D063") != -1 || SAN.indexOf("00D079") != -1 || SAN.indexOf("00D090") != -1 || SAN.indexOf("00D097") != -1 || SAN.indexOf("00D0BA") != -1 || SAN.indexOf("00D0BB") != -1 || SAN.indexOf("00D0BC") != -1 || SAN.indexOf("00D0C0") != -1 || SAN.indexOf("00D0D3") != -1 || SAN.indexOf("00D0E4") != -1 || SAN.indexOf("00D0FF") != -1 || SAN.indexOf("00E014") != -1 || SAN.indexOf("00E01E") != -1 || SAN.indexOf("00E034") != -1 || SAN.indexOf("00E04F") != -1 || SAN.indexOf("00E08F") != -1 || SAN.indexOf("00E0A3") != -1 || SAN.indexOf("00E0B0") != -1 || SAN.indexOf("00E0F7") != -1 || SAN.indexOf("00E0F9") != -1 || SAN.indexOf("00E0FE") != -1) {
                domainportsupport = false;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Cisco switch, domain/port not supported");
                }
            }
            if (SAN.indexOf("00051E") != -1 || SAN.indexOf("006069") != -1) {
                domainportsupport = false;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Brocade switch, domain/port not supported");
                }
            }
            if ((SAN.indexOf("00C0DD") != -1 || SAN.indexOf("00E08B") != -1) && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Qlogic switch, domain/port not supported");
            }
            if ((SAN.indexOf("080088") != -1 || SAN.indexOf("00010F") != -1) && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Mcdata switch, domain/port not supported");
            }
            if (domainportsupport) {
                capabilities.setSupportsDomainPort(true);
            } else {
                capabilities.setSupportsDomainPort(false);
            }
            boolean fullzonedbsupport = true;
            if (SAN.indexOf("080088") != -1 || SAN.indexOf("00010F") != -1) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Mcdata switch, domain/port not supported");
                }
                fullzonedbsupport = false;
            }
            if (fullzonedbsupport) {
                capabilities.setSupportsFullZoneDB(true);
                capabilities.setSupportsFCID(true);
                capabilities.setZcAgentType(1);
            } else {
                capabilities.setMaxZoneSets(1);
                capabilities.setSupportsFullZoneDB(false);
                capabilities.setSupportsFCID(false);
                capabilities.setZcAgentType(2);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Mcdata switch, using same name for a zoneset and a zone is supported");
                }
                capabilities.setSupportsSameZoneSetAndZoneName(true);
            }
            capabilities.setSupportsOrphanZoneAliases(false);
            capabilities.setSupportsOrphanZones(false);
            capabilities.setSupportsSpecialCharacters(true);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Capabilities of SAN " + SAN + " are " + capabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
            return capabilities;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ZoneCapabilities getZoneControlCapabilities(String SAN) throws Exception {
        String methodName = "getZoneControlCapabilities";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ZoneCapabilities zc = null;
        String agentType = FabricDbAccess.getZoneControllerInfo(SAN);
        if (agentType != null) {
            if ("GS-3".equals(agentType)) {
                if (SAN.indexOf("00051E") != -1 || SAN.indexOf("006069") != -1) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Since WWN of switch identifies it is a Brocade switch the inband agent cannot be used for zone control");
                    }
                } else {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Need to get zone capabilities for inband agent for SAN " + SAN);
                    }
                    zc = FabricDbAccess.populateCapabilitiesForInbandAgent(SAN);
                }
            } else if ("Brocade".equals(agentType)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Need to get zone capabilities for outband agent for SAN " + SAN);
                }
                zc = FabricDbAccess.populateCapabilitiesForOutbandAgent(SAN);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return zc;
    }

    public static String getRemoveHostString(int computerID) {
        String buf = "delete from t_res_host where computer_id = " + computerID + " and computer_id not in (select computer_id from t_res_agent)" + " and computer_id not in (select computer_id from t_res_server)";
        return buf;
    }

    public static ZoneDefinition getZoneDefinition(String sanWWN, boolean active) {
        ZoneDefinition zoneDef;
        String methodName;
        block5: {
            methodName = "getZoneDefinition";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, sanWWN);
            }
            zoneDef = new ZoneDefinition();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("FABRIC_WWN", sanWWN);
            try {
                String[] fabricIds = FabricDbAccess.getFabrics(params);
                if (fabricIds != null && fabricIds.length > 0) {
                    zoneDef = FabricDbAccess.populateZoneSets(fabricIds[0], active, zoneDef);
                    zoneDef = FabricDbAccess.populateZones(fabricIds[0], active, zoneDef);
                    zoneDef = FabricDbAccess.populateZoneAliases(fabricIds[0], zoneDef, active);
                    zoneDef = FabricDbAccess.populateZoneMembers(fabricIds[0], active, zoneDef);
                    zoneDef = FabricDbAccess.populateZoneAliasMembers(fabricIds[0], active, zoneDef);
                    zoneDef = FabricDbAccess.populateActiveZoneSet(fabricIds[0], zoneDef);
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return zoneDef;
    }

    private static ZoneDefinition populateZoneSets(String fabricId, boolean active, ZoneDefinition zDef) {
        String methodName;
        block6: {
            methodName = "populateZoneSets";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            String[] attList = new String[]{"DESCRIPTION", "ZSET_NAME"};
            try {
                HashMap[] zsAttr;
                String[] zoneSetIds = FabricDbAccess.getZoneSets(fabricId, active);
                if (zoneSetIds != null && zoneSetIds.length > 0 && (zsAttr = FabricDbAccess.getZoneSetAttributes(fabricId, zoneSetIds, active, attList)) != null) {
                    HashMap currZS = new HashMap();
                    for (int i = 0; i < zsAttr.length; ++i) {
                        currZS = zsAttr[i];
                        zDef.addZoneSet(new ZoneSet((String)currZS.get("ZSET_NAME"), (String)currZS.get("DESCRIPTION")));
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    private static ZoneDefinition populateActiveZoneSet(String fabricId, ZoneDefinition zDef) {
        String methodName;
        block6: {
            methodName = "populateActiveZoneSet";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            String[] attList = new String[]{"DESCRIPTION", "ZSET_NAME"};
            try {
                HashMap[] zsAttr;
                String[] zoneSetIds = FabricDbAccess.getZoneSets(fabricId, true);
                if (zoneSetIds != null && zoneSetIds.length > 0 && (zsAttr = FabricDbAccess.getZoneSetAttributes(fabricId, zoneSetIds, true, attList)) != null) {
                    HashMap currZS = new HashMap();
                    for (int i = 0; i < zsAttr.length; ++i) {
                        currZS = zsAttr[i];
                        zDef.activateZoneSet(new ZoneSet((String)currZS.get("ZSET_NAME"), (String)currZS.get("DESCRIPTION")));
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    private static ZoneDefinition populateZones(String fabricId, boolean active, ZoneDefinition zDef) {
        String methodName;
        block13: {
            methodName = "populateZones";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            String[] attList = new String[]{"DESCRIPTION", "ZONE_NAME", "ZONE_TYPE", "ZONE_SUBTYPE"};
            try {
                HashMap[] zoneAttr;
                String[] zoneIds;
                ZoneSet[] zSets = zDef.getZoneSets();
                if (zSets != null) {
                    for (int i = 0; i < zSets.length; ++i) {
                        HashMap[] zoneAttr2;
                        String[] zoneIds2 = FabricDbAccess.getZones(fabricId, zSets[i].getName(), active);
                        if (zoneIds2 == null || zoneIds2.length <= 0 || (zoneAttr2 = FabricDbAccess.getZoneAttributes(fabricId, zoneIds2, active, attList)) == null) continue;
                        HashMap currZone = new HashMap();
                        for (int j = 0; j < zoneAttr2.length; ++j) {
                            currZone = zoneAttr2[j];
                            Integer zTypeInt = (Integer)currZone.get("ZONE_TYPE");
                            short zType = 0;
                            if (zTypeInt != null) {
                                zType = zTypeInt.shortValue();
                            }
                            Integer zSubTypeInt = (Integer)currZone.get("ZONE_SUBTYPE");
                            short zSubType = 0;
                            if (zSubTypeInt != null) {
                                zSubType = zSubTypeInt.shortValue();
                            }
                            zDef.addZone(new ZoneSet(zSets[i].getName()), new Zone((String)currZone.get("ZONE_NAME"), (String)currZone.get("DESCRIPTION"), zType, zSubType));
                        }
                    }
                }
                if ((zoneIds = FabricDbAccess.getZones(fabricId, null, active)) != null && zoneIds.length > 0 && (zoneAttr = FabricDbAccess.getZoneAttributes(fabricId, zoneIds, active, attList)) != null) {
                    HashMap currZone = new HashMap();
                    for (int j = 0; j < zoneAttr.length; ++j) {
                        currZone = zoneAttr[j];
                        Integer zTypeInt = (Integer)currZone.get("ZONE_TYPE");
                        short zType = 0;
                        if (zTypeInt != null) {
                            zType = zTypeInt.shortValue();
                        }
                        Integer zSubTypeInt = (Integer)currZone.get("ZONE_SUBTYPE");
                        short zSubType = 0;
                        if (zSubTypeInt != null) {
                            zSubType = zSubTypeInt.shortValue();
                        }
                        zDef.addZone(new Zone((String)currZone.get("ZONE_NAME"), (String)currZone.get("DESCRIPTION"), zType, zSubType));
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block13;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    private static ZoneDefinition populateZoneAliases(String fabricId, ZoneDefinition zDef, boolean active) {
        String methodName;
        block9: {
            methodName = "populateZoneAliases";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            String[] attList = new String[]{"DESCRIPTION", "ALIAS_NAME"};
            try {
                HashMap[] aliasAttr;
                String[] aliasIds;
                Zone[] zones = zDef.getZones();
                if (zones != null) {
                    for (int i = 0; i < zones.length; ++i) {
                        HashMap[] aliasAttr2;
                        String[] aliasIds2 = FabricDbAccess.getZonesAliases(fabricId, zones[i].getName(), active);
                        if (aliasIds2 == null || aliasIds2.length <= 0 || (aliasAttr2 = FabricDbAccess.getZoneAliasAttributes(fabricId, aliasIds2, attList)) == null || aliasAttr2.length <= 0) continue;
                        HashMap currAlias = new HashMap();
                        for (int j = 0; j < aliasAttr2.length; ++j) {
                            currAlias = aliasAttr2[j];
                            String aliasName = (String)currAlias.get("ALIAS_NAME");
                            String aliasDesc = (String)currAlias.get("DESCRIPTION");
                            zDef.addAlias(zones[i], new ZoneAlias(aliasName, aliasDesc));
                        }
                    }
                }
                if ((aliasIds = FabricDbAccess.getZonesAliases(fabricId, null, false)) != null && aliasIds.length > 0 && (aliasAttr = FabricDbAccess.getZoneAliasAttributes(fabricId, aliasIds, attList)) != null && aliasAttr.length > 0) {
                    HashMap currAlias = new HashMap();
                    for (int j = 0; j < aliasAttr.length; ++j) {
                        currAlias = aliasAttr[j];
                        String aliasName = (String)currAlias.get("ALIAS_NAME");
                        String aliasDesc = (String)currAlias.get("DESCRIPTION");
                        zDef.addAlias(new ZoneAlias(aliasName, aliasDesc));
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block9;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    private static ZoneDefinition populateZoneMembers(String fabricId, boolean active, ZoneDefinition zDef) {
        String methodName;
        block10: {
            methodName = "populateZoneMembers";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            try {
                Zone[] zones = zDef.getZones();
                if (zones != null) {
                    for (int i = 0; i < zones.length; ++i) {
                        HashMap[] zmAttr = FabricDbAccess.getZoneMembers(fabricId, zones[i].getName(), active);
                        if (zmAttr == null || zmAttr.length <= 0) continue;
                        HashMap currZMem = new HashMap();
                        for (int j = 0; j < zmAttr.length; ++j) {
                            currZMem = zmAttr[j];
                            Integer zmTypeInt = (Integer)currZMem.get("TYPE");
                            short zmType = 0;
                            if (zmTypeInt != null) {
                                zmType = zmTypeInt.shortValue();
                            }
                            Integer zmVendorTypeInt = (Integer)currZMem.get("VENDOR_TYPE");
                            short zmVendorType = 0;
                            if (zmVendorTypeInt != null) {
                                zmVendorType = zmVendorTypeInt.shortValue();
                            }
                            if (zmType != 15) {
                                zDef.addMember(zones[i], new ZoneMember(zmType, (String)currZMem.get("NAME")));
                                continue;
                            }
                            zDef.addAlias(zones[i], new ZoneAlias((String)currZMem.get("NAME")));
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block10;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    private static ZoneDefinition populateZoneAliasMembers(String fabricId, boolean active, ZoneDefinition zDef) {
        String methodName;
        block8: {
            methodName = "populateZoneAliasMembers";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricId);
            }
            try {
                ZoneAlias[] aliases = zDef.getAliases();
                if (aliases != null && aliases.length > 0) {
                    for (int i = 0; i < aliases.length; ++i) {
                        HashMap[] zmAttr = FabricDbAccess.getZoneMembersInZoneAlias(fabricId, aliases[i].getName());
                        if (zmAttr == null || zmAttr.length <= 0) continue;
                        HashMap currZMem = new HashMap();
                        for (int j = 0; j < zmAttr.length; ++j) {
                            currZMem = zmAttr[j];
                            Integer zmTypeInt = (Integer)currZMem.get("TYPE");
                            short zmType = 0;
                            if (zmTypeInt != null) {
                                zmType = zmTypeInt.shortValue();
                            }
                            zDef.addMember(aliases[i], new ZoneMember(zmType, (String)currZMem.get("NAME")));
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, fabricId);
        }
        return zDef;
    }

    static {
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        DEAD_END_NODES = " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_FABRIC as FABRIC, T_RES_NODE as NODE, T_RES_SWITCH2PORT as S2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC2SWITCH as F2S where  (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)  and (P2P.PORT_ID1 = S2P.PORT_ID OR P2P.PORT_ID2 = S2P.PORT_ID)  and S2P.SWITCH_WWN = F2S.SWITCH_WWN  and  F2S.FABRIC_WWN = FABRIC.FABRIC_WWN  and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1) or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0)) and PORT.NODE_ID = NODE.NODE_ID and NODE.NODE_ID in (select distinct NODE.NODE_ID as NODE_ID from T_RES_NODE as NODE left outer join T_RES_SWITCH_BLADE as SWTB on (SWTB.SWITCH_BLADE_ID=NODE.BLADE_ID) left outer join T_RES_PE2NODE as PE2NODE on (PE2NODE.NODE_ID=NODE.NODE_ID) left outer join T_RES_NODE2HBA as N2H on (N2H.NODE_ID=NODE.NODE_ID) left outer join T_RES_PORT as PORT on (PORT.NODE_ID=NODE.NODE_ID and PORT.SUBSYSTEM_ID is null) left outer join T_RES_CONTROLLER as CON on (PORT.NAME=CON.WWN_STR) where SWTB.SWITCH_BLADE_ID is null and PE2NODE.NODE_ID is null and N2H.NODE_ID is null and CON.WWN_STR is null) and  (S2P.DETECTABLE = 1 or (S2P.Detectable = 0 and Port.Detectable = 0)) ";
        DEAD_END_PORTS = " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC as FABRIC, T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)  and (P2P.PORT_ID1 = S2P.PORT_ID OR P2P.PORT_ID2 = S2P.PORT_ID)  and S2P.SWITCH_WWN = F2S.SWITCH_WWN  and  F2S.FABRIC_WWN = FABRIC.FABRIC_WWN  and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1) or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0)) and PORT.NAME in (select distinct PORT.NAME as WWN from  T_RES_PORT as Port left outer join T_RES_SWITCH2PORT as S2P on (S2P.PORT_ID = PORT.PORT_ID) left outer join T_RES_NODE as Node on (PORT.NODE_ID = NODE.NODE_ID) left outer join T_RES_CONTROLLER as CON on (PORT.NAME=CON.WWN_STR), T_RES_PORT2PORT as P2P, T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S where S2P.PORT_ID is null and NODE.NODE_ID is null and CON.WWN_STR is null and (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)  and PORT.SUBSYSTEM_ID is null) ";
        SAN_ASSETS_ALL = "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as FABRIC_ID, 1 , cast (case  when (PORT.DISPLAY_ICON_TYPE is not null) then cast (PORT.DISPLAY_ICON_TYPE as char(2))  when (PORT.TYPE is not null) then cast (PORT.TYPE as char(2))  end as smallint)  as TYPE,       case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as LABEL," + FabricDBConstants.getDeviceStatus("PORT", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S, T_RES_SWITCH as SWITCH" + " where" + PORT_TO_P2P_CMP + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and PORT.NAME in (select distinct PORT.NAME as WWN" + " from T_RES_PORT as Port" + " left outer join T_RES_SWITCH2PORT as S2P on (S2P.PORT_ID = PORT.PORT_ID)" + " left outer join T_RES_NODE as NODE on (PORT.NODE_ID = NODE.NODE_ID)" + " left outer join T_RES_CONTROLLER as CON on (PORT.NAME=CON.WWN_STR)," + " T_RES_PORT2PORT as P2P, T_RES_FABRIC as FABRIC,\tT_RES_FABRIC2SWITCH as F2S" + " where S2P.PORT_ID is null and NODE.NODE_ID is null and CON.WWN_STR is null" + " and" + PORT_TO_P2P_CMP + " and PORT.SUBSYSTEM_ID is null)" + " UNION" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 2 " + "," + FabricDBConstants.NODE_TYPE_SQL + " as TYPE," + "       case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end " + " as LABEL," + FabricDBConstants.getDeviceStatus("NODE", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_FABRIC as FABRIC," + " T_RES_NODE as NODE, T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S, T_RES_SWITCH as SWITCH" + " where" + PORT_TO_P2P_CMP + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID in (select distinct NODE.NODE_ID as NODE_ID" + " from T_RES_NODE as NODE " + " left outer join T_RES_SWITCH_BLADE as SWTB on (SWTB.SWITCH_BLADE_ID=NODE.BLADE_ID)" + " left outer join T_RES_PE2NODE as PE2NODE on (PE2NODE.NODE_ID=NODE.NODE_ID)" + " left outer join T_RES_NODE2HBA as N2H on (N2H.NODE_ID=NODE.NODE_ID)" + " left outer join T_RES_PORT as PORT on (PORT.NODE_ID=NODE.NODE_ID and PORT.SUBSYSTEM_ID is null)" + " left outer join T_RES_CONTROLLER as CON on (PORT.NAME=CON.WWN_STR)" + " where SWTB.SWITCH_BLADE_ID is null" + " and PE2NODE.NODE_ID is null and N2H.NODE_ID is null and CON.WWN_STR is null) " + " UNION" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 3 " + "," + FabricDBConstants.PE_TYPE_SQL + " as TYPE," + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as LABEL," + FabricDBConstants.getDeviceStatus("PE", false) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_PHY_PE PE, T_RES_PE2NODE PE2N," + " T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL, T_RES_SWITCH as SWITCH," + " T_RES_NODE NODE, T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P,T_RES_FABRIC2SWITCH F2S" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = PE2N.NODE_ID" + " and PE.VENDOR_ID = VENDOR.VENDOR_ID" + " and PE.MODEL_ID = MODEL.MODEL_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT DISTINCT " + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 8 " + "," + " 0 " + " as TYPE," + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as LABEL," + FabricDBConstants.getDeviceStatus("HOST", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_NODE2HBA N2HBA, T_RES_HBA HBA, T_RES_SWITCH as SWITCH," + " T_RES_HOST HOST, T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P,T_RES_FABRIC2SWITCH F2S" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = N2HBA.NODE_ID" + " and N2HBA.HBA_ID = HBA.HBA_ID" + " and HBA.HOST_ID = HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 7 " + "," + " 0 " + " as TYPE," + "       case            when (HBA.NAME is not null) then HBA.NAME            else HBA.HBA_WWN   end " + " as LABEL," + FabricDBConstants.getDeviceStatus("HBA", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_NODE2HBA N2HBA, T_RES_HBA HBA, T_RES_SWITCH as SWITCH," + " T_RES_HOST HOST, T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P,T_RES_FABRIC2SWITCH F2S" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = N2HBA.NODE_ID" + " and N2HBA.HBA_ID = HBA.HBA_ID" + " and HBA.HOST_ID != HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 9 " + "," + " 0 " + " as TYPE," + "       case            when (SSS.DISPLAY_NAME is not null) then SSS.DISPLAY_NAME            else SSS.NAME   end " + " as LABEL," + FabricDBConstants.getDeviceStatus("SSS", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_NODE NODE," + " T_RES_STORAGE_SUBSYSTEM SSS, T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P," + " T_RES_FABRIC2SWITCH F2S, T_RES_SWITCH as SWITCH" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.SYSTEM_ID = SSS.SUBSYSTEM_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 5 " + "," + " 0 " + " as TYPE," + " case when TAPE.DEVICE_ID is not null then TAPE.DEVICE_ID else TAPE.ELEMENT_NAME end " + " as LABEL," + FabricDBConstants.getDeviceStatus("TAPE", true) + " as STATUS " + " from T_RES_TAPE_DRIVE TAPE, T_RES_PORT PORT, T_RES_PORT2PORT P2P," + " T_RES_NODE NODE, T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P," + " T_RES_FABRIC2SWITCH F2S, T_RES_SWITCH as SWITCH" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = TAPE.NODE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " UNION" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 6 " + "," + " 0 " + " as TYPE," + " case when TMC.DISPLAY_NAME is not null then TMC.DISPLAY_NAME else TMC.DEVICE_ID end " + " as LABEL," + FabricDBConstants.getDeviceStatus("NODE", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_NODE NODE," + " T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P, T_RES_FABRIC2SWITCH F2S," + " T_RES_TAPE_MEDIA_CHANGER TMC, T_RES_SWITCH as SWITCH" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = TMC.NODE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 4 " + "," + " SWTBTYP.SWITCH_BLADE_TYPE_ID as TYPE," + " SWTB.SERIAL_NUMBER as LABEL, " + FabricDBConstants.getDeviceStatus("SWTB", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_NODE NODE," + " T_RES_SWITCH_BLADE SWTB, T_RES_SWITCH_BLADE_TYPE SWTBTYP, T_RES_SWITCH as SWITCH," + " T_RES_FABRIC FABRIC, T_RES_SWITCH2PORT S2P,T_RES_FABRIC2SWITCH F2S" + " where (PORT.PORT_ID = P2P.PORT_ID1 OR PORT.PORT_ID = P2P.PORT_ID2)" + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.BLADE_ID = SWTB.SWITCH_BLADE_ID" + " and SWTB.SWITCH_BLADE_TYPE_ID = SWTBTYP.SWITCH_BLADE_TYPE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " UNION" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 0 " + "," + " 0 " + " as TYPE," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as LABEL," + FabricDBConstants.getDeviceStatus("SWITCH", true) + " as STATUS " + " from T_RES_FABRIC FABRIC, T_RES_FABRIC2SWITCH F2S, T_RES_SWITCH SWITCH" + " where SWITCH.SWITCH_WWN=F2S.SWITCH_WWN" + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " union" + " SELECT DISTINCT" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 8 " + "," + " 0 " + " as TYPE," + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as LABEL," + FabricDBConstants.getDeviceStatus("HOST", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_CONTROLLER as CON," + " T_RES_HOST as HOST, T_RES_FABRIC as FABRIC, T_RES_SWITCH2PORT as S2P," + " T_RES_FABRIC2SWITCH as F2S, T_RES_SWITCH as SWITCH" + " where (Port.PORT_ID = P2P.PORT_ID1 OR" + " Port.PORT_ID = P2P.PORT_ID2)" + " and PORT.NAME = CON.WWN_STR" + " and CON.COMPUTER_ID = HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))";
        SAN_ASSETS_CONNECTED_DEV = " distinct       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as FABRIC_ID, 1 , cast (case  when (PORT.DISPLAY_ICON_TYPE is not null) then cast (PORT.DISPLAY_ICON_TYPE as char(2))  when (PORT.TYPE is not null) then cast (PORT.TYPE as char(2))  end as smallint)  as TYPE,       case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as LABEL, PORT.NAME as WWN," + FabricDBConstants.getDeviceStatus("PORT", true) + " as STATUS " + DEAD_END_PORTS + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 2 " + "," + FabricDBConstants.NODE_TYPE_SQL + " as TYPE," + "       case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end " + " as LABEL," + " NODE.NAME as WWN," + FabricDBConstants.getDeviceStatus("NODE", true) + " as STATUS " + DEAD_END_NODES + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 3 " + "," + FabricDBConstants.PE_TYPE_SQL + " as TYPE," + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as LABEL," + " PE.MGMT_URL_ADDR as WWN," + FabricDBConstants.getDeviceStatus("PE", false) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL," + " T_RES_PORT2PORT as P2P, T_RES_PHY_PE as PE," + " T_RES_PE2NODE as PE2N, T_RES_NODE as NODE, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = PE2N.NODE_ID" + " and PE2N.PHY_PE_ID = PE.PHY_PE_ID" + " and PE.VENDOR_ID = VENDOR.VENDOR_ID" + " and PE.MODEL_ID = MODEL.MODEL_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 8 " + "," + " 0 " + " as TYPE," + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as LABEL," + " HOST.HOST_URL as WWN," + FabricDBConstants.getDeviceStatus("HOST", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_NODE2HBA as N2HBA," + " T_RES_HBA as HBA, T_RES_HOST as Host, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = N2HBA.NODE_ID" + " and N2HBA.HBA_ID = HBA.HBA_ID" + " and HBA.HOST_ID = HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 7 " + "," + " 0 " + " as TYPE," + "       case            when (HBA.NAME is not null) then HBA.NAME            else HBA.HBA_WWN   end " + " as LABEL," + " HBA.HBA_WWN as WWN," + FabricDBConstants.getDeviceStatus("HBA", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_NODE2HBA as N2HBA," + " T_RES_HBA as HBA, T_RES_HOST as Host, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = N2HBA.NODE_ID" + " and N2HBA.HBA_ID = HBA.HBA_ID" + " and HBA.HOST_ID != HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 9 " + "," + " 0 " + " as TYPE," + "       case            when (SSS.DISPLAY_NAME is not null) then SSS.DISPLAY_NAME            else SSS.NAME   end " + " as LABEL," + " SSS.IP_ADDRESS as WWN," + FabricDBConstants.getDeviceStatus("SSS", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_NODE as NODE," + " T_RES_STORAGE_SUBSYSTEM as SSS, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_SWITCH as SWITCH, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.SYSTEM_ID = SSS.SUBSYSTEM_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select " + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 5 " + "," + " 0 " + " as TYPE," + " case when TAPE.DEVICE_ID is not null then TAPE.DEVICE_ID else TAPE.ELEMENT_NAME end " + " as LABEL," + " '' as WWN," + FabricDBConstants.getDeviceStatus("TAPE", true) + " as STATUS " + " from T_RES_TAPE_DRIVE as TAPE, T_RES_PORT as PORT, T_RES_PORT2PORT as P2P," + " T_RES_NODE as NODE, T_RES_FABRIC as FABRIC, T_RES_SWITCH as SWITCH," + " T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = TAPE.NODE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 6 " + "," + " 0 " + " as TYPE," + " case when TMC.DISPLAY_NAME is not null then TMC.DISPLAY_NAME else TMC.DEVICE_ID end " + " as LABEL," + " PORT.NAME as WWN," + FabricDBConstants.getDeviceStatus("NODE", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P," + " T_RES_NODE as NODE, T_RES_SWITCH as SWITCH," + " T_RES_TAPE_MEDIA_CHANGER as TMC, T_RES_FABRIC as FABRIC," + " T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID = TMC.NODE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 4 " + "," + " SWTBTYP.SWITCH_BLADE_TYPE_ID as TYPE," + " SWTB.SERIAL_NUMBER as LABEL," + " SWTB.SWITCH_WWN as WWN," + FabricDBConstants.getDeviceStatus("SWTB", true) + " as STATUS " + " from T_RES_PORT as PORT, T_RES_PORT2PORT as P2P, T_RES_NODE as NODE," + " T_RES_SWITCH_BLADE as SWTB, T_RES_SWITCH_BLADE_TYPE as SWTBTYP, T_RES_SWITCH as SWITCH," + " T_RES_FABRIC as FABRIC, T_RES_SWITCH2PORT as S2P, T_RES_FABRIC2SWITCH as F2S" + " where" + PORT_TO_P2P_CMP + " and PORT.NODE_ID = NODE.NODE_ID" + " and NODE.BLADE_ID = SWTB.SWITCH_BLADE_ID" + " and SWTB.SWITCH_BLADE_TYPE_ID = SWTBTYP.SWITCH_BLADE_TYPE_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 8 " + "," + " 0 " + " as TYPE," + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as LABEL," + " HOST.HOST_URL as WWN," + FabricDBConstants.getDeviceStatus("HOST", true) + " as STATUS " + " from T_RES_PORT PORT, T_RES_PORT2PORT P2P, T_RES_CONTROLLER as CON," + " T_RES_HOST as HOST, T_RES_FABRIC as FABRIC, T_RES_SWITCH2PORT as S2P," + " T_RES_FABRIC2SWITCH as F2S, T_RES_SWITCH as SWITCH" + " where" + PORT_TO_P2P_CMP + " and PORT.NAME = CON.WWN_STR" + " and CON.COMPUTER_ID = HOST.COMPUTER_ID" + " and" + P2P_IDS_TO_S2P_ID_CMP + " and" + S2P_SWWN_TO_F2S_SWWN_CMP + " and" + F2S_WWN_TO_FABRIC_WWN_CMP + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2PORT_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + " 0 " + "," + " 0 " + " as TYPE," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as LABEL," + " SWITCH.SWITCH_WWN as WWN," + FabricDBConstants.getDeviceStatus("SWITCH", true) + " as STATUS " + " from T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " join T_RES_SWITCH2PORT as S2P2 on (P2.PORT_ID = S2P2.PORT_ID)" + " join T_RES_SWITCH as SWITCH2 on (S2P2.SWITCH_WWN = SWITCH2.SWITCH_WWN)" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and (S2P.DETECTABLE = 1 or (S2P.Detectable = 0 and P1.Detectable = 0))" + " and (S2P2.DETECTABLE = 1 or (S2P2.Detectable = 0 and P2.Detectable = 0))";
        PORT_CONNECTIONS = " distinct       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end  as FABRIC_ID,  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end  as SWITCH_ID, case when SWITCH.DOMAIN is not null and SWITCH.DOMAIN !='' then SWITCH.DOMAIN || ',' || P1.PORT_NUMBER else P1.NAME end  as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + " 99 as CONNECTION_STATE," + " '' as CONNECTED_PORT," + " 99 as CONNECTED_PORT_STATE," + " 1 " + "," + " 99 as DEVICE," + " 99 as DEVICE_STATE" + " from T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S " + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN) " + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN) " + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " left outer join T_RES_SWITCH2Port as SP2 on (SP2.port_id = p2.port_id)" + " left outer join T_RES_CONTROLLER as CON on (P2.NAME = CON.WWN_STR)" + " left outer join T_RES_STORAGE_SUBSYSTEM as SSS on (P2.SUBSYSTEM_ID = SSS.SUBSYSTEM_ID)" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and\tp2.node_id is null" + " and sp2.port_id is null" + " and con.WWN_STR is null" + " and p2.SUBSYSTEM_ID is null" + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT, " + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 8 " + "," + " 0 " + " as DEVICE," + FabricDBConstants.getDeviceStatus("HOST", true) + " as DEVICE_STATE " + " FROM T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " left outer join T_RES_NODE as NODE on( p2.NODE_ID = NODE.NODE_ID)" + " left outer join T_RES_NODE2HBA as N2HBA on (N2HBA.NODE_ID = NODE.NODE_ID)" + " left outer join T_RES_HBA as HBA on ( HBA.HBA_ID = N2HBA.HBA_ID)" + " left outer join T_RES_HOST as HOST on (HBA.HOST_ID = HOST.COMPUTER_ID)" + " left outer join T_RES_CONTROLLER as CON on (P2.NAME=CON.WWN_STR)" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and HOST.DETECTABLE is not null" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 3 " + "," + FabricDBConstants.PE_TYPE_SQL + " as DEVICE," + FabricDBConstants.getDeviceStatus("PE", false) + " as DEVICE_STATE " + " from  T_RES_PHY_PE AS PE, T_RES_PE2NODE AS PE2N, T_RES_NODE as NODE," + " T_RES_PORT as PORT, T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL," + " T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID) " + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and PE.PHY_PE_ID = PE2N.PHY_PE_ID" + " and NODE.NODE_ID = PE2N.NODE_ID" + " and P2.NODE_ID = PE2N.NODE_ID" + " and PE.VENDOR_ID = VENDOR.VENDOR_ID" + " and PE.MODEL_ID = MODEL.MODEL_ID" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 2 " + "," + FabricDBConstants.NODE_TYPE_SQL + " as DEVICE," + FabricDBConstants.getDeviceStatus("NODE", true) + " as DEVICE_STATE " + " from T_RES_NODE as NODE, T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " join T_RES_PORT2PORT as P2P on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " and P2.NODE_ID = NODE.NODE_ID" + " and NODE.NODE_ID in" + " (select distinct NODE.NODE_ID as NODE_ID" + " from T_RES_NODE as NODE" + " left outer join T_RES_SWITCH_BLADE as SWTB on (SWTB.SWITCH_BLADE_ID=NODE.BLADE_ID)" + " left outer join T_RES_PE2NODE as PE2NODE on (PE2NODE.NODE_ID=NODE.NODE_ID)" + " left outer join T_RES_NODE2HBA as N2H on (N2H.NODE_ID=NODE.NODE_ID)" + " left outer join T_RES_STORAGE_SUBSYSTEM as SSS on (SSS.SUBSYSTEM_ID = NODE.SYSTEM_ID)" + " left outer join T_RES_PORT as PORT on (PORT.NODE_ID=NODE.NODE_ID and PORT.SUBSYSTEM_ID is null)" + " left outer join T_RES_CONTROLLER as CON on (PORT.NAME=CON.WWN_STR)" + " where SWTB.SWITCH_BLADE_ID is null" + " and PE2NODE.NODE_ID is null" + " and N2H.NODE_ID is null" + " and SSS.SUBSYSTEM_ID is null" + " and CON.WWN_STR is null)" + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 4 " + "," + " SWTBTYP.SWITCH_BLADE_TYPE_ID as DEVICE," + FabricDBConstants.getDeviceStatus("SWTB", true) + " as DEVICE_STATE " + " from T_RES_NODE NODE, T_RES_SWITCH_BLADE SWTB," + " T_RES_SWITCH_BLADE_TYPE SWTBTYP," + " T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and P2.NODE_ID = NODE.NODE_ID" + " and NODE.BLADE_ID = SWTB.SWITCH_BLADE_ID" + " and SWTB.SWITCH_BLADE_TYPE_ID = SWTBTYP.SWITCH_BLADE_TYPE_ID" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 9 " + "," + " 0 " + " as DEVICE," + FabricDBConstants.getDeviceStatus("SSS", true) + " as DEVICE_STATE " + " from T_RES_STORAGE_SUBSYSTEM SSS,T_RES_NODE NODE," + " T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and NODE.SYSTEM_ID = SSS.SUBSYSTEM_ID" + " and P2.NODE_ID = NODE.NODE_ID" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 5 " + "," + " 0 " + " as DEVICE," + FabricDBConstants.getDeviceStatus("TAPE", true) + " as DEVICE_STATE " + " from T_RES_TAPE_DRIVE TAPE, T_RES_NODE NODE," + " T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and NODE.NODE_ID = TAPE.NODE_ID" + " and P2.NODE_ID = NODE.NODE_ID" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " p2.name as CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 6 " + "," + " 0 " + " as DEVICE," + FabricDBConstants.getDeviceStatus("TMC", true) + " as DEVICE_STATE " + " from T_RES_TAPE_MEDIA_CHANGER TMC, T_RES_NODE NODE," + " T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and NODE.NODE_ID = TMC.NODE_ID" + " and P2.NODE_ID = NODE.NODE_ID" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " union" + " select distinct" + "       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end " + " as FABRIC_ID," + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as SWITCH_ID," + SWITCH_PORT_NAME + " as SWITCH_PORT," + FabricDBConstants.getDeviceStatus("p1", true) + " as SWITCH_PORT_STATE, " + FabricDBConstants.getDeviceStatus("p2p", true) + " as CONNECTION_STATE, " + " P2.NAME AS CONNECTED_PORT," + FabricDBConstants.getDeviceStatus("p2", true) + " as CONNECTED_PORT_STATE, " + " 0 " + "," + " 0 " + " as DEVICE," + FabricDBConstants.getDeviceStatus("SWITCH2", true) + " as DEVICE_STATE " + " from T_RES_FABRIC as FABRIC, T_RES_FABRIC2SWITCH as F2S" + " join T_RES_SWITCH as SWITCH on (F2S.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_SWITCH2PORT as S2P on (S2P.SWITCH_WWN = SWITCH.SWITCH_WWN)" + " join T_RES_PORT as P1 on (S2P.PORT_ID = P1.PORT_ID)" + " left outer join T_RES_PORT2PORT as P2P" + " on (P1.PORT_ID = P2P.PORT_ID1 or P1.PORT_ID = P2P.PORT_ID2)" + " left outer join T_RES_PORT as p2 on (not (p2.Port_ID=p1.port_ID)" + " and (p2.port_ID=p2p.port_id1 or p2.port_id=p2p.port_ID2))" + " join  T_RES_SWITCH2PORT as S2P2 on (P2.PORT_ID = S2P2.PORT_ID)" + " join T_RES_SWITCH as SWITCH2 on (S2P2.SWITCH_WWN = SWITCH2.SWITCH_WWN)" + " where F2S.FABRIC_WWN = FABRIC.FABRIC_WWN" + " and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1)" + " or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))" + " and " + SWITCH2P1_FILTER + " and " + SWITCH2P2_FILTER + " ORDER BY FABRIC_ID, SWITCH_ID, SWITCH_PORT";
        GET_HBA_TABLE_INFO_STRING = "SELECT case when HBA.NAME is not null then HBA.NAME else HBA.HBA_WWN end as IDENTIFIER, " + FabricDBConstants.getDeviceStatus("HBA", true) + " as STATUS, " + "HBA.DRIVER_VERSION as VERSION, " + "HBA.FIRMWARE_VERSION as FIRM_VERSION, " + "HBA.ROM_VERSION as ROM_VERSION, " + "HBA.HW_VERSION as HARDWARE_VERSION " + "FROM T_RES_DEVICE_AGENT DEVICE_AGENT, T_RES_HBA HBA " + "WHERE " + "DEVICE_AGENT.HOST_ID=HBA.HOST_ID " + "AND HBA.DETECTABLE = 1 " + "AND DEVICE_AGENT.DEVICE_AGENT_ID=";
    }
}

