/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.dbaccess;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Agent;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;

public class HostAgentPingDbAccess {
    private static String UPDATE_STATUS_BY_ID = "UPDATE t_res_host SET consolidated_status=?, detectable=? where computer_id=?";
    private static String PING_STATUS_BY_HOST = "SELECT received FROM t_stat_ping_hist WHERE computer_id = ? AND monitor_start = (SELECT MAX(monitor_start) FROM T_STAT_PING_HIST WHERE COMPUTER_ID=?)";
    private static String DATA_STATUS_BY_HOST_ID = "select state from t_res_agent where computer_id = ?";
    private static String DEVICE_STATUS_BY_HOST_ID = "select status from t_res_device_agent where host_id = ?";
    static int pingStatus = 0;
    static int dataAgtStatus = 0;
    static String deviceAgtStatus = "";

    private static void main(String[] args) {
        try {
            DBConnPoolDataSource.initialize("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://localhost:50000/TPCDB", "tpcdb", "administrator", "th1h8123", 10);
            HostAgentPingDbAccess.updateHostStatus(300, "AC ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateHostStatus(int id, String devAgentStatus) {
        deviceAgtStatus = devAgentStatus;
        if (devAgentStatus.indexOf("AC") != -1) {
            pingStatus = 1;
        }
        HostAgentPingDbAccess.updateStatus(id);
    }

    public static void updateHostStatus(int id, int pingStat) {
        pingStatus = pingStat;
        HostAgentPingDbAccess.updateStatus(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStatus(int id) {
        DBPreparedStatement stmt = null;
        DBConnection connection = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
            int overallStatus = 2;
            short detectable = 0;
            if (pingStatus == 1) {
                detectable = 1;
                dataAgtStatus = HostAgentPingDbAccess.getDataAgentStatus(id, connection);
                if (deviceAgtStatus.compareTo("") == 0) {
                    deviceAgtStatus = HostAgentPingDbAccess.getDeviceAgentStatus(id, connection);
                }
                overallStatus = dataAgtStatus == 1 && deviceAgtStatus != null && deviceAgtStatus.indexOf("AC") != -1 ? 0 : (dataAgtStatus == 1 && deviceAgtStatus == null || dataAgtStatus == 2 && deviceAgtStatus != null ? 0 : 1);
            }
            stmt = connection.prepareStatement(UPDATE_STATUS_BY_ID);
            stmt.setInt(1, overallStatus);
            stmt.setShort(2, detectable);
            stmt.setInt(3, id);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        finally {
            pingStatus = 0;
            dataAgtStatus = 0;
            deviceAgtStatus = "";
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static int getDataAgentStatus(int id, DBConnection connection) throws Exception {
        DBResultSet rs = null;
        int status = 2;
        try {
            Hashtable<ColumnInfo, String> ht = new Hashtable<ColumnInfo, String>();
            ht.put(Agent.getColumnInfo("COMPUTER_ID"), Integer.toString(id));
            rs = ComplexQuery.sqlQuery(connection, DATA_STATUS_BY_HOST_ID, ht);
            if (rs == null) {
                int n = 0;
                return n;
            }
            while (rs.next()) {
                status = rs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.getStatement().close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    throw e1;
                }
            }
        }
        return status;
    }

    private static String getDeviceAgentStatus(int id, DBConnection connection) throws Exception {
        DBResultSet rs = null;
        String status = null;
        try {
            Hashtable<ColumnInfo, String> ht = new Hashtable<ColumnInfo, String>();
            ht.put(DeviceAgent.getColumnInfo("HOST_ID"), Integer.toString(id));
            rs = ComplexQuery.sqlQuery(connection, DEVICE_STATUS_BY_HOST_ID, ht);
            if (rs == null) {
                String string = null;
                return string;
            }
            while (rs.next()) {
                status = rs.getString(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.getStatement().close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    throw e1;
                }
            }
        }
        return status;
    }
}

