/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.core.constants.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.constants.metadata.IMetadataSource;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertProductSource
implements IMetadataSource {
    private static final Set<Short> supportedConstants;
    private static final Map<Short, Map<String, Object>> constantMetadataMap;

    private static void registerName(short product, String nameKey) {
        AlertProductSource.register(product, "org.eclipse.aperi.constants.metadata.AlertProduct.Name", nameKey);
    }

    private static void registerSnmpOid(short product, int[] oid) {
        AlertProductSource.register(product, "org.eclipse.aperi.constants.metadata.AlertProduct.SnmpOID", oid);
    }

    private static void registerSubproductCount(short product, short count) {
        AlertProductSource.register(product, "org.eclipse.aperi.constants.metadata.AlertProduct.SubproductCount", count);
    }

    private static void registerAlertLogUserHelp(short product, String help) {
        AlertProductSource.register(product, "org.eclipse.aperi.constants.metadata.AlertProduct.AlertLogUserHelp", help);
    }

    private static void registerAlertLogActiveHelp(short product, String help) {
        AlertProductSource.register(product, "org.eclipse.aperi.constants.metadata.AlertProduct.AlertLogActiveHelp", help);
    }

    private static void register(short alertProduct, String metadataKey, Object metadataValue) {
        Map<String, Object> metadata = AlertProductSource.getMetadata(alertProduct);
        metadata.put(metadataKey, metadataValue);
    }

    private static Map<String, Object> getMetadata(Short constantValue) {
        Map<String, Object> metadata = constantMetadataMap.get(constantValue);
        if (metadata == null) {
            metadata = new HashMap<String, Object>();
            constantMetadataMap.put(constantValue, metadata);
        }
        return metadata;
    }

    @Override
    public Object getValue(Object constantValue, String metadataKey) {
        Object metadataValue = AlertProductSource.getMetadata((Short)constantValue).get(metadataKey);
        if (metadataValue != null && metadataKey.equals("org.eclipse.aperi.constants.metadata.AlertProduct.Name")) {
            metadataValue = MessageLog.getMessageNoID((String)metadataValue);
        }
        return metadataValue;
    }

    @Override
    public Set<?> getSupportedConstants() {
        return supportedConstants;
    }

    public void dispose() {
    }

    static {
        constantMetadataMap = new HashMap<Short, Map<String, Object>>();
        AlertProductSource.registerName((short)0, "ALR1202L");
        AlertProductSource.registerName((short)1, "ALR1203L");
        AlertProductSource.registerName((short)2, "ALR1204L");
        AlertProductSource.registerName((short)3, "ALR1205L");
        AlertProductSource.registerSnmpOid((short)0, new int[]{2, 1});
        AlertProductSource.registerSnmpOid((short)1, new int[]{3, 1});
        AlertProductSource.registerSnmpOid((short)2, new int[]{4, 1});
        AlertProductSource.registerSnmpOid((short)3, new int[]{5, 1});
        AlertProductSource.registerSubproductCount((short)0, (short)1);
        AlertProductSource.registerSubproductCount((short)1, (short)0);
        AlertProductSource.registerSubproductCount((short)2, (short)4);
        AlertProductSource.registerSubproductCount((short)3, (short)2);
        AlertProductSource.registerAlertLogUserHelp((short)0, "alag40");
        AlertProductSource.registerAlertLogActiveHelp((short)0, "alag5");
        supportedConstants = Collections.unmodifiableSet(constantMetadataMap.keySet());
    }
}

