/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.StormSettings;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class RemoveMissingUtils {
    private static final String className = RemoveMissingUtils.class.getName();
    private static final long MILLIS_PER_DAY = 86400000L;
    public static StormSettings settings;
    public static final String MESSAGE_NAME = "aperi.logger.message.RemoveMissing";
    public static final String TRACE_NAME = "aperi.logger.trace.RemoveMissing";
    public static String MSG_FILE;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    public static final long MIN_RETRY_INTERVAL = 100L;
    public static final long MULT_RETRY_INTERVAL = 500L;
    public static final int ALLOWED_RETRIES = 3;

    public static DBConnection getDBConnection() {
        DBConnection dbConn = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            dbConn = (DBConnection)ds.getPooledConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbConn;
    }

    public static void closeConnection(DBConnection dbConn) {
        if (dbConn != null) {
            try {
                dbConn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dbConn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPortsForSwitch(String switchId, DBConnection connection) {
        String methodName = "getPortsForSwitch";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct port.port_id as portId, port.detectable as state from T_RES_PORT port, T_RES_SWITCH2PORT s2p, T_RES_SWITCH switch  where port.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_id = " + switchId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPortsForNode(String nodeId, DBConnection connection) {
        String methodName = "getPortsForNode";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct port.port_id as portId, port.detectable as state from t_res_node node, t_res_port port where node.node_id = port.node_id  and node.node_id = " + nodeId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getBladesForNode(String nodeId, DBConnection connection) {
        String methodName = "getPortsBladesForNode";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct blade.switch_blade_id as bladeId, blade.detectable as state from t_res_node node, t_res_switch_blade blade where node.blade_id = blade.switch_blade_id  and node.node_id = " + nodeId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostRemovable(String hostId) {
        boolean bool;
        block30: {
            String methodName = "getPortsForSwitch";
            DBResultSet dbr = null;
            bool = false;
            DBConnection connection = RemoveMissingUtils.getDBConnection();
            if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
                return bool;
            }
            try {
                String sql = " select distinct host.computer_id  from t_res_host host, t_res_device_agent deviceAgent, t_res_agent dataAgent where ( deviceAgent.host_id = host.computer_id  or dataAgent.computer_id = host.computer_id ) and host.computer_id = " + hostId;
                try {
                    dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
                    if (dbr != null && dbr.next()) {
                        bool = false;
                        break block30;
                    }
                    if (TraceLogger.enableTrace) {
                        String msg = "Host " + hostId + " has no agents installed and is removable.";
                        TraceLogger.traceMessage(1, className, methodName, msg);
                    }
                    bool = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (dbr != null) {
                    try {
                        dbr.getStatement().close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getHBAsForHost(String hostId, DBConnection connection) {
        String methodName = "getHBAsForHost";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct hba.hba_wwn as wwn, hba.hba_id as hbaId, hba.host_id as hostId, hba.detectable as state from t_res_hba hba, t_res_host host where hba.host_id = host.computer_id  and host.computer_id = " + hostId;
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getNodesForHBA(String hbaId, DBConnection connection) {
        String methodName = "getNodesForHBA";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct node.node_id as nodeId, node.detectable as state1, h2n.node2hba_id as node2hbaId, h2n.detectable as state2  from  t_res_node node,  t_res_node2hba h2n,  t_res_hba hba where node.node_id = h2n.node_id  and h2n.hba_id = hba.hba_id  and hba.hba_id = " + hbaId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getNode2HBAForNode(String nodeId, DBConnection connection) {
        String methodName = "getNode2HBAForNode";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct n2h.node2hba_id as node2hbaId, n2h.detectable as state from  t_res_node node,  t_res_node2hba n2h where node.node_id = n2h.node_id  and node.node_id = " + nodeId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPort2portForPort(String portId, DBConnection connection) throws SQLException {
        String methodName = "getPort2portForPort";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct p2p.port2port_id  as port2portId, p2p.detectable as state from  t_res_port2port p2p where p2p.port_id1 = " + portId + " OR p2p.port_id2 = " + portId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getZoneSet2ZonesForZone(String zoneId, DBConnection connection) {
        String methodName = "getZoeSet2ZoneForZone";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct zset2zone.zset2zone_id as zset2zoneId  from  t_res_zset2zone zset2zone,  t_res_zone zone where zset2zone.zone_id =  zone.zone_id  and zone.zone_id = " + zoneId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getZone2MembersForZone(String zoneId, DBConnection connection) {
        String methodName = "getZone2MembersForZone";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  zone2member.zone2member_id as zone2memberId  from  t_res_zone2member zone2member,  t_res_zone zone where zone2member.zone_id =  zone.zone_id  and zone.zone_id = " + Integer.parseInt(zoneId);
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getFabricForSwitch(String switchId, DBConnection connection) throws SQLException {
        String methodName = "getZone2MembersForZone";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct fabric.fabric_id as fabricId, fabric.detectable as state from  t_res_fabric fabric,  t_res_fabric2switch f2s,   t_res_switch switch where fabric.fabric_wwn = f2s.fabric_wwn  and f2s.switch_wwn = switch.switch_wwn  and switch.switch_id = " + switchId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getFabric2SwitchForSwitch(String switchId, DBConnection connection) {
        String methodName = "getFabric2SwitchForSwitch";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct f2s.fabric2switch_id as fabric2switchId, f2s.detectable as state  from  t_res_fabric2switch f2s, t_res_switch switch  where  f2s.switch_wwn = switch.switch_wwn  and switch.switch_id = " + switchId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getSwitch2PortForSwitch(String switchId, DBConnection connection) {
        String methodName = "getFabric2SwitchForSwitch";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct s2p.switch2port_id as switch2portId, s2p.detectable as state  from  t_res_switch2port s2p, t_res_switch switch  where  s2p.switch_wwn = switch.switch_wwn  and switch.switch_id = " + switchId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllZoneSetsForFabric(String fabricId, DBConnection connection) {
        String methodName = "getAllZoneSetsForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  zset.zset_id  as zsetId  from  t_res_zset zset,  t_res_fabric fabric  where zset.fabric_wwn = fabric.fabric_wwn and fabric.fabric_wwn = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllZonesForFabric(String fabricId, DBConnection connection) {
        String methodName = "getAllZoneSetsForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  zone.zone_id  as zoneId  from  t_res_zone zone,  t_res_fabric fabric  where zone.fabric_wwn = fabric.fabric_wwn and fabric.fabric_wwn = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllZoneMembersForFabric(String fabricId, DBConnection connection) {
        String methodName = "getAllZoneMembersForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  zonemember.zone_member_id  as zonememberId  from   t_res_zone2member zone2member,  t_res_zone_member zonemember,  t_res_zone zone,  t_res_fabric fabric  where zone2member.zone_id = zone.zone_id  and zone2member.zone_member_id = zonemember.zone_member_id  and zone.fabric_wwn = fabric.fabric_wwn and fabric.fabric_id = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getBladesForSwitch(String switchId, DBConnection connection) {
        String methodName = "getBladesForSwitch";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  blade.switch_blade_id as bladeId, blade.detectable as state from  t_res_switch_blade blade, t_res_switch switch  where blade.switch_wwn =  switch.switch_wwn and switch.switch_id = " + switchId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getSwitchesForFabric(String fabricId, DBConnection connection) {
        String methodName = "getBladesForSwitch";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  switch.switch_id as switchId, switch.detectable as state1, f2s.fabric2switch_id as fabric2switchId,  f2s.detectable as state2  from  t_res_fabric fabric,  t_res_switch switch,  t_res_fabric2switch f2s where f2s.fabric_wwn = fabric.fabric_wwn and switch.switch_wwn = f2s.switch_wwn and fabric.fabric_id = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getHostsForFabric(String fabricId, DBConnection connection) {
        String methodName = "getHostsForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  host.computer_id as hostId, host.detectable as state  from  t_res_hba hba,  t_res_node2hba n2h,  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch switch,  t_res_switch2port s2p,   t_res_fabric2switch f2s,  t_res_fabric fabric, t_res_host host  where host.computer_id = hba.host_id  and hba.hba_id = n2h.hba_id  and n2h.node_id = node.node_id  and node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getPEsForFabric(String fabricId, DBConnection connection) {
        String methodName = "getPEsForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  pe.phy_pe_id as peId, pe.detectable as state  from  t_res_phy_pe pe,  t_res_pe2node p2n,  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch switch,  t_res_switch2port s2p,   t_res_fabric2switch f2s,  t_res_fabric fabric  where pe.phy_pe_id = p2n.phy_pe_id  and p2n.node_id = node.node_id  and node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getNodesForFabric(String fabricId, DBConnection connection) {
        String methodName = "getNodesForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  node.node_id as nodeId, node.detectable as state  from  t_res_node node,   t_res_port port1,  t_res_port port2,  t_res_port2port p2p,   t_res_switch2port s2p,  t_res_switch switch,   t_res_fabric2switch f2s,  t_res_fabric fabric  where node.node_id = port1.node_id  and ( (port1.port_id = p2p.port_id1 and port2.port_id = p2p.port_id2)  OR (port1.port_id = p2p.port_id2 and port2.port_id = p2p.port_id1) ) and port2.port_id = s2p.port_id  and s2p.switch_wwn = switch.switch_wwn  and switch.switch_wwn = f2s.switch_wwn  and f2s.fabric_wwn = fabric.fabric_wwn  and fabric.fabric_id = " + fabricId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getNodesForPE(String peId, DBConnection connection) throws SQLException {
        String methodName = "getNodesForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  node.node_id as nodeId, node.detectable state1,  p2n.pe2node_id as pe2nodeId, p2n.detectable as state2  from   t_res_node node,  t_res_phy_pe pe,  t_res_pe2node p2n where p2n.phy_pe_id = pe.phy_pe_id  and p2n.node_id = node.node_id  and pe.phy_pe_id = " + peId;
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllMissingSwitches(String timeStamp, DBConnection connection) {
        String methodName = "getNodesForFabric";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            String sql = " select distinct  switch.switch_id as switchId  from  t_res_switch switch  where switch.detectable = 0";
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllMissingFabrics(String timeStamp, DBConnection connection) {
        String methodName = "getAllMissinfFabrics";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return null;
        }
        try {
            String sql = " select distinct  fabric.fabric_id as fabricId  from  t_res_fabric fabric  where fabric.detectable = 0";
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getAllMissingTapeLibraries(String timeStamp, DBConnection connection) {
        String methodName = "getAllMissingTapeLibraries";
        DBResultSet dbr = null;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return null;
        }
        try {
            String sql = " select distinct  lib.tape_library_id as libId  from  t_res_tape_library lib  where lib.detectable = 0";
            dbr = ComplexQuery.sqlQuery(connection, sql, new Hashtable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getExpiredMissingEntitiesOld(String type, DBConnection dbConn) {
        String tableName;
        String methodName = "getExpiredMissingEntities";
        ArrayList<String> expiredEntities = new ArrayList<String>();
        String tableAlias = type;
        String elementId = null;
        String keepRemoved = null;
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return expiredEntities;
        }
        if (type.equals("fabric")) {
            tableName = "t_res_fabric";
            elementId = "fabric_id";
            keepRemoved = "fabric";
        } else if (type.equals("switch")) {
            tableName = "t_res_switch";
            elementId = "switch_id";
            keepRemoved = "fabric";
        } else if (type.equals("host")) {
            tableName = "t_res_host";
            elementId = "computer_id";
            keepRemoved = "fabric";
        } else if (type.equals("pe")) {
            tableName = "t_res_phy_pe";
            elementId = "phy_pe_id";
            keepRemoved = "fabric";
        } else if (type.equals("node")) {
            tableName = "t_res_node";
            elementId = "node_id";
            keepRemoved = "fabric";
        } else if (type.equals("port")) {
            tableName = "t_res_port";
            elementId = "port_id";
            keepRemoved = "fabric";
        } else if (type.equals("port2port")) {
            tableName = "t_res_port2port";
            elementId = "port2port_id";
            keepRemoved = "fabric";
        } else if (type.equals("tapelibrary")) {
            tableName = "t_res_tape_library";
            elementId = "tape_library_id";
            keepRemoved = "tapelibrary";
        } else if (type.equals("subsystem")) {
            tableName = "t_res_storage_subsystem";
            elementId = "subsystem_id";
            keepRemoved = "subsystem";
        } else {
            if (TraceLogger.enableTrace) {
                String msg = type + " is not supported as individual remove.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
            return expiredEntities;
        }
        long keepDuration = RemoveMissingUtils.getKeepRemovedSettings(keepRemoved);
        DBResultSet dbr = null;
        try {
            String schema = dbConn.getSchema();
            String sql = "Select distinct state.ELEMENT_ID, state.UPDATE_TIMESTAMP from T_RES_ELEMENT_PROBE_STATUS state, " + tableName + " device " + " where device.DETECTABLE = 0 " + " and  device." + elementId + "=state.ELEMENT_ID";
            dbr = ComplexQuery.sqlQuery(dbConn, sql, null);
            ArrayList subResults = new ArrayList();
            ArrayList values = new ArrayList();
            long shortestTimeExpired = 0L;
            long timeExpired = 0L;
            String element_id_value = null;
            while (dbr.next()) {
                long lastDiscoveryTime;
                Timestamp lastDiscoveryTimeStamp = (Timestamp)dbr.getObject(2);
                element_id_value = dbr.getString(1);
                long currentTime = CurrentTime.getTimestamp(dbConn).getTime();
                timeExpired = currentTime - (lastDiscoveryTime = lastDiscoveryTimeStamp.getTime());
                if (timeExpired < keepDuration) continue;
                expiredEntities.add(type + ':' + element_id_value);
                if (!TraceLogger.enableTrace) continue;
                String msg = type + element_id_value + " is missing for " + timeExpired;
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dbr != null) {
                try {
                    dbr.getStatement().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dbConn != null) {
                try {
                    dbConn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return expiredEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long getKeepRemovedSettings(String type) {
        long keepRemovedValue;
        block29: {
            Exception e222222;
            StormSettings.StormSettingsCursor cursor;
            DBConnection dbConn;
            block27: {
                block26: {
                    String methodName = "getKeepRemovedSettings";
                    dbConn = RemoveMissingUtils.getDBConnection();
                    String schema = dbConn.getSchema();
                    keepRemovedValue = 0L;
                    Hashtable settings = new Hashtable();
                    cursor = null;
                    cursor = StormSettings.getCursor(dbConn, null, null);
                    if (!cursor.next()) break block26;
                    StormSettings stormSettings = cursor.getObject();
                    if (type.equalsIgnoreCase("fabric")) {
                        keepRemovedValue = (long)stormSettings.getKeepRemovedFabric() * 86400000L;
                        break block26;
                    }
                    if (type.equalsIgnoreCase("tapelibrary")) {
                        keepRemovedValue = (long)stormSettings.getKeepRemovedTape() * 86400000L;
                        break block26;
                    }
                    if (!type.equalsIgnoreCase("subsystem")) break block26;
                    keepRemovedValue = (long)stormSettings.getKeepRemovedSubsystems() * 86400000L;
                }
                Object var10_9 = null;
                if (cursor == null) break block27;
                try {
                    cursor.close();
                }
                catch (Exception e222222) {
                    if (!traceLogger.isLogging()) break block27;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close TStormSettings cursor");
                }
            }
            if (dbConn != null) {
                block28: {
                    try {
                        dbConn.commit();
                    }
                    catch (Exception e222222) {
                        if (!traceLogger.isLogging()) break block28;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                        traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Error committing connection");
                    }
                }
                try {
                    dbConn.close();
                }
                catch (Exception e222222) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                        traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close connection");
                    }
                    break block29;
                }
            }
            break block29;
            {
                catch (Exception e3) {
                    Exception e222222;
                    block31: {
                        block30: {
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e3);
                                traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Exception while retrieving keepRemovedSettings for type " + type);
                            }
                            Object var10_10 = null;
                            if (cursor != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Exception e222222) {
                                    if (!traceLogger.isLogging()) break block30;
                                    traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                                    traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close TStormSettings cursor");
                                }
                            }
                        }
                        if (dbConn == null) break block29;
                        try {
                            dbConn.commit();
                        }
                        catch (Exception e222222) {
                            if (!traceLogger.isLogging()) break block31;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Error committing connection");
                        }
                    }
                    try {
                        dbConn.close();
                    }
                    catch (Exception e222222) {
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close connection");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block34: {
                    Exception e222222;
                    block32: {
                        Object var10_11 = null;
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Exception e222222) {
                                if (!traceLogger.isLogging()) break block32;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                                traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close TStormSettings cursor");
                            }
                        }
                    }
                    if (dbConn != null) {
                        block33: {
                            try {
                                dbConn.commit();
                            }
                            catch (Exception e222222) {
                                if (!traceLogger.isLogging()) break block33;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                                traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Error committing connection");
                            }
                        }
                        try {
                            dbConn.close();
                        }
                        catch (Exception e222222) {
                            if (!traceLogger.isLogging()) break block34;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", e222222);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, "getKeepRemovedSettings", "Could not close connection");
                        }
                    }
                }
                throw throwable;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, className, "getKeepRemovedSettings", "keepRemovedValue for type " + type + " is " + keepRemovedValue);
        }
        return keepRemovedValue;
    }

    public static ArrayList getExpiredMissingEntities(String type, DBConnection dbConn) {
        return RemoveMissingUtils.getExpiredMissingEntities(type, null, dbConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ArrayList getExpiredMissingEntities(String type, String keepRemoved, DBConnection dbConn) {
        ArrayList<Object> expiredEntities;
        String methodName;
        block86: {
            Exception e222;
            DBResultSet dbr;
            block82: {
                String tableName;
                methodName = "getExpiredMissingEntitiesINDB";
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, type);
                }
                expiredEntities = new ArrayList<Object>();
                String tableAlias = type;
                String elementId = null;
                boolean isSubEntity = false;
                if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
                    return expiredEntities;
                }
                if (type.equals("fabric")) {
                    tableName = "t_res_fabric";
                    elementId = "fabric_id";
                    keepRemoved = "fabric";
                } else if (type.equals("fabric2switch")) {
                    tableName = "t_res_fabric2switch";
                    elementId = "fabric2switch_id";
                    keepRemoved = "fabric";
                } else if (type.equals("switch")) {
                    tableName = "t_res_switch";
                    elementId = "switch_id";
                    keepRemoved = "fabric";
                } else if (type.equals("blade")) {
                    tableName = "t_res_switch_blade";
                    elementId = "switch_blade_id";
                    keepRemoved = "fabric";
                } else if (type.equals("switch2port")) {
                    tableName = "t_res_switch2port";
                    elementId = "switch2port_id";
                    keepRemoved = "fabric";
                } else if (type.equals("host")) {
                    tableName = "t_res_host";
                    elementId = "computer_id";
                    keepRemoved = "fabric";
                } else if (type.equals("hba")) {
                    tableName = "t_res_hba";
                    elementId = "hba_id";
                    keepRemoved = "fabric";
                } else if (type.equals("node2hba")) {
                    tableName = "t_res_node2hba";
                    elementId = "node2hba_id";
                    keepRemoved = "fabric";
                } else if (type.equals("pe")) {
                    tableName = "t_res_phy_pe";
                    elementId = "phy_pe_id";
                    keepRemoved = "fabric";
                } else if (type.equals("pe2node")) {
                    tableName = "t_res_pe2node";
                    elementId = "pe2node_id";
                    keepRemoved = "fabric";
                } else if (type.equals("node")) {
                    tableName = "t_res_node";
                    elementId = "node_id";
                    keepRemoved = "fabric";
                } else if (type.equals("port")) {
                    tableName = "t_res_port";
                    elementId = "port_id";
                    if (keepRemoved == null) {
                        keepRemoved = "fabric";
                    } else {
                        isSubEntity = true;
                    }
                } else if (type.equals("port2port")) {
                    tableName = "t_res_port2port";
                    elementId = "port2port_id";
                    keepRemoved = "fabric";
                } else if (type.equals("subsystem")) {
                    tableName = "t_res_storage_subsystem";
                    elementId = "subsystem_id";
                    keepRemoved = "subsystem";
                } else if (type.equals("storagevolume")) {
                    tableName = StorageVolume.getTablename();
                    elementId = "SVID";
                    isSubEntity = true;
                } else if (type.equals("storagepool")) {
                    tableName = StoragePool.getTablename();
                    elementId = "POOL_ID";
                    isSubEntity = true;
                } else if (type.equals("physicalvolume")) {
                    tableName = PhysicalVolume.getTablename();
                    elementId = "PHYSICAL_VOLUME_ID";
                    isSubEntity = true;
                } else if (type.equals("tapelibrary")) {
                    tableName = "t_res_tape_library";
                    elementId = "tape_library_id";
                    keepRemoved = "tapelibrary";
                } else if (type.equals("tapedrive")) {
                    tableName = TapeDrive.getTablename();
                    elementId = "TAPE_DRIVE_ID";
                    isSubEntity = true;
                } else if (type.equals("tapemediachanger")) {
                    tableName = TapeMediaChanger.getTablename();
                    elementId = "TAPE_MEDIA_CHANGER_ID";
                    isSubEntity = true;
                } else {
                    if (TraceLogger.enableTrace) {
                        String msg = type + " is not supported as individual remove.";
                        TraceLogger.traceMessage(1, className, methodName, msg);
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, type + " is not supported for individual removal.");
                    }
                    return expiredEntities;
                }
                long keepDuration = RemoveMissingUtils.getKeepRemovedSettings(keepRemoved);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, methodName, " retention for type " + type + " is keepDuration");
                }
                dbr = null;
                String schema = dbConn.getSchema();
                String sql = " Select distinct  device." + elementId + ", device.UPDATE_TIMESTAMP " + " from " + tableName + " device " + " where device.DETECTABLE = 0 ";
                dbr = ComplexQuery.sqlQuery(dbConn, sql, null);
                ArrayList subResults = new ArrayList();
                ArrayList values = new ArrayList();
                long shortestTimeExpired = 0L;
                long timeExpired = 0L;
                String deviceId = null;
                int subEntityID = -1;
                while (dbr.next()) {
                    long lastDiscoveryTime;
                    if (isSubEntity) {
                        subEntityID = dbr.getInt(1);
                    } else {
                        deviceId = dbr.getString(1);
                    }
                    if (type.equals("host") && !RemoveMissingUtils.isHostRemovable(deviceId)) {
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_INFO, className, methodName, " The host with device Id : " + deviceId + " is not removable.");
                        continue;
                    }
                    Timestamp lastDiscoveryTimeStamp = (Timestamp)dbr.getObject(2);
                    long currentTime = CurrentTime.getTimestamp(dbConn).getTime();
                    timeExpired = currentTime - (lastDiscoveryTime = lastDiscoveryTimeStamp.getTime());
                    if (timeExpired < keepDuration) continue;
                    if (isSubEntity) {
                        expiredEntities.add(new Integer(subEntityID));
                    } else {
                        expiredEntities.add(type + ':' + deviceId);
                    }
                    int expiredDays = Math.round(timeExpired / 86400000L);
                    if (TraceLogger.enableTrace) {
                        String msg = type + deviceId + " has missed for " + expiredDays + " days.";
                        TraceLogger.traceMessage(1, className, methodName, msg);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, className, methodName, type + deviceId + " has been missing for " + expiredDays + " days.");
                }
                Object var30_26 = null;
                if (dbr == null) break block82;
                try {
                    dbr.getStatement().close();
                }
                catch (Exception e222) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(className, methodName, e222);
                    }
                    if (!traceLogger.isLogging()) break block82;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                    traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while closing DBResultSet.");
                }
            }
            if (dbConn != null) {
                try {
                    dbConn.commit();
                }
                catch (Exception e222) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception(className, methodName, e222);
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                        traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while committing connection.");
                    }
                }
            }
            break block86;
            {
                catch (Exception e3) {
                    Exception e222;
                    block83: {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception(className, methodName, e3);
                        }
                        if (traceLogger.isLogging()) {
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e3);
                            traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while getting expired missing entities");
                        }
                        Object var30_27 = null;
                        if (dbr != null) {
                            try {
                                dbr.getStatement().close();
                            }
                            catch (Exception e222) {
                                if (TraceLogger.enableTrace) {
                                    TraceLogger.exception(className, methodName, e222);
                                }
                                if (!traceLogger.isLogging()) break block83;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                                traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while closing DBResultSet.");
                            }
                        }
                    }
                    if (dbConn != null) {
                        try {
                            dbConn.commit();
                        }
                        catch (Exception e222) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception(className, methodName, e222);
                            }
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                                traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while committing connection.");
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block85: {
                    Exception e222;
                    block84: {
                        Object var30_28 = null;
                        if (dbr != null) {
                            try {
                                dbr.getStatement().close();
                            }
                            catch (Exception e222) {
                                if (TraceLogger.enableTrace) {
                                    TraceLogger.exception(className, methodName, e222);
                                }
                                if (!traceLogger.isLogging()) break block84;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                                traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while closing DBResultSet.");
                            }
                        }
                    }
                    if (dbConn != null) {
                        try {
                            dbConn.commit();
                        }
                        catch (Exception e222) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception(className, methodName, e222);
                            }
                            if (!traceLogger.isLogging()) break block85;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e222);
                            traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Exception while committing connection.");
                        }
                    }
                }
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(className, methodName, "Found " + expiredEntities.size() + " expired entities of type " + type);
        }
        return expiredEntities;
    }

    public static DBResultSet executeSqlQuery(DBConnection dbConn, String sql) throws Exception {
        String methodName = "executeSqlQuery";
        boolean toRetry = false;
        int numRetries = 0;
        DBResultSet dbr = null;
        do {
            try {
                dbr = ComplexQuery.sqlQuery(dbConn, sql, new Hashtable());
                toRetry = false;
            }
            catch (SQLException e) {
                if (SQLExceptionHelper.isDeadlock(dbConn, e)) {
                    e.printStackTrace();
                    dbConn.rollback();
                    if (++numRetries <= 3) {
                        if (TraceLogger.enableTrace) {
                            String msg = " Retry " + numRetries + "after deadlock";
                            TraceLogger.traceMessage(1, className, methodName, msg);
                        }
                        toRetry = true;
                        Random randGen = new Random();
                        long msWaitPeriod = (long)(500.0 * randGen.nextDouble() * (double)numRetries);
                        if (msWaitPeriod < 100L) {
                            msWaitPeriod = 100L;
                        }
                        Thread.sleep(msWaitPeriod);
                        continue;
                    }
                    throw e;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        } while (toRetry);
        return dbr;
    }

    public static boolean isBadConnection(String methodName, DBConnection connection) {
        boolean bool = false;
        String method = "isBadConnection";
        if (connection == null) {
            if (TraceLogger.enableTrace) {
                String msg = "WARNING:" + methodName + " call has invalid DBConnection.";
                TraceLogger.traceMessage(1, className, method, msg);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "WARNING:" + methodName + " call has invalid DBConnection.");
            }
            bool = true;
        }
        return bool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPhysicalFabric(String fabricId) {
        boolean bool;
        String methodName;
        block21: {
            methodName = "isPhysicalFabric";
            bool = false;
            String isPhysical = "1";
            DBConnection connection = RemoveMissingUtils.getDBConnection();
            DBResultSet dbr = null;
            String sql = "select * from t_res_fabric fabric where fabric.fabric_id = " + fabricId + " and fabric.is_Physical =1 and fabric.parent_fabric_wwn is null ";
            if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
                return bool;
            }
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, null);
                if (dbr != null && dbr.next()) {
                    bool = true;
                }
            }
            catch (Exception e) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error determining whether the given fabric : " + fabricId + " is a physical SAN or not. The DB Query failed");
                }
            }
            finally {
                block20: {
                    if (dbr != null) {
                        try {
                            dbr.getStatement().close();
                        }
                        catch (Exception e) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bool);
        }
        return bool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBResultSet getVsansForFabric(String fabricId, DBConnection connection) {
        String methodName = "getVsansForFabric";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, fabricId);
        }
        DBResultSet dbr = null;
        String sqlGetWwn = "select fabric.fabric_WWN from t_res_fabric fabric where fabric.fabric_id = " + fabricId;
        String sqlGetVsans = " select distinct  fabric.fabric_id as vsanId, fabric.detectable as vsanState  from  t_res_fabric fabric  where fabric.parent_fabric_wwn = ";
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return dbr;
        }
        try {
            dbr = ComplexQuery.sqlQuery(connection, sqlGetWwn, null);
            String physicalSanWWN = null;
            while (dbr.next()) {
                physicalSanWWN = dbr.getString("fabric_WWN");
            }
            sqlGetVsans = sqlGetVsans + "'" + physicalSanWWN + "'";
            dbr = ComplexQuery.sqlQuery(connection, sqlGetVsans, new Hashtable());
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Could not retrieve VSANs for physical SAN with fabric id: " + fabricId);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return dbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markChildVsansAsRegular(String physicalFabricId, DBConnection connection) {
        String methodName = "markChildVsansAsRegular";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, physicalFabricId);
        }
        int rows = 0;
        DBResultSet dbr = null;
        String sqlGetWwn = "select fabric.fabric_WWN from t_res_fabric fabric where fabric.fabric_id = " + physicalFabricId;
        String sqlUpdateVsans = " update  t_res_fabric fabric  set fabric.parent_fabric_wwn = '', fabric.is_physical = 1  where fabric.parent_fabric_wwn = ";
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return;
        }
        try {
            dbr = ComplexQuery.sqlQuery(connection, sqlGetWwn, null);
            String physicalSanWWN = null;
            while (dbr.next()) {
                physicalSanWWN = dbr.getString("fabric_WWN");
            }
            sqlUpdateVsans = sqlUpdateVsans + "'" + physicalSanWWN + "'";
            rows = ComplexQuery.sqlUpdate(connection, sqlUpdateVsans, new Hashtable());
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, className, methodName, "marked " + rows + " vsans as regular SANs ");
            }
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Could not mark VSANs as regular SANs during the physical infrastructure removal");
            }
        }
        finally {
            block19: {
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (Exception e) {
                        if (!traceLogger.isLogging()) break block19;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                        traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Error committing updated vsan records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markHBAPortAsNormalPort(String hbaId, DBConnection connection) {
        String methodName = "markHBAPortAsNormalPort";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, hbaId);
        }
        int rows = 0;
        Object dbr = null;
        String sqlUpdates = " update  t_res_port port  set port.hba_id = null  where port.hba_id = " + hbaId;
        if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
            return;
        }
        try {
            rows = ComplexQuery.sqlUpdate(connection, sqlUpdates, new Hashtable());
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "marked " + rows + " HBAPORT as Normal PORT ");
            }
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Could not mark hba port as normal port.");
            }
        }
        finally {
            block18: {
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (Exception e) {
                        if (!traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                        traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Error committing updated ports records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAttributeSnapshot(String deviceType, String deviceId, DBConnection dbConn) {
        String tableName;
        String methodName = "deleteAttributeSnapshot";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, deviceType + deviceId);
        }
        String tableAlias = deviceType;
        String elementId = null;
        if (RemoveMissingUtils.isBadConnection(methodName, dbConn)) {
            return;
        }
        if (deviceType.equals("fabric")) {
            tableName = "t_res_fabric_attribute_snapshot";
            elementId = "fabric_wwn";
            deviceId = "'" + deviceId + "'";
        } else if (deviceType.equals("fabric2switch")) {
            tableName = "t_res_fabric2switch_attribute_snapshot";
            elementId = "fabric2switch_id";
        } else if (deviceType.equals("switch")) {
            tableName = "t_res_switch_attribute_snapshot";
            elementId = "switch_wwn";
            deviceId = "'" + deviceId + "'";
        } else if (deviceType.equals("blade")) {
            tableName = "t_res_switch_blade_attribute_snapshot";
            elementId = "switch_blade_id";
        } else if (deviceType.equals("switch2port")) {
            tableName = "t_res_switch2port_attribute_snapshot";
            elementId = "switch2port_id";
        } else if (deviceType.equals("host")) {
            tableName = "t_res_host_attribute_snapshot";
            elementId = "computer_id";
        } else if (deviceType.equals("hba")) {
            tableName = "t_res_hba_attribute_snapshot";
            elementId = "hba_id";
        } else if (deviceType.equals("node2hba")) {
            tableName = "t_view_node2computer_attribute_snapshot";
            elementId = "node2hba_id";
        } else if (deviceType.equals("pe")) {
            tableName = "t_res_phy_pe_attribute_snapshot";
            elementId = "phy_pe_id";
        } else if (deviceType.equals("pe2node")) {
            tableName = "t_res_pe2node_attribute_snapshot";
            elementId = "pe2node_id";
        } else if (deviceType.equals("node")) {
            tableName = "t_res_node_attribute_snapshot";
            elementId = "node_id";
        } else if (deviceType.equals("port")) {
            tableName = "t_view_port2parent_attribute_snapshot";
            elementId = "port_id";
        } else if (deviceType.equals("port2port")) {
            tableName = "t_view_port2port2fabric_attribute_snapshot";
            elementId = "port2port_id";
        } else {
            if (TraceLogger.enableTrace) {
                String msg = deviceType + " is not supported as individual remove.";
                TraceLogger.traceMessage(1, className, methodName, msg);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, deviceType + " is not supported for individual removal.");
            }
            return;
        }
        try {
            String sqlDeletes = " delete from " + tableName + " device " + " where device.detectable=0" + " and device." + elementId + "=" + deviceId;
            int rows = ComplexQuery.sqlUpdate(dbConn, sqlDeletes, new Hashtable());
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, methodName, "delete " + rows + " from " + tableName + deviceId);
            }
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Could not mark hba port as normal port.");
            }
        }
        finally {
            block46: {
                if (dbConn != null) {
                    try {
                        dbConn.commit();
                    }
                    catch (Exception e) {
                        if (!traceLogger.isLogging()) break block46;
                        traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                        traceLogger.text(IRecordType.TYPE_ERR, className, methodName, "Error committing updated ports records.");
                    }
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricWWNById(String fabricId) {
        String fabricWWN;
        boolean bool;
        String methodName;
        block21: {
            methodName = "getFabricWWNById";
            bool = false;
            fabricWWN = null;
            DBConnection connection = RemoveMissingUtils.getDBConnection();
            DBResultSet dbr = null;
            String sql = "select fabric_wwn from t_res_fabric fabric where fabric.fabric_id = " + fabricId;
            if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
                return null;
            }
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, null);
                if (dbr != null && dbr.next()) {
                    fabricWWN = dbr.getString("fabric_wwn");
                }
            }
            catch (Exception e) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                }
            }
            finally {
                block20: {
                    if (dbr != null) {
                        try {
                            dbr.getStatement().close();
                        }
                        catch (Exception e) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bool);
        }
        return fabricWWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSwitchWWNById(String switchId) {
        String switchWWN;
        boolean bool;
        String methodName;
        block21: {
            methodName = "getSwitchWWNById";
            bool = false;
            switchWWN = null;
            DBConnection connection = RemoveMissingUtils.getDBConnection();
            DBResultSet dbr = null;
            String sql = "select switch_wwn from t_res_switch switch where switch.switch_id = " + switchId;
            if (RemoveMissingUtils.isBadConnection(methodName, connection)) {
                return null;
            }
            try {
                dbr = ComplexQuery.sqlQuery(connection, sql, null);
                if (dbr != null && dbr.next()) {
                    switchWWN = dbr.getString("switch_wwn");
                }
            }
            catch (Exception e) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                }
            }
            finally {
                block20: {
                    if (dbr != null) {
                        try {
                            dbr.getStatement().close();
                        }
                        catch (Exception e) {
                            if (!traceLogger.isLogging()) break block20;
                            traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                            traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error while closing DB ResultSet");
                        }
                    }
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block21;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
                    traceLogger.text(IRecordType.TYPE_ERROR, className, methodName, "Error closing DB connection");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, bool);
        }
        return switchWWN;
    }

    static {
        MSG_FILE = "org.eclipse.aperi.resources.RemoveMissingProcessorTMS";
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

