/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.interfaces;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.discovery.Response;
import org.sblim.wbem.cim.CIMObjectPath;

public class Query
implements Response,
Serializable {
    public static final String[] cmdNames = new String[]{"Enumerate Instances", "Enumerate Instance Names", "Associators", "Associator Names", "Enumerate Classes", "Enumerate Class Names", "References", "Reference Names", "get Instance"};
    public static final int ENUMERATEINSTANCES = 0;
    public static final int ENUMERATEINSTANCENAMES = 1;
    public static final int ASSOCIATORS = 2;
    public static final int ASSOCIATORNAMES = 3;
    public static final int ENUMERATECLASSES = 4;
    public static final int ENUMERATECLASSNAMES = 5;
    public static final int REFERENCES = 6;
    public static final int REFERENCESNAMES = 7;
    public static final int GETINSTANCE = 8;
    private int cmd = 0;
    private String className = null;
    private Vector properties = null;
    private CIMObjectPath cCOP = null;
    private String assocClassName = null;
    private String resultClassName = null;
    String role = null;
    String resultRole = null;

    private Query(int cmd, String className, String assocClassName, String resultClassName, String role, String resultRole) {
        this.cmd = cmd;
        this.className = className;
        this.assocClassName = assocClassName;
        this.resultClassName = resultClassName;
        this.role = role;
        this.resultRole = resultRole;
    }

    public static Query references(String classname, String pResultClass, String pRole) {
        return new Query(6, classname, pResultClass, pResultClass, pRole, null);
    }

    public static Query referencesNames(String classname, String pResultClass) {
        return new Query(7, classname, pResultClass, pResultClass, null, null);
    }

    public static Query enumerateInstancesQuery(String classname) {
        return new Query(0, classname, null, null, null, null);
    }

    public static Query enumerateInstanceNamesQuery(String classname) {
        return new Query(1, classname, null, null, null, null);
    }

    public static Query associators(String className, String assocClassname, String resultClassName, String role, String resultRole) {
        return new Query(2, className, assocClassname, resultClassName, role, resultRole);
    }

    public static Query associatorNames(String className, String assocClassname, String resultClassName, String role, String resultRole) {
        return new Query(3, className, assocClassname, resultClassName, role, resultRole);
    }

    public static Query enumerateClassesQuery(String classname) {
        return new Query(4, classname, null, null, null, null);
    }

    public static Query enumerateClassNamesQuery(String classname) {
        return new Query(5, classname, null, null, null, null);
    }

    public static Query getInstanceQuery(String pResultClassname) {
        return new Query(8, pResultClassname, null, pResultClassname, null, null);
    }

    public Object getData() {
        return this;
    }

    public void close() {
    }

    public int getCmd() {
        return this.cmd;
    }

    public String getResultClassName() {
        return this.resultClassName;
    }

    public String getResultRole() {
        return this.resultRole;
    }

    public String getRole() {
        return this.role;
    }

    public String getAssocClassName() {
        return this.assocClassName;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public Vector getProperties() {
        return this.properties;
    }

    public void setProperties(Vector vector) {
        this.properties = vector;
    }

    public CIMObjectPath getCOP() {
        return this.cCOP;
    }

    public void setCOP(CIMObjectPath pCOP) {
        this.cCOP = pCOP;
    }

    public Object clone() {
        return new Query(this.cmd, this.className, this.assocClassName, this.resultClassName, this.role, this.resultRole);
    }

    public String toString() {
        return cmdNames[this.cmd] + ":" + this.className + (this.assocClassName != null ? ":" + this.assocClassName + ":" + this.resultClassName : "");
    }
}

