/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;

public final class DiskMessageHelper {
    public static SRMMessage getSRMMessage(String pMsgID, Object pInsert1, Object pInsert2, LogTraceHelper pLTH) {
        SRMMessage mMsg = new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2)});
        pLTH.logMsg(pMsgID, mMsg.getMsgInserts());
        pLTH.traceHigh(mMsg.getMessage());
        return mMsg;
    }

    public static SRMMessage getSRMMessage(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, LogTraceHelper pLTH) {
        SRMMessage mMsg = new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3)});
        pLTH.logMsg(pMsgID, mMsg.getMsgInserts());
        pLTH.traceHigh(mMsg.getMessage());
        return mMsg;
    }

    public static SRMMessage getSRMMessage(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, Object pInsert4, LogTraceHelper pLTH) {
        SRMMessage mMsg = new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3), DiskMessageHelper.toMsgString(pInsert4)});
        pLTH.logMsg(pMsgID, mMsg.getMsgInserts());
        pLTH.traceHigh(mMsg.getMessage());
        return mMsg;
    }

    public static SRMMessage getSRMMessage(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, Object pInsert4, Object pInsert5, LogTraceHelper pLTH) {
        SRMMessage mMsg = new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3), DiskMessageHelper.toMsgString(pInsert4), DiskMessageHelper.toMsgString(pInsert5)});
        pLTH.logMsg(pMsgID, mMsg.getMsgInserts());
        pLTH.traceHigh(pMsgID);
        return mMsg;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert)}));
        pLTH.traceError(pMsgID, mEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert, Throwable pEx, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert)}), pEx);
        pLTH.traceError(pMsgID, mEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, Throwable pEx, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2)}), pEx);
        pLTH.traceError(pMsgID, mEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, Throwable pEx, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3)}), pEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        pLTH.traceError(pMsgID, mEx);
        return mEx;
    }

    public static MissingParameterException getMissingParameterException(int pParameterNumber, String pMsgID, Object pInsert, LogTraceHelper pLTH) {
        MissingParameterException mEx = new MissingParameterException(pParameterNumber, new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert)}));
        pLTH.traceError(pMsgID, mEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        return mEx;
    }

    public static InvalidParameterException getInvalidParameterException(int pNum, String pMsgID, Object pInsert, LogTraceHelper pLTH) {
        InvalidParameterException mEx = new InvalidParameterException(pNum, new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert)}));
        pLTH.traceError(pMsgID, mEx);
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        return mEx;
    }

    public static DiscoveryException getDiscoveryException(String pMethodName, String pMsgKey, String[] pMsgInserts, JobInfo pJobInfo, LogTraceHelper pLTH) {
        Object mRespData;
        Exception mEx = null;
        if (pJobInfo.getResponse() != null && pJobInfo.getResponse() instanceof CIMExceptionResponse && (mRespData = ((CIMExceptionResponse)pJobInfo.getResponse()).getData()) instanceof Exception) {
            mEx = (Exception)mRespData;
        }
        DiscoveryException mReturn = mEx != null ? new DiscoveryException(pMethodName, pMsgKey, pMsgInserts, mEx) : new DiscoveryException(pMethodName, pMsgKey);
        pLTH.traceError("HWN021503E", mEx);
        return mReturn;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2)}));
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        pLTH.traceError(pMsgID, mEx);
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3)}));
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        pLTH.traceError(pMsgID, mEx);
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, Object pInsert4, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3), DiskMessageHelper.toMsgString(pInsert4)}));
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        pLTH.traceError(pMsgID, mEx);
        return mEx;
    }

    public static ServerException getServerException(String pMsgID, Object pInsert1, Object pInsert2, Object pInsert3, Object pInsert4, Object pInsert5, LogTraceHelper pLTH) {
        ServerException mEx = new ServerException(new SRMMessage(pMsgID, new String[]{DiskMessageHelper.toMsgString(pInsert1), DiskMessageHelper.toMsgString(pInsert2), DiskMessageHelper.toMsgString(pInsert3), DiskMessageHelper.toMsgString(pInsert4), DiskMessageHelper.toMsgString(pInsert5)}));
        pLTH.logMsg(pMsgID, mEx.getSRMMessage().getMsgInserts());
        pLTH.traceError(pMsgID, mEx);
        return mEx;
    }

    public static String toMsgString(Object pObj) {
        if (pObj == null) {
            return "null";
        }
        if (pObj.getClass().isArray()) {
            return DiskMessageHelper.handleArray(pObj);
        }
        if (pObj instanceof List) {
            return DiskMessageHelper.handleList((List)pObj);
        }
        if (pObj instanceof Map) {
            return DiskMessageHelper.handleMap((Map)pObj);
        }
        if (pObj instanceof Result) {
            return DiskMessageHelper.handleResult((Result)pObj);
        }
        return pObj.toString();
    }

    private static String handleMap(Map pObj) {
        if (pObj == null) {
            return "null";
        }
        if (pObj.size() == 0) {
            return "{}";
        }
        StringBuffer mReturn = new StringBuffer();
        mReturn.append("{");
        for (Object bKey : pObj.keySet()) {
            mReturn.append(DiskMessageHelper.toMsgString(bKey));
            mReturn.append("=");
            mReturn.append(DiskMessageHelper.toMsgString(pObj.get(bKey)));
            mReturn.append(", ");
        }
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.append("}");
        return mReturn.toString();
    }

    private static String handleArray(Object pObj) {
        if (Array.getLength(pObj) == 0) {
            return "[]";
        }
        StringBuffer mReturn = new StringBuffer();
        mReturn.append("[");
        for (int mLoop = 0; mLoop < Array.getLength(pObj); ++mLoop) {
            Object mInst = Array.get(pObj, mLoop);
            if (pObj.getClass().isPrimitive()) {
                mReturn.append("" + mInst);
                mReturn.append(", ");
                continue;
            }
            mReturn.append(DiskMessageHelper.toMsgString(mInst));
            mReturn.append(", ");
        }
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.append("]");
        return mReturn.toString();
    }

    private static String handleList(List pObj) {
        if (pObj.size() == 0) {
            return "[]";
        }
        StringBuffer mReturn = new StringBuffer();
        mReturn.append("[");
        Iterator mListIt = pObj.iterator();
        while (mListIt.hasNext()) {
            mReturn.append(DiskMessageHelper.toMsgString(mListIt.next()));
            mReturn.append(", ");
        }
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.deleteCharAt(mReturn.length() - 1);
        mReturn.append("]");
        return mReturn.toString();
    }

    private static String handleResult(Result pResult) {
        StringBuffer mReturn = new StringBuffer();
        mReturn.append("\n====================================================================");
        mReturn.append(pResult instanceof AsyncResult ? "\nAsyncResult: " : "\nResult: ");
        mReturn.append(pResult.getMessage());
        mReturn.append("(");
        mReturn.append("RC: ");
        mReturn.append(pResult.getRc());
        if (pResult instanceof AsyncResult) {
            mReturn.append(", Status: ");
            mReturn.append(DiskMessageHelper.resolveResultStatus((AsyncResult)pResult));
            mReturn.append(", Job: ");
            mReturn.append(((AsyncResult)pResult).getJobId());
        }
        mReturn.append(") ");
        if (pResult.getResults() != null) {
            mReturn.append("\nResults:");
            mReturn.append(DiskMessageHelper.toMsgString(pResult.getResults()));
        }
        if (pResult instanceof AsyncResult) {
            if (((AsyncResult)pResult).getSubJobResults() != null) {
                mReturn.append("\nSubJob Results:");
                mReturn.append(DiskMessageHelper.toMsgString(((AsyncResult)pResult).getSubJobResults()));
            }
            if (((AsyncResult)pResult).getReturnException() != null) {
                mReturn.append(((AsyncResult)pResult).getReturnException().toString());
            }
        }
        mReturn.append("\n====================================================================");
        return mReturn.toString();
    }

    private static String resolveResultStatus(AsyncResult pResult) {
        switch (pResult.getStatus()) {
            case 5: {
                return "cancelled";
            }
            case 0: {
                return "failed";
            }
            case 4: {
                return "partial failure";
            }
            case 2: {
                return "running";
            }
            case -1: {
                return "submitted";
            }
            case 1: {
                return "successful";
            }
            case -2: {
                return "waiting";
            }
            case 3: {
                return "warning";
            }
        }
        return "unknown (" + pResult.getStatus();
    }
}

